<?php

/* caisse_enregistreuse/dashboard_caisse.html.twig */
class __TwigTemplate_085c2b8b5b3844a6cf6622c76acabd4b066e6be37f3471fd3f049d4001cf9ebd extends Twig_Template
{
    public function __construct(Twig_Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = array(
        );
    }

    protected function doDisplay(array $context, array $blocks = array())
    {
        // line 1
        echo "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>ERP ETAA - Caisse Enregistreuse</title>
    <!-- Feather Icons CDN -->
    <script src=\"https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js\"></script>
  <style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}
:root {
    --background: hsl(220, 25%, 97%);
    --foreground: hsl(224, 30%, 15%);
    --card: hsl(0, 0%, 100%);
    --card-foreground: hsl(224, 30%, 15%);
    --primary: hsl(221, 83%, 53%);
    --primary-foreground: hsl(0, 0%, 100%);
    --primary-light: hsl(217, 91%, 60%);
    --primary-dark: hsl(224, 76%, 48%);
    --secondary: hsl(214, 100%, 97%);
    --secondary-foreground: hsl(224, 30%, 25%);
    --muted: hsl(217, 33%, 94%);
    --muted-foreground: hsl(215, 25%, 55%);
    --accent: hsl(213, 97%, 87%);
    --accent-foreground: hsl(224, 30%, 25%);
    --border: hsl(217, 25%, 88%);
    --success: hsl(142, 71%, 45%);
    --success-foreground: hsl(0, 0%, 100%);
    --danger: hsl(0, 84%, 60%);
    --danger-foreground: hsl(0, 0%, 100%);
    --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));
    --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));
    --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));
    --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);
    --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);
    --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);
}
html, body {
    width: 100%;
    overflow-x: hidden;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    background: var(--background);
    color: var(--foreground);
    line-height: 1.6;
}
/* Navbar Styles */
.navbar {
    background: var(--gradient-primary);
    box-shadow: var(--shadow-elegant);
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    position: sticky;
    top: 0;
    z-index: 1000;
    width: 100%;
}
.navbar-container {
    max-width: 1400px;
    width: 100%;
    margin: 0 auto;
    padding: 0 1rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    height: 64px;
}
.logo {
    font-size: 1.25rem;
    font-weight: bold;
    color: var(--primary-foreground);
    flex-shrink: 0;
}
.nav-menu {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    flex-wrap: nowrap;
}
.nav-item {
    position: relative;
}
.nav-link {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 0.75rem;
    color: var(--primary-foreground);
    text-decoration: none;
    border-radius: 0.375rem;
    transition: all 0.3s ease;
    background: transparent;
    border: none;
    cursor: pointer;
    font-size: 0.875rem;
    white-space: nowrap;
}
.nav-link:hover {
    background: rgba(255, 255, 255, 0.1);
}
.dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 0.5rem;
    box-shadow: var(--shadow-card);
    min-width: 180px;
    max-width: calc(100vw - 2rem);
    opacity: 0;
    visibility: hidden;
    transform: translateY(-10px);
    transition: all 0.3s ease;
    z-index: 100;
}
.nav-item:hover .dropdown {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}
.dropdown-item {
    display: block;
    padding: 0.75rem 1rem;
    color: var(--foreground);
    text-decoration: none;
    transition: background 0.2s ease;
    white-space: nowrap;
}
.dropdown-item:hover {
    background: var(--accent);
}
.user-menu {
    position: relative;
    flex-shrink: 0;
}
.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: background 0.3s ease;
}
.user-avatar:hover {
    background: rgba(255, 255, 255, 0.2);
}
.user-menu.active .dropdown {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}
.mobile-menu-btn {
    display: none;
    background: transparent;
    border: none;
    color: var(--primary-foreground);
    cursor: pointer;
    padding: 0.5rem;
    border-radius: 0.375rem;
    flex-shrink: 0;
}
/* POS Dashboard Styles */
.pos-dashboard {
    max-width: 1400px;
    width: 100%;
    margin: 0 auto;
    padding: 1rem;
}
.pos-header {
    margin-bottom: 1.5rem;
    text-align: center;
}
.pos-title {
    font-size: 2.5rem;
    font-weight: bold;
    margin-bottom: 0.5rem;
    background: var(--gradient-primary);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}
.pos-subtitle {
    color: var(--muted-foreground);
    font-size: 1rem;
}
/* Quick Actions Grid */
.quick-actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
    margin-bottom: 2rem;
    width: 100%;
}
.quick-action-card {
    background: var(--gradient-card);
    border: 1px solid var(--border);
    border-radius: 0.75rem;
    padding: 1rem;
    box-shadow: var(--shadow-card);
    transition: all 0.3s ease;
    cursor: pointer;
    text-align: center;
    animation: slideInUp 0.6s ease forwards;
    opacity: 0;
}
.quick-action-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-module);
    border-color: var(--primary);
}
.quick-action-card:nth-child(1) { animation-delay: 0.1s; }
.quick-action-card:nth-child(2) { animation-delay: 0.2s; }
.quick-action-card:nth-child(3) { animation-delay: 0.3s; }
.quick-action-card:nth-child(4) { animation-delay: 0.4s; }
.quick-action-icon {
    width: 2.5rem;
    height: 2.5rem;
    background: var(--gradient-primary);
    border-radius: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary-foreground);
    margin: 0 auto 0.5rem;
}
.quick-action-title {
    font-size: 0.875rem;
    font-weight: bold;
    color: var(--foreground);
}
/* Product Search */
.search-section {
    background: var(--gradient-card);
    border: 1px solid var(--border);
    border-radius: 0.75rem;
    padding: 1.5rem;
    box-shadow: var(--shadow-card);
    margin-bottom: 2rem;
    animation: slideInUp 0.6s ease forwards;
    opacity: 0;
    animation-delay: 0.5s;
}
.search-input-group {
    display: flex;
    gap: 1rem;
    margin-bottom: 1rem;
    flex-wrap: wrap;
    align-items: center;
}
.search-input {
    flex: 1;
    padding: 0.75rem 1rem;
    border: 1px solid var(--border);
    border-radius: 0.5rem;
    font-size: 1rem;
    background: var(--card);
    min-width: 200px;
}
.search-btn {
    padding: 0.75rem 1.5rem;
    background: var(--gradient-primary);
    color: var(--primary-foreground);
    border: none;
    border-radius: 0.5rem;
    cursor: pointer;
    font-weight: bold;
    transition: all 0.3s ease;
}
.search-btn:hover {
    background: var(--primary-dark);
}
.client-phone-input {
    padding: 0.75rem 1rem;
    border: 1px solid var(--border);
    border-radius: 0.5rem;
    font-size: 1rem;
    background: var(--card);
    min-width: 200px;
}
.validate-order-btn {
    padding: 0.75rem 1.5rem;
    background: var(--gradient-primary);
    color: var(--primary-foreground);
    border: none;
    border-radius: 0.5rem;
    cursor: pointer;
    font-weight: bold;
    transition: all 0.3s ease;
    white-space: nowrap;
    font-size: 1rem;
}
.validate-order-btn:hover:not(:disabled) {
    background: var(--primary-dark);
}
.validate-order-btn:disabled {
    background: var(--muted);
    color: var(--muted-foreground);
    cursor: not-allowed;
}
.phone-label {
    font-weight: bold;
    color: var(--foreground);
    white-space: nowrap;
    margin-right: 0.5rem;
}
/* Main POS Content */
.main-pos-content {
    display: grid;
    grid-template-columns: 1fr 2fr; /* Colonne gauche 1 partie, droite 2 parties (droite plus grande) */
    gap: 2rem;
    margin-bottom: 2rem;
    width: 100%;
}
.left-panel {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}
.right-panel {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}
/* Cart List */
.products-list {
    background: var(--gradient-card);
    border: 1px solid var(--border);
    border-radius: 0.75rem;
    padding: 1.5rem;
    box-shadow: var(--shadow-card);
    max-height: 500px;
    overflow-y: auto;
    animation: slideInUp 0.6s ease forwards;
    opacity: 0;
    animation-delay: 0.7s;
}
.products-list h3 {
    margin-bottom: 1rem;
    color: var(--foreground);
    font-size: 1.25rem;
}
.product-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    border-bottom: 1px solid var(--border);
    transition: background 0.2s ease;
}
.product-item:hover {
    background: var(--accent);
}
.product-item:last-child {
    border-bottom: none;
}
.product-details {
    flex: 1;
}
.product-name {
    font-weight: bold;
    color: var(--foreground);
}
.product-price {
    color: var(--primary);
    font-size: 1.1rem;
}
.product-controls {
    display: flex;
    gap: 0.5rem;
    align-items: center;
}
.qty-btn, .remove-btn {
    padding: 0.25rem 0.5rem;
    border: 1px solid var(--border);
    background: var(--card);
    border-radius: 0.25rem;
    cursor: pointer;
    transition: all 0.2s ease;
}
.qty-btn:hover, .remove-btn:hover {
    background: var(--primary);
    color: var(--primary-foreground);
}
.remove-btn {
    color: var(--danger);
    border-color: var(--danger);
}
.remove-btn:hover {
    background: var(--danger);
    color: var(--danger-foreground);
}
/* Totals Section */
.totals-section {
    background: var(--gradient-card);
    border: 1px solid var(--border);
    border-radius: 0.75rem;
    padding: 1.5rem;
    box-shadow: var(--shadow-card);
    animation: slideInUp 0.6s ease forwards;
    opacity: 0;
    animation-delay: 0.8s;
}
.total-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 1rem;
    font-size: 1.1rem;
}
.total-label {
    color: var(--muted-foreground);
}
.total-value {
    font-weight: bold;
    color: var(--foreground);
}
.grand-total {
    border-top: 2px solid var(--border);
    padding-top: 1rem;
    font-size: 1.5rem;
    color: var(--primary);
}
/* Products Grid */
.products-grid-section {
    background: var(--gradient-card);
    border: 1px solid var(--border);
    border-radius: 0.75rem;
    padding: 1.5rem;
    box-shadow: var(--shadow-card);
    animation: slideInUp 0.6s ease forwards;
    opacity: 0;
    animation-delay: 0.6s;
}
.products-grid-section h3 {
    margin-bottom: 1rem;
    color: var(--foreground);
    font-size: 1.25rem;
}
.products-grid {
    display: grid;
    grid-template-columns: repeat(5, 1fr); /* 5 colonnes fixes pour desktop/large screens */
    gap: 0.75rem; /* Gap ajusté pour plus de densité avec 5 colonnes */
    width: 100%;
    max-height: 600px; /* Hauteur max pour limiter l'espace vertical */
    overflow-y: auto; /* Active le scroll vertical */
    padding-right: 0.5rem; /* Petit padding pour éviter que le scroll colle au bord */
    scrollbar-width: thin; /* Scrollbar fine (Firefox) */
    scrollbar-color: var(--primary) var(--muted); /* Couleur scrollbar (Firefox) */
}
/* Scrollbar Webkit pour .products-grid */
.products-grid::-webkit-scrollbar {
    width: 6px;
}
.products-grid::-webkit-scrollbar-track {
    background: var(--muted);
    border-radius: 3px;
}
.products-grid::-webkit-scrollbar-thumb {
    background: var(--primary);
    border-radius: 3px;
}
.products-grid::-webkit-scrollbar-thumb:hover {
    background: var(--primary-dark);
}
.product-card {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 0.5rem; /* Bordure légèrement plus petite pour compacité */
    padding: 0.75rem; /* Ajusté pour la largeur moyenne */
    box-shadow: var(--shadow-card);
    transition: all 0.3s ease;
    cursor: pointer;
    text-align: center;
    opacity: 1;
    aspect-ratio: 3 / 5; /* Ratio augmenté en hauteur pour plus d'espace au nom */
    display: flex;
    flex-direction: column; /* Layout vertical compact */
    justify-content: flex-start; /* Aligne en haut pour plus d'espace au nom */
}
.product-card:hover {
    transform: translateY(-2px); /* Hover plus subtil pour petites cartes */
    box-shadow: var(--shadow-module);
    border-color: var(--primary);
}
.product-card.hidden {
    display: none;
}
.product-image {
    width: 100%;
    height: 40%; /* Réduit à 40% pour laisser plus d'espace au nom sur desktop */
    background: var(--muted);
    border-radius: 0.375rem;
    margin-bottom: 0.5rem; /* Plus d'espace après l'image */
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--muted-foreground);
    font-size: 1.25rem; /* Icône adaptée pour placeholder */
    object-fit: cover; /* Pour les vraies images : couvre sans déformer */
    flex-shrink: 0; /* Empêche la réduction de l'image */
}
.product-name {
    font-weight: bold;
    color: var(--foreground);
    margin-bottom: 0.25rem;
    font-size: 1rem; /* Augmenté pour meilleure visibilité sur desktop */
    line-height: 1.5; /* Plus aéré pour lisibilité complète */
    overflow: hidden;
    display: -webkit-box;
    -webkit-line-clamp: 4; /* Permet jusqu'à 4 lignes pour afficher le nom complet sur desktop */
    -webkit-box-orient: vertical;
    flex: 1; /* Occupe tout l'espace disponible pour le nom */
    text-align: center; /* Centré pour cohérence */
}
.product-price {
    font-size: 0.95rem; /* Légèrement augmenté */
    color: var(--primary);
    font-weight: bold;
    margin-bottom: 0.5rem; /* Plus d'espace avant bouton */
    flex-shrink: 0; /* Prix fixe */
}
.add-to-cart-btn {
    width: 100%;
    padding: 0.35rem; /* Légèrement augmenté */
    background: var(--gradient-primary);
    color: var(--primary-foreground);
    border: none;
    border-radius: 0.375rem; /* Bordure plus petite */
    cursor: pointer;
    font-size: 0.75rem; /* Légèrement augmenté */
    transition: all 0.3s ease;
    flex-shrink: 0; /* Bouton fixe en bas */
}
.add-to-cart-btn:hover {
    background: var(--primary-dark);
}
/* Payment Section */
.payment-section {
    background: var(--gradient-card);
    border: 1px solid var(--border);
    border-radius: 0.75rem;
    padding: 1.5rem;
    box-shadow: var(--shadow-card);
    animation: slideInUp 0.6s ease forwards;
    opacity: 0;
    animation-delay: 0.9s;
}
.payment-methods {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}
.payment-method {
    flex: 1;
    padding: 1rem;
    text-align: center;
    border: 2px solid var(--border);
    border-radius: 0.5rem;
    cursor: pointer;
    transition: all 0.3s ease;
    background: var(--card);
}
.payment-method:hover, .payment-method.active {
    border-color: var(--primary);
    background: var(--primary-light);
    color: var(--primary-foreground);
}
.payment-method-icon {
    width: 2rem;
    height: 2rem;
    margin: 0 auto 0.5rem;
    color: var(--primary);
}
/* Animations */
@keyframes slideInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
/* Mobile Styles */
@media (max-width: 768px) {
    .nav-menu {
        display: none;
    }
    .mobile-menu-btn {
        display: block;
    }
    .pos-dashboard {
        padding: 0.5rem;
    }
    .quick-actions-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 0.5rem;
    }
    .main-pos-content {
        grid-template-columns: 1fr; /* Sur mobile, une seule colonne pour l'empilement */
        gap: 1rem;
    }
    .products-grid {
        grid-template-columns: repeat(3, 1fr); /* 3 colonnes sur mobile/tablette */
        gap: 0.5rem; /* Gap réduit sur mobile */
        max-height: 400px; /* Hauteur réduite sur mobile */
    }
    .payment-methods {
        flex-direction: column;
    }
    .search-input-group {
        flex-direction: column;
        align-items: stretch;
    }
    .search-input, .client-phone-input {
        min-width: auto;
    }
    .pos-title {
        font-size: 2rem;
    }
    .product-card {
        aspect-ratio: 4 / 5; /* Ratio ajusté pour mobile (plus vertical) */
        padding: 0.6rem;
    }
    .product-image {
        height: 40%; /* Réduit pour plus d'espace au nom sur mobile */
    }
    .product-name {
        font-size: 0.85rem;
        -webkit-line-clamp: 4; /* Plus de lignes sur mobile pour visibilité complète */
        line-height: 1.4;
    }
    .product-price {
        font-size: 0.9rem;
    }
    .add-to-cart-btn {
        font-size: 0.7rem;
        padding: 0.3rem;
    }
}
@media (max-width: 480px) {
    .products-grid {
        grid-template-columns: repeat(2, 1fr); /* 2 colonnes sur très petit mobile pour lisibilité */
        gap: 0.5rem;
        max-height: 500px; /* Plus de hauteur pour scroll vertical */
    }
    .product-card {
        aspect-ratio: 3 / 5; /* Ratio augmenté pour plus d'espace sur petit écran */
        padding: 0.75rem;
    }
    .product-image {
        height: 40%; /* Réduit pour plus d'espace au nom */
    }
    .product-name {
        font-size: 0.9rem;
        -webkit-line-clamp: 4; /* 4 lignes max sur petit écran */
        white-space: normal; /* Permet le wrap complet */
    }
    .product-price {
        font-size: 0.95rem;
    }
    .add-to-cart-btn {
        font-size: 0.75rem;
        padding: 0.35rem;
    }
}
@media (max-width: 1199px) and (min-width: 769px) {
    .products-grid {
        grid-template-columns: repeat(4, 1fr); /* 4 colonnes sur tablette large */
        gap: 0.6rem;
        max-height: 500px; /* Légèrement réduit */
    }
    .product-card {
        aspect-ratio: 3 / 5; /* Ratio augmenté pour plus d'espace */
    }
    .product-image {
        height: 45%; /* Ajusté pour tablette */
    }
    .product-name {
        font-size: 0.95rem;
        -webkit-line-clamp: 4;
    }
    .product-price {
        font-size: 0.95rem;
    }
    .add-to-cart-btn {
        font-size: 0.75rem;
        padding: 0.35rem;
    }
}
/* Mobile Menu Overlay */
.mobile-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 999;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}
.mobile-overlay.active {
    opacity: 1;
    visibility: visible;
}
.mobile-menu {
    position: fixed;
    top: 0;
    right: -100%;
    width: min(280px, 90vw);
    height: 100vh;
    background: var(--gradient-primary);
    z-index: 1000;
    transition: right 0.3s ease;
    padding: 1.5rem;
    overflow-x: hidden;
}
.mobile-menu.active {
    right: 0;
}
.mobile-menu-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}
.mobile-menu-title {
    color: var(--primary-foreground);
    font-size: 1.25rem;
    font-weight: bold;
}
.close-btn {
    background: transparent;
    border: none;
    color: var(--primary-foreground);
    cursor: pointer;
    padding: 0.5rem;
}
.mobile-nav-item {
    margin-bottom: 0.75rem;
}
.mobile-nav-link {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    color: var(--primary-foreground);
    text-decoration: none;
    border-radius: 0.5rem;
    transition: background 0.3s ease;
    white-space: nowrap;
    font-size: 0.875rem;
}
.mobile-nav-link:hover {
    background: rgba(255, 255, 255, 0.1);
}
/* Icons */
.icon {
    width: 1rem;
    height: 1rem;
    stroke: currentColor;
    fill: none;
    stroke-width: 2;
}
.icon-lg {
    width: 1.5rem;
    height: 1.5rem;
}
</style>
</head>
<body>
    <input type=\"hidden\" name=\"base_url\" id=\"base_url\" value=\"";
        // line 780
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "\"/>
    <!-- Navigation -->
    <nav class=\"navbar\">
        <div class=\"navbar-container\">
            <div class=\"logo\">ERP ETAA</div>
         
            <div class=\"nav-menu\">

                <div class=\"nav-item\">
                    <a href=\"";
        // line 789
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "admin/dashboard\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"airplay\"></i>
                        Dashboard principal
                    </a>
                </div>
                <div class=\"nav-item\">
                    <a href=\"";
        // line 795
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"home\"></i>
                         Dashboard Gestion Commerciale
                    </a>
                </div>
                
               <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"package\"></i>
                        Achats
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
    
                        <a href=\"";
        // line 809
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/demandes_achat/\" class=\"dropdown-item\">Demandes d'achat</a>
                        <a href=\"";
        // line 810
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/commandes_fournisseur\" class=\"dropdown-item\">Commandes fournisseurs</a>
                        <a href=\"";
        // line 811
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/liste_bons_recepotion\" class=\"dropdown-item\">Réceptions</a>
                        <a href=\"";
        // line 812
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/liste_factures_fournisseur\" class=\"dropdown-item\">Factures fournisseur</a>

                        
                    </div>
                </div>
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"shopping-bag\"></i>
                        Ventes
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
    
                        <a href=\"";
        // line 825
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/liste_devis/\" class=\"dropdown-item\">Devis</a>
                         <a href=\"";
        // line 826
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/liste_bons_commande/\" class=\"dropdown-item\">Bons de commande </a>
                        <a href=\"";
        // line 827
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/liste_bons_livraison\" class=\"dropdown-item\">Bons de livraison</a>
                        <a href=\"";
        // line 828
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_commerciale/liste_factures_client\" class=\"dropdown-item\">Factures </a>

                        
                    </div>
                </div>
                
            
                <div class=\"nav-item\">
                    <a href=\"";
        // line 836
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "crm/liste_campagnes/1/-1\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"pie-chart\"></i>
                        Suivi & Reporting
                    </a>
                </div>
                
            </div>
         
            <div class=\"user-menu\">
                <button class=\"user-avatar\" onclick=\"toggleUserMenu()\">
                    <i class=\"icon icon-lg\" data-feather=\"user\"></i>
                </button>
                <div class=\"dropdown\">
                    <a href=\"/profil\" class=\"dropdown-item\">Profil</a>
                    <a href=\"/logout\" class=\"dropdown-item\" style=\"color: #dc2626;\">Se déconnecter</a>
                </div>
            </div>
         
            <button class=\"mobile-menu-btn\" onclick=\"toggleMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"menu\"></i>
            </button>
        </div>
    </nav>
    <!-- Mobile Menu Overlay -->
    <div class=\"mobile-overlay\" id=\"mobileOverlay\" onclick=\"closeMobileMenu()\"></div>
    <div class=\"mobile-menu\" id=\"mobileMenu\">
        <div class=\"mobile-menu-header\">
            <div class=\"mobile-menu-title\">Menu</div>
            <button class=\"close-btn\" onclick=\"closeMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"x\"></i>
            </button>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"home\"></i>
                Dashboard
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/caisse\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"dollar-sign\"></i>
                Caisse
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/ventes\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"shopping-cart\"></i>
                Ventes
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/stock\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"package\"></i>
                Stock
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/rapports\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"file-text\"></i>
                Rapports
            </a>
        </div>
    </div>
    <!-- POS Content -->
    <main class=\"pos-dashboard\">
        <div class=\"pos-header\">
            <h1 class=\"pos-title\">Caisse Enregistreuse  </h1>
            <p style=\"font-size:20px\"><b>Total:</b>&nbsp; <b style=\"color:red\">";
        // line 903
        echo twig_escape_filter($this->env, (isset($context["total_caisse"]) ? $context["total_caisse"] : null), "html", null, true);
        echo " ";
        echo twig_escape_filter($this->env, $this->getAttribute((isset($context["societe"]) ? $context["societe"] : null), "Devise", array()), "html", null, true);
        echo "</b></p>
        </div>
      
        <!-- Quick Actions -->
        <!--
        <div class=\"quick-actions-grid\">
            <div class=\"quick-action-card\" onclick=\"newSale()\">
                <div class=\"quick-action-icon\">
                    <i data-feather=\"plus-circle\"></i>
                </div>
                <div class=\"quick-action-title\">Nouvelle Vente</div>
            </div>
            <div class=\"quick-action-card\" onclick=\"addDiscount()\">
                <div class=\"quick-action-icon\">
                    <i data-feather=\"percent\"></i>
                </div>
                <div class=\"quick-action-title\">Remise</div>
            </div>
            <div class=\"quick-action-card\" onclick=\"selectCustomer()\">
                <div class=\"quick-action-icon\">
                    <i data-feather=\"user-plus\"></i>
                </div>
                <div class=\"quick-action-title\">Client</div>
            </div>
            <div class=\"quick-action-card\" onclick=\"printReceipt()\">
                <div class=\"quick-action-icon\">
                    <i data-feather=\"printer\"></i>
                </div>
                <div class=\"quick-action-title\">Imprimer</div>
            </div>
        </div>
        -->
      
        <!-- Product Search and Client Info -->
        <div class=\"search-section\">
            <div class=\"search-input-group\">
                <input type=\"text\" class=\"search-input\" placeholder=\"Rechercher un produit (code ou nom)...\" id=\"productSearch\" onkeyup=\"searchProductsAjax()\" onchange=\"searchProductsAjax()\">
                <button class=\"search-btn\" onclick=\"searchProduct()\">
                    <i class=\"icon\" data-feather=\"search\"></i>
                    Rechercher
                </button>
                <span class=\"phone-label\">Téléphone client (optionnel) :</span>
                <input type=\"text\" id=\"customerPhone\" class=\"client-phone-input\" placeholder=\"Entrez le numéro de téléphone\">
                <button class=\"validate-order-btn\" onclick=\"completeSale()\" id=\"validateBtn\" disabled>Valider la commande</button>
            </div>
        </div>
      
        <!-- Main POS Content: Cart Left, Products Right -->
        <div class=\"main-pos-content\">
            <div class=\"left-panel\">
                <!-- Cart List -->
                <div class=\"products-list\">
                    <h3>Panier Actuel</h3>
                    <div id=\"productItems\">
                        <!-- Items ajoutés dynamiquement -->
                    </div>
                </div>
                <!-- Totals -->
                <div class=\"totals-section\">
                    <h3>Totaux</h3>
                    <div class=\"total-row grand-total\">
                        <span class=\"total-label\">Total TTC</span>
                        <span class=\"total-value\" id=\"grandTotal\">0,00 ";
        // line 965
        echo twig_escape_filter($this->env, $this->getAttribute((isset($context["societe"]) ? $context["societe"] : null), "Devise", array()), "html", null, true);
        echo "</span>
                    </div>
                </div>
            </div>
            <div class=\"right-panel\">
                <!-- Products Grid -->
                <div class=\"products-grid-section\">
                    <h3>Produits Disponibles</h3>
                    <div class=\"products-grid\" id=\"productsGrid\">
                        <!-- Produits seront générés par JS -->
                    </div>
                </div>
            </div>
        </div>
      
        <!-- Payment -->
        <div class=\"payment-section\">
            <h3>Modes de Paiement</h3>
            <div class=\"payment-methods\">
                <div class=\"payment-method active\" onclick=\"selectPayment(this, 'Espèces')\">
                    <div class=\"payment-method-icon\">
                        <i data-feather=\"dollar-sign\"></i>
                    </div>
                    Espèces
                </div>
                <div class=\"payment-method\" onclick=\"selectPayment(this, 'Carte bancaire')\">
                    <div class=\"payment-method-icon\">
                        <i data-feather=\"credit-card\"></i>
                    </div>
                    Carte
                </div>
                <div class=\"payment-method\" >
                    <a href=\"\" id=\"impression\" style=\"text-decoration:none;\" target=\"_blank\">
                    <div class=\"payment-method-icon\">
                        <i data-feather=\"file-text\"></i>
                    </div>
                    </a>
                    Imprimer
                </div>
            </div>
        </div>
    </main>
     <script src=\"https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js\"></script>
     <script src=\"https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js\"></script>
    <script src=\"https://unpkg.com/sweetalert/dist/sweetalert.min.js\"></script>
    <script>
        // Initialize Feather Icons
        feather.replace();

        // Sample Products Data
        const products = ";
        // line 1015
        echo (isset($context["liste_produits"]) ? $context["liste_produits"] : null);
        echo ";
        const devise = '";
        // line 1016
        echo twig_escape_filter($this->env, $this->getAttribute((isset($context["societe"]) ? $context["societe"] : null), "Devise", array()), "html", null, true);
        echo "';

        // Log initial pour inspecter les données produits
        console.log('Données produits chargées :', products); // Vérifie la structure ici !

        function toggleMobileMenu() {
            const overlay = document.getElementById('mobileOverlay');
            const menu = document.getElementById('mobileMenu');
            overlay.classList.add('active');
            menu.classList.add('active');
        }
        function closeMobileMenu() {
            const overlay = document.getElementById('mobileOverlay');
            const menu = document.getElementById('mobileMenu');
            overlay.classList.remove('active');
            menu.classList.remove('active');
        }
        function toggleUserMenu() {
            const userMenu = document.querySelector('.user-menu');
            userMenu.classList.toggle('active');
        }

        // POS Functions
        function newSale() {
            document.getElementById('productItems').innerHTML = '';
            document.getElementById('customerPhone').value = '';
            updateTotals();
            alert('Nouvelle vente initiée');
        }
        function addDiscount() {
            const discount = prompt('Entrez le pourcentage de remise :');
            if (discount) alert(`Remise de \${discount}% appliquée`);
        }
        function selectCustomer() {
            const customer = prompt('Entrez le nom du client :');
            if (customer) alert(`Client sélectionné : \${customer}`);
        }
        function printReceipt() {
            alert('Ticket en cours d\\'impression...');
        }
        function searchProduct() {
            const query = document.getElementById('productSearch').value.toLowerCase();
            filterProducts(query);
        }
        function filterProducts(query = '') {
            const grid = document.getElementById('productsGrid');
            grid.innerHTML = '';
            const filteredProducts = products.filter(p =>
                p.name.toLowerCase().includes(query) ||
                p.id.toString().includes(query)  // Log si id manquant
            );
            console.log('Produits filtrés :', filteredProducts); // Vérifie les IDs ici
            filteredProducts.forEach(product => {
                console.log(`Produit \${product.name} - ID: \${product.id}, Prix: \${product.price}`); // Trace par produit
                const card = document.createElement('div');
                card.className = 'product-card';
                card.innerHTML = `
                    <img src=\"\${product.image}\" alt=\"\${product.name}\" class=\"product-image\"
                         style=\"width: 100%; height: 120px; object-fit: cover; border-radius: 0.5rem; margin-bottom: 0.5rem; display: block;\"
                         onerror=\"this.style.display='none'; this.parentNode.insertAdjacentHTML('afterbegin', '<div class=\\\\'product-image-placeholder\\\\' style=\\\\'width:100%; height:120px; background:var(--muted); border-radius:0.5rem; display:flex; align-items:center; justify-content:center; color:var(--muted-foreground); font-size:2rem;\\\\'><i data-feather=\\\\\"image\\\\\"></i></div>
                    <div class=\"product-name\">\${product.name}</div>
                    <div class=\"product-price\">\${parseFloat(product.price).toFixed(2)} \${devise}</div>
                    <button class=\"add-to-cart-btn\" onclick=\"addProductToCart(\${product.id || 'null'}, '\${product.name.replace(/'/g, \"\\\\'\")}', \${parseFloat(product.price)})\">Ajouter</button>
                `;
                grid.appendChild(card);
            });
            if (filteredProducts.length === 0) {
                grid.innerHTML = '<p style=\"text-align: center; color: var(--muted-foreground);\">Aucun produit trouvé.</p>';
                }
                feather.replace(); // Réinitialise les icônes Feather après ajout dynamique
            }
    function addProductToCart(id, name, price) {
        console.log(`Ajout au panier - ID reçu: \${id}, Nom: \${name}, Prix: \${price}`); // Trace l'ID entrant
        const items = document.getElementById('productItems');
        // Check if product already in cart
        let existingItem = Array.from(items.querySelectorAll('.product-item')).find(item =>
            item.dataset.productId == id
        );
        if (existingItem) {
            const qty = existingItem.querySelector('.product-controls span');
            qty.textContent = parseInt(qty.textContent) + 1;
            console.log(`Quantité augmentée pour ID \${id}`);
        } else {
            const item = document.createElement('div');
            item.className = 'product-item';
            item.dataset.productId = id; // Définit l'ID (string ou number -> string)
            console.log(`Dataset défini pour nouvel item - productId: \${item.dataset.productId}`); // Vérifie le dataset
            item.innerHTML = `
                <div class=\"product-details\">
                    <div class=\"product-name\">\${name}</div>
                    <div class=\"product-price\">\${price.toFixed(2)} \${devise}</div>
                </div>
                <div class=\"product-controls\">
                    <button class=\"qty-btn\" onclick=\"decreaseQty(this)\">-</button>
                    <span>1</span>
                    <button class=\"qty-btn\" onclick=\"increaseQty(this)\">+</button>
                    <button class=\"remove-btn\" onclick=\"removeItem(this)\">×</button>
                </div>
            `;
            items.appendChild(item);
        }
        updateTotals();
        //searchProductsAjax();
    }
        function increaseQty(btn) {
            const qty = btn.previousElementSibling;
            qty.textContent = parseInt(qty.textContent) + 1;
            updateTotals();
        }
        function decreaseQty(btn) {
            const qty = btn.nextElementSibling;
            if (parseInt(qty.textContent) > 1) {
                qty.textContent = parseInt(qty.textContent) - 1;
                updateTotals();
            } else if (parseInt(qty.textContent) === 1) {
                // Optionnel : supprimer l'item si qty=0
                removeItem(btn.parentNode.querySelector('.remove-btn'));
            }
        }
        function removeItem(btn) {
            btn.closest('.product-item').remove();
            updateTotals();
        }
        function updateTotals() {
            const items = document.querySelectorAll('.product-item');
            let total = 0;
            items.forEach(item => {
                const priceText = item.querySelector('.product-price').textContent.replace(devise, '').trim();
                const price = parseFloat(priceText);
                const qty = parseInt(item.querySelector('.product-controls span').textContent);
                total += price * qty;
            });
            document.getElementById('grandTotal').textContent = total.toFixed(2) + ' ' + devise;
            document.getElementById('validateBtn').disabled = items.length === 0;
        }
        let selectedPaymentMethod = 'cash'; // Variable globale pour stocker le mode de paiement sélectionné
        function selectPayment(method, type) {
            document.querySelectorAll('.payment-method').forEach(m => m.classList.remove('active'));
            method.classList.add('active');
            selectedPaymentMethod = type;
        }
function completeSale() {
    const items = document.querySelectorAll('.product-item');
    if (items.length === 0) return;
    // Collecter les données du panier
    const cartData = [];
    items.forEach((item, index) => {
        const id = item.dataset.productId; // Récupère l'ID du dataset
        const name = item.querySelector('.product-name').textContent;
        const priceText = item.querySelector('.product-price').textContent.replace(devise, '').trim();
        const price = parseFloat(priceText);
        const qty = parseInt(item.querySelector('.product-controls span').textContent);
        
        console.log(`Item \${index} - Dataset ID: \"\${id}\" (type: \${typeof id}), Nom: \${name}`); // Trace détaillé par item
        
        if (!id) {
            console.warn(`⚠️ ID manquant pour l'item \"\${name}\" ! Vérifiez les données produits.`);
            return; // Ignore cet item si ID vide
        }
        
        cartData.push({ id, name, price, quantity: qty });
    });
    console.log('Données panier final :', cartData); // Log final avant envoi
    
    const saleData = {
        customerPhone: document.getElementById('customerPhone').value || null,
        items: cartData,
        total: parseFloat(document.getElementById('grandTotal').textContent.replace(devise, '').trim()),
        paymentMethod: selectedPaymentMethod,
        // Ajoutez d'autres champs si nécessaire (ex: client_id, etc.)
    };
    // AJAX avec XMLHttpRequest
    const xhr = new XMLHttpRequest();
    let base_url = \$(\"#base_url\").val();
    xhr.open('POST', base_url+'api/stocker_commande_caisse', true); // Remplacez par votre endpoint réel
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                const result = xhr.responseText;
                console.log('Réponse serveur :', result);
                const responseData = JSON.parse(result);
                window.location.href =base_url+\"docs/ticket_caisse/\"+responseData.id;
                //alert('Vente encaissée avec succès ! Ticket généré.'+responseData.id);
                newSale(); // Vider le panier
            } else {
                alert('Erreur lors de l\\'encaissement de la vente. Veuillez réessayer.');
            }
                }
            };
            xhr.onerror = function() {
                alert('Erreur lors de l\\'encaissement de la vente. Veuillez réessayer.');
            };
            console.log('Envoi des données :', saleData); // Log avant envoi AJAX
            xhr.send(JSON.stringify(saleData));
        }

        // Initialize Products Grid and Add Initial Cart Items
        document.addEventListener('DOMContentLoaded', function() {
            filterProducts();
            // Add some initial products to cart (exemple, à supprimer en prod)
            // addProductToCart(1, 'Produit Exemple 1', 15.99);
            // addProductToCart(2, 'Produit Exemple 2', 29.50);
        });

        // Close dropdowns and user menu when clicking outside
        document.addEventListener('click', function(event) {
            const userMenu = document.querySelector('.user-menu');
            const userAvatar = document.querySelector('.user-avatar');

            if (!userAvatar.contains(event.target) && !userMenu.contains(event.target)) {
                userMenu.classList.remove('active');
            }
        });

    function searchProductsAjax() {

        const query = document.getElementById('productSearch').value.trim();
        const grid = document.getElementById('productsGrid');
        
        // Vider la grille au début de la recherche
        grid.innerHTML = '<p style=\"text-align: center; color: var(--muted-foreground);\">Recherche en cours...</p>';
        
        // Ne pas faire de requête si la query est trop courte (ex: min 2 caractères)
        /*
        if (query.length < 2) {
            grid.innerHTML = '<p style=\"text-align: center; color: var(--muted-foreground);\">Entrez au moins 2 caractères pour rechercher.</p>';
            return;
        }*/
        
        // Récupérer la base URL
        const baseUrl = \$(\"#base_url\").val();
        
        // Requête AJAX avec jQuery (déjà inclus)
        \$.ajax({
            url: baseUrl + 'api/search_products', // Remplacez par votre endpoint réel de recherche (ex: /api/search_products?query=...)
            method: 'POST', // Ou 'POST' si vous préférez envoyer en body
            data: { query: query }, // Paramètres de recherche
            dataType: 'json',
            success: function(response) {
                console.log('Réponse de recherche brute :', response); // Log pour debug (vérifiez dans la console du navigateur)
                
                // Vérifier si la réponse est valide et extraire les produits
                let products = [];
                if (response && typeof response === 'object') {
                    products = response.products || response.data || response || [];
                } else {
                    console.warn('Réponse inattendue (pas un objet) :', response);
                }
                
                // Vérifier explicitement si products est un tableau
                if (!Array.isArray(products)) {
                    console.error('Products n\\'est pas un tableau :', products, '(type:', typeof products, ')');
                    grid.innerHTML = '<p style=\"text-align: center; color: var(--danger);\">Erreur : Données de produits invalides reçues du serveur.</p>';
                    return;
                }
                
                console.log('Produits extraits (tableau) :', products); 
                
                if (products.length === 0) {
                    grid.innerHTML = '<p style=\"text-align: center; color: var(--muted-foreground);\">Aucun produit trouvé.</p>';
                    return;
                }
                
                // Vider et repopuler la grille
                grid.innerHTML = '';
                products.forEach(product => {
                    // Vérifiez la structure de vos produits (ex: {id, name, price, image})
                    // Ajout d'une vérification basique pour chaque produit
                    if (!product || !product.name || !product.price) {
                        console.warn('Produit incomplet ignoré :', product);
                        return;
                    }
                    
                    const card = document.createElement('div');
                    card.className = 'product-card';
                    card.innerHTML = `
                        <img src=\"\${product.image || ''}\" alt=\"\${product.name}\" class=\"product-image\"
                             style=\"width: 100%; height: 120px; object-fit: cover; border-radius: 0.5rem; margin-bottom: 0.5rem; display: block;\"
                             onerror=\"this.style.display='none'; this.parentNode.insertAdjacentHTML('afterbegin', '<div class=\\\\'product-image-placeholder\\\\' style=\\\\'width:100%; height:120px; background:var(--muted); border-radius:0.5rem; display:flex; align-items:center; justify-content:center; color:var(--muted-foreground); font-size:2rem;\\\\'><i data-feather=\\\\\"image\\\\\"></i></div>
                        <div class=\"product-name\">\${product.name}</div>
                        <div class=\"product-price\">\${parseFloat(product.price || 0).toFixed(2)} \${devise}</div>
                        <button class=\"add-to-cart-btn\" onclick=\"addProductToCart(\${product.id || 'null'}, '\${(product.name || '').replace(/'/g, \"\\\\'\")}', \${parseFloat(product.price || 0)})\">Ajouter</button>
                    `;
                    grid.appendChild(card);
                });
                
                // Réinitialiser les icônes Feather
                feather.replace();
            },
            error: function(xhr, status, error) {
                console.error('Erreur AJAX détaillée :', { status, error, response: xhr.responseText }); // Log étendu pour debug
                grid.innerHTML = '<p style=\"text-align: center; color: var(--danger);\">Erreur lors de la recherche. Vérifiez la console pour plus de détails.</p>';
            }
        });
    }
    </script>
</body>
</html>";
    }

    public function getTemplateName()
    {
        return "caisse_enregistreuse/dashboard_caisse.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  1083 => 1016,  1079 => 1015,  1026 => 965,  959 => 903,  889 => 836,  878 => 828,  874 => 827,  870 => 826,  866 => 825,  850 => 812,  846 => 811,  842 => 810,  838 => 809,  821 => 795,  812 => 789,  800 => 780,  19 => 1,);
    }
}
/* <!DOCTYPE html>*/
/* <html lang="fr">*/
/* <head>*/
/*     <meta charset="UTF-8">*/
/*     <meta name="viewport" content="width=device-width, initial-scale=1.0">*/
/*     <title>ERP ETAA - Caisse Enregistreuse</title>*/
/*     <!-- Feather Icons CDN -->*/
/*     <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>*/
/*   <style>*/
/* * {*/
/*     margin: 0;*/
/*     padding: 0;*/
/*     box-sizing: border-box;*/
/* }*/
/* :root {*/
/*     --background: hsl(220, 25%, 97%);*/
/*     --foreground: hsl(224, 30%, 15%);*/
/*     --card: hsl(0, 0%, 100%);*/
/*     --card-foreground: hsl(224, 30%, 15%);*/
/*     --primary: hsl(221, 83%, 53%);*/
/*     --primary-foreground: hsl(0, 0%, 100%);*/
/*     --primary-light: hsl(217, 91%, 60%);*/
/*     --primary-dark: hsl(224, 76%, 48%);*/
/*     --secondary: hsl(214, 100%, 97%);*/
/*     --secondary-foreground: hsl(224, 30%, 25%);*/
/*     --muted: hsl(217, 33%, 94%);*/
/*     --muted-foreground: hsl(215, 25%, 55%);*/
/*     --accent: hsl(213, 97%, 87%);*/
/*     --accent-foreground: hsl(224, 30%, 25%);*/
/*     --border: hsl(217, 25%, 88%);*/
/*     --success: hsl(142, 71%, 45%);*/
/*     --success-foreground: hsl(0, 0%, 100%);*/
/*     --danger: hsl(0, 84%, 60%);*/
/*     --danger-foreground: hsl(0, 0%, 100%);*/
/*     --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));*/
/*     --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));*/
/*     --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));*/
/*     --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);*/
/*     --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);*/
/*     --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);*/
/* }*/
/* html, body {*/
/*     width: 100%;*/
/*     overflow-x: hidden;*/
/*     font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;*/
/*     background: var(--background);*/
/*     color: var(--foreground);*/
/*     line-height: 1.6;*/
/* }*/
/* /* Navbar Styles *//* */
/* .navbar {*/
/*     background: var(--gradient-primary);*/
/*     box-shadow: var(--shadow-elegant);*/
/*     border-bottom: 1px solid rgba(255, 255, 255, 0.1);*/
/*     position: sticky;*/
/*     top: 0;*/
/*     z-index: 1000;*/
/*     width: 100%;*/
/* }*/
/* .navbar-container {*/
/*     max-width: 1400px;*/
/*     width: 100%;*/
/*     margin: 0 auto;*/
/*     padding: 0 1rem;*/
/*     display: flex;*/
/*     align-items: center;*/
/*     justify-content: space-between;*/
/*     height: 64px;*/
/* }*/
/* .logo {*/
/*     font-size: 1.25rem;*/
/*     font-weight: bold;*/
/*     color: var(--primary-foreground);*/
/*     flex-shrink: 0;*/
/* }*/
/* .nav-menu {*/
/*     display: flex;*/
/*     align-items: center;*/
/*     gap: 0.75rem;*/
/*     flex-wrap: nowrap;*/
/* }*/
/* .nav-item {*/
/*     position: relative;*/
/* }*/
/* .nav-link {*/
/*     display: flex;*/
/*     align-items: center;*/
/*     gap: 0.5rem;*/
/*     padding: 0.5rem 0.75rem;*/
/*     color: var(--primary-foreground);*/
/*     text-decoration: none;*/
/*     border-radius: 0.375rem;*/
/*     transition: all 0.3s ease;*/
/*     background: transparent;*/
/*     border: none;*/
/*     cursor: pointer;*/
/*     font-size: 0.875rem;*/
/*     white-space: nowrap;*/
/* }*/
/* .nav-link:hover {*/
/*     background: rgba(255, 255, 255, 0.1);*/
/* }*/
/* .dropdown {*/
/*     position: absolute;*/
/*     top: 100%;*/
/*     left: 0;*/
/*     background: var(--card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.5rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     min-width: 180px;*/
/*     max-width: calc(100vw - 2rem);*/
/*     opacity: 0;*/
/*     visibility: hidden;*/
/*     transform: translateY(-10px);*/
/*     transition: all 0.3s ease;*/
/*     z-index: 100;*/
/* }*/
/* .nav-item:hover .dropdown {*/
/*     opacity: 1;*/
/*     visibility: visible;*/
/*     transform: translateY(0);*/
/* }*/
/* .dropdown-item {*/
/*     display: block;*/
/*     padding: 0.75rem 1rem;*/
/*     color: var(--foreground);*/
/*     text-decoration: none;*/
/*     transition: background 0.2s ease;*/
/*     white-space: nowrap;*/
/* }*/
/* .dropdown-item:hover {*/
/*     background: var(--accent);*/
/* }*/
/* .user-menu {*/
/*     position: relative;*/
/*     flex-shrink: 0;*/
/* }*/
/* .user-avatar {*/
/*     width: 40px;*/
/*     height: 40px;*/
/*     border-radius: 50%;*/
/*     background: rgba(255, 255, 255, 0.1);*/
/*     display: flex;*/
/*     align-items: center;*/
/*     justify-content: center;*/
/*     cursor: pointer;*/
/*     transition: background 0.3s ease;*/
/* }*/
/* .user-avatar:hover {*/
/*     background: rgba(255, 255, 255, 0.2);*/
/* }*/
/* .user-menu.active .dropdown {*/
/*     opacity: 1;*/
/*     visibility: visible;*/
/*     transform: translateY(0);*/
/* }*/
/* .mobile-menu-btn {*/
/*     display: none;*/
/*     background: transparent;*/
/*     border: none;*/
/*     color: var(--primary-foreground);*/
/*     cursor: pointer;*/
/*     padding: 0.5rem;*/
/*     border-radius: 0.375rem;*/
/*     flex-shrink: 0;*/
/* }*/
/* /* POS Dashboard Styles *//* */
/* .pos-dashboard {*/
/*     max-width: 1400px;*/
/*     width: 100%;*/
/*     margin: 0 auto;*/
/*     padding: 1rem;*/
/* }*/
/* .pos-header {*/
/*     margin-bottom: 1.5rem;*/
/*     text-align: center;*/
/* }*/
/* .pos-title {*/
/*     font-size: 2.5rem;*/
/*     font-weight: bold;*/
/*     margin-bottom: 0.5rem;*/
/*     background: var(--gradient-primary);*/
/*     -webkit-background-clip: text;*/
/*     -webkit-text-fill-color: transparent;*/
/*     background-clip: text;*/
/* }*/
/* .pos-subtitle {*/
/*     color: var(--muted-foreground);*/
/*     font-size: 1rem;*/
/* }*/
/* /* Quick Actions Grid *//* */
/* .quick-actions-grid {*/
/*     display: grid;*/
/*     grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));*/
/*     gap: 1rem;*/
/*     margin-bottom: 2rem;*/
/*     width: 100%;*/
/* }*/
/* .quick-action-card {*/
/*     background: var(--gradient-card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.75rem;*/
/*     padding: 1rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     transition: all 0.3s ease;*/
/*     cursor: pointer;*/
/*     text-align: center;*/
/*     animation: slideInUp 0.6s ease forwards;*/
/*     opacity: 0;*/
/* }*/
/* .quick-action-card:hover {*/
/*     transform: translateY(-2px);*/
/*     box-shadow: var(--shadow-module);*/
/*     border-color: var(--primary);*/
/* }*/
/* .quick-action-card:nth-child(1) { animation-delay: 0.1s; }*/
/* .quick-action-card:nth-child(2) { animation-delay: 0.2s; }*/
/* .quick-action-card:nth-child(3) { animation-delay: 0.3s; }*/
/* .quick-action-card:nth-child(4) { animation-delay: 0.4s; }*/
/* .quick-action-icon {*/
/*     width: 2.5rem;*/
/*     height: 2.5rem;*/
/*     background: var(--gradient-primary);*/
/*     border-radius: 0.5rem;*/
/*     display: flex;*/
/*     align-items: center;*/
/*     justify-content: center;*/
/*     color: var(--primary-foreground);*/
/*     margin: 0 auto 0.5rem;*/
/* }*/
/* .quick-action-title {*/
/*     font-size: 0.875rem;*/
/*     font-weight: bold;*/
/*     color: var(--foreground);*/
/* }*/
/* /* Product Search *//* */
/* .search-section {*/
/*     background: var(--gradient-card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.75rem;*/
/*     padding: 1.5rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     margin-bottom: 2rem;*/
/*     animation: slideInUp 0.6s ease forwards;*/
/*     opacity: 0;*/
/*     animation-delay: 0.5s;*/
/* }*/
/* .search-input-group {*/
/*     display: flex;*/
/*     gap: 1rem;*/
/*     margin-bottom: 1rem;*/
/*     flex-wrap: wrap;*/
/*     align-items: center;*/
/* }*/
/* .search-input {*/
/*     flex: 1;*/
/*     padding: 0.75rem 1rem;*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.5rem;*/
/*     font-size: 1rem;*/
/*     background: var(--card);*/
/*     min-width: 200px;*/
/* }*/
/* .search-btn {*/
/*     padding: 0.75rem 1.5rem;*/
/*     background: var(--gradient-primary);*/
/*     color: var(--primary-foreground);*/
/*     border: none;*/
/*     border-radius: 0.5rem;*/
/*     cursor: pointer;*/
/*     font-weight: bold;*/
/*     transition: all 0.3s ease;*/
/* }*/
/* .search-btn:hover {*/
/*     background: var(--primary-dark);*/
/* }*/
/* .client-phone-input {*/
/*     padding: 0.75rem 1rem;*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.5rem;*/
/*     font-size: 1rem;*/
/*     background: var(--card);*/
/*     min-width: 200px;*/
/* }*/
/* .validate-order-btn {*/
/*     padding: 0.75rem 1.5rem;*/
/*     background: var(--gradient-primary);*/
/*     color: var(--primary-foreground);*/
/*     border: none;*/
/*     border-radius: 0.5rem;*/
/*     cursor: pointer;*/
/*     font-weight: bold;*/
/*     transition: all 0.3s ease;*/
/*     white-space: nowrap;*/
/*     font-size: 1rem;*/
/* }*/
/* .validate-order-btn:hover:not(:disabled) {*/
/*     background: var(--primary-dark);*/
/* }*/
/* .validate-order-btn:disabled {*/
/*     background: var(--muted);*/
/*     color: var(--muted-foreground);*/
/*     cursor: not-allowed;*/
/* }*/
/* .phone-label {*/
/*     font-weight: bold;*/
/*     color: var(--foreground);*/
/*     white-space: nowrap;*/
/*     margin-right: 0.5rem;*/
/* }*/
/* /* Main POS Content *//* */
/* .main-pos-content {*/
/*     display: grid;*/
/*     grid-template-columns: 1fr 2fr; /* Colonne gauche 1 partie, droite 2 parties (droite plus grande) *//* */
/*     gap: 2rem;*/
/*     margin-bottom: 2rem;*/
/*     width: 100%;*/
/* }*/
/* .left-panel {*/
/*     display: flex;*/
/*     flex-direction: column;*/
/*     gap: 1rem;*/
/* }*/
/* .right-panel {*/
/*     display: flex;*/
/*     flex-direction: column;*/
/*     gap: 1rem;*/
/* }*/
/* /* Cart List *//* */
/* .products-list {*/
/*     background: var(--gradient-card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.75rem;*/
/*     padding: 1.5rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     max-height: 500px;*/
/*     overflow-y: auto;*/
/*     animation: slideInUp 0.6s ease forwards;*/
/*     opacity: 0;*/
/*     animation-delay: 0.7s;*/
/* }*/
/* .products-list h3 {*/
/*     margin-bottom: 1rem;*/
/*     color: var(--foreground);*/
/*     font-size: 1.25rem;*/
/* }*/
/* .product-item {*/
/*     display: flex;*/
/*     justify-content: space-between;*/
/*     align-items: center;*/
/*     padding: 1rem;*/
/*     border-bottom: 1px solid var(--border);*/
/*     transition: background 0.2s ease;*/
/* }*/
/* .product-item:hover {*/
/*     background: var(--accent);*/
/* }*/
/* .product-item:last-child {*/
/*     border-bottom: none;*/
/* }*/
/* .product-details {*/
/*     flex: 1;*/
/* }*/
/* .product-name {*/
/*     font-weight: bold;*/
/*     color: var(--foreground);*/
/* }*/
/* .product-price {*/
/*     color: var(--primary);*/
/*     font-size: 1.1rem;*/
/* }*/
/* .product-controls {*/
/*     display: flex;*/
/*     gap: 0.5rem;*/
/*     align-items: center;*/
/* }*/
/* .qty-btn, .remove-btn {*/
/*     padding: 0.25rem 0.5rem;*/
/*     border: 1px solid var(--border);*/
/*     background: var(--card);*/
/*     border-radius: 0.25rem;*/
/*     cursor: pointer;*/
/*     transition: all 0.2s ease;*/
/* }*/
/* .qty-btn:hover, .remove-btn:hover {*/
/*     background: var(--primary);*/
/*     color: var(--primary-foreground);*/
/* }*/
/* .remove-btn {*/
/*     color: var(--danger);*/
/*     border-color: var(--danger);*/
/* }*/
/* .remove-btn:hover {*/
/*     background: var(--danger);*/
/*     color: var(--danger-foreground);*/
/* }*/
/* /* Totals Section *//* */
/* .totals-section {*/
/*     background: var(--gradient-card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.75rem;*/
/*     padding: 1.5rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     animation: slideInUp 0.6s ease forwards;*/
/*     opacity: 0;*/
/*     animation-delay: 0.8s;*/
/* }*/
/* .total-row {*/
/*     display: flex;*/
/*     justify-content: space-between;*/
/*     margin-bottom: 1rem;*/
/*     font-size: 1.1rem;*/
/* }*/
/* .total-label {*/
/*     color: var(--muted-foreground);*/
/* }*/
/* .total-value {*/
/*     font-weight: bold;*/
/*     color: var(--foreground);*/
/* }*/
/* .grand-total {*/
/*     border-top: 2px solid var(--border);*/
/*     padding-top: 1rem;*/
/*     font-size: 1.5rem;*/
/*     color: var(--primary);*/
/* }*/
/* /* Products Grid *//* */
/* .products-grid-section {*/
/*     background: var(--gradient-card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.75rem;*/
/*     padding: 1.5rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     animation: slideInUp 0.6s ease forwards;*/
/*     opacity: 0;*/
/*     animation-delay: 0.6s;*/
/* }*/
/* .products-grid-section h3 {*/
/*     margin-bottom: 1rem;*/
/*     color: var(--foreground);*/
/*     font-size: 1.25rem;*/
/* }*/
/* .products-grid {*/
/*     display: grid;*/
/*     grid-template-columns: repeat(5, 1fr); /* 5 colonnes fixes pour desktop/large screens *//* */
/*     gap: 0.75rem; /* Gap ajusté pour plus de densité avec 5 colonnes *//* */
/*     width: 100%;*/
/*     max-height: 600px; /* Hauteur max pour limiter l'espace vertical *//* */
/*     overflow-y: auto; /* Active le scroll vertical *//* */
/*     padding-right: 0.5rem; /* Petit padding pour éviter que le scroll colle au bord *//* */
/*     scrollbar-width: thin; /* Scrollbar fine (Firefox) *//* */
/*     scrollbar-color: var(--primary) var(--muted); /* Couleur scrollbar (Firefox) *//* */
/* }*/
/* /* Scrollbar Webkit pour .products-grid *//* */
/* .products-grid::-webkit-scrollbar {*/
/*     width: 6px;*/
/* }*/
/* .products-grid::-webkit-scrollbar-track {*/
/*     background: var(--muted);*/
/*     border-radius: 3px;*/
/* }*/
/* .products-grid::-webkit-scrollbar-thumb {*/
/*     background: var(--primary);*/
/*     border-radius: 3px;*/
/* }*/
/* .products-grid::-webkit-scrollbar-thumb:hover {*/
/*     background: var(--primary-dark);*/
/* }*/
/* .product-card {*/
/*     background: var(--card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.5rem; /* Bordure légèrement plus petite pour compacité *//* */
/*     padding: 0.75rem; /* Ajusté pour la largeur moyenne *//* */
/*     box-shadow: var(--shadow-card);*/
/*     transition: all 0.3s ease;*/
/*     cursor: pointer;*/
/*     text-align: center;*/
/*     opacity: 1;*/
/*     aspect-ratio: 3 / 5; /* Ratio augmenté en hauteur pour plus d'espace au nom *//* */
/*     display: flex;*/
/*     flex-direction: column; /* Layout vertical compact *//* */
/*     justify-content: flex-start; /* Aligne en haut pour plus d'espace au nom *//* */
/* }*/
/* .product-card:hover {*/
/*     transform: translateY(-2px); /* Hover plus subtil pour petites cartes *//* */
/*     box-shadow: var(--shadow-module);*/
/*     border-color: var(--primary);*/
/* }*/
/* .product-card.hidden {*/
/*     display: none;*/
/* }*/
/* .product-image {*/
/*     width: 100%;*/
/*     height: 40%; /* Réduit à 40% pour laisser plus d'espace au nom sur desktop *//* */
/*     background: var(--muted);*/
/*     border-radius: 0.375rem;*/
/*     margin-bottom: 0.5rem; /* Plus d'espace après l'image *//* */
/*     display: flex;*/
/*     align-items: center;*/
/*     justify-content: center;*/
/*     color: var(--muted-foreground);*/
/*     font-size: 1.25rem; /* Icône adaptée pour placeholder *//* */
/*     object-fit: cover; /* Pour les vraies images : couvre sans déformer *//* */
/*     flex-shrink: 0; /* Empêche la réduction de l'image *//* */
/* }*/
/* .product-name {*/
/*     font-weight: bold;*/
/*     color: var(--foreground);*/
/*     margin-bottom: 0.25rem;*/
/*     font-size: 1rem; /* Augmenté pour meilleure visibilité sur desktop *//* */
/*     line-height: 1.5; /* Plus aéré pour lisibilité complète *//* */
/*     overflow: hidden;*/
/*     display: -webkit-box;*/
/*     -webkit-line-clamp: 4; /* Permet jusqu'à 4 lignes pour afficher le nom complet sur desktop *//* */
/*     -webkit-box-orient: vertical;*/
/*     flex: 1; /* Occupe tout l'espace disponible pour le nom *//* */
/*     text-align: center; /* Centré pour cohérence *//* */
/* }*/
/* .product-price {*/
/*     font-size: 0.95rem; /* Légèrement augmenté *//* */
/*     color: var(--primary);*/
/*     font-weight: bold;*/
/*     margin-bottom: 0.5rem; /* Plus d'espace avant bouton *//* */
/*     flex-shrink: 0; /* Prix fixe *//* */
/* }*/
/* .add-to-cart-btn {*/
/*     width: 100%;*/
/*     padding: 0.35rem; /* Légèrement augmenté *//* */
/*     background: var(--gradient-primary);*/
/*     color: var(--primary-foreground);*/
/*     border: none;*/
/*     border-radius: 0.375rem; /* Bordure plus petite *//* */
/*     cursor: pointer;*/
/*     font-size: 0.75rem; /* Légèrement augmenté *//* */
/*     transition: all 0.3s ease;*/
/*     flex-shrink: 0; /* Bouton fixe en bas *//* */
/* }*/
/* .add-to-cart-btn:hover {*/
/*     background: var(--primary-dark);*/
/* }*/
/* /* Payment Section *//* */
/* .payment-section {*/
/*     background: var(--gradient-card);*/
/*     border: 1px solid var(--border);*/
/*     border-radius: 0.75rem;*/
/*     padding: 1.5rem;*/
/*     box-shadow: var(--shadow-card);*/
/*     animation: slideInUp 0.6s ease forwards;*/
/*     opacity: 0;*/
/*     animation-delay: 0.9s;*/
/* }*/
/* .payment-methods {*/
/*     display: flex;*/
/*     gap: 1rem;*/
/*     margin-bottom: 1.5rem;*/
/* }*/
/* .payment-method {*/
/*     flex: 1;*/
/*     padding: 1rem;*/
/*     text-align: center;*/
/*     border: 2px solid var(--border);*/
/*     border-radius: 0.5rem;*/
/*     cursor: pointer;*/
/*     transition: all 0.3s ease;*/
/*     background: var(--card);*/
/* }*/
/* .payment-method:hover, .payment-method.active {*/
/*     border-color: var(--primary);*/
/*     background: var(--primary-light);*/
/*     color: var(--primary-foreground);*/
/* }*/
/* .payment-method-icon {*/
/*     width: 2rem;*/
/*     height: 2rem;*/
/*     margin: 0 auto 0.5rem;*/
/*     color: var(--primary);*/
/* }*/
/* /* Animations *//* */
/* @keyframes slideInUp {*/
/*     from {*/
/*         opacity: 0;*/
/*         transform: translateY(30px);*/
/*     }*/
/*     to {*/
/*         opacity: 1;*/
/*         transform: translateY(0);*/
/*     }*/
/* }*/
/* /* Mobile Styles *//* */
/* @media (max-width: 768px) {*/
/*     .nav-menu {*/
/*         display: none;*/
/*     }*/
/*     .mobile-menu-btn {*/
/*         display: block;*/
/*     }*/
/*     .pos-dashboard {*/
/*         padding: 0.5rem;*/
/*     }*/
/*     .quick-actions-grid {*/
/*         grid-template-columns: repeat(2, 1fr);*/
/*         gap: 0.5rem;*/
/*     }*/
/*     .main-pos-content {*/
/*         grid-template-columns: 1fr; /* Sur mobile, une seule colonne pour l'empilement *//* */
/*         gap: 1rem;*/
/*     }*/
/*     .products-grid {*/
/*         grid-template-columns: repeat(3, 1fr); /* 3 colonnes sur mobile/tablette *//* */
/*         gap: 0.5rem; /* Gap réduit sur mobile *//* */
/*         max-height: 400px; /* Hauteur réduite sur mobile *//* */
/*     }*/
/*     .payment-methods {*/
/*         flex-direction: column;*/
/*     }*/
/*     .search-input-group {*/
/*         flex-direction: column;*/
/*         align-items: stretch;*/
/*     }*/
/*     .search-input, .client-phone-input {*/
/*         min-width: auto;*/
/*     }*/
/*     .pos-title {*/
/*         font-size: 2rem;*/
/*     }*/
/*     .product-card {*/
/*         aspect-ratio: 4 / 5; /* Ratio ajusté pour mobile (plus vertical) *//* */
/*         padding: 0.6rem;*/
/*     }*/
/*     .product-image {*/
/*         height: 40%; /* Réduit pour plus d'espace au nom sur mobile *//* */
/*     }*/
/*     .product-name {*/
/*         font-size: 0.85rem;*/
/*         -webkit-line-clamp: 4; /* Plus de lignes sur mobile pour visibilité complète *//* */
/*         line-height: 1.4;*/
/*     }*/
/*     .product-price {*/
/*         font-size: 0.9rem;*/
/*     }*/
/*     .add-to-cart-btn {*/
/*         font-size: 0.7rem;*/
/*         padding: 0.3rem;*/
/*     }*/
/* }*/
/* @media (max-width: 480px) {*/
/*     .products-grid {*/
/*         grid-template-columns: repeat(2, 1fr); /* 2 colonnes sur très petit mobile pour lisibilité *//* */
/*         gap: 0.5rem;*/
/*         max-height: 500px; /* Plus de hauteur pour scroll vertical *//* */
/*     }*/
/*     .product-card {*/
/*         aspect-ratio: 3 / 5; /* Ratio augmenté pour plus d'espace sur petit écran *//* */
/*         padding: 0.75rem;*/
/*     }*/
/*     .product-image {*/
/*         height: 40%; /* Réduit pour plus d'espace au nom *//* */
/*     }*/
/*     .product-name {*/
/*         font-size: 0.9rem;*/
/*         -webkit-line-clamp: 4; /* 4 lignes max sur petit écran *//* */
/*         white-space: normal; /* Permet le wrap complet *//* */
/*     }*/
/*     .product-price {*/
/*         font-size: 0.95rem;*/
/*     }*/
/*     .add-to-cart-btn {*/
/*         font-size: 0.75rem;*/
/*         padding: 0.35rem;*/
/*     }*/
/* }*/
/* @media (max-width: 1199px) and (min-width: 769px) {*/
/*     .products-grid {*/
/*         grid-template-columns: repeat(4, 1fr); /* 4 colonnes sur tablette large *//* */
/*         gap: 0.6rem;*/
/*         max-height: 500px; /* Légèrement réduit *//* */
/*     }*/
/*     .product-card {*/
/*         aspect-ratio: 3 / 5; /* Ratio augmenté pour plus d'espace *//* */
/*     }*/
/*     .product-image {*/
/*         height: 45%; /* Ajusté pour tablette *//* */
/*     }*/
/*     .product-name {*/
/*         font-size: 0.95rem;*/
/*         -webkit-line-clamp: 4;*/
/*     }*/
/*     .product-price {*/
/*         font-size: 0.95rem;*/
/*     }*/
/*     .add-to-cart-btn {*/
/*         font-size: 0.75rem;*/
/*         padding: 0.35rem;*/
/*     }*/
/* }*/
/* /* Mobile Menu Overlay *//* */
/* .mobile-overlay {*/
/*     position: fixed;*/
/*     top: 0;*/
/*     left: 0;*/
/*     right: 0;*/
/*     bottom: 0;*/
/*     background: rgba(0, 0, 0, 0.5);*/
/*     z-index: 999;*/
/*     opacity: 0;*/
/*     visibility: hidden;*/
/*     transition: all 0.3s ease;*/
/* }*/
/* .mobile-overlay.active {*/
/*     opacity: 1;*/
/*     visibility: visible;*/
/* }*/
/* .mobile-menu {*/
/*     position: fixed;*/
/*     top: 0;*/
/*     right: -100%;*/
/*     width: min(280px, 90vw);*/
/*     height: 100vh;*/
/*     background: var(--gradient-primary);*/
/*     z-index: 1000;*/
/*     transition: right 0.3s ease;*/
/*     padding: 1.5rem;*/
/*     overflow-x: hidden;*/
/* }*/
/* .mobile-menu.active {*/
/*     right: 0;*/
/* }*/
/* .mobile-menu-header {*/
/*     display: flex;*/
/*     justify-content: space-between;*/
/*     align-items: center;*/
/*     margin-bottom: 1.5rem;*/
/* }*/
/* .mobile-menu-title {*/
/*     color: var(--primary-foreground);*/
/*     font-size: 1.25rem;*/
/*     font-weight: bold;*/
/* }*/
/* .close-btn {*/
/*     background: transparent;*/
/*     border: none;*/
/*     color: var(--primary-foreground);*/
/*     cursor: pointer;*/
/*     padding: 0.5rem;*/
/* }*/
/* .mobile-nav-item {*/
/*     margin-bottom: 0.75rem;*/
/* }*/
/* .mobile-nav-link {*/
/*     display: flex;*/
/*     align-items: center;*/
/*     gap: 0.75rem;*/
/*     padding: 0.75rem;*/
/*     color: var(--primary-foreground);*/
/*     text-decoration: none;*/
/*     border-radius: 0.5rem;*/
/*     transition: background 0.3s ease;*/
/*     white-space: nowrap;*/
/*     font-size: 0.875rem;*/
/* }*/
/* .mobile-nav-link:hover {*/
/*     background: rgba(255, 255, 255, 0.1);*/
/* }*/
/* /* Icons *//* */
/* .icon {*/
/*     width: 1rem;*/
/*     height: 1rem;*/
/*     stroke: currentColor;*/
/*     fill: none;*/
/*     stroke-width: 2;*/
/* }*/
/* .icon-lg {*/
/*     width: 1.5rem;*/
/*     height: 1.5rem;*/
/* }*/
/* </style>*/
/* </head>*/
/* <body>*/
/*     <input type="hidden" name="base_url" id="base_url" value="{{ base_url }}"/>*/
/*     <!-- Navigation -->*/
/*     <nav class="navbar">*/
/*         <div class="navbar-container">*/
/*             <div class="logo">ERP ETAA</div>*/
/*          */
/*             <div class="nav-menu">*/
/* */
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}admin/dashboard" class="nav-link">*/
/*                         <i class="icon" data-feather="airplay"></i>*/
/*                         Dashboard principal*/
/*                     </a>*/
/*                 </div>*/
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_commerciale" class="nav-link">*/
/*                         <i class="icon" data-feather="home"></i>*/
/*                          Dashboard Gestion Commerciale*/
/*                     </a>*/
/*                 </div>*/
/*                 */
/*                <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="package"></i>*/
/*                         Achats*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*     */
/*                         <a href="{{ base_url }}gestion_commerciale/demandes_achat/" class="dropdown-item">Demandes d'achat</a>*/
/*                         <a href="{{ base_url }}gestion_commerciale/commandes_fournisseur" class="dropdown-item">Commandes fournisseurs</a>*/
/*                         <a href="{{ base_url }}gestion_commerciale/liste_bons_recepotion" class="dropdown-item">Réceptions</a>*/
/*                         <a href="{{ base_url }}gestion_commerciale/liste_factures_fournisseur" class="dropdown-item">Factures fournisseur</a>*/
/* */
/*                         */
/*                     </div>*/
/*                 </div>*/
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="shopping-bag"></i>*/
/*                         Ventes*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*     */
/*                         <a href="{{ base_url }}gestion_commerciale/liste_devis/" class="dropdown-item">Devis</a>*/
/*                          <a href="{{ base_url }}gestion_commerciale/liste_bons_commande/" class="dropdown-item">Bons de commande </a>*/
/*                         <a href="{{ base_url }}gestion_commerciale/liste_bons_livraison" class="dropdown-item">Bons de livraison</a>*/
/*                         <a href="{{ base_url }}gestion_commerciale/liste_factures_client" class="dropdown-item">Factures </a>*/
/* */
/*                         */
/*                     </div>*/
/*                 </div>*/
/*                 */
/*             */
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}crm/liste_campagnes/1/-1" class="nav-link">*/
/*                         <i class="icon" data-feather="pie-chart"></i>*/
/*                         Suivi & Reporting*/
/*                     </a>*/
/*                 </div>*/
/*                 */
/*             </div>*/
/*          */
/*             <div class="user-menu">*/
/*                 <button class="user-avatar" onclick="toggleUserMenu()">*/
/*                     <i class="icon icon-lg" data-feather="user"></i>*/
/*                 </button>*/
/*                 <div class="dropdown">*/
/*                     <a href="/profil" class="dropdown-item">Profil</a>*/
/*                     <a href="/logout" class="dropdown-item" style="color: #dc2626;">Se déconnecter</a>*/
/*                 </div>*/
/*             </div>*/
/*          */
/*             <button class="mobile-menu-btn" onclick="toggleMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="menu"></i>*/
/*             </button>*/
/*         </div>*/
/*     </nav>*/
/*     <!-- Mobile Menu Overlay -->*/
/*     <div class="mobile-overlay" id="mobileOverlay" onclick="closeMobileMenu()"></div>*/
/*     <div class="mobile-menu" id="mobileMenu">*/
/*         <div class="mobile-menu-header">*/
/*             <div class="mobile-menu-title">Menu</div>*/
/*             <button class="close-btn" onclick="closeMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="x"></i>*/
/*             </button>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="home"></i>*/
/*                 Dashboard*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/caisse" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="dollar-sign"></i>*/
/*                 Caisse*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/ventes" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="shopping-cart"></i>*/
/*                 Ventes*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/stock" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="package"></i>*/
/*                 Stock*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/rapports" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="file-text"></i>*/
/*                 Rapports*/
/*             </a>*/
/*         </div>*/
/*     </div>*/
/*     <!-- POS Content -->*/
/*     <main class="pos-dashboard">*/
/*         <div class="pos-header">*/
/*             <h1 class="pos-title">Caisse Enregistreuse  </h1>*/
/*             <p style="font-size:20px"><b>Total:</b>&nbsp; <b style="color:red">{{ total_caisse }} {{ societe.Devise }}</b></p>*/
/*         </div>*/
/*       */
/*         <!-- Quick Actions -->*/
/*         <!--*/
/*         <div class="quick-actions-grid">*/
/*             <div class="quick-action-card" onclick="newSale()">*/
/*                 <div class="quick-action-icon">*/
/*                     <i data-feather="plus-circle"></i>*/
/*                 </div>*/
/*                 <div class="quick-action-title">Nouvelle Vente</div>*/
/*             </div>*/
/*             <div class="quick-action-card" onclick="addDiscount()">*/
/*                 <div class="quick-action-icon">*/
/*                     <i data-feather="percent"></i>*/
/*                 </div>*/
/*                 <div class="quick-action-title">Remise</div>*/
/*             </div>*/
/*             <div class="quick-action-card" onclick="selectCustomer()">*/
/*                 <div class="quick-action-icon">*/
/*                     <i data-feather="user-plus"></i>*/
/*                 </div>*/
/*                 <div class="quick-action-title">Client</div>*/
/*             </div>*/
/*             <div class="quick-action-card" onclick="printReceipt()">*/
/*                 <div class="quick-action-icon">*/
/*                     <i data-feather="printer"></i>*/
/*                 </div>*/
/*                 <div class="quick-action-title">Imprimer</div>*/
/*             </div>*/
/*         </div>*/
/*         -->*/
/*       */
/*         <!-- Product Search and Client Info -->*/
/*         <div class="search-section">*/
/*             <div class="search-input-group">*/
/*                 <input type="text" class="search-input" placeholder="Rechercher un produit (code ou nom)..." id="productSearch" onkeyup="searchProductsAjax()" onchange="searchProductsAjax()">*/
/*                 <button class="search-btn" onclick="searchProduct()">*/
/*                     <i class="icon" data-feather="search"></i>*/
/*                     Rechercher*/
/*                 </button>*/
/*                 <span class="phone-label">Téléphone client (optionnel) :</span>*/
/*                 <input type="text" id="customerPhone" class="client-phone-input" placeholder="Entrez le numéro de téléphone">*/
/*                 <button class="validate-order-btn" onclick="completeSale()" id="validateBtn" disabled>Valider la commande</button>*/
/*             </div>*/
/*         </div>*/
/*       */
/*         <!-- Main POS Content: Cart Left, Products Right -->*/
/*         <div class="main-pos-content">*/
/*             <div class="left-panel">*/
/*                 <!-- Cart List -->*/
/*                 <div class="products-list">*/
/*                     <h3>Panier Actuel</h3>*/
/*                     <div id="productItems">*/
/*                         <!-- Items ajoutés dynamiquement -->*/
/*                     </div>*/
/*                 </div>*/
/*                 <!-- Totals -->*/
/*                 <div class="totals-section">*/
/*                     <h3>Totaux</h3>*/
/*                     <div class="total-row grand-total">*/
/*                         <span class="total-label">Total TTC</span>*/
/*                         <span class="total-value" id="grandTotal">0,00 {{ societe.Devise }}</span>*/
/*                     </div>*/
/*                 </div>*/
/*             </div>*/
/*             <div class="right-panel">*/
/*                 <!-- Products Grid -->*/
/*                 <div class="products-grid-section">*/
/*                     <h3>Produits Disponibles</h3>*/
/*                     <div class="products-grid" id="productsGrid">*/
/*                         <!-- Produits seront générés par JS -->*/
/*                     </div>*/
/*                 </div>*/
/*             </div>*/
/*         </div>*/
/*       */
/*         <!-- Payment -->*/
/*         <div class="payment-section">*/
/*             <h3>Modes de Paiement</h3>*/
/*             <div class="payment-methods">*/
/*                 <div class="payment-method active" onclick="selectPayment(this, 'Espèces')">*/
/*                     <div class="payment-method-icon">*/
/*                         <i data-feather="dollar-sign"></i>*/
/*                     </div>*/
/*                     Espèces*/
/*                 </div>*/
/*                 <div class="payment-method" onclick="selectPayment(this, 'Carte bancaire')">*/
/*                     <div class="payment-method-icon">*/
/*                         <i data-feather="credit-card"></i>*/
/*                     </div>*/
/*                     Carte*/
/*                 </div>*/
/*                 <div class="payment-method" >*/
/*                     <a href="" id="impression" style="text-decoration:none;" target="_blank">*/
/*                     <div class="payment-method-icon">*/
/*                         <i data-feather="file-text"></i>*/
/*                     </div>*/
/*                     </a>*/
/*                     Imprimer*/
/*                 </div>*/
/*             </div>*/
/*         </div>*/
/*     </main>*/
/*      <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>*/
/*      <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>*/
/*     <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>*/
/*     <script>*/
/*         // Initialize Feather Icons*/
/*         feather.replace();*/
/* */
/*         // Sample Products Data*/
/*         const products = {{ liste_produits|raw }};*/
/*         const devise = '{{ societe.Devise }}';*/
/* */
/*         // Log initial pour inspecter les données produits*/
/*         console.log('Données produits chargées :', products); // Vérifie la structure ici !*/
/* */
/*         function toggleMobileMenu() {*/
/*             const overlay = document.getElementById('mobileOverlay');*/
/*             const menu = document.getElementById('mobileMenu');*/
/*             overlay.classList.add('active');*/
/*             menu.classList.add('active');*/
/*         }*/
/*         function closeMobileMenu() {*/
/*             const overlay = document.getElementById('mobileOverlay');*/
/*             const menu = document.getElementById('mobileMenu');*/
/*             overlay.classList.remove('active');*/
/*             menu.classList.remove('active');*/
/*         }*/
/*         function toggleUserMenu() {*/
/*             const userMenu = document.querySelector('.user-menu');*/
/*             userMenu.classList.toggle('active');*/
/*         }*/
/* */
/*         // POS Functions*/
/*         function newSale() {*/
/*             document.getElementById('productItems').innerHTML = '';*/
/*             document.getElementById('customerPhone').value = '';*/
/*             updateTotals();*/
/*             alert('Nouvelle vente initiée');*/
/*         }*/
/*         function addDiscount() {*/
/*             const discount = prompt('Entrez le pourcentage de remise :');*/
/*             if (discount) alert(`Remise de ${discount}% appliquée`);*/
/*         }*/
/*         function selectCustomer() {*/
/*             const customer = prompt('Entrez le nom du client :');*/
/*             if (customer) alert(`Client sélectionné : ${customer}`);*/
/*         }*/
/*         function printReceipt() {*/
/*             alert('Ticket en cours d\'impression...');*/
/*         }*/
/*         function searchProduct() {*/
/*             const query = document.getElementById('productSearch').value.toLowerCase();*/
/*             filterProducts(query);*/
/*         }*/
/*         function filterProducts(query = '') {*/
/*             const grid = document.getElementById('productsGrid');*/
/*             grid.innerHTML = '';*/
/*             const filteredProducts = products.filter(p =>*/
/*                 p.name.toLowerCase().includes(query) ||*/
/*                 p.id.toString().includes(query)  // Log si id manquant*/
/*             );*/
/*             console.log('Produits filtrés :', filteredProducts); // Vérifie les IDs ici*/
/*             filteredProducts.forEach(product => {*/
/*                 console.log(`Produit ${product.name} - ID: ${product.id}, Prix: ${product.price}`); // Trace par produit*/
/*                 const card = document.createElement('div');*/
/*                 card.className = 'product-card';*/
/*                 card.innerHTML = `*/
/*                     <img src="${product.image}" alt="${product.name}" class="product-image"*/
/*                          style="width: 100%; height: 120px; object-fit: cover; border-radius: 0.5rem; margin-bottom: 0.5rem; display: block;"*/
/*                          onerror="this.style.display='none'; this.parentNode.insertAdjacentHTML('afterbegin', '<div class=\\'product-image-placeholder\\' style=\\'width:100%; height:120px; background:var(--muted); border-radius:0.5rem; display:flex; align-items:center; justify-content:center; color:var(--muted-foreground); font-size:2rem;\\'><i data-feather=\\"image\\"></i></div>*/
/*                     <div class="product-name">${product.name}</div>*/
/*                     <div class="product-price">${parseFloat(product.price).toFixed(2)} ${devise}</div>*/
/*                     <button class="add-to-cart-btn" onclick="addProductToCart(${product.id || 'null'}, '${product.name.replace(/'/g, "\\'")}', ${parseFloat(product.price)})">Ajouter</button>*/
/*                 `;*/
/*                 grid.appendChild(card);*/
/*             });*/
/*             if (filteredProducts.length === 0) {*/
/*                 grid.innerHTML = '<p style="text-align: center; color: var(--muted-foreground);">Aucun produit trouvé.</p>';*/
/*                 }*/
/*                 feather.replace(); // Réinitialise les icônes Feather après ajout dynamique*/
/*             }*/
/*     function addProductToCart(id, name, price) {*/
/*         console.log(`Ajout au panier - ID reçu: ${id}, Nom: ${name}, Prix: ${price}`); // Trace l'ID entrant*/
/*         const items = document.getElementById('productItems');*/
/*         // Check if product already in cart*/
/*         let existingItem = Array.from(items.querySelectorAll('.product-item')).find(item =>*/
/*             item.dataset.productId == id*/
/*         );*/
/*         if (existingItem) {*/
/*             const qty = existingItem.querySelector('.product-controls span');*/
/*             qty.textContent = parseInt(qty.textContent) + 1;*/
/*             console.log(`Quantité augmentée pour ID ${id}`);*/
/*         } else {*/
/*             const item = document.createElement('div');*/
/*             item.className = 'product-item';*/
/*             item.dataset.productId = id; // Définit l'ID (string ou number -> string)*/
/*             console.log(`Dataset défini pour nouvel item - productId: ${item.dataset.productId}`); // Vérifie le dataset*/
/*             item.innerHTML = `*/
/*                 <div class="product-details">*/
/*                     <div class="product-name">${name}</div>*/
/*                     <div class="product-price">${price.toFixed(2)} ${devise}</div>*/
/*                 </div>*/
/*                 <div class="product-controls">*/
/*                     <button class="qty-btn" onclick="decreaseQty(this)">-</button>*/
/*                     <span>1</span>*/
/*                     <button class="qty-btn" onclick="increaseQty(this)">+</button>*/
/*                     <button class="remove-btn" onclick="removeItem(this)">×</button>*/
/*                 </div>*/
/*             `;*/
/*             items.appendChild(item);*/
/*         }*/
/*         updateTotals();*/
/*         //searchProductsAjax();*/
/*     }*/
/*         function increaseQty(btn) {*/
/*             const qty = btn.previousElementSibling;*/
/*             qty.textContent = parseInt(qty.textContent) + 1;*/
/*             updateTotals();*/
/*         }*/
/*         function decreaseQty(btn) {*/
/*             const qty = btn.nextElementSibling;*/
/*             if (parseInt(qty.textContent) > 1) {*/
/*                 qty.textContent = parseInt(qty.textContent) - 1;*/
/*                 updateTotals();*/
/*             } else if (parseInt(qty.textContent) === 1) {*/
/*                 // Optionnel : supprimer l'item si qty=0*/
/*                 removeItem(btn.parentNode.querySelector('.remove-btn'));*/
/*             }*/
/*         }*/
/*         function removeItem(btn) {*/
/*             btn.closest('.product-item').remove();*/
/*             updateTotals();*/
/*         }*/
/*         function updateTotals() {*/
/*             const items = document.querySelectorAll('.product-item');*/
/*             let total = 0;*/
/*             items.forEach(item => {*/
/*                 const priceText = item.querySelector('.product-price').textContent.replace(devise, '').trim();*/
/*                 const price = parseFloat(priceText);*/
/*                 const qty = parseInt(item.querySelector('.product-controls span').textContent);*/
/*                 total += price * qty;*/
/*             });*/
/*             document.getElementById('grandTotal').textContent = total.toFixed(2) + ' ' + devise;*/
/*             document.getElementById('validateBtn').disabled = items.length === 0;*/
/*         }*/
/*         let selectedPaymentMethod = 'cash'; // Variable globale pour stocker le mode de paiement sélectionné*/
/*         function selectPayment(method, type) {*/
/*             document.querySelectorAll('.payment-method').forEach(m => m.classList.remove('active'));*/
/*             method.classList.add('active');*/
/*             selectedPaymentMethod = type;*/
/*         }*/
/* function completeSale() {*/
/*     const items = document.querySelectorAll('.product-item');*/
/*     if (items.length === 0) return;*/
/*     // Collecter les données du panier*/
/*     const cartData = [];*/
/*     items.forEach((item, index) => {*/
/*         const id = item.dataset.productId; // Récupère l'ID du dataset*/
/*         const name = item.querySelector('.product-name').textContent;*/
/*         const priceText = item.querySelector('.product-price').textContent.replace(devise, '').trim();*/
/*         const price = parseFloat(priceText);*/
/*         const qty = parseInt(item.querySelector('.product-controls span').textContent);*/
/*         */
/*         console.log(`Item ${index} - Dataset ID: "${id}" (type: ${typeof id}), Nom: ${name}`); // Trace détaillé par item*/
/*         */
/*         if (!id) {*/
/*             console.warn(`⚠️ ID manquant pour l'item "${name}" ! Vérifiez les données produits.`);*/
/*             return; // Ignore cet item si ID vide*/
/*         }*/
/*         */
/*         cartData.push({ id, name, price, quantity: qty });*/
/*     });*/
/*     console.log('Données panier final :', cartData); // Log final avant envoi*/
/*     */
/*     const saleData = {*/
/*         customerPhone: document.getElementById('customerPhone').value || null,*/
/*         items: cartData,*/
/*         total: parseFloat(document.getElementById('grandTotal').textContent.replace(devise, '').trim()),*/
/*         paymentMethod: selectedPaymentMethod,*/
/*         // Ajoutez d'autres champs si nécessaire (ex: client_id, etc.)*/
/*     };*/
/*     // AJAX avec XMLHttpRequest*/
/*     const xhr = new XMLHttpRequest();*/
/*     let base_url = $("#base_url").val();*/
/*     xhr.open('POST', base_url+'api/stocker_commande_caisse', true); // Remplacez par votre endpoint réel*/
/*     xhr.setRequestHeader('Content-Type', 'application/json');*/
/*     xhr.onreadystatechange = function() {*/
/*         if (xhr.readyState === 4) {*/
/*             if (xhr.status === 200) {*/
/*                 const result = xhr.responseText;*/
/*                 console.log('Réponse serveur :', result);*/
/*                 const responseData = JSON.parse(result);*/
/*                 window.location.href =base_url+"docs/ticket_caisse/"+responseData.id;*/
/*                 //alert('Vente encaissée avec succès ! Ticket généré.'+responseData.id);*/
/*                 newSale(); // Vider le panier*/
/*             } else {*/
/*                 alert('Erreur lors de l\'encaissement de la vente. Veuillez réessayer.');*/
/*             }*/
/*                 }*/
/*             };*/
/*             xhr.onerror = function() {*/
/*                 alert('Erreur lors de l\'encaissement de la vente. Veuillez réessayer.');*/
/*             };*/
/*             console.log('Envoi des données :', saleData); // Log avant envoi AJAX*/
/*             xhr.send(JSON.stringify(saleData));*/
/*         }*/
/* */
/*         // Initialize Products Grid and Add Initial Cart Items*/
/*         document.addEventListener('DOMContentLoaded', function() {*/
/*             filterProducts();*/
/*             // Add some initial products to cart (exemple, à supprimer en prod)*/
/*             // addProductToCart(1, 'Produit Exemple 1', 15.99);*/
/*             // addProductToCart(2, 'Produit Exemple 2', 29.50);*/
/*         });*/
/* */
/*         // Close dropdowns and user menu when clicking outside*/
/*         document.addEventListener('click', function(event) {*/
/*             const userMenu = document.querySelector('.user-menu');*/
/*             const userAvatar = document.querySelector('.user-avatar');*/
/* */
/*             if (!userAvatar.contains(event.target) && !userMenu.contains(event.target)) {*/
/*                 userMenu.classList.remove('active');*/
/*             }*/
/*         });*/
/* */
/*     function searchProductsAjax() {*/
/* */
/*         const query = document.getElementById('productSearch').value.trim();*/
/*         const grid = document.getElementById('productsGrid');*/
/*         */
/*         // Vider la grille au début de la recherche*/
/*         grid.innerHTML = '<p style="text-align: center; color: var(--muted-foreground);">Recherche en cours...</p>';*/
/*         */
/*         // Ne pas faire de requête si la query est trop courte (ex: min 2 caractères)*/
/*         /**/
/*         if (query.length < 2) {*/
/*             grid.innerHTML = '<p style="text-align: center; color: var(--muted-foreground);">Entrez au moins 2 caractères pour rechercher.</p>';*/
/*             return;*/
/*         }*//* */
/*         */
/*         // Récupérer la base URL*/
/*         const baseUrl = $("#base_url").val();*/
/*         */
/*         // Requête AJAX avec jQuery (déjà inclus)*/
/*         $.ajax({*/
/*             url: baseUrl + 'api/search_products', // Remplacez par votre endpoint réel de recherche (ex: /api/search_products?query=...)*/
/*             method: 'POST', // Ou 'POST' si vous préférez envoyer en body*/
/*             data: { query: query }, // Paramètres de recherche*/
/*             dataType: 'json',*/
/*             success: function(response) {*/
/*                 console.log('Réponse de recherche brute :', response); // Log pour debug (vérifiez dans la console du navigateur)*/
/*                 */
/*                 // Vérifier si la réponse est valide et extraire les produits*/
/*                 let products = [];*/
/*                 if (response && typeof response === 'object') {*/
/*                     products = response.products || response.data || response || [];*/
/*                 } else {*/
/*                     console.warn('Réponse inattendue (pas un objet) :', response);*/
/*                 }*/
/*                 */
/*                 // Vérifier explicitement si products est un tableau*/
/*                 if (!Array.isArray(products)) {*/
/*                     console.error('Products n\'est pas un tableau :', products, '(type:', typeof products, ')');*/
/*                     grid.innerHTML = '<p style="text-align: center; color: var(--danger);">Erreur : Données de produits invalides reçues du serveur.</p>';*/
/*                     return;*/
/*                 }*/
/*                 */
/*                 console.log('Produits extraits (tableau) :', products); */
/*                 */
/*                 if (products.length === 0) {*/
/*                     grid.innerHTML = '<p style="text-align: center; color: var(--muted-foreground);">Aucun produit trouvé.</p>';*/
/*                     return;*/
/*                 }*/
/*                 */
/*                 // Vider et repopuler la grille*/
/*                 grid.innerHTML = '';*/
/*                 products.forEach(product => {*/
/*                     // Vérifiez la structure de vos produits (ex: {id, name, price, image})*/
/*                     // Ajout d'une vérification basique pour chaque produit*/
/*                     if (!product || !product.name || !product.price) {*/
/*                         console.warn('Produit incomplet ignoré :', product);*/
/*                         return;*/
/*                     }*/
/*                     */
/*                     const card = document.createElement('div');*/
/*                     card.className = 'product-card';*/
/*                     card.innerHTML = `*/
/*                         <img src="${product.image || ''}" alt="${product.name}" class="product-image"*/
/*                              style="width: 100%; height: 120px; object-fit: cover; border-radius: 0.5rem; margin-bottom: 0.5rem; display: block;"*/
/*                              onerror="this.style.display='none'; this.parentNode.insertAdjacentHTML('afterbegin', '<div class=\\'product-image-placeholder\\' style=\\'width:100%; height:120px; background:var(--muted); border-radius:0.5rem; display:flex; align-items:center; justify-content:center; color:var(--muted-foreground); font-size:2rem;\\'><i data-feather=\\"image\\"></i></div>*/
/*                         <div class="product-name">${product.name}</div>*/
/*                         <div class="product-price">${parseFloat(product.price || 0).toFixed(2)} ${devise}</div>*/
/*                         <button class="add-to-cart-btn" onclick="addProductToCart(${product.id || 'null'}, '${(product.name || '').replace(/'/g, "\\'")}', ${parseFloat(product.price || 0)})">Ajouter</button>*/
/*                     `;*/
/*                     grid.appendChild(card);*/
/*                 });*/
/*                 */
/*                 // Réinitialiser les icônes Feather*/
/*                 feather.replace();*/
/*             },*/
/*             error: function(xhr, status, error) {*/
/*                 console.error('Erreur AJAX détaillée :', { status, error, response: xhr.responseText }); // Log étendu pour debug*/
/*                 grid.innerHTML = '<p style="text-align: center; color: var(--danger);">Erreur lors de la recherche. Vérifiez la console pour plus de détails.</p>';*/
/*             }*/
/*         });*/
/*     }*/
/*     </script>*/
/* </body>*/
/* </html>*/
