<?php

/* caisse_enregistreuse/header_caisse.html.twig */
class __TwigTemplate_1c5781304b9cf389ee9290b759fb7b96882bff147091202a90c75f8f62cee6b7 extends Twig_Template
{
    public function __construct(Twig_Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = array(
        );
    }

    protected function doDisplay(array $context, array $blocks = array())
    {
        // line 1
        echo "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>MonERP - Caisse Enregistreuse</title>
    <!-- Feather Icons CDN -->
    <script src=\"https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js\"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        :root {
            --background: hsl(220, 25%, 97%);
            --foreground: hsl(224, 30%, 15%);
            --card: hsl(0, 0%, 100%);
            --card-foreground: hsl(224, 30%, 15%);
            --primary: hsl(221, 83%, 53%);
            --primary-foreground: hsl(0, 0%, 100%);
            --primary-light: hsl(217, 91%, 60%);
            --primary-dark: hsl(224, 76%, 48%);
            --secondary: hsl(214, 100%, 97%);
            --secondary-foreground: hsl(224, 30%, 25%);
            --muted: hsl(217, 33%, 94%);
            --muted-foreground: hsl(215, 25%, 55%);
            --accent: hsl(213, 97%, 87%);
            --accent-foreground: hsl(224, 30%, 25%);
            --border: hsl(217, 25%, 88%);
            --success: hsl(142, 71%, 45%);
            --success-foreground: hsl(0, 0%, 100%);
            --danger: hsl(0, 84%, 60%);
            --danger-foreground: hsl(0, 0%, 100%);
            --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));
            --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));
            --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));
            --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);
            --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);
            --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);
        }
        html, body {
            width: 100%;
            overflow-x: hidden;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: var(--background);
            color: var(--foreground);
            line-height: 1.6;
        }
        /* Navbar Styles */
        .navbar {
            background: var(--gradient-primary);
            box-shadow: var(--shadow-elegant);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
            width: 100%;
        }
        .navbar-container {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 0 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 64px;
        }
        .logo {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }
        .nav-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            flex-wrap: nowrap;
        }
        .nav-item {
            position: relative;
        }
        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.375rem;
            transition: all 0.3s ease;
            background: transparent;
            border: none;
            cursor: pointer;
            font-size: 0.875rem;
            white-space: nowrap;
        }
        .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }
        .dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            box-shadow: var(--shadow-card);
            min-width: 180px;
            max-width: calc(100vw - 2rem);
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
            z-index: 100;
        }
        .nav-item:hover .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }
        .dropdown-item {
            display: block;
            padding: 0.75rem 1rem;
            color: var(--foreground);
            text-decoration: none;
            transition: background 0.2s ease;
            white-space: nowrap;
        }
        .dropdown-item:hover {
            background: var(--accent);
        }
        .user-menu {
            position: relative;
            flex-shrink: 0;
        }
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        .user-menu.active .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }
        .mobile-menu-btn {
            display: none;
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.375rem;
            flex-shrink: 0;
        }
        /* POS Dashboard Styles */
        .pos-dashboard {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 1rem;
        }
        .pos-header {
            margin-bottom: 1.5rem;
            text-align: center;
        }
        .pos-title {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .pos-subtitle {
            color: var(--muted-foreground);
            font-size: 1rem;
        }
        /* Quick Actions Grid */
        .quick-actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
            width: 100%;
        }
        .quick-action-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            cursor: pointer;
            text-align: center;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }
        .quick-action-card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-module);
            border-color: var(--primary);
        }
        .quick-action-card:nth-child(1) { animation-delay: 0.1s; }
        .quick-action-card:nth-child(2) { animation-delay: 0.2s; }
        .quick-action-card:nth-child(3) { animation-delay: 0.3s; }
        .quick-action-card:nth-child(4) { animation-delay: 0.4s; }
        .quick-action-icon {
            width: 2.5rem;
            height: 2.5rem;
            background: var(--gradient-primary);
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-foreground);
            margin: 0 auto 0.5rem;
        }
        .quick-action-title {
            font-size: 0.875rem;
            font-weight: bold;
            color: var(--foreground);
        }
        /* Product Search */
        .search-section {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            margin-bottom: 2rem;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            animation-delay: 0.5s;
        }
        .search-input-group {
            display: flex;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        .search-input {
            flex: 1;
            padding: 0.75rem 1rem;
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            font-size: 1rem;
            background: var(--card);
        }
        .search-btn {
            padding: 0.75rem 1.5rem;
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            border: none;
            border-radius: 0.5rem;
            cursor: pointer;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        .search-btn:hover {
            background: var(--primary-dark);
        }
        /* Main POS Content */
        .main-pos-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
            margin-bottom: 2rem;
            width: 100%;
        }
        .left-panel {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
        .right-panel {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
        /* Cart List */
        .products-list {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            max-height: 500px;
            overflow-y: auto;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            animation-delay: 0.7s;
        }
        .products-list h3 {
            margin-bottom: 1rem;
            color: var(--foreground);
            font-size: 1.25rem;
        }
        .product-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem;
            border-bottom: 1px solid var(--border);
            transition: background 0.2s ease;
        }
        .product-item:hover {
            background: var(--accent);
        }
        .product-item:last-child {
            border-bottom: none;
        }
        .product-details {
            flex: 1;
        }
        .product-name {
            font-weight: bold;
            color: var(--foreground);
        }
        .product-price {
            color: var(--primary);
            font-size: 1.1rem;
        }
        .product-controls {
            display: flex;
            gap: 0.5rem;
            align-items: center;
        }
        .qty-btn, .remove-btn {
            padding: 0.25rem 0.5rem;
            border: 1px solid var(--border);
            background: var(--card);
            border-radius: 0.25rem;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        .qty-btn:hover, .remove-btn:hover {
            background: var(--primary);
            color: var(--primary-foreground);
        }
        .remove-btn {
            color: var(--danger);
            border-color: var(--danger);
        }
        .remove-btn:hover {
            background: var(--danger);
            color: var(--danger-foreground);
        }
        /* Totals Section */
        .totals-section {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            animation-delay: 0.8s;
        }
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1rem;
            font-size: 1.1rem;
        }
        .total-label {
            color: var(--muted-foreground);
        }
        .total-value {
            font-weight: bold;
            color: var(--foreground);
        }
        .grand-total {
            border-top: 2px solid var(--border);
            padding-top: 1rem;
            font-size: 1.5rem;
            color: var(--primary);
        }
        /* Products Grid */
        .products-grid-section {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            animation-delay: 0.6s;
        }
        .products-grid-section h3 {
            margin-bottom: 1rem;
            color: var(--foreground);
            font-size: 1.25rem;
        }
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 1rem;
            width: 100%;
        }
        .product-card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            cursor: pointer;
            text-align: center;
            opacity: 1;
        }
        .product-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-module);
            border-color: var(--primary);
        }
        .product-card.hidden {
            display: none;
        }
        .product-image {
            width: 100%;
            height: 120px;
            background: var(--muted);
            border-radius: 0.5rem;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--muted-foreground);
            font-size: 2rem;
        }
        .product-name {
            font-weight: bold;
            color: var(--foreground);
            margin-bottom: 0.25rem;
        }
        .product-price {
            font-size: 1.1rem;
            color: var(--primary);
            font-weight: bold;
        }
        .add-to-cart-btn {
            width: 100%;
            padding: 0.5rem;
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            border: none;
            border-radius: 0.5rem;
            cursor: pointer;
            margin-top: 0.5rem;
            font-size: 0.875rem;
            transition: all 0.3s ease;
        }
        .add-to-cart-btn:hover {
            background: var(--primary-dark);
        }
        /* Payment Section */
        .payment-section {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            animation-delay: 0.9s;
        }
        .payment-methods {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }
        .payment-method {
            flex: 1;
            padding: 1rem;
            text-align: center;
            border: 2px solid var(--border);
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            background: var(--card);
        }
        .payment-method:hover, .payment-method.active {
            border-color: var(--primary);
            background: var(--primary-light);
            color: var(--primary-foreground);
        }
        .payment-method-icon {
            width: 2rem;
            height: 2rem;
            margin: 0 auto 0.5rem;
            color: var(--primary);
        }
        .complete-sale-btn {
            width: 100%;
            padding: 1rem;
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            border: none;
            border-radius: 0.5rem;
            font-size: 1.25rem;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .complete-sale-btn:hover {
            background: var(--primary-dark);
        }
        .complete-sale-btn:disabled {
            background: var(--muted);
            color: var(--muted-foreground);
            cursor: not-allowed;
        }
        /* Animations */
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        /* Mobile Styles */
        @media (max-width: 768px) {
            .nav-menu {
                display: none;
            }
            .mobile-menu-btn {
                display: block;
            }
            .pos-dashboard {
                padding: 0.5rem;
            }
            .quick-actions-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 0.5rem;
            }
            .main-pos-content {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            .products-grid {
                grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            }
            .payment-methods {
                flex-direction: column;
            }
            .pos-title {
                font-size: 2rem;
            }
        }
        /* Mobile Menu Overlay */
        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }
        .mobile-menu {
            position: fixed;
            top: 0;
            right: -100%;
            width: min(280px, 90vw);
            height: 100vh;
            background: var(--gradient-primary);
            z-index: 1000;
            transition: right 0.3s ease;
            padding: 1.5rem;
            overflow-x: hidden;
        }
        .mobile-menu.active {
            right: 0;
        }
        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        .mobile-menu-title {
            color: var(--primary-foreground);
            font-size: 1.25rem;
            font-weight: bold;
        }
        .close-btn {
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
        }
        .mobile-nav-item {
            margin-bottom: 0.75rem;
        }
        .mobile-nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.5rem;
            transition: background 0.3s ease;
            white-space: nowrap;
            font-size: 0.875rem;
        }
        .mobile-nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }
        /* Icons */
        .icon {
            width: 1rem;
            height: 1rem;
            stroke: currentColor;
            fill: none;
            stroke-width: 2;
        }
        .icon-lg {
            width: 1.5rem;
            height: 1.5rem;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class=\"navbar\">
        <div class=\"navbar-container\">
            <div class=\"logo\">ERP ETAA</div>
           
            <div class=\"nav-menu\">
                <div class=\"nav-item\">
                    <a href=\"/\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"home\"></i>
                        Dashboard
                    </a>
                </div>
               
                <div class=\"nav-item\">
                    <a href=\"/caisse\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"dollar-sign\"></i>
                        Caisse
                    </a>
                </div>
               
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"shopping-cart\"></i>
                        Ventes
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/devis\" class=\"dropdown-item\">Devis</a>
                        <a href=\"/commandes\" class=\"dropdown-item\">Commandes</a>
                        <a href=\"/factures\" class=\"dropdown-item\">Factures</a>
                        <a href=\"/clients\" class=\"dropdown-item\">Clients</a>
                    </div>
                </div>
               
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"package\"></i>
                        Stock
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/produits\" class=\"dropdown-item\">Produits</a>
                        <a href=\"/inventaire\" class=\"dropdown-item\">Inventaire</a>
                        <a href=\"/fournisseurs\" class=\"dropdown-item\">Fournisseurs</a>
                    </div>
                </div>
               
                <div class=\"nav-item\">
                    <a href=\"/rapports\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"file-text\"></i>
                        Rapports
                    </a>
                </div>
            </div>
           
            <div class=\"user-menu\">
                <button class=\"user-avatar\" onclick=\"toggleUserMenu()\">
                    <i class=\"icon icon-lg\" data-feather=\"user\"></i>
                </button>
                <div class=\"dropdown\">
                    <a href=\"/profil\" class=\"dropdown-item\">Profil</a>
                    <a href=\"/logout\" class=\"dropdown-item\" style=\"color: #dc2626;\">Se déconnecter</a>
                </div>
            </div>
           
            <button class=\"mobile-menu-btn\" onclick=\"toggleMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"menu\"></i>
            </button>
        </div>
    </nav>
    <!-- Mobile Menu Overlay -->
    <div class=\"mobile-overlay\" id=\"mobileOverlay\" onclick=\"closeMobileMenu()\"></div>
    <div class=\"mobile-menu\" id=\"mobileMenu\">
        <div class=\"mobile-menu-header\">
            <div class=\"mobile-menu-title\">Menu</div>
            <button class=\"close-btn\" onclick=\"closeMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"x\"></i>
            </button>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"home\"></i>
                Dashboard
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/caisse\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"dollar-sign\"></i>
                Caisse
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/ventes\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"shopping-cart\"></i>
                Ventes
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/stock\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"package\"></i>
                Stock
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/rapports\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"file-text\"></i>
                Rapports
            </a>
        </div>
    </div>";
    }

    public function getTemplateName()
    {
        return "caisse_enregistreuse/header_caisse.html.twig";
    }

    public function getDebugInfo()
    {
        return array (  19 => 1,);
    }
}
/* <!DOCTYPE html>*/
/* <html lang="fr">*/
/* <head>*/
/*     <meta charset="UTF-8">*/
/*     <meta name="viewport" content="width=device-width, initial-scale=1.0">*/
/*     <title>MonERP - Caisse Enregistreuse</title>*/
/*     <!-- Feather Icons CDN -->*/
/*     <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>*/
/*     <style>*/
/*         * {*/
/*             margin: 0;*/
/*             padding: 0;*/
/*             box-sizing: border-box;*/
/*         }*/
/*         :root {*/
/*             --background: hsl(220, 25%, 97%);*/
/*             --foreground: hsl(224, 30%, 15%);*/
/*             --card: hsl(0, 0%, 100%);*/
/*             --card-foreground: hsl(224, 30%, 15%);*/
/*             --primary: hsl(221, 83%, 53%);*/
/*             --primary-foreground: hsl(0, 0%, 100%);*/
/*             --primary-light: hsl(217, 91%, 60%);*/
/*             --primary-dark: hsl(224, 76%, 48%);*/
/*             --secondary: hsl(214, 100%, 97%);*/
/*             --secondary-foreground: hsl(224, 30%, 25%);*/
/*             --muted: hsl(217, 33%, 94%);*/
/*             --muted-foreground: hsl(215, 25%, 55%);*/
/*             --accent: hsl(213, 97%, 87%);*/
/*             --accent-foreground: hsl(224, 30%, 25%);*/
/*             --border: hsl(217, 25%, 88%);*/
/*             --success: hsl(142, 71%, 45%);*/
/*             --success-foreground: hsl(0, 0%, 100%);*/
/*             --danger: hsl(0, 84%, 60%);*/
/*             --danger-foreground: hsl(0, 0%, 100%);*/
/*             --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));*/
/*             --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));*/
/*             --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));*/
/*             --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);*/
/*             --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);*/
/*             --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);*/
/*         }*/
/*         html, body {*/
/*             width: 100%;*/
/*             overflow-x: hidden;*/
/*             font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;*/
/*             background: var(--background);*/
/*             color: var(--foreground);*/
/*             line-height: 1.6;*/
/*         }*/
/*         /* Navbar Styles *//* */
/*         .navbar {*/
/*             background: var(--gradient-primary);*/
/*             box-shadow: var(--shadow-elegant);*/
/*             border-bottom: 1px solid rgba(255, 255, 255, 0.1);*/
/*             position: sticky;*/
/*             top: 0;*/
/*             z-index: 1000;*/
/*             width: 100%;*/
/*         }*/
/*         .navbar-container {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 0 1rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             height: 64px;*/
/*         }*/
/*         .logo {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/*         .nav-menu {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             flex-wrap: nowrap;*/
/*         }*/
/*         .nav-item {*/
/*             position: relative;*/
/*         }*/
/*         .nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.5rem;*/
/*             padding: 0.5rem 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.375rem;*/
/*             transition: all 0.3s ease;*/
/*             background: transparent;*/
/*             border: none;*/
/*             cursor: pointer;*/
/*             font-size: 0.875rem;*/
/*             white-space: nowrap;*/
/*         }*/
/*         .nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*         }*/
/*         .dropdown {*/
/*             position: absolute;*/
/*             top: 100%;*/
/*             left: 0;*/
/*             background: var(--card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             min-width: 180px;*/
/*             max-width: calc(100vw - 2rem);*/
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transform: translateY(-10px);*/
/*             transition: all 0.3s ease;*/
/*             z-index: 100;*/
/*         }*/
/*         .nav-item:hover .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/*         .dropdown-item {*/
/*             display: block;*/
/*             padding: 0.75rem 1rem;*/
/*             color: var(--foreground);*/
/*             text-decoration: none;*/
/*             transition: background 0.2s ease;*/
/*             white-space: nowrap;*/
/*         }*/
/*         .dropdown-item:hover {*/
/*             background: var(--accent);*/
/*         }*/
/*         .user-menu {*/
/*             position: relative;*/
/*             flex-shrink: 0;*/
/*         }*/
/*         .user-avatar {*/
/*             width: 40px;*/
/*             height: 40px;*/
/*             border-radius: 50%;*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             cursor: pointer;*/
/*             transition: background 0.3s ease;*/
/*         }*/
/*         .user-avatar:hover {*/
/*             background: rgba(255, 255, 255, 0.2);*/
/*         }*/
/*         .user-menu.active .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/*         .mobile-menu-btn {*/
/*             display: none;*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*             border-radius: 0.375rem;*/
/*             flex-shrink: 0;*/
/*         }*/
/*         /* POS Dashboard Styles *//* */
/*         .pos-dashboard {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 1rem;*/
/*         }*/
/*         .pos-header {*/
/*             margin-bottom: 1.5rem;*/
/*             text-align: center;*/
/*         }*/
/*         .pos-title {*/
/*             font-size: 2.5rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 0.5rem;*/
/*             background: var(--gradient-primary);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/*         .pos-subtitle {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 1rem;*/
/*         }*/
/*         /* Quick Actions Grid *//* */
/*         .quick-actions-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));*/
/*             gap: 1rem;*/
/*             margin-bottom: 2rem;*/
/*             width: 100%;*/
/*         }*/
/*         .quick-action-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             cursor: pointer;*/
/*             text-align: center;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/*         .quick-action-card:hover {*/
/*             transform: translateY(-2px);*/
/*             box-shadow: var(--shadow-module);*/
/*             border-color: var(--primary);*/
/*         }*/
/*         .quick-action-card:nth-child(1) { animation-delay: 0.1s; }*/
/*         .quick-action-card:nth-child(2) { animation-delay: 0.2s; }*/
/*         .quick-action-card:nth-child(3) { animation-delay: 0.3s; }*/
/*         .quick-action-card:nth-child(4) { animation-delay: 0.4s; }*/
/*         .quick-action-icon {*/
/*             width: 2.5rem;*/
/*             height: 2.5rem;*/
/*             background: var(--gradient-primary);*/
/*             border-radius: 0.5rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             color: var(--primary-foreground);*/
/*             margin: 0 auto 0.5rem;*/
/*         }*/
/*         .quick-action-title {*/
/*             font-size: 0.875rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*         }*/
/*         /* Product Search *//* */
/*         .search-section {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             margin-bottom: 2rem;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             animation-delay: 0.5s;*/
/*         }*/
/*         .search-input-group {*/
/*             display: flex;*/
/*             gap: 1rem;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/*         .search-input {*/
/*             flex: 1;*/
/*             padding: 0.75rem 1rem;*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             font-size: 1rem;*/
/*             background: var(--card);*/
/*         }*/
/*         .search-btn {*/
/*             padding: 0.75rem 1.5rem;*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             border: none;*/
/*             border-radius: 0.5rem;*/
/*             cursor: pointer;*/
/*             font-weight: bold;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .search-btn:hover {*/
/*             background: var(--primary-dark);*/
/*         }*/
/*         /* Main POS Content *//* */
/*         .main-pos-content {*/
/*             display: grid;*/
/*             grid-template-columns: 1fr 1fr;*/
/*             gap: 2rem;*/
/*             margin-bottom: 2rem;*/
/*             width: 100%;*/
/*         }*/
/*         .left-panel {*/
/*             display: flex;*/
/*             flex-direction: column;*/
/*             gap: 1rem;*/
/*         }*/
/*         .right-panel {*/
/*             display: flex;*/
/*             flex-direction: column;*/
/*             gap: 1rem;*/
/*         }*/
/*         /* Cart List *//* */
/*         .products-list {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             max-height: 500px;*/
/*             overflow-y: auto;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             animation-delay: 0.7s;*/
/*         }*/
/*         .products-list h3 {*/
/*             margin-bottom: 1rem;*/
/*             color: var(--foreground);*/
/*             font-size: 1.25rem;*/
/*         }*/
/*         .product-item {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             padding: 1rem;*/
/*             border-bottom: 1px solid var(--border);*/
/*             transition: background 0.2s ease;*/
/*         }*/
/*         .product-item:hover {*/
/*             background: var(--accent);*/
/*         }*/
/*         .product-item:last-child {*/
/*             border-bottom: none;*/
/*         }*/
/*         .product-details {*/
/*             flex: 1;*/
/*         }*/
/*         .product-name {*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*         }*/
/*         .product-price {*/
/*             color: var(--primary);*/
/*             font-size: 1.1rem;*/
/*         }*/
/*         .product-controls {*/
/*             display: flex;*/
/*             gap: 0.5rem;*/
/*             align-items: center;*/
/*         }*/
/*         .qty-btn, .remove-btn {*/
/*             padding: 0.25rem 0.5rem;*/
/*             border: 1px solid var(--border);*/
/*             background: var(--card);*/
/*             border-radius: 0.25rem;*/
/*             cursor: pointer;*/
/*             transition: all 0.2s ease;*/
/*         }*/
/*         .qty-btn:hover, .remove-btn:hover {*/
/*             background: var(--primary);*/
/*             color: var(--primary-foreground);*/
/*         }*/
/*         .remove-btn {*/
/*             color: var(--danger);*/
/*             border-color: var(--danger);*/
/*         }*/
/*         .remove-btn:hover {*/
/*             background: var(--danger);*/
/*             color: var(--danger-foreground);*/
/*         }*/
/*         /* Totals Section *//* */
/*         .totals-section {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             animation-delay: 0.8s;*/
/*         }*/
/*         .total-row {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             margin-bottom: 1rem;*/
/*             font-size: 1.1rem;*/
/*         }*/
/*         .total-label {*/
/*             color: var(--muted-foreground);*/
/*         }*/
/*         .total-value {*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*         }*/
/*         .grand-total {*/
/*             border-top: 2px solid var(--border);*/
/*             padding-top: 1rem;*/
/*             font-size: 1.5rem;*/
/*             color: var(--primary);*/
/*         }*/
/*         /* Products Grid *//* */
/*         .products-grid-section {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             animation-delay: 0.6s;*/
/*         }*/
/*         .products-grid-section h3 {*/
/*             margin-bottom: 1rem;*/
/*             color: var(--foreground);*/
/*             font-size: 1.25rem;*/
/*         }*/
/*         .products-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));*/
/*             gap: 1rem;*/
/*             width: 100%;*/
/*         }*/
/*         .product-card {*/
/*             background: var(--card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             cursor: pointer;*/
/*             text-align: center;*/
/*             opacity: 1;*/
/*         }*/
/*         .product-card:hover {*/
/*             transform: translateY(-4px);*/
/*             box-shadow: var(--shadow-module);*/
/*             border-color: var(--primary);*/
/*         }*/
/*         .product-card.hidden {*/
/*             display: none;*/
/*         }*/
/*         .product-image {*/
/*             width: 100%;*/
/*             height: 120px;*/
/*             background: var(--muted);*/
/*             border-radius: 0.5rem;*/
/*             margin-bottom: 0.5rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             color: var(--muted-foreground);*/
/*             font-size: 2rem;*/
/*         }*/
/*         .product-name {*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*             margin-bottom: 0.25rem;*/
/*         }*/
/*         .product-price {*/
/*             font-size: 1.1rem;*/
/*             color: var(--primary);*/
/*             font-weight: bold;*/
/*         }*/
/*         .add-to-cart-btn {*/
/*             width: 100%;*/
/*             padding: 0.5rem;*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             border: none;*/
/*             border-radius: 0.5rem;*/
/*             cursor: pointer;*/
/*             margin-top: 0.5rem;*/
/*             font-size: 0.875rem;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .add-to-cart-btn:hover {*/
/*             background: var(--primary-dark);*/
/*         }*/
/*         /* Payment Section *//* */
/*         .payment-section {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             animation-delay: 0.9s;*/
/*         }*/
/*         .payment-methods {*/
/*             display: flex;*/
/*             gap: 1rem;*/
/*             margin-bottom: 1.5rem;*/
/*         }*/
/*         .payment-method {*/
/*             flex: 1;*/
/*             padding: 1rem;*/
/*             text-align: center;*/
/*             border: 2px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*             background: var(--card);*/
/*         }*/
/*         .payment-method:hover, .payment-method.active {*/
/*             border-color: var(--primary);*/
/*             background: var(--primary-light);*/
/*             color: var(--primary-foreground);*/
/*         }*/
/*         .payment-method-icon {*/
/*             width: 2rem;*/
/*             height: 2rem;*/
/*             margin: 0 auto 0.5rem;*/
/*             color: var(--primary);*/
/*         }*/
/*         .complete-sale-btn {*/
/*             width: 100%;*/
/*             padding: 1rem;*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             border: none;*/
/*             border-radius: 0.5rem;*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .complete-sale-btn:hover {*/
/*             background: var(--primary-dark);*/
/*         }*/
/*         .complete-sale-btn:disabled {*/
/*             background: var(--muted);*/
/*             color: var(--muted-foreground);*/
/*             cursor: not-allowed;*/
/*         }*/
/*         /* Animations *//* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(30px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/*         /* Mobile Styles *//* */
/*         @media (max-width: 768px) {*/
/*             .nav-menu {*/
/*                 display: none;*/
/*             }*/
/*             .mobile-menu-btn {*/
/*                 display: block;*/
/*             }*/
/*             .pos-dashboard {*/
/*                 padding: 0.5rem;*/
/*             }*/
/*             .quick-actions-grid {*/
/*                 grid-template-columns: repeat(2, 1fr);*/
/*                 gap: 0.5rem;*/
/*             }*/
/*             .main-pos-content {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/*             .products-grid {*/
/*                 grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));*/
/*             }*/
/*             .payment-methods {*/
/*                 flex-direction: column;*/
/*             }*/
/*             .pos-title {*/
/*                 font-size: 2rem;*/
/*             }*/
/*         }*/
/*         /* Mobile Menu Overlay *//* */
/*         .mobile-overlay {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             left: 0;*/
/*             right: 0;*/
/*             bottom: 0;*/
/*             background: rgba(0, 0, 0, 0.5);*/
/*             z-index: 999;*/
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .mobile-overlay.active {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*         }*/
/*         .mobile-menu {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             right: -100%;*/
/*             width: min(280px, 90vw);*/
/*             height: 100vh;*/
/*             background: var(--gradient-primary);*/
/*             z-index: 1000;*/
/*             transition: right 0.3s ease;*/
/*             padding: 1.5rem;*/
/*             overflow-x: hidden;*/
/*         }*/
/*         .mobile-menu.active {*/
/*             right: 0;*/
/*         }*/
/*         .mobile-menu-header {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             margin-bottom: 1.5rem;*/
/*         }*/
/*         .mobile-menu-title {*/
/*             color: var(--primary-foreground);*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*         }*/
/*         .close-btn {*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*         }*/
/*         .mobile-nav-item {*/
/*             margin-bottom: 0.75rem;*/
/*         }*/
/*         .mobile-nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             padding: 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.5rem;*/
/*             transition: background 0.3s ease;*/
/*             white-space: nowrap;*/
/*             font-size: 0.875rem;*/
/*         }*/
/*         .mobile-nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*         }*/
/*         /* Icons *//* */
/*         .icon {*/
/*             width: 1rem;*/
/*             height: 1rem;*/
/*             stroke: currentColor;*/
/*             fill: none;*/
/*             stroke-width: 2;*/
/*         }*/
/*         .icon-lg {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*         }*/
/*     </style>*/
/* </head>*/
/* <body>*/
/*     <!-- Navigation -->*/
/*     <nav class="navbar">*/
/*         <div class="navbar-container">*/
/*             <div class="logo">ERP ETAA</div>*/
/*            */
/*             <div class="nav-menu">*/
/*                 <div class="nav-item">*/
/*                     <a href="/" class="nav-link">*/
/*                         <i class="icon" data-feather="home"></i>*/
/*                         Dashboard*/
/*                     </a>*/
/*                 </div>*/
/*                */
/*                 <div class="nav-item">*/
/*                     <a href="/caisse" class="nav-link">*/
/*                         <i class="icon" data-feather="dollar-sign"></i>*/
/*                         Caisse*/
/*                     </a>*/
/*                 </div>*/
/*                */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="shopping-cart"></i>*/
/*                         Ventes*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/devis" class="dropdown-item">Devis</a>*/
/*                         <a href="/commandes" class="dropdown-item">Commandes</a>*/
/*                         <a href="/factures" class="dropdown-item">Factures</a>*/
/*                         <a href="/clients" class="dropdown-item">Clients</a>*/
/*                     </div>*/
/*                 </div>*/
/*                */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="package"></i>*/
/*                         Stock*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/produits" class="dropdown-item">Produits</a>*/
/*                         <a href="/inventaire" class="dropdown-item">Inventaire</a>*/
/*                         <a href="/fournisseurs" class="dropdown-item">Fournisseurs</a>*/
/*                     </div>*/
/*                 </div>*/
/*                */
/*                 <div class="nav-item">*/
/*                     <a href="/rapports" class="nav-link">*/
/*                         <i class="icon" data-feather="file-text"></i>*/
/*                         Rapports*/
/*                     </a>*/
/*                 </div>*/
/*             </div>*/
/*            */
/*             <div class="user-menu">*/
/*                 <button class="user-avatar" onclick="toggleUserMenu()">*/
/*                     <i class="icon icon-lg" data-feather="user"></i>*/
/*                 </button>*/
/*                 <div class="dropdown">*/
/*                     <a href="/profil" class="dropdown-item">Profil</a>*/
/*                     <a href="/logout" class="dropdown-item" style="color: #dc2626;">Se déconnecter</a>*/
/*                 </div>*/
/*             </div>*/
/*            */
/*             <button class="mobile-menu-btn" onclick="toggleMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="menu"></i>*/
/*             </button>*/
/*         </div>*/
/*     </nav>*/
/*     <!-- Mobile Menu Overlay -->*/
/*     <div class="mobile-overlay" id="mobileOverlay" onclick="closeMobileMenu()"></div>*/
/*     <div class="mobile-menu" id="mobileMenu">*/
/*         <div class="mobile-menu-header">*/
/*             <div class="mobile-menu-title">Menu</div>*/
/*             <button class="close-btn" onclick="closeMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="x"></i>*/
/*             </button>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="home"></i>*/
/*                 Dashboard*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/caisse" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="dollar-sign"></i>*/
/*                 Caisse*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/ventes" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="shopping-cart"></i>*/
/*                 Ventes*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/stock" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="package"></i>*/
/*                 Stock*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/rapports" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="file-text"></i>*/
/*                 Rapports*/
/*             </a>*/
/*         </div>*/
/*     </div>*/
