<?php

/* dashboard/header.html.twig */
class __TwigTemplate_a39974ea70cc7f9b870f324d9e5e35c32d67cda4c848e4960e7ff8e8696848de extends Twig_Template
{
    public function __construct(Twig_Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = array(
        );
    }

    protected function doDisplay(array $context, array $blocks = array())
    {
        // line 1
        echo "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>ERP ETAA - Tableau de Bord</title>
    <!-- Feather Icons CDN -->
    <script src=\"https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js\"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --background: hsl(220, 25%, 97%);
            --foreground: hsl(224, 30%, 15%);
            --card: hsl(0, 0%, 100%);
            --card-foreground: hsl(224, 30%, 15%);
            --primary: hsl(221, 83%, 53%);
            --primary-foreground: hsl(0, 0%, 100%);
            --primary-light: hsl(217, 91%, 60%);
            --primary-dark: hsl(224, 76%, 48%);
            --secondary: hsl(214, 100%, 97%);
            --secondary-foreground: hsl(224, 30%, 25%);
            --muted: hsl(217, 33%, 94%);
            --muted-foreground: hsl(215, 25%, 55%);
            --accent: hsl(213, 97%, 87%);
            --accent-foreground: hsl(224, 30%, 25%);
            --border: hsl(217, 25%, 88%);
            --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));
            --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));
            --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));
            --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);
            --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);
            --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);
        }

        html, body {
            width: 100%;
            overflow-x: hidden;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: var(--background);
            color: var(--foreground);
            line-height: 1.6;
        }

        /* Navbar Styles */
        .navbar {
            background: var(--gradient-primary);
            box-shadow: var(--shadow-elegant);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
            width: 100%;
        }

        .navbar-container {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 0 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 64px;
        }

        .logo {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }

        .nav-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            flex-wrap: nowrap;
        }

        .nav-item {
            position: relative;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.375rem;
            transition: all 0.3s ease;
            background: transparent;
            border: none;
            cursor: pointer;
            font-size: 0.875rem;
            white-space: nowrap;
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            box-shadow: var(--shadow-card);
            min-width: 180px;
            max-width: calc(100vw - 2rem);
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
            z-index: 100;
        }

        .nav-item:hover .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .dropdown-item {
            display: block;
            padding: 0.75rem 1rem;
            color: var(--foreground);
            text-decoration: none;
            transition: background 0.2s ease;
            white-space: nowrap;
        }

        .dropdown-item:hover {
            background: var(--accent);
        }

        .user-menu {
            position: relative;
            flex-shrink: 0;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .user-menu .dropdown {
            right: 0;
            left: auto;
            min-width: 150px;
            max-width: 200px;
        }

        .user-menu.active .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .mobile-menu-btn {
            display: none;
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.375rem;
            flex-shrink: 0;
        }

        /* Dashboard Styles */
        .dashboard {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 2rem 1rem;
        }

        .dashboard-header {
            margin-bottom: 2rem;
            text-align: center;
        }

        .dashboard-title {
            font-size: 2rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .dashboard-subtitle {
            color: var(--muted-foreground);
            font-size: 1rem;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 3rem;
            width: 100%;
        }

        .stat-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-module);
        }

        .stat-card:nth-child(1) { animation-delay: 0.1s; }
        .stat-card:nth-child(2) { animation-delay: 0.2s; }
        .stat-card:nth-child(3) { animation-delay: 0.3s; }
        .stat-card:nth-child(4) { animation-delay: 0.4s; }

        .stat-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 1rem;
        }

        .stat-title {
            font-size: 0.875rem;
            color: var(--muted-foreground);
            font-weight: 500;
        }

        .stat-icon {
            width: 1.5rem;
            height: 1.5rem;
            color: var(--primary);
        }

        .stat-value {
            font-size: 2rem;
            font-weight: bold;
            color: var(--foreground);
            margin-bottom: 0.25rem;
        }

        .stat-description {
            font-size: 0.75rem;
            color: var(--muted-foreground);
        }

        /* Modules Grid */
        .modules-title {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 2rem;
            text-align: center;
            color: var(--foreground);
        }

        .modules-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            width: 100%;
        }

        .module-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            cursor: pointer;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }

        .module-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-module);
            border-color: var(--primary);
        }

        .module-card:nth-child(1) { animation-delay: 0.5s; }
        .module-card:nth-child(2) { animation-delay: 0.6s; }
        .module-card:nth-child(3) { animation-delay: 0.7s; }
        .module-card:nth-child(4) { animation-delay: 0.8s; }
        .module-card:nth-child(5) { animation-delay: 0.9s; }
        .module-card:nth-child(6) { animation-delay: 1.0s; }
        .module-card:nth-child(7) { animation-delay: 1.1s; }
        .module-card:nth-child(8) { animation-delay: 1.2s; }

        .module-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .module-icon {
            width: 3rem;
            height: 3rem;
            background: var(--gradient-primary);
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }

        .module-title {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--foreground);
        }

        .module-description {
            color: var(--muted-foreground);
            font-size: 0.875rem;
            line-height: 1.5;
        }

        /* Animations */
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile Styles */
        @media (max-width: 768px) {
            .nav-menu {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .dashboard {
                padding: 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .modules-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .dashboard-title {
                font-size: 1.5rem;
            }
        }

        /* Mobile Menu Overlay */
        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 0;
            right: -100%;
            width: min(280px, 90vw);
            height: 100vh;
            background: var(--gradient-primary);
            z-index: 1000;
            transition: right 0.3s ease;
            padding: 1.5rem;
            overflow-x: hidden;
        }

        .mobile-menu.active {
            right: 0;
        }

        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }

        .mobile-menu-title {
            color: var(--primary-foreground);
            font-size: 1.25rem;
            font-weight: bold;
        }

        .close-btn {
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-nav-item {
            margin-bottom: 0.75rem;
        }

        .mobile-nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.5rem;
            transition: background 0.3s ease;
            white-space: nowrap;
            font-size: 0.875rem;
        }

        .mobile-nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        /* Icons */
        .icon {
            width: 1rem;
            height: 1rem;
            stroke: currentColor;
            fill: none;
            stroke-width: 2;
        }

        .icon-lg {
            width: 1.5rem;
            height: 1.5rem;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class=\"navbar\">
        <div class=\"navbar-container\">
            <div class=\"logo\">ERP ETAA</div>
            
            <div class=\"nav-menu\">
                <div class=\"nav-item\">
                    <a href=\"/\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"home\"></i>
                        Dashboard
                    </a>
                </div>

                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"package\"></i>
                        Stock
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/produits\" class=\"dropdown-item\">Produits</a>
                        <a href=\"/inventaire\" class=\"dropdown-item\">Inventaire</a>
                        <a href=\"/fournisseurs\" class=\"dropdown-item\">Fournisseurs</a>
                        <a href=\"/mouvements\" class=\"dropdown-item\">Mouvements</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"shopping-cart\"></i>
                       Achats & Ventes
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/devis\" class=\"dropdown-item\">Devis</a>
                        <a href=\"/commandes\" class=\"dropdown-item\">Commandes</a>
                        <a href=\"/factures\" class=\"dropdown-item\">Factures</a>
                        <a href=\"/clients\" class=\"dropdown-item\">Clients</a>
                    </div>
                </div>
                
                
                
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"dollar-sign\"></i>
                        Finances
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/tresorerie\" class=\"dropdown-item\">Trésorerie</a>
                        <a href=\"/comptabilite\" class=\"dropdown-item\">Comptabilité</a>
                        <a href=\"/budget\" class=\"dropdown-item\">Budget</a>
                        <a href=\"/rapports\" class=\"dropdown-item\">Rapports</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"users\"></i>
                        RH
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/employes\" class=\"dropdown-item\">Employés</a>
                        <a href=\"/paie\" class=\"dropdown-item\">Paie</a>
                        <a href=\"/conges\" class=\"dropdown-item\">Congés</a>
                        <a href=\"/formation\" class=\"dropdown-item\">Formation</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"calendar\"></i>
                        Agenda
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/evenements\" class=\"dropdown-item\">Événements</a>
                        <a href=\"/taches\" class=\"dropdown-item\">Tâches</a>
                        <a href=\"/rendezvous\" class=\"dropdown-item\">Rendez-vous</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"settings\"></i>
                        Configuration
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"/utilisateurs\" class=\"dropdown-item\">Utilisateurs</a>
                        <a href=\"/parametres\" class=\"dropdown-item\">Paramètres</a>
                        <a href=\"/securite\" class=\"dropdown-item\">Sécurité</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <a href=\"/documents\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"file-text\"></i>
                        Documents
                    </a>
                </div>
            </div>
            
            <div class=\"user-menu\">
                <button class=\"user-avatar\" onclick=\"toggleUserMenu()\" style=\"color:white;border:1px solid white;\">
                    <i class=\"icon icon-lg\" data-feather=\"user\" style=\"color:white\"></i>
                </button>
                <div class=\"dropdown\">
                    <a href=\"/profil\" class=\"dropdown-item\">Profil</a>
                    <a href=\"/logout\" class=\"dropdown-item\" style=\"color: #dc2626;\">Se déconnecter</a>
                </div>
            </div>
            
            <button class=\"mobile-menu-btn\" onclick=\"toggleMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"menu\"></i>
            </button>
        </div>
    </nav>

    <!-- Mobile Menu Overlay -->
    <div class=\"mobile-overlay\" id=\"mobileOverlay\" onclick=\"closeMobileMenu()\"></div>
    <div class=\"mobile-menu\" id=\"mobileMenu\">
        <div class=\"mobile-menu-header\">
            <div class=\"mobile-menu-title\">Menu</div>
            <button class=\"close-btn\" onclick=\"closeMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"x\"></i>
            </button>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"home\"></i>
                Dashboard
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/ventes\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"shopping-cart\"></i>
                Ventes
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/stock\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"package\"></i>
                Stock
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/finances\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"dollar-sign\"></i>
                Finances
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/rh\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"users\"></i>
                RH
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/agenda\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"calendar\"></i>
                Agenda
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/configuration\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"settings\"></i>
                Configuration
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"/documents\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"file-text\"></i>
                Documents
            </a>
        </div>
    </div>";
    }

    public function getTemplateName()
    {
        return "dashboard/header.html.twig";
    }

    public function getDebugInfo()
    {
        return array (  19 => 1,);
    }
}
/* <!DOCTYPE html>*/
/* <html lang="fr">*/
/* <head>*/
/*     <meta charset="UTF-8">*/
/*     <meta name="viewport" content="width=device-width, initial-scale=1.0">*/
/*     <title>ERP ETAA - Tableau de Bord</title>*/
/*     <!-- Feather Icons CDN -->*/
/*     <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>*/
/*     <style>*/
/*         * {*/
/*             margin: 0;*/
/*             padding: 0;*/
/*             box-sizing: border-box;*/
/*         }*/
/* */
/*         :root {*/
/*             --background: hsl(220, 25%, 97%);*/
/*             --foreground: hsl(224, 30%, 15%);*/
/*             --card: hsl(0, 0%, 100%);*/
/*             --card-foreground: hsl(224, 30%, 15%);*/
/*             --primary: hsl(221, 83%, 53%);*/
/*             --primary-foreground: hsl(0, 0%, 100%);*/
/*             --primary-light: hsl(217, 91%, 60%);*/
/*             --primary-dark: hsl(224, 76%, 48%);*/
/*             --secondary: hsl(214, 100%, 97%);*/
/*             --secondary-foreground: hsl(224, 30%, 25%);*/
/*             --muted: hsl(217, 33%, 94%);*/
/*             --muted-foreground: hsl(215, 25%, 55%);*/
/*             --accent: hsl(213, 97%, 87%);*/
/*             --accent-foreground: hsl(224, 30%, 25%);*/
/*             --border: hsl(217, 25%, 88%);*/
/*             --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));*/
/*             --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));*/
/*             --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));*/
/*             --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);*/
/*             --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);*/
/*             --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);*/
/*         }*/
/* */
/*         html, body {*/
/*             width: 100%;*/
/*             overflow-x: hidden;*/
/*             font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;*/
/*             background: var(--background);*/
/*             color: var(--foreground);*/
/*             line-height: 1.6;*/
/*         }*/
/* */
/*         /* Navbar Styles *//* */
/*         .navbar {*/
/*             background: var(--gradient-primary);*/
/*             box-shadow: var(--shadow-elegant);*/
/*             border-bottom: 1px solid rgba(255, 255, 255, 0.1);*/
/*             position: sticky;*/
/*             top: 0;*/
/*             z-index: 1000;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .navbar-container {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 0 1rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             height: 64px;*/
/*         }*/
/* */
/*         .logo {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .nav-menu {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             flex-wrap: nowrap;*/
/*         }*/
/* */
/*         .nav-item {*/
/*             position: relative;*/
/*         }*/
/* */
/*         .nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.5rem;*/
/*             padding: 0.5rem 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.375rem;*/
/*             transition: all 0.3s ease;*/
/*             background: transparent;*/
/*             border: none;*/
/*             cursor: pointer;*/
/*             font-size: 0.875rem;*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*         }*/
/* */
/*         .dropdown {*/
/*             position: absolute;*/
/*             top: 100%;*/
/*             left: 0;*/
/*             background: var(--card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             min-width: 180px;*/
/*             max-width: calc(100vw - 2rem);*/
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transform: translateY(-10px);*/
/*             transition: all 0.3s ease;*/
/*             z-index: 100;*/
/*         }*/
/* */
/*         .nav-item:hover .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/* */
/*         .dropdown-item {*/
/*             display: block;*/
/*             padding: 0.75rem 1rem;*/
/*             color: var(--foreground);*/
/*             text-decoration: none;*/
/*             transition: background 0.2s ease;*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .dropdown-item:hover {*/
/*             background: var(--accent);*/
/*         }*/
/* */
/*         .user-menu {*/
/*             position: relative;*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .user-avatar {*/
/*             width: 40px;*/
/*             height: 40px;*/
/*             border-radius: 50%;*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             cursor: pointer;*/
/*             transition: background 0.3s ease;*/
/*         }*/
/* */
/*         .user-avatar:hover {*/
/*             background: rgba(255, 255, 255, 0.2);*/
/*         }*/
/* */
/*         .user-menu .dropdown {*/
/*             right: 0;*/
/*             left: auto;*/
/*             min-width: 150px;*/
/*             max-width: 200px;*/
/*         }*/
/* */
/*         .user-menu.active .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/* */
/*         .mobile-menu-btn {*/
/*             display: none;*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*             border-radius: 0.375rem;*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         /* Dashboard Styles *//* */
/*         .dashboard {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 2rem 1rem;*/
/*         }*/
/* */
/*         .dashboard-header {*/
/*             margin-bottom: 2rem;*/
/*             text-align: center;*/
/*         }*/
/* */
/*         .dashboard-title {*/
/*             font-size: 2rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 0.5rem;*/
/*             background: var(--gradient-primary);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/* */
/*         .dashboard-subtitle {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 1rem;*/
/*         }*/
/* */
/*         /* Stats Grid *//* */
/*         .stats-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));*/
/*             gap: 1.5rem;*/
/*             margin-bottom: 3rem;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .stat-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/* */
/*         .stat-card:hover {*/
/*             transform: translateY(-2px);*/
/*             box-shadow: var(--shadow-module);*/
/*         }*/
/* */
/*         .stat-card:nth-child(1) { animation-delay: 0.1s; }*/
/*         .stat-card:nth-child(2) { animation-delay: 0.2s; }*/
/*         .stat-card:nth-child(3) { animation-delay: 0.3s; }*/
/*         .stat-card:nth-child(4) { animation-delay: 0.4s; }*/
/* */
/*         .stat-header {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .stat-title {*/
/*             font-size: 0.875rem;*/
/*             color: var(--muted-foreground);*/
/*             font-weight: 500;*/
/*         }*/
/* */
/*         .stat-icon {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .stat-value {*/
/*             font-size: 2rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*             margin-bottom: 0.25rem;*/
/*         }*/
/* */
/*         .stat-description {*/
/*             font-size: 0.75rem;*/
/*             color: var(--muted-foreground);*/
/*         }*/
/* */
/*         /* Modules Grid *//* */
/*         .modules-title {*/
/*             font-size: 1.5rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 2rem;*/
/*             text-align: center;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .modules-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));*/
/*             gap: 1.5rem;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .module-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             cursor: pointer;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/* */
/*         .module-card:hover {*/
/*             transform: translateY(-4px);*/
/*             box-shadow: var(--shadow-module);*/
/*             border-color: var(--primary);*/
/*         }*/
/* */
/*         .module-card:nth-child(1) { animation-delay: 0.5s; }*/
/*         .module-card:nth-child(2) { animation-delay: 0.6s; }*/
/*         .module-card:nth-child(3) { animation-delay: 0.7s; }*/
/*         .module-card:nth-child(4) { animation-delay: 0.8s; }*/
/*         .module-card:nth-child(5) { animation-delay: 0.9s; }*/
/*         .module-card:nth-child(6) { animation-delay: 1.0s; }*/
/*         .module-card:nth-child(7) { animation-delay: 1.1s; }*/
/*         .module-card:nth-child(8) { animation-delay: 1.2s; }*/
/* */
/*         .module-header {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 1rem;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .module-icon {*/
/*             width: 3rem;*/
/*             height: 3rem;*/
/*             background: var(--gradient-primary);*/
/*             border-radius: 0.75rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .module-title {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .module-description {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 0.875rem;*/
/*             line-height: 1.5;*/
/*         }*/
/* */
/*         /* Animations *//* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(30px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/* */
/*         /* Mobile Styles *//* */
/*         @media (max-width: 768px) {*/
/*             .nav-menu {*/
/*                 display: none;*/
/*             }*/
/* */
/*             .mobile-menu-btn {*/
/*                 display: block;*/
/*             }*/
/* */
/*             .dashboard {*/
/*                 padding: 1rem;*/
/*             }*/
/* */
/*             .stats-grid {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/* */
/*             .modules-grid {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/* */
/*             .dashboard-title {*/
/*                 font-size: 1.5rem;*/
/*             }*/
/*         }*/
/* */
/*         /* Mobile Menu Overlay *//* */
/*         .mobile-overlay {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             left: 0;*/
/*             right: 0;*/
/*             bottom: 0;*/
/*             background: rgba(0, 0, 0, 0.5);*/
/*             z-index: 999;*/
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .mobile-overlay.active {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*         }*/
/* */
/*         .mobile-menu {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             right: -100%;*/
/*             width: min(280px, 90vw);*/
/*             height: 100vh;*/
/*             background: var(--gradient-primary);*/
/*             z-index: 1000;*/
/*             transition: right 0.3s ease;*/
/*             padding: 1.5rem;*/
/*             overflow-x: hidden;*/
/*         }*/
/* */
/*         .mobile-menu.active {*/
/*             right: 0;*/
/*         }*/
/* */
/*         .mobile-menu-header {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             margin-bottom: 1.5rem;*/
/*         }*/
/* */
/*         .mobile-menu-title {*/
/*             color: var(--primary-foreground);*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*         }*/
/* */
/*         .close-btn {*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*         }*/
/* */
/*         .mobile-nav-item {*/
/*             margin-bottom: 0.75rem;*/
/*         }*/
/* */
/*         .mobile-nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             padding: 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.5rem;*/
/*             transition: background 0.3s ease;*/
/*             white-space: nowrap;*/
/*             font-size: 0.875rem;*/
/*         }*/
/* */
/*         .mobile-nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*         }*/
/* */
/*         /* Icons *//* */
/*         .icon {*/
/*             width: 1rem;*/
/*             height: 1rem;*/
/*             stroke: currentColor;*/
/*             fill: none;*/
/*             stroke-width: 2;*/
/*         }*/
/* */
/*         .icon-lg {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*         }*/
/*     </style>*/
/* </head>*/
/* <body>*/
/*     <!-- Navigation -->*/
/*     <nav class="navbar">*/
/*         <div class="navbar-container">*/
/*             <div class="logo">ERP ETAA</div>*/
/*             */
/*             <div class="nav-menu">*/
/*                 <div class="nav-item">*/
/*                     <a href="/" class="nav-link">*/
/*                         <i class="icon" data-feather="home"></i>*/
/*                         Dashboard*/
/*                     </a>*/
/*                 </div>*/
/* */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="package"></i>*/
/*                         Stock*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/produits" class="dropdown-item">Produits</a>*/
/*                         <a href="/inventaire" class="dropdown-item">Inventaire</a>*/
/*                         <a href="/fournisseurs" class="dropdown-item">Fournisseurs</a>*/
/*                         <a href="/mouvements" class="dropdown-item">Mouvements</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="shopping-cart"></i>*/
/*                        Achats & Ventes*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/devis" class="dropdown-item">Devis</a>*/
/*                         <a href="/commandes" class="dropdown-item">Commandes</a>*/
/*                         <a href="/factures" class="dropdown-item">Factures</a>*/
/*                         <a href="/clients" class="dropdown-item">Clients</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 */
/*                 */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="dollar-sign"></i>*/
/*                         Finances*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/tresorerie" class="dropdown-item">Trésorerie</a>*/
/*                         <a href="/comptabilite" class="dropdown-item">Comptabilité</a>*/
/*                         <a href="/budget" class="dropdown-item">Budget</a>*/
/*                         <a href="/rapports" class="dropdown-item">Rapports</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="users"></i>*/
/*                         RH*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/employes" class="dropdown-item">Employés</a>*/
/*                         <a href="/paie" class="dropdown-item">Paie</a>*/
/*                         <a href="/conges" class="dropdown-item">Congés</a>*/
/*                         <a href="/formation" class="dropdown-item">Formation</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="calendar"></i>*/
/*                         Agenda*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/evenements" class="dropdown-item">Événements</a>*/
/*                         <a href="/taches" class="dropdown-item">Tâches</a>*/
/*                         <a href="/rendezvous" class="dropdown-item">Rendez-vous</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="settings"></i>*/
/*                         Configuration*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="/utilisateurs" class="dropdown-item">Utilisateurs</a>*/
/*                         <a href="/parametres" class="dropdown-item">Paramètres</a>*/
/*                         <a href="/securite" class="dropdown-item">Sécurité</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <a href="/documents" class="nav-link">*/
/*                         <i class="icon" data-feather="file-text"></i>*/
/*                         Documents*/
/*                     </a>*/
/*                 </div>*/
/*             </div>*/
/*             */
/*             <div class="user-menu">*/
/*                 <button class="user-avatar" onclick="toggleUserMenu()" style="color:white;border:1px solid white;">*/
/*                     <i class="icon icon-lg" data-feather="user" style="color:white"></i>*/
/*                 </button>*/
/*                 <div class="dropdown">*/
/*                     <a href="/profil" class="dropdown-item">Profil</a>*/
/*                     <a href="/logout" class="dropdown-item" style="color: #dc2626;">Se déconnecter</a>*/
/*                 </div>*/
/*             </div>*/
/*             */
/*             <button class="mobile-menu-btn" onclick="toggleMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="menu"></i>*/
/*             </button>*/
/*         </div>*/
/*     </nav>*/
/* */
/*     <!-- Mobile Menu Overlay -->*/
/*     <div class="mobile-overlay" id="mobileOverlay" onclick="closeMobileMenu()"></div>*/
/*     <div class="mobile-menu" id="mobileMenu">*/
/*         <div class="mobile-menu-header">*/
/*             <div class="mobile-menu-title">Menu</div>*/
/*             <button class="close-btn" onclick="closeMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="x"></i>*/
/*             </button>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="home"></i>*/
/*                 Dashboard*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/ventes" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="shopping-cart"></i>*/
/*                 Ventes*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/stock" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="package"></i>*/
/*                 Stock*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/finances" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="dollar-sign"></i>*/
/*                 Finances*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/rh" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="users"></i>*/
/*                 RH*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/agenda" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="calendar"></i>*/
/*                 Agenda*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/configuration" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="settings"></i>*/
/*                 Configuration*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="/documents" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="file-text"></i>*/
/*                 Documents*/
/*             </a>*/
/*         </div>*/
/*     </div>*/
