<?php

/* stock/header_form@.html.twig */
class __TwigTemplate_46dae82a7b961212aaeeb59325b2012c1b528e9b778a203eda03150d89e73586 extends Twig_Template
{
    public function __construct(Twig_Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = array(
        );
    }

    protected function doDisplay(array $context, array $blocks = array())
    {
        // line 1
        echo "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>ERP ETAA - Tableau de Bord</title>
    <!-- Bootstrap CSS CDN -->
    <link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css\" rel=\"stylesheet\" integrity=\"sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN\" crossorigin=\"anonymous\">
    <!-- Feather Icons CDN -->
    <script src=\"https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js\"></script>
    <link href=\"https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css\" rel=\"stylesheet\" />
    <style>
       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --background: hsl(220, 25%, 97%);
            --foreground: hsl(224, 30%, 15%);
            --card: hsl(0, 0%, 100%);
            --card-foreground: hsl(224, 30%, 15%);
            --primary: hsl(221, 83%, 53%);
            --primary-foreground: hsl(0, 0%, 100%);
            --primary-light: hsl(217, 91%, 60%);
            --primary-dark: hsl(224, 76%, 48%);
            --secondary: hsl(214, 100%, 97%);
            --secondary-foreground: hsl(224, 30%, 25%);
            --muted: hsl(217, 33%, 94%);
            --muted-foreground: hsl(215, 25%, 55%);
            --accent: hsl(213, 97%, 87%);
            --accent-foreground: hsl(224, 30%, 25%);
            --border: hsl(217, 25%, 88%);
            --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));
            --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));
            --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));
            --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);
            --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);
            --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);
        }

        html, body {
            width: 100%;
            overflow-x: hidden;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: var(--background);
            color: var(--foreground);
            line-height: 1.6;
        }

        /* Navbar Styles */
        .navbar {
            background: var(--gradient-primary);
            box-shadow: var(--shadow-elegant);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
            width: 100%;
        }

        .navbar-container {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 0 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 64px;
        }

        .logo {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }

        .nav-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            flex-wrap: nowrap;
        }

        .nav-item {
            position: relative;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.375rem;
            transition: all 0.3s ease;
            background: transparent;
            border: none;
            cursor: pointer;
            font-size: 0.875rem;
            white-space: nowrap;
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            box-shadow: var(--shadow-card);
            min-width: 180px;
            max-width: calc(100vw - 2rem);
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
            z-index: 100;
        }

        .nav-item:hover .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .dropdown-item {
            display: block;
            padding: 0.75rem 1rem;
            color: var(--foreground);
            text-decoration: none;
            transition: background 0.2s ease;
            white-space: nowrap;
        }

        .dropdown-item:hover {
            background: var(--accent);
        }

        .user-menu {
            position: relative;
            flex-shrink: 0;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .user-menu .dropdown {
            right: 0;
            left: auto;
            min-width: 150px;
            max-width: 200px;
        }

        .user-menu.active .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .mobile-menu-btn {
            display: none;
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.375rem;
            flex-shrink: 0;
            z-index: 1001; /* Ajout pour éviter les conflits */
        }

        /* Dashboard Styles */
        .dashboard {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 2rem 1rem;
        }

        .dashboard-header {
            margin-bottom: 2rem;
            text-align: center;
        }

        .dashboard-title {
            font-size: 2rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .dashboard-subtitle {
            color: var(--muted-foreground);
            font-size: 1rem;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 3rem;
            width: 100%;
        }

        .stat-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-module);
        }

        .stat-card:nth-child(1) { animation-delay: 0.1s; }
        .stat-card:nth-child(2) { animation-delay: 0.2s; }
        .stat-card:nth-child(3) { animation-delay: 0.3s; }
        .stat-card:nth-child(4) { animation-delay: 0.4s; }

        .stat-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 1rem;
        }

        .stat-title {
            font-size: 0.875rem;
            color: var(--muted-foreground);
            font-weight: 500;
        }

        .stat-icon {
            width: 1.5rem;
            height: 1.5rem;
            color: var(--primary);
        }

        .stat-value {
            font-size: 2rem;
            font-weight: bold;
            color: var(--foreground);
            margin-bottom: 0.25rem;
        }

        .stat-description {
            font-size: 0.75rem;
            color: var(--muted-foreground);
        }

        /* Modules Grid */
        .modules-title {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 2rem;
            text-align: center;
            color: var(--foreground);
        }

        .modules-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            width: 100%;
        }

        .module-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            cursor: pointer;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }

        .module-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-module);
            border-color: var(--primary);
        }

        .module-card:nth-child(1) { animation-delay: 0.5s; }
        .module-card:nth-child(2) { animation-delay: 0.6s; }
        .module-card:nth-child(3) { animation-delay: 0.7s; }
        .module-card:nth-child(4) { animation-delay: 0.8s; }
        .module-card:nth-child(5) { animation-delay: 0.9s; }
        .module-card:nth-child(6) { animation-delay: 1.0s; }
        .module-card:nth-child(7) { animation-delay: 1.1s; }
        .module-card:nth-child(8) { animation-delay: 1.2s; }

        .module-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .module-icon {
            width: 3rem;
            height: 3rem;
            background: var(--gradient-primary);
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }

        .module-title {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--foreground);
        }

        .module-description {
            color: var(--muted-foreground);
            font-size: 0.875rem;
            line-height: 1.5;
        }

        /* Animations */
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile Styles */
        @media (max-width: 768px) {
            .nav-menu {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .dashboard {
                padding: 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .modules-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .dashboard-title {
                font-size: 1.5rem;
            }
        }

        /* Mobile Menu Overlay */
        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9999; /* Augmenté pour éviter les conflits */
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 0;
            right: -100%;
            width: min(280px, 90vw);
            height: 100vh;
            background: var(--gradient-primary);
            z-index: 10000; /* Augmenté pour éviter les conflits */
            transition: right 0.3s ease;
            padding: 1.5rem;
            overflow-x: hidden;
        }
        .mobile-menu.active {
            right: 0;
        }

        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }

        .mobile-menu-title {
            color: var(--primary-foreground);
            font-size: 1.25rem;
            font-weight: bold;
        }

        .close-btn {
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-nav-item {
            margin-bottom: 0.75rem;
        }

        .mobile-nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.5rem;
            transition: background 0.3s ease;
            white-space: nowrap;
            font-size: 0.875rem;
        }

        .mobile-nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        /* Icons */
        .icon {
            width: 1rem;
            height: 1rem;
            stroke: currentColor;
            fill: none;
            stroke-width: 2;
        }

        .icon-lg {
            width: 1.5rem;
            height: 1.5rem;
        }
        /* Footer Styles */
        .footer {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            padding: 1rem;
            text-align: center;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: var(--shadow-elegant);
            width: 100%;
            position: sticky;
            bottom: 0;
            z-index: 1000;
        }

        .footer-text {
            font-size: 0.875rem;
            margin: 0;
        }

        .footer-text a {
            color: var(--primary-foreground);
            text-decoration: none;
            font-weight: bold;
        }

        .footer-text a:hover {
            text-decoration: underline;
        }

        .alerts-container {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 2rem 1rem;
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        .alert {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            padding: 1rem 1.5rem;
            box-shadow: var(--shadow-card);
            display: flex;
            justify-content: space-between;
            align-items: center;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            position: relative;
            transition: all 0.3s ease;
        }

        .alert:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-hover);
        }

        .alert-primary {
            border-left: 4px solid var(--primary);
            background: linear-gradient(145deg, hsl(221, 83%, 97%), hsl(221, 83%, 99%));
        }

        .alert-success {
            border-left: 4px solid var(--success);
            background: linear-gradient(145deg, hsl(142, 71%, 97%), hsl(142, 71%, 99%));
        }

        .alert-warning {
            border-left: 4px solid var(--warning);
            background: linear-gradient(145deg, hsl(38, 92%, 97%), hsl(38, 92%, 99%));
        }

        .alert-danger {
            border-left: 4px solid var(--danger);
            background: linear-gradient(145deg, hsl(0, 84%, 97%), hsl(0, 84%, 99%));
        }

        .alert-content {
            display: flex;
            align-items: center;
            gap: 1rem;
            flex: 1;
        }

        .alert-icon {
            width: 1.5rem;
            height: 1.5rem;
            flex-shrink: 0;
        }

        .alert-primary .alert-icon {
            color: var(--primary);
        }

        .alert-success .alert-icon {
            color: var(--success);
        }

        .alert-warning .alert-icon {
            color: var(--warning);
        }

        .alert-danger .alert-icon {
            color: var(--danger);
        }

        .alert-message {
            font-size: 0.875rem;
            color: var(--foreground);
        }

        .alert-primary .alert-message {
            color: var(--primary);
        }

        .alert-success .alert-message {
            color: var(--success);
        }

        .alert-warning .alert-message {
            color: var(--warning);
        }

        .alert-danger .alert-message {
            color: var(--danger);
        }

        .alert-close {
            background: transparent;
            border: none;
            cursor: pointer;
            padding: 0.5rem;
            color: var(--foreground);
            opacity: 0.6;
            transition: opacity 0.3s ease;
        }

        .alert-close:hover {
            opacity: 1;
        }

        .alert:nth-child(1) { animation-delay: 0.1s; }
        .alert:nth-child(2) { animation-delay: 0.2s; }
        .alert:nth-child(3) { animation-delay: 0.3s; }
        .alert:nth-child(4) { animation-delay: 0.4s; }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .alerts-container {
                padding: 1rem;
            }

            .alert {
                padding: 0.75rem 1rem;
            }

            .alert-message {
                font-size: 0.8125rem;
            }
        }

        /* Add this to the <style> tag */
        .pagination .page-link {
            color: var(--primary);
            background: var(--card);
            border: 1px solid var(--border);
            transition: all 0.3s ease;
        }

        .pagination .page-link:hover {
            background: var(--accent);
            color: var(--primary-dark);
        }

        .pagination .page-item.active .page-link {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            border-color: var(--primary);
        }

        .pagination .page-item.disabled .page-link {
            color: var(--muted-foreground);
            background: var(--muted);
            border-color: var(--border);
        }

         .important{

            border: 2px solid red;
        }

          .thumbnail {
          position: relative;
          display: inline-block;
          border: 1px solid #ccc;
          padding: 5px;
          margin: 10px;
          border-radius: 5px;
        }

        .thumbnail_details {
          position: relative;
          display: inline-block;
          border: 1px solid #ccc;
          padding: 5px;
          margin: 10px;
          border-radius: 5px;
        }

        .thumbnail img {
          width: 200px;
          height: 200px;
          object-fit: cover;
          display: block;
          border-radius: 5px;
        }
        .thumbnail_details img {
          width: 400px;
          height: 400px;
          object-fit: cover;
          display: block;
          border-radius: 5px;
        }

        .delete-icon {
          position: absolute;
          top: 5px;
          right: 5px;
          width: 20px;
          height: 20px;
          line-height: 20px;
          text-align: center;
          font-size: 16px;
          background-color: red;
          color: white;
          border-radius: 50%;
          cursor: pointer;
          
        }

        .delete-icon:hover {
          opacity: 1;
        }

        .tab-container {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 1.5rem;
            overflow-x: auto;
            padding: 0 1rem;
        }

        .tab {
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            background: var(--card);
            color: var(--foreground);
            font-size: 0.875rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid var(--border);
            box-shadow: var(--neumorphic-shadow);
            white-space: nowrap;
        }

        .tab:hover {
            background: var(--accent);
        }

        .tab.active {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            box-shadow: var(--neumorphic-shadow-hover);
        }

        @media (max-width: 768px) {
            .tab-container {
                padding: 0 0.5rem;
            }

            .tab {
                padding: 0.5rem 1rem;
                font-size: 0.75rem;
            }
        }


    </style>
    <!--<link href=\"https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css\" rel=\"stylesheet\" />-->
</head>
<body>
    <!-- Navigation -->
    <nav class=\"navbar\">
        <div class=\"navbar-container\">
            <div class=\"logo\"><a href=\"";
        // line 796
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "admin/dashboard\"><img src=\"";
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "uploads/logo_etaa_blanc.png\" style=\"height:50px\"/></a></div>
            
             <div class=\"nav-item\">
                    <a href=\"";
        // line 799
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "admin/dashboard\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"airplay\"></i>
                        Dashboard principal
                    </a>
                </div>
            <div class=\"nav-menu\">
                <div class=\"nav-item\">
                    <a href=\"";
        // line 806
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"home\"></i>
                        Tableau de bord Gestion Stock
                    </a>
                </div>
                
               <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"bookmark\"></i>
                        Stock
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"";
        // line 819
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/categories\" class=\"dropdown-item\">Catégories</a>
                        <a href=\"";
        // line 820
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/liste_produits\" class=\"dropdown-item\">Produits</a>
                        <a href=\"";
        // line 821
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/liste_services\" class=\"dropdown-item\">Services</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"layers\"></i>
                        Entrepôts
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                         <a href=\"";
        // line 832
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/entrepots\" class=\"dropdown-item\">Gestion des entreprôts</a>
                        <a href=\"";
        // line 833
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/ajouter_casier\" class=\"dropdown-item\">Gestion des Casiers</a>
                    </div>
                </div>
                
                <div class=\"nav-item\">
                    <a href=\"";
        // line 838
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/liste_inventaires\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"list\"></i>
                        Inventaires
                    </a>
                </div>

                 <div class=\"nav-item\">
                    <a href=\"";
        // line 845
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/mouvements\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"book\"></i>
                        Mouvements
                    </a>
                </div>

                 <div class=\"nav-item\">
                    <a href=\"";
        // line 852
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/fournisseurs\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"truck\"></i>
                        Fournisseurs
                    </a>
                </div>
                
                
                <div class=\"user-menu\">
                    <button class=\"user-avatar\" style=\"border:1px solid white;\" onclick=\"toggleUserMenu()\">
                        <i class=\"icon icon-lg\" style=\"color:white\" data-feather=\"user\"></i>
                    </button>
                    <div class=\"dropdown\">
                        <a href=\"";
        // line 864
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "home/mon_profil\" class=\"dropdown-item\">Profil</a>
                        <a href=\"";
        // line 865
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "home/logout\" class=\"dropdown-item\" style=\"color: #dc2626;\">Se déconnecter</a>
                    </div>
                </div>
            
                <button class=\"mobile-menu-btn\" onclick=\"toggleMobileMenu()\">
                    <i class=\"icon icon-lg\" data-feather=\"menu\"></i>
                </button>
        </div>
    </nav>

    <!-- Mobile Menu Overlay -->
    <div class=\"mobile-overlay\" id=\"mobileOverlay\" onclick=\"closeMobileMenu()\"></div>
    <div class=\"mobile-menu\" id=\"mobileMenu\">
    <div class=\"mobile-menu-header\">
        <div class=\"mobile-menu-title\">Menu</div>
        <button class=\"close-btn\" onclick=\"closeMobileMenu()\">
            <i class=\"icon icon-lg\" data-feather=\"x\"></i>
        </button>
    </div>
    <div class=\"mobile-nav-item\">
        <a href=\"https://localhost/erp_etaa/admin/dashboard\" class=\"mobile-nav-link\">
            <i class=\"icon\" data-feather=\"home\"></i>
            Tableau de bord
        </a>
    </div>
    <div class=\"mobile-nav-item\">
        <a href=\"https://localhost/erp_etaa/gestion_stock/liste_produits\" class=\"mobile-nav-link\">
            <i class=\"icon\" data-feather=\"shopping-cart\"></i>
            Stock
        </a>
    </div>
    <div class=\"mobile-nav-item\">
        <a href=\"https://localhost/erp_etaa/gestion_stock/entrepots\" class=\"mobile-nav-link\">
            <i class=\"icon\" data-feather=\"package\"></i>
            Entrepôts
        </a>
    </div>
    <div class=\"mobile-nav-item\">
        <a href=\"https://localhost/erp_etaa/gestion_stock/liste_inventaires\" class=\"mobile-nav-link\">
            <i class=\"icon\" data-feather=\"dollar-sign\"></i>
            Inventaire
        </a>
    </div>
    <div class=\"mobile-nav-item\">
        <a href=\"https://localhost/erp_etaa/gestion_stock/mouvements\" class=\"mobile-nav-link\">
            <i class=\"icon\" data-feather=\"users\"></i>
            Mouvements
        </a>
    </div>
    <div class=\"mobile-nav-item\">
        <a href=\"https://localhost/erp_etaa/gestion_stock/fournisseurs\" class=\"mobile-nav-link\">
            <i class=\"icon\" data-feather=\"calendar\"></i>
            Fournisseurs
        </a>
    </div>
</div>";
    }

    public function getTemplateName()
    {
        return "stock/header_form@.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  923 => 865,  919 => 864,  904 => 852,  894 => 845,  884 => 838,  876 => 833,  872 => 832,  858 => 821,  854 => 820,  850 => 819,  834 => 806,  824 => 799,  816 => 796,  19 => 1,);
    }
}
/* <!DOCTYPE html>*/
/* <html lang="fr">*/
/* <head>*/
/*     <meta charset="UTF-8">*/
/*     <meta name="viewport" content="width=device-width, initial-scale=1.0">*/
/*     <title>ERP ETAA - Tableau de Bord</title>*/
/*     <!-- Bootstrap CSS CDN -->*/
/*     <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">*/
/*     <!-- Feather Icons CDN -->*/
/*     <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>*/
/*     <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />*/
/*     <style>*/
/*        * {*/
/*             margin: 0;*/
/*             padding: 0;*/
/*             box-sizing: border-box;*/
/*         }*/
/* */
/*         :root {*/
/*             --background: hsl(220, 25%, 97%);*/
/*             --foreground: hsl(224, 30%, 15%);*/
/*             --card: hsl(0, 0%, 100%);*/
/*             --card-foreground: hsl(224, 30%, 15%);*/
/*             --primary: hsl(221, 83%, 53%);*/
/*             --primary-foreground: hsl(0, 0%, 100%);*/
/*             --primary-light: hsl(217, 91%, 60%);*/
/*             --primary-dark: hsl(224, 76%, 48%);*/
/*             --secondary: hsl(214, 100%, 97%);*/
/*             --secondary-foreground: hsl(224, 30%, 25%);*/
/*             --muted: hsl(217, 33%, 94%);*/
/*             --muted-foreground: hsl(215, 25%, 55%);*/
/*             --accent: hsl(213, 97%, 87%);*/
/*             --accent-foreground: hsl(224, 30%, 25%);*/
/*             --border: hsl(217, 25%, 88%);*/
/*             --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));*/
/*             --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));*/
/*             --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));*/
/*             --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);*/
/*             --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);*/
/*             --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);*/
/*         }*/
/* */
/*         html, body {*/
/*             width: 100%;*/
/*             overflow-x: hidden;*/
/*             font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;*/
/*             background: var(--background);*/
/*             color: var(--foreground);*/
/*             line-height: 1.6;*/
/*         }*/
/* */
/*         /* Navbar Styles *//* */
/*         .navbar {*/
/*             background: var(--gradient-primary);*/
/*             box-shadow: var(--shadow-elegant);*/
/*             border-bottom: 1px solid rgba(255, 255, 255, 0.1);*/
/*             position: sticky;*/
/*             top: 0;*/
/*             z-index: 1000;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .navbar-container {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 0 1rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             height: 64px;*/
/*         }*/
/* */
/*         .logo {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .nav-menu {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             flex-wrap: nowrap;*/
/*         }*/
/* */
/*         .nav-item {*/
/*             position: relative;*/
/*         }*/
/* */
/*         .nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.5rem;*/
/*             padding: 0.5rem 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.375rem;*/
/*             transition: all 0.3s ease;*/
/*             background: transparent;*/
/*             border: none;*/
/*             cursor: pointer;*/
/*             font-size: 0.875rem;*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*             color: white;*/
/*         }*/
/* */
/*         .dropdown {*/
/*             position: absolute;*/
/*             top: 100%;*/
/*             left: 0;*/
/*             background: var(--card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             min-width: 180px;*/
/*             max-width: calc(100vw - 2rem);*/
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transform: translateY(-10px);*/
/*             transition: all 0.3s ease;*/
/*             z-index: 100;*/
/*         }*/
/* */
/*         .nav-item:hover .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/* */
/*         .dropdown-item {*/
/*             display: block;*/
/*             padding: 0.75rem 1rem;*/
/*             color: var(--foreground);*/
/*             text-decoration: none;*/
/*             transition: background 0.2s ease;*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .dropdown-item:hover {*/
/*             background: var(--accent);*/
/*         }*/
/* */
/*         .user-menu {*/
/*             position: relative;*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .user-avatar {*/
/*             width: 40px;*/
/*             height: 40px;*/
/*             border-radius: 50%;*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             cursor: pointer;*/
/*             transition: background 0.3s ease;*/
/*         }*/
/* */
/*         .user-avatar:hover {*/
/*             background: rgba(255, 255, 255, 0.2);*/
/*         }*/
/* */
/*         .user-menu .dropdown {*/
/*             right: 0;*/
/*             left: auto;*/
/*             min-width: 150px;*/
/*             max-width: 200px;*/
/*         }*/
/* */
/*         .user-menu.active .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/* */
/*         .mobile-menu-btn {*/
/*             display: none;*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*             border-radius: 0.375rem;*/
/*             flex-shrink: 0;*/
/*             z-index: 1001; /* Ajout pour éviter les conflits *//* */
/*         }*/
/* */
/*         /* Dashboard Styles *//* */
/*         .dashboard {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 2rem 1rem;*/
/*         }*/
/* */
/*         .dashboard-header {*/
/*             margin-bottom: 2rem;*/
/*             text-align: center;*/
/*         }*/
/* */
/*         .dashboard-title {*/
/*             font-size: 2rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 0.5rem;*/
/*             background: var(--gradient-primary);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/* */
/*         .dashboard-subtitle {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 1rem;*/
/*         }*/
/* */
/*         /* Stats Grid *//* */
/*         .stats-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));*/
/*             gap: 1.5rem;*/
/*             margin-bottom: 3rem;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .stat-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/* */
/*         .stat-card:hover {*/
/*             transform: translateY(-2px);*/
/*             box-shadow: var(--shadow-module);*/
/*         }*/
/* */
/*         .stat-card:nth-child(1) { animation-delay: 0.1s; }*/
/*         .stat-card:nth-child(2) { animation-delay: 0.2s; }*/
/*         .stat-card:nth-child(3) { animation-delay: 0.3s; }*/
/*         .stat-card:nth-child(4) { animation-delay: 0.4s; }*/
/* */
/*         .stat-header {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .stat-title {*/
/*             font-size: 0.875rem;*/
/*             color: var(--muted-foreground);*/
/*             font-weight: 500;*/
/*         }*/
/* */
/*         .stat-icon {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .stat-value {*/
/*             font-size: 2rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*             margin-bottom: 0.25rem;*/
/*         }*/
/* */
/*         .stat-description {*/
/*             font-size: 0.75rem;*/
/*             color: var(--muted-foreground);*/
/*         }*/
/* */
/*         /* Modules Grid *//* */
/*         .modules-title {*/
/*             font-size: 1.5rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 2rem;*/
/*             text-align: center;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .modules-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));*/
/*             gap: 1.5rem;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .module-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             cursor: pointer;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/* */
/*         .module-card:hover {*/
/*             transform: translateY(-4px);*/
/*             box-shadow: var(--shadow-module);*/
/*             border-color: var(--primary);*/
/*         }*/
/* */
/*         .module-card:nth-child(1) { animation-delay: 0.5s; }*/
/*         .module-card:nth-child(2) { animation-delay: 0.6s; }*/
/*         .module-card:nth-child(3) { animation-delay: 0.7s; }*/
/*         .module-card:nth-child(4) { animation-delay: 0.8s; }*/
/*         .module-card:nth-child(5) { animation-delay: 0.9s; }*/
/*         .module-card:nth-child(6) { animation-delay: 1.0s; }*/
/*         .module-card:nth-child(7) { animation-delay: 1.1s; }*/
/*         .module-card:nth-child(8) { animation-delay: 1.2s; }*/
/* */
/*         .module-header {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 1rem;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .module-icon {*/
/*             width: 3rem;*/
/*             height: 3rem;*/
/*             background: var(--gradient-primary);*/
/*             border-radius: 0.75rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .module-title {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .module-description {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 0.875rem;*/
/*             line-height: 1.5;*/
/*         }*/
/* */
/*         /* Animations *//* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(30px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/* */
/*         /* Mobile Styles *//* */
/*         @media (max-width: 768px) {*/
/*             .nav-menu {*/
/*                 display: none;*/
/*             }*/
/* */
/*             .mobile-menu-btn {*/
/*                 display: block;*/
/*             }*/
/* */
/*             .dashboard {*/
/*                 padding: 1rem;*/
/*             }*/
/* */
/*             .stats-grid {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/* */
/*             .modules-grid {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/* */
/*             .dashboard-title {*/
/*                 font-size: 1.5rem;*/
/*             }*/
/*         }*/
/* */
/*         /* Mobile Menu Overlay *//* */
/*         .mobile-overlay {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             left: 0;*/
/*             right: 0;*/
/*             bottom: 0;*/
/*             background: rgba(0, 0, 0, 0.5);*/
/*             z-index: 9999; /* Augmenté pour éviter les conflits *//* */
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .mobile-overlay.active {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*         }*/
/* */
/*         .mobile-menu {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             right: -100%;*/
/*             width: min(280px, 90vw);*/
/*             height: 100vh;*/
/*             background: var(--gradient-primary);*/
/*             z-index: 10000; /* Augmenté pour éviter les conflits *//* */
/*             transition: right 0.3s ease;*/
/*             padding: 1.5rem;*/
/*             overflow-x: hidden;*/
/*         }*/
/*         .mobile-menu.active {*/
/*             right: 0;*/
/*         }*/
/* */
/*         .mobile-menu-header {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             margin-bottom: 1.5rem;*/
/*         }*/
/* */
/*         .mobile-menu-title {*/
/*             color: var(--primary-foreground);*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*         }*/
/* */
/*         .close-btn {*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*         }*/
/* */
/*         .mobile-nav-item {*/
/*             margin-bottom: 0.75rem;*/
/*         }*/
/* */
/*         .mobile-nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             padding: 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.5rem;*/
/*             transition: background 0.3s ease;*/
/*             white-space: nowrap;*/
/*             font-size: 0.875rem;*/
/*         }*/
/* */
/*         .mobile-nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*         }*/
/* */
/*         /* Icons *//* */
/*         .icon {*/
/*             width: 1rem;*/
/*             height: 1rem;*/
/*             stroke: currentColor;*/
/*             fill: none;*/
/*             stroke-width: 2;*/
/*         }*/
/* */
/*         .icon-lg {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*         }*/
/*         /* Footer Styles *//* */
/*         .footer {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             padding: 1rem;*/
/*             text-align: center;*/
/*             border-top: 1px solid rgba(255, 255, 255, 0.1);*/
/*             box-shadow: var(--shadow-elegant);*/
/*             width: 100%;*/
/*             position: sticky;*/
/*             bottom: 0;*/
/*             z-index: 1000;*/
/*         }*/
/* */
/*         .footer-text {*/
/*             font-size: 0.875rem;*/
/*             margin: 0;*/
/*         }*/
/* */
/*         .footer-text a {*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             font-weight: bold;*/
/*         }*/
/* */
/*         .footer-text a:hover {*/
/*             text-decoration: underline;*/
/*         }*/
/* */
/*         .alerts-container {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 2rem 1rem;*/
/*             display: flex;*/
/*             flex-direction: column;*/
/*             gap: 1rem;*/
/*         }*/
/* */
/*         .alert {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             padding: 1rem 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             position: relative;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .alert:hover {*/
/*             transform: translateY(-2px);*/
/*             box-shadow: var(--shadow-hover);*/
/*         }*/
/* */
/*         .alert-primary {*/
/*             border-left: 4px solid var(--primary);*/
/*             background: linear-gradient(145deg, hsl(221, 83%, 97%), hsl(221, 83%, 99%));*/
/*         }*/
/* */
/*         .alert-success {*/
/*             border-left: 4px solid var(--success);*/
/*             background: linear-gradient(145deg, hsl(142, 71%, 97%), hsl(142, 71%, 99%));*/
/*         }*/
/* */
/*         .alert-warning {*/
/*             border-left: 4px solid var(--warning);*/
/*             background: linear-gradient(145deg, hsl(38, 92%, 97%), hsl(38, 92%, 99%));*/
/*         }*/
/* */
/*         .alert-danger {*/
/*             border-left: 4px solid var(--danger);*/
/*             background: linear-gradient(145deg, hsl(0, 84%, 97%), hsl(0, 84%, 99%));*/
/*         }*/
/* */
/*         .alert-content {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 1rem;*/
/*             flex: 1;*/
/*         }*/
/* */
/*         .alert-icon {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .alert-primary .alert-icon {*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .alert-success .alert-icon {*/
/*             color: var(--success);*/
/*         }*/
/* */
/*         .alert-warning .alert-icon {*/
/*             color: var(--warning);*/
/*         }*/
/* */
/*         .alert-danger .alert-icon {*/
/*             color: var(--danger);*/
/*         }*/
/* */
/*         .alert-message {*/
/*             font-size: 0.875rem;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .alert-primary .alert-message {*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .alert-success .alert-message {*/
/*             color: var(--success);*/
/*         }*/
/* */
/*         .alert-warning .alert-message {*/
/*             color: var(--warning);*/
/*         }*/
/* */
/*         .alert-danger .alert-message {*/
/*             color: var(--danger);*/
/*         }*/
/* */
/*         .alert-close {*/
/*             background: transparent;*/
/*             border: none;*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*             color: var(--foreground);*/
/*             opacity: 0.6;*/
/*             transition: opacity 0.3s ease;*/
/*         }*/
/* */
/*         .alert-close:hover {*/
/*             opacity: 1;*/
/*         }*/
/* */
/*         .alert:nth-child(1) { animation-delay: 0.1s; }*/
/*         .alert:nth-child(2) { animation-delay: 0.2s; }*/
/*         .alert:nth-child(3) { animation-delay: 0.3s; }*/
/*         .alert:nth-child(4) { animation-delay: 0.4s; }*/
/* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(20px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/* */
/*         @media (max-width: 768px) {*/
/*             .alerts-container {*/
/*                 padding: 1rem;*/
/*             }*/
/* */
/*             .alert {*/
/*                 padding: 0.75rem 1rem;*/
/*             }*/
/* */
/*             .alert-message {*/
/*                 font-size: 0.8125rem;*/
/*             }*/
/*         }*/
/* */
/*         /* Add this to the <style> tag *//* */
/*         .pagination .page-link {*/
/*             color: var(--primary);*/
/*             background: var(--card);*/
/*             border: 1px solid var(--border);*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .pagination .page-link:hover {*/
/*             background: var(--accent);*/
/*             color: var(--primary-dark);*/
/*         }*/
/* */
/*         .pagination .page-item.active .page-link {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             border-color: var(--primary);*/
/*         }*/
/* */
/*         .pagination .page-item.disabled .page-link {*/
/*             color: var(--muted-foreground);*/
/*             background: var(--muted);*/
/*             border-color: var(--border);*/
/*         }*/
/* */
/*          .important{*/
/* */
/*             border: 2px solid red;*/
/*         }*/
/* */
/*           .thumbnail {*/
/*           position: relative;*/
/*           display: inline-block;*/
/*           border: 1px solid #ccc;*/
/*           padding: 5px;*/
/*           margin: 10px;*/
/*           border-radius: 5px;*/
/*         }*/
/* */
/*         .thumbnail_details {*/
/*           position: relative;*/
/*           display: inline-block;*/
/*           border: 1px solid #ccc;*/
/*           padding: 5px;*/
/*           margin: 10px;*/
/*           border-radius: 5px;*/
/*         }*/
/* */
/*         .thumbnail img {*/
/*           width: 200px;*/
/*           height: 200px;*/
/*           object-fit: cover;*/
/*           display: block;*/
/*           border-radius: 5px;*/
/*         }*/
/*         .thumbnail_details img {*/
/*           width: 400px;*/
/*           height: 400px;*/
/*           object-fit: cover;*/
/*           display: block;*/
/*           border-radius: 5px;*/
/*         }*/
/* */
/*         .delete-icon {*/
/*           position: absolute;*/
/*           top: 5px;*/
/*           right: 5px;*/
/*           width: 20px;*/
/*           height: 20px;*/
/*           line-height: 20px;*/
/*           text-align: center;*/
/*           font-size: 16px;*/
/*           background-color: red;*/
/*           color: white;*/
/*           border-radius: 50%;*/
/*           cursor: pointer;*/
/*           */
/*         }*/
/* */
/*         .delete-icon:hover {*/
/*           opacity: 1;*/
/*         }*/
/* */
/*         .tab-container {*/
/*             display: flex;*/
/*             gap: 0.5rem;*/
/*             margin-bottom: 1.5rem;*/
/*             overflow-x: auto;*/
/*             padding: 0 1rem;*/
/*         }*/
/* */
/*         .tab {*/
/*             padding: 0.75rem 1.5rem;*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             color: var(--foreground);*/
/*             font-size: 0.875rem;*/
/*             font-weight: 500;*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*             border: 1px solid var(--border);*/
/*             box-shadow: var(--neumorphic-shadow);*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .tab:hover {*/
/*             background: var(--accent);*/
/*         }*/
/* */
/*         .tab.active {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             box-shadow: var(--neumorphic-shadow-hover);*/
/*         }*/
/* */
/*         @media (max-width: 768px) {*/
/*             .tab-container {*/
/*                 padding: 0 0.5rem;*/
/*             }*/
/* */
/*             .tab {*/
/*                 padding: 0.5rem 1rem;*/
/*                 font-size: 0.75rem;*/
/*             }*/
/*         }*/
/* */
/* */
/*     </style>*/
/*     <!--<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />-->*/
/* </head>*/
/* <body>*/
/*     <!-- Navigation -->*/
/*     <nav class="navbar">*/
/*         <div class="navbar-container">*/
/*             <div class="logo"><a href="{{ base_url }}admin/dashboard"><img src="{{ base_url }}uploads/logo_etaa_blanc.png" style="height:50px"/></a></div>*/
/*             */
/*              <div class="nav-item">*/
/*                     <a href="{{ base_url }}admin/dashboard" class="nav-link">*/
/*                         <i class="icon" data-feather="airplay"></i>*/
/*                         Dashboard principal*/
/*                     </a>*/
/*                 </div>*/
/*             <div class="nav-menu">*/
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock" class="nav-link">*/
/*                         <i class="icon" data-feather="home"></i>*/
/*                         Tableau de bord Gestion Stock*/
/*                     </a>*/
/*                 </div>*/
/*                 */
/*                <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="bookmark"></i>*/
/*                         Stock*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="{{ base_url }}gestion_stock/categories" class="dropdown-item">Catégories</a>*/
/*                         <a href="{{ base_url }}gestion_stock/liste_produits" class="dropdown-item">Produits</a>*/
/*                         <a href="{{ base_url }}gestion_stock/liste_services" class="dropdown-item">Services</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="layers"></i>*/
/*                         Entrepôts*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                          <a href="{{ base_url }}gestion_stock/entrepots" class="dropdown-item">Gestion des entreprôts</a>*/
/*                         <a href="{{ base_url }}gestion_stock/ajouter_casier" class="dropdown-item">Gestion des Casiers</a>*/
/*                     </div>*/
/*                 </div>*/
/*                 */
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock/liste_inventaires" class="nav-link">*/
/*                         <i class="icon" data-feather="list"></i>*/
/*                         Inventaires*/
/*                     </a>*/
/*                 </div>*/
/* */
/*                  <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock/mouvements" class="nav-link">*/
/*                         <i class="icon" data-feather="book"></i>*/
/*                         Mouvements*/
/*                     </a>*/
/*                 </div>*/
/* */
/*                  <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock/fournisseurs" class="nav-link">*/
/*                         <i class="icon" data-feather="truck"></i>*/
/*                         Fournisseurs*/
/*                     </a>*/
/*                 </div>*/
/*                 */
/*                 */
/*                 <div class="user-menu">*/
/*                     <button class="user-avatar" style="border:1px solid white;" onclick="toggleUserMenu()">*/
/*                         <i class="icon icon-lg" style="color:white" data-feather="user"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         <a href="{{ base_url }}home/mon_profil" class="dropdown-item">Profil</a>*/
/*                         <a href="{{ base_url }}home/logout" class="dropdown-item" style="color: #dc2626;">Se déconnecter</a>*/
/*                     </div>*/
/*                 </div>*/
/*             */
/*                 <button class="mobile-menu-btn" onclick="toggleMobileMenu()">*/
/*                     <i class="icon icon-lg" data-feather="menu"></i>*/
/*                 </button>*/
/*         </div>*/
/*     </nav>*/
/* */
/*     <!-- Mobile Menu Overlay -->*/
/*     <div class="mobile-overlay" id="mobileOverlay" onclick="closeMobileMenu()"></div>*/
/*     <div class="mobile-menu" id="mobileMenu">*/
/*     <div class="mobile-menu-header">*/
/*         <div class="mobile-menu-title">Menu</div>*/
/*         <button class="close-btn" onclick="closeMobileMenu()">*/
/*             <i class="icon icon-lg" data-feather="x"></i>*/
/*         </button>*/
/*     </div>*/
/*     <div class="mobile-nav-item">*/
/*         <a href="https://localhost/erp_etaa/admin/dashboard" class="mobile-nav-link">*/
/*             <i class="icon" data-feather="home"></i>*/
/*             Tableau de bord*/
/*         </a>*/
/*     </div>*/
/*     <div class="mobile-nav-item">*/
/*         <a href="https://localhost/erp_etaa/gestion_stock/liste_produits" class="mobile-nav-link">*/
/*             <i class="icon" data-feather="shopping-cart"></i>*/
/*             Stock*/
/*         </a>*/
/*     </div>*/
/*     <div class="mobile-nav-item">*/
/*         <a href="https://localhost/erp_etaa/gestion_stock/entrepots" class="mobile-nav-link">*/
/*             <i class="icon" data-feather="package"></i>*/
/*             Entrepôts*/
/*         </a>*/
/*     </div>*/
/*     <div class="mobile-nav-item">*/
/*         <a href="https://localhost/erp_etaa/gestion_stock/liste_inventaires" class="mobile-nav-link">*/
/*             <i class="icon" data-feather="dollar-sign"></i>*/
/*             Inventaire*/
/*         </a>*/
/*     </div>*/
/*     <div class="mobile-nav-item">*/
/*         <a href="https://localhost/erp_etaa/gestion_stock/mouvements" class="mobile-nav-link">*/
/*             <i class="icon" data-feather="users"></i>*/
/*             Mouvements*/
/*         </a>*/
/*     </div>*/
/*     <div class="mobile-nav-item">*/
/*         <a href="https://localhost/erp_etaa/gestion_stock/fournisseurs" class="mobile-nav-link">*/
/*             <i class="icon" data-feather="calendar"></i>*/
/*             Fournisseurs*/
/*         </a>*/
/*     </div>*/
/* </div>*/
