<?php

/* stock/header_form.html.twig */
class __TwigTemplate_22c61600d52c4fb3eec257b206ed9d2e1610873c2373cb98dcc759ba5bff6969 extends Twig_Template
{
    public function __construct(Twig_Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = array(
        );
    }

    protected function doDisplay(array $context, array $blocks = array())
    {
        // line 1
        echo "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>ERP ETAA - Tableau de Bord</title>
    <!-- Feather Icons CDN -->
    
    <link href=\"https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css\" rel=\"stylesheet\" integrity=\"sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN\" crossorigin=\"anonymous\">
    <!-- Feather Icons CDN -->
    <script src=\"https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js\"></script>
    <link href=\"https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css\" rel=\"stylesheet\" />
    <link rel=\"stylesheet\" href=\"https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css\" />
    <style>
     
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --background: hsl(220, 25%, 97%);
            --foreground: hsl(224, 30%, 15%);
            --card: hsl(0, 0%, 100%);
            --card-foreground: hsl(224, 30%, 15%);
            --primary: hsl(221, 83%, 53%);
            --primary-foreground: hsl(0, 0%, 100%);
            --primary-light: hsl(217, 91%, 60%);
            --primary-dark: hsl(224, 76%, 48%);
            --secondary: hsl(214, 100%, 97%);
            --secondary-foreground: hsl(224, 30%, 25%);
            --muted: hsl(217, 33%, 94%);
            --muted-foreground: hsl(215, 25%, 55%);
            --accent: hsl(213, 97%, 87%);
            --accent-foreground: hsl(224, 30%, 25%);
            --border: hsl(217, 25%, 88%);
            --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));
            --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));
            --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));
            --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);
            --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);
            --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);
        }

        html, body {
            width: 100%;
            overflow-x: hidden;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: var(--background);
            color: var(--foreground);
            line-height: 1.6;
        }

        /* Navbar Styles */
        .navbar {
            background: var(--gradient-primary);
            box-shadow: var(--shadow-elegant);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
            width: 100%;
        }

        .navbar-container {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 0 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 64px;
        }

        .logo {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }

        .nav-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            flex-wrap: nowrap;
        }

        .nav-item {
            position: relative;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.375rem;
            transition: all 0.3s ease;
            background: transparent;
            border: none;
            cursor: pointer;
            font-size: 0.875rem;
            white-space: nowrap;
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            box-shadow: var(--shadow-card);
            min-width: 180px;
            max-width: calc(100vw - 2rem);
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
            z-index: 100;
        }

        .nav-item:hover .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .dropdown-item {
            display: block;
            padding: 0.75rem 1rem;
            color: var(--foreground);
            text-decoration: none;
            transition: background 0.2s ease;
            white-space: nowrap;
        }

        .dropdown-item:hover {
            background: var(--accent);
        }

        .user-menu {
            position: relative;
            flex-shrink: 0;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .user-menu .dropdown {
            right: 0;
            left: auto;
            min-width: 150px;
            max-width: 200px;
        }

        .user-menu.active .dropdown {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .mobile-menu-btn {
            display: none;
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.375rem;
            flex-shrink: 0;
            z-index: 1001; /* Ajout pour éviter les conflits */
        }

        /* Dashboard Styles */
        .dashboard {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 2rem 1rem;
        }

        .dashboard-header {
            margin-bottom: 2rem;
            text-align: center;
        }

        .dashboard-title {
            font-size: 2rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .dashboard-subtitle {
            color: var(--muted-foreground);
            font-size: 1rem;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 3rem;
            width: 100%;
        }

        .stat-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-module);
        }

        .stat-card:nth-child(1) { animation-delay: 0.1s; }
        .stat-card:nth-child(2) { animation-delay: 0.2s; }
        .stat-card:nth-child(3) { animation-delay: 0.3s; }
        .stat-card:nth-child(4) { animation-delay: 0.4s; }

        .stat-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 1rem;
        }

        .stat-title {
            font-size: 0.875rem;
            color: var(--muted-foreground);
            font-weight: 500;
        }

        .stat-icon {
            width: 1.5rem;
            height: 1.5rem;
            color: var(--primary);
        }

        .stat-value {
            font-size: 2rem;
            font-weight: bold;
            color: var(--foreground);
            margin-bottom: 0.25rem;
        }

        .stat-description {
            font-size: 0.75rem;
            color: var(--muted-foreground);
        }

        /* Modules Grid */
        .modules-title {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 2rem;
            text-align: center;
            color: var(--foreground);
        }

        .modules-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            width: 100%;
        }

        .module-card {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            transition: all 0.3s ease;
            cursor: pointer;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
        }

        .module-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-module);
            border-color: var(--primary);
        }

        .module-card:nth-child(1) { animation-delay: 0.5s; }
        .module-card:nth-child(2) { animation-delay: 0.6s; }
        .module-card:nth-child(3) { animation-delay: 0.7s; }
        .module-card:nth-child(4) { animation-delay: 0.8s; }
        .module-card:nth-child(5) { animation-delay: 0.9s; }
        .module-card:nth-child(6) { animation-delay: 1.0s; }
        .module-card:nth-child(7) { animation-delay: 1.1s; }
        .module-card:nth-child(8) { animation-delay: 1.2s; }

        .module-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .module-icon {
            width: 3rem;
            height: 3rem;
            background: var(--gradient-primary);
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-foreground);
            flex-shrink: 0;
        }

        .module-title {
            font-size: 1.25rem;
            font-weight: bold;
            color: var(--foreground);
        }

        .module-description {
            color: var(--muted-foreground);
            font-size: 0.875rem;
            line-height: 1.5;
        }

        /* Animations */
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Mobile Styles */
        @media (max-width: 768px) {
            .nav-menu {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .dashboard {
                padding: 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .modules-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .dashboard-title {
                font-size: 1.5rem;
            }
        }

        /* Mobile Menu Overlay */
        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9999; /* Augmenté pour éviter les conflits */
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 0;
            right: -100%;
            width: min(280px, 90vw);
            height: 100vh;
            background: var(--gradient-primary);
            z-index: 10000; /* Augmenté pour éviter les conflits */
            transition: right 0.3s ease;
            padding: 1.5rem;
            overflow-x: hidden;
        }
        .mobile-menu.active {
            right: 0;
        }

        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }

        .mobile-menu-title {
            color: var(--primary-foreground);
            font-size: 1.25rem;
            font-weight: bold;
        }

        .close-btn {
            background: transparent;
            border: none;
            color: var(--primary-foreground);
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-nav-item {
            margin-bottom: 0.75rem;
        }

        .mobile-nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            color: var(--primary-foreground);
            text-decoration: none;
            border-radius: 0.5rem;
            transition: background 0.3s ease;
            white-space: nowrap;
            font-size: 0.875rem;
        }

        .mobile-nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        /* Icons */
        .icon {
            width: 1rem;
            height: 1rem;
            stroke: currentColor;
            fill: none;
            stroke-width: 2;
        }

        .icon-lg {
            width: 1.5rem;
            height: 1.5rem;
        }
        /* Footer Styles */
        .footer {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            padding: 1rem;
            text-align: center;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: var(--shadow-elegant);
            width: 100%;
            position: sticky;
            bottom: 0;
            z-index: 1000;
        }

        .footer-text {
            font-size: 0.875rem;
            margin: 0;
        }

        .footer-text a {
            color: var(--primary-foreground);
            text-decoration: none;
            font-weight: bold;
        }

        .footer-text a:hover {
            text-decoration: underline;
        }

         /* Styles pour Select2 afin de correspondre à .form-select */
        .select2-container {
            width: 100% !important; /* Assure que Select2 prend toute la largeur */
        }

        /* Style du champ de sélection principal */
        .select2-container--default .select2-selection--single {
            padding: 0.75rem;
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            background: var(--card);
            color: var(--foreground);
            font-size: 0.875rem;
            box-shadow: var(--neumorphic-shadow);
            transition: all 0.3s ease;
            height: auto; /* Permet une hauteur flexible */
        }

        /* Style du texte affiché */
        .select2-container--default .select2-selection--single .select2-selection__rendered {
            color: var(--foreground);
            line-height: 1.6;
            padding: 0; /* Supprime le padding interne pour éviter un décalage */
        }

        /* Style de la flèche */
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 100%;
            right: 0.75rem; /* Alignement avec le padding */
            top: 0;
            width: 20px;
        }

        /* Effet au focus (identique à .form-select:focus) */
        .select2-container--default .select2-selection--single:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);
            transform: translateY(-2px);
        }

        /* Effet au survol (identique à .form-select:hover) */
        .select2-container--default .select2-selection--single:hover {
            box-shadow: var(--neumorphic-shadow-hover);
            transform: translateY(-1px);
        }

        /* Style du menu déroulant */
        .select2-container--default .select2-dropdown {
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            background: var(--card);
            box-shadow: var(--shadow-card);
            z-index: 1050; /* Supérieur au z-index de la navbar (1000) */
        }

        /* Style des options dans le menu déroulant */
        .select2-container--default .select2-results__option {
            color: var(--foreground);
            padding: 0.75rem 1rem;
            font-size: 0.875rem;
        }

        /* Style de l'option surlignée */
        .select2-container--default .select2-results__option--highlighted {
            background: var(--accent);
            color: var(--foreground);
        }

        /* Style de l'option sélectionnée */
        .select2-container--default .select2-results__option--selected {
            background: var(--primary-light);
            color: var(--primary-foreground);
        }

        /* Placeholder */
        .select2-container--default .select2-selection--single .select2-selection__placeholder {
            color: var(--muted-foreground);
        }

        .alerts-container {
            max-width: 100%;
            width: 100%;
            margin: 0 auto;
            padding: 2rem 1rem;
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        .alert {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            padding: 1rem 1.5rem;
            box-shadow: var(--shadow-card);
            display: flex;
            justify-content: space-between;
            align-items: center;
            animation: slideInUp 0.6s ease forwards;
            opacity: 0;
            position: relative;
            transition: all 0.3s ease;
        }

        .alert:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-hover);
        }

        .alert-primary {
            border-left: 4px solid var(--primary);
            background: linear-gradient(145deg, hsl(221, 83%, 97%), hsl(221, 83%, 99%));
        }

        .alert-success {
            border-left: 4px solid var(--success);
            background: linear-gradient(145deg, hsl(142, 71%, 97%), hsl(142, 71%, 99%));
        }

        .alert-warning {
            border-left: 4px solid var(--warning);
            background: linear-gradient(145deg, hsl(38, 92%, 97%), hsl(38, 92%, 99%));
        }

        .alert-danger {
            border-left: 4px solid var(--danger);
            background: linear-gradient(145deg, hsl(0, 84%, 97%), hsl(0, 84%, 99%));
        }

        .alert-content {
            display: flex;
            align-items: center;
            gap: 1rem;
            flex: 1;
        }

        .alert-icon {
            width: 1.5rem;
            height: 1.5rem;
            flex-shrink: 0;
        }

        .alert-primary .alert-icon {
            color: var(--primary);
        }

        .alert-success .alert-icon {
            color: var(--success);
        }

        .alert-warning .alert-icon {
            color: var(--warning);
        }

        .alert-danger .alert-icon {
            color: var(--danger);
        }

        .alert-message {
            font-size: 0.875rem;
            color: var(--foreground);
        }

        .alert-primary .alert-message {
            color: var(--primary);
        }

        .alert-success .alert-message {
            color: var(--success);
        }

        .alert-warning .alert-message {
            color: var(--warning);
        }

        .alert-danger .alert-message {
            color: var(--danger);
        }

        .alert-close {
            background: transparent;
            border: none;
            cursor: pointer;
            padding: 0.5rem;
            color: var(--foreground);
            opacity: 0.6;
            transition: opacity 0.3s ease;
        }

        .alert-close:hover {
            opacity: 1;
        }

        .alert:nth-child(1) { animation-delay: 0.1s; }
        .alert:nth-child(2) { animation-delay: 0.2s; }
        .alert:nth-child(3) { animation-delay: 0.3s; }
        .alert:nth-child(4) { animation-delay: 0.4s; }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .alerts-container {
                padding: 1rem;
            }

            .alert {
                padding: 0.75rem 1rem;
            }

            .alert-message {
                font-size: 0.8125rem;
            }
        }

        .table-container {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 1.5rem;
            box-shadow: var(--shadow-card);
            margin-bottom: 2rem;
            animation: slideInUp 0.6s ease forwards;
            width: 100%;
            max-width: 100vw;
            margin-left: 0;
            margin-right: 0;
        }

        .table-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding: 0 1rem;
        }

        .table-search {
            position: relative;
            max-width: 300px;
            width: 100%;
        }

        .table-search-input {
            padding: 0.75rem 2.5rem 0.75rem 1rem;
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            background: var(--card);
            color: var(--foreground);
            font-size: 0.875rem;
            width: 100%;
            box-shadow: var(--neumorphic-shadow);
            transition: all 0.3s ease;
        }

        .table-search-input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);
        }

        .table-search-icon {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--muted-foreground);
        }

        * Form Styles */
        .product-form-container {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 2rem;
            box-shadow: var(--shadow-card);
            margin-bottom: 2rem;
            animation: slideInUp 0.6s ease forwards;
            width: 100%;
            max-width: 100%;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .form-label {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--foreground);
        }

        .form-input,
        .form-select,
        .form-textarea {
            padding: 0.75rem;
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            background: var(--card);
            color: var(--foreground);
            font-size: 0.875rem;
            box-shadow: var(--neumorphic-shadow);
            transition: all 0.3s ease;
        }

        .form-input:focus,
        .form-select:focus,
        .form-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);
            transform: translateY(-2px);
        }

        .form-input:hover,
        .form-select:hover,
        .form-textarea:hover {
            box-shadow: var(--neumorphic-shadow-hover);
            transform: translateY(-1px);
        }

        .form-textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-actions {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 0.375rem;
            font-size: 0.875rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
        }

        .btn-primary {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .table-responsive {
            overflow-x: auto;
            width: 100%;
        }

        .product-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            background: var(--card);
            border-radius: 0.5rem;
            overflow: hidden;
            box-shadow: var(--shadow-card);
        }

        .product-table th,
        .product-table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid var(--border);
        }

        .product-table th {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            font-weight: 500;
            font-size: 0.875rem;
        }

        .product-table tr:last-child td {
            border-bottom: none;
        }

        .product-table tr:hover {
            background: var(--accent);
        }

        .action-buttons {
            display: flex;
            gap: 0.5rem;
        }

        .action-btn {
            padding: 0.5rem;
            border-radius: 0.375rem;
            background: var(--muted);
            border: 1px solid var(--border);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .action-btn:hover {
            background: var(--primary);
            color: var(--primary-foreground);
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .nav-menu {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .dashboard {
                padding: 1rem 0;
            }

            .dashboard-title {
                font-size: 1.5rem;
            }

            .table-container {
                padding: 1rem;
            }

            .product-table th,
            .product-table td {
                font-size: 0.75rem;
                padding: 0.75rem;
            }

            .action-buttons {
                flex-direction: column;
            }
        }

        .switch {
          position: relative;
          display: inline-block;
          width: 60px;
          height: 34px;
        }

        .switch input { 
          opacity: 0;
          width: 0;
          height: 0;
        }

        .slider {
          position: absolute;
          cursor: pointer;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          background-color: #ccc;
          -webkit-transition: .4s;
          transition: .4s;
        }

        .slider:before {
          position: absolute;
          content: \"\";
          height: 26px;
          width: 26px;
          left: 4px;
          bottom: 4px;
          background-color: white;
          -webkit-transition: .4s;
          transition: .4s;
        }

        input:checked + .slider {
          background-color: #2196F3;
        }

        input:focus + .slider {
          box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
          -webkit-transform: translateX(26px);
          -ms-transform: translateX(26px);
          transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
          border-radius: 34px;
        }

        .slider.round:before {
          border-radius: 50%;
        }

        .pull-right {
          float: right !important;
        }
        .clearfix::after {
          content: \"\";
          display: table;
          clear: both;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .form-label {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--foreground);
        }

        .form-textarea {
            padding: 0.75rem;
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            background: var(--card);
            color: var(--foreground);
            font-size: 0.875rem;
            box-shadow: var(--neumorphic-shadow);
            transition: all 0.3s ease;
            resize: vertical;
            min-height: 100px;
        }

        .form-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);
            transform: translateY(-2px);
        }

        .form-textarea:hover {
            box-shadow: var(--neumorphic-shadow-hover);
            transform: translateY(-1px);
        }

        .important{

            border: 2px solid red;
        }

          .thumbnail {
          position: relative;
          display: inline-block;
          border: 1px solid #ccc;
          padding: 5px;
          margin: 10px;
          border-radius: 5px;
        }

        .thumbnail_details {
          position: relative;
          display: inline-block;
          border: 1px solid #ccc;
          padding: 5px;
          margin: 10px;
          border-radius: 5px;
        }

        .thumbnail img {
          width: 200px;
          height: 200px;
          object-fit: cover;
          display: block;
          border-radius: 5px;
        }
        .thumbnail_details img {
          width: 400px;
          height: 400px;
          object-fit: cover;
          display: block;
          border-radius: 5px;
        }

        .delete-icon {
          position: absolute;
          top: 5px;
          right: 5px;
          width: 20px;
          height: 20px;
          line-height: 20px;
          text-align: center;
          font-size: 16px;
          background-color: red;
          color: white;
          border-radius: 50%;
          cursor: pointer;
          
        }

        .delete-icon:hover {
          opacity: 1;
        }

        /* ✅ Grille responsive */
          .gallery{
            display:grid;
            gap: var(--gap);
            grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
          }

          /* ✅ Carte image */
          .card{
            position:relative;
            border-radius: var(--radius);
            overflow:hidden;
            background:#fff;
            box-shadow: var(--shadow);
          }

          /* ✅ Thumbnail carré (s’adapte à toutes tailles d’images) */
          .card img{
            display:block;
            width:100%;
            aspect-ratio: 1 / 1;      /* garde un carré */
            object-fit: cover;         /* recadre sans déformer */
            transition: transform .25s ease;
          }
          .card:hover img{ transform: scale(1.03); }

          /* ✅ Bouton croix rouge (suppression) */
          .remove-btn{
            position:absolute;
            top:8px; right:8px;
            width:32px; height:32px;
            border:none; border-radius:999px;
            background: var(--danger);
            color:#fff; font-size:18px; line-height:0;
            display:grid; place-items:center;
            cursor:pointer;
            box-shadow: 0 4px 10px rgba(0,0,0,.18);
            transition: background .2s ease, transform .1s ease;
          }
          .remove-btn:hover{ background: var(--danger-hover); }
          .remove-btn:active{ transform: scale(.96); }
          .remove-btn:focus-visible{ outline: 3px solid rgba(255,59,48,.35); }

          /* Optionnel: info bulle simple */
          .remove-btn[title] { position: relative; }

          .tab-container {
                display: flex;
                gap: 0.5rem;
                margin-bottom: 1.5rem;
                overflow-x: auto;
                padding: 0 1rem;
            }

            .tab {
                padding: 0.75rem 1.5rem;
                border-radius: 0.5rem;
                background: var(--card);
                color: var(--foreground);
                font-size: 0.875rem;
                font-weight: 500;
                cursor: pointer;
                transition: all 0.3s ease;
                border: 1px solid var(--border);
                box-shadow: var(--neumorphic-shadow);
                white-space: nowrap;
            }

            .tab:hover {
                background: var(--accent);
            }

            .tab.active {
                background: var(--gradient-primary);
                color: var(--primary-foreground);
                box-shadow: var(--neumorphic-shadow-hover);
            }

            @media (max-width: 768px) {
                .tab-container {
                    padding: 0 0.5rem;
                }

                .tab {
                    padding: 0.5rem 1rem;
                    font-size: 0.75rem;
                }
            }

            .form-input,
            .form-select,
            .form-textarea {
                padding: 0.75rem;
                border: 1px solid hsl(217, 25%, 88%);
                border-radius: 0.5rem;
                background: hsl(0, 0%, 100%);
                color: hsl(224, 30%, 15%);
                font-size: 0.875rem;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Ombre externe */
                transition: all 0.3s ease;
            }

            .form-input:hover,
            .form-select:hover,
            .form-textarea:hover {
                box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15); /* Ombre externe renforcée au survol */
                transform: translateY(-2px); /* Animation de soulèvement */
            }

            .form-input:focus,
            .form-select:focus,
            .form-textarea:focus {
                outline: none;
                border-color: hsl(221, 83%, 53%);
                box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15), 0 0 0 3px rgba(59, 130, 246, 0.3); /* Ombre externe + halo */
                transform: translateY(-2px); /* Même animation que hover */
            }

            .form-row-inline {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem; /* Espace entre les champs */
            align-items: end; /* Aligne les bas des champs pour uniformité */
            margin-bottom: 1rem;
        }

        .form-field-inline {
            flex: 1;
            min-width: 200px; /* Largeur minimale pour éviter le chevauchement sur petits écrans */
            display: flex;
            flex-direction: column;
        }

        .form-field-inline label {
            margin-bottom: 0.25rem;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--foreground);
        }

        .form-field-inline .form-select,
        .form-field-inline .form-input {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid var(--border);
            border-radius: 0.5rem;
            background: var(--card);
            color: var(--foreground);
            font-size: 0.875rem;
            box-shadow: var(--neumorphic-shadow);
            transition: all 0.3s ease;
        }

        .form-field-inline .form-select:focus,
        .form-field-inline .form-input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);
            transform: translateY(-2px);
        }

        /* Responsive: Sur mobile, passer en colonne */
        @media (max-width: 768px) {
            .form-row-inline {
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .form-field-inline {
                min-width: 100%;
            }
        }

        /* Améliorations pour les images et tableau des prix */
        .images-section,
        .suppliers-section {
            background: var(--gradient-card);
            border: 1px solid var(--border);
            border-radius: 0.75rem;
            padding: 2rem;
            box-shadow: var(--shadow-card);
            margin-bottom: 2rem;
            animation: slideInUp 0.6s ease forwards;
            width: 100%;
            max-width: 100%;
        }

        .section-title {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 1.5rem;
            color: var(--foreground);
            text-align: center;
        }

        /* Grille d'images responsive (améliorée pour mobile) */
        .gallery {
            display: grid;
            gap: var(--gap);
            grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
            margin-top: 1rem;
        }

        @media (max-width: 768px) {
            .gallery {
                grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
                gap: 0.5rem;
            }
        }

        /* Tableau des prix par fournisseur */
        .suppliers-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            background: var(--card);
            border-radius: 0.5rem;
            overflow: hidden;
            box-shadow: var(--shadow-card);
            margin-top: 1rem;
        }

        .suppliers-table th,
        .suppliers-table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid var(--border);
        }

        .suppliers-table th {
            background: var(--gradient-primary);
            color: var(--primary-foreground);
            font-weight: 500;
            font-size: 0.875rem;
        }

        .suppliers-table tr:hover {
            background: var(--accent);
        }

        @media (max-width: 768px) {
            .suppliers-table th,
            .suppliers-table td {
                font-size: 0.75rem;
                padding: 0.75rem;
            }
        }
        .img_produit {
          width: 100px;
          height: 100px;
          object-fit: cover; /* Remplit la zone sans déformation */
          object-position: center; /* Centre l’image */
          border-radius: 6px; /* (facultatif) coins arrondis */
        }
    </style>
    <style>
    th {
        cursor: pointer;
        user-select: none;
        padding-right: 20px;
        position: relative;
    }
    th .arrow {
        position: absolute;
        right: 5px;
        font-size: 12px;
    }
</style>
    <link rel=\"stylesheet\" href=\"https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css\" />
</head>
<body>
    <!-- Navigation -->
    <nav class=\"navbar\">
        <div class=\"navbar-container\">
            <div class=\"logo\"><a href=\"";
        // line 1420
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "admin/dashboard\"><img src=\"";
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "uploads/logo_etaa_blanc.png\" style=\"height:50px\"/></a></div>
            
            <div class=\"nav-menu\">
                <div class=\"nav-item\">
                    <a href=\"";
        // line 1424
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "admin/dashboard\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"home\"></i>
                        Dashboard principal
                    </a>
                </div>

                <div class=\"nav-item\">
                    <a href=\"";
        // line 1431
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"home\"></i>
                        Tableau de bord Gestion Stock
                    </a>
                </div>

                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"bookmark\"></i>
                        Stock
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        ";
        // line 1444
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.liste_categories", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1445
            echo "                        <a href=\"";
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/categories\" class=\"dropdown-item\">Catégories</a>
                        ";
        }
        // line 1447
        echo "                        ";
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.list", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1448
            echo "                        <a href=\"";
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_produits\" class=\"dropdown-item\">Produits</a>
                        <a href=\"";
            // line 1449
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_services\" class=\"dropdown-item\">Services</a>
                        ";
        }
        // line 1451
        echo "                        <a href=\"";
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/stock_par_entrepot\" class=\"dropdown-item\">Stock par entrepôt</a>
                        
                        
                    </div>
                </div>
                ";
        // line 1456
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.liste_entrepots", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1457
            echo "                <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"layers\"></i>
                        Entrepôts
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                        
                         <a href=\"";
            // line 1465
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/entrepots\" class=\"dropdown-item\">Gestion des entreprôts</a>
                        <a href=\"";
            // line 1466
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/ajouter_casier\" class=\"dropdown-item\">Gestion des Casiers</a>
                        
                    </div>
                </div>
                ";
        }
        // line 1471
        echo "
                ";
        // line 1472
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.inventaire", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1473
            echo "
                <div class=\"nav-item\">
                    <a href=\"";
            // line 1475
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_inventaires\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"list\"></i>
                        Inventaires
                    </a>
                </div>
                ";
        }
        // line 1481
        echo "
                 <div class=\"nav-item\">
                    <a href=\"";
        // line 1483
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/mouvements\" class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"book\"></i>
                        Mouvements
                    </a>
                </div>

                 ";
        // line 1489
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.liste_fournisseurs", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1490
            echo "                
                 <div class=\"nav-item\">
                    <button class=\"nav-link\">
                        <i class=\"icon\" data-feather=\"truck\"></i>
                        Fournisseurs
                        <i class=\"icon\" data-feather=\"chevron-down\"></i>
                    </button>
                    <div class=\"dropdown\">
                       
                        <a href=\"";
            // line 1499
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/fournisseurs\" class=\"dropdown-item\">Liste des fournisseurs</a> 
                        <a href=\"";
            // line 1500
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_produits_fournisseur\" class=\"dropdown-item\">Produits par fournisseur</a>

                    </div>
                </div>
                ";
        }
        // line 1505
        echo "                
                
            </div>
            
            <div class=\"user-menu\">
                <button class=\"user-avatar\" onclick=\"toggleUserMenu()\" style=\"color:white;border:1px solid white;\">
                    <i class=\"icon icon-lg\" data-feather=\"user\" style=\"color:white\"></i>
                </button>
                <div class=\"dropdown\">
                    <a href=\"/profil\" class=\"dropdown-item\">Profil</a>
                    <a href=\"";
        // line 1515
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "home/logout\" class=\"dropdown-item\" style=\"color: #dc2626;\">Se déconnecter</a>
                </div>
            </div>
            
            <button class=\"mobile-menu-btn\" onclick=\"toggleMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"menu\"></i>
            </button>
        </div>
    </nav>

    <!-- Mobile Menu Overlay -->
    <div class=\"mobile-overlay\" id=\"mobileOverlay\" onclick=\"closeMobileMenu()\"></div>
    <div class=\"mobile-menu\" id=\"mobileMenu\">
        <div class=\"mobile-menu-header\">
            <div class=\"mobile-menu-title\">Menu</div>
            <button class=\"close-btn\" onclick=\"closeMobileMenu()\">
                <i class=\"icon icon-lg\" data-feather=\"x\"></i>
            </button>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"";
        // line 1535
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "admin/dashboard\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"home\"></i>
                Tableau de bord principal
            </a>
        </div>
         <div class=\"mobile-nav-item\">
            <a href=\"";
        // line 1541
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"home\"></i>
                Tableau de bord stocks
            </a>
        </div>
        ";
        // line 1546
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.list", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1547
            echo "         <div class=\"mobile-nav-item\">
            <a href=\"";
            // line 1548
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_produits\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"bookmark\"></i>
                Produits
            </a>
        </div>
        <div class=\"mobile-nav-item\">
            <a href=\"";
            // line 1554
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_services\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"bookmark\"></i>
                Services
            </a>
        </div>
        ";
        }
        // line 1560
        echo "        ";
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.liste_entrepots", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1561
            echo "        <div class=\"mobile-nav-item\">
            <a href=\"";
            // line 1562
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/entrepots\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"layers\"></i>
                Entrepôts
            </a>
        </div>
        ";
        }
        // line 1568
        echo "
        ";
        // line 1569
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.inventaire", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1570
            echo "        <div class=\"mobile-nav-item\">
            <a href=\"";
            // line 1571
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/liste_inventaires\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"list\"></i>
                Inventaires
            </a>
        </div>
        ";
        }
        // line 1577
        echo "        <div class=\"mobile-nav-item\">
            <a href=\"";
        // line 1578
        echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
        echo "gestion_stock/mouvements\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"book\"></i>
                Mouvements
            </a>
        </div>
        ";
        // line 1583
        if ((((isset($context["role_utilisateur"]) ? $context["role_utilisateur"] : null) ==  -1) || twig_in_filter("Stock.liste_fournisseurs", (isset($context["liste_autorisations"]) ? $context["liste_autorisations"] : null)))) {
            // line 1584
            echo "        <div class=\"mobile-nav-item\">
            <a href=\"";
            // line 1585
            echo twig_escape_filter($this->env, (isset($context["base_url"]) ? $context["base_url"] : null), "html", null, true);
            echo "gestion_stock/fournisseurs\" class=\"mobile-nav-link\">
                <i class=\"icon\" data-feather=\"truck\"></i>
                Fournisseurs
            </a>
        </div>
        ";
        }
        // line 1591
        echo "        
    </div>";
    }

    public function getTemplateName()
    {
        return "stock/header_form.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  1717 => 1591,  1708 => 1585,  1705 => 1584,  1703 => 1583,  1695 => 1578,  1692 => 1577,  1683 => 1571,  1680 => 1570,  1678 => 1569,  1675 => 1568,  1666 => 1562,  1663 => 1561,  1660 => 1560,  1651 => 1554,  1642 => 1548,  1639 => 1547,  1637 => 1546,  1629 => 1541,  1620 => 1535,  1597 => 1515,  1585 => 1505,  1577 => 1500,  1573 => 1499,  1562 => 1490,  1560 => 1489,  1551 => 1483,  1547 => 1481,  1538 => 1475,  1534 => 1473,  1532 => 1472,  1529 => 1471,  1521 => 1466,  1517 => 1465,  1507 => 1457,  1505 => 1456,  1496 => 1451,  1491 => 1449,  1486 => 1448,  1483 => 1447,  1477 => 1445,  1475 => 1444,  1459 => 1431,  1449 => 1424,  1440 => 1420,  19 => 1,);
    }
}
/* <!DOCTYPE html>*/
/* <html lang="fr">*/
/* <head>*/
/*     <meta charset="UTF-8">*/
/*     <meta name="viewport" content="width=device-width, initial-scale=1.0">*/
/*     <title>ERP ETAA - Tableau de Bord</title>*/
/*     <!-- Feather Icons CDN -->*/
/*     */
/*     <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">*/
/*     <!-- Feather Icons CDN -->*/
/*     <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>*/
/*     <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />*/
/*     <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" />*/
/*     <style>*/
/*      */
/*         * {*/
/*             margin: 0;*/
/*             padding: 0;*/
/*             box-sizing: border-box;*/
/*         }*/
/* */
/*         :root {*/
/*             --background: hsl(220, 25%, 97%);*/
/*             --foreground: hsl(224, 30%, 15%);*/
/*             --card: hsl(0, 0%, 100%);*/
/*             --card-foreground: hsl(224, 30%, 15%);*/
/*             --primary: hsl(221, 83%, 53%);*/
/*             --primary-foreground: hsl(0, 0%, 100%);*/
/*             --primary-light: hsl(217, 91%, 60%);*/
/*             --primary-dark: hsl(224, 76%, 48%);*/
/*             --secondary: hsl(214, 100%, 97%);*/
/*             --secondary-foreground: hsl(224, 30%, 25%);*/
/*             --muted: hsl(217, 33%, 94%);*/
/*             --muted-foreground: hsl(215, 25%, 55%);*/
/*             --accent: hsl(213, 97%, 87%);*/
/*             --accent-foreground: hsl(224, 30%, 25%);*/
/*             --border: hsl(217, 25%, 88%);*/
/*             --gradient-primary: linear-gradient(135deg, hsl(221, 83%, 53%), hsl(217, 91%, 60%));*/
/*             --gradient-secondary: linear-gradient(135deg, hsl(213, 97%, 87%), hsl(217, 91%, 85%));*/
/*             --gradient-card: linear-gradient(145deg, hsl(0, 0%, 100%), hsl(217, 33%, 97%));*/
/*             --shadow-elegant: 0 10px 30px -10px hsl(221, 83%, 53%, 0.3);*/
/*             --shadow-card: 0 4px 20px -4px hsl(221, 83%, 53%, 0.15);*/
/*             --shadow-module: 0 8px 25px -8px hsl(221, 83%, 53%, 0.2);*/
/*         }*/
/* */
/*         html, body {*/
/*             width: 100%;*/
/*             overflow-x: hidden;*/
/*             font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;*/
/*             background: var(--background);*/
/*             color: var(--foreground);*/
/*             line-height: 1.6;*/
/*         }*/
/* */
/*         /* Navbar Styles *//* */
/*         .navbar {*/
/*             background: var(--gradient-primary);*/
/*             box-shadow: var(--shadow-elegant);*/
/*             border-bottom: 1px solid rgba(255, 255, 255, 0.1);*/
/*             position: sticky;*/
/*             top: 0;*/
/*             z-index: 1000;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .navbar-container {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 0 1rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             height: 64px;*/
/*         }*/
/* */
/*         .logo {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .nav-menu {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             flex-wrap: nowrap;*/
/*         }*/
/* */
/*         .nav-item {*/
/*             position: relative;*/
/*         }*/
/* */
/*         .nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.5rem;*/
/*             padding: 0.5rem 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.375rem;*/
/*             transition: all 0.3s ease;*/
/*             background: transparent;*/
/*             border: none;*/
/*             cursor: pointer;*/
/*             font-size: 0.875rem;*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*             color: white;*/
/*         }*/
/* */
/*         .dropdown {*/
/*             position: absolute;*/
/*             top: 100%;*/
/*             left: 0;*/
/*             background: var(--card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             min-width: 180px;*/
/*             max-width: calc(100vw - 2rem);*/
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transform: translateY(-10px);*/
/*             transition: all 0.3s ease;*/
/*             z-index: 100;*/
/*         }*/
/* */
/*         .nav-item:hover .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/* */
/*         .dropdown-item {*/
/*             display: block;*/
/*             padding: 0.75rem 1rem;*/
/*             color: var(--foreground);*/
/*             text-decoration: none;*/
/*             transition: background 0.2s ease;*/
/*             white-space: nowrap;*/
/*         }*/
/* */
/*         .dropdown-item:hover {*/
/*             background: var(--accent);*/
/*         }*/
/* */
/*         .user-menu {*/
/*             position: relative;*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .user-avatar {*/
/*             width: 40px;*/
/*             height: 40px;*/
/*             border-radius: 50%;*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             cursor: pointer;*/
/*             transition: background 0.3s ease;*/
/*         }*/
/* */
/*         .user-avatar:hover {*/
/*             background: rgba(255, 255, 255, 0.2);*/
/*         }*/
/* */
/*         .user-menu .dropdown {*/
/*             right: 0;*/
/*             left: auto;*/
/*             min-width: 150px;*/
/*             max-width: 200px;*/
/*         }*/
/* */
/*         .user-menu.active .dropdown {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*             transform: translateY(0);*/
/*         }*/
/* */
/*         .mobile-menu-btn {*/
/*             display: none;*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*             border-radius: 0.375rem;*/
/*             flex-shrink: 0;*/
/*             z-index: 1001; /* Ajout pour éviter les conflits *//* */
/*         }*/
/* */
/*         /* Dashboard Styles *//* */
/*         .dashboard {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 2rem 1rem;*/
/*         }*/
/* */
/*         .dashboard-header {*/
/*             margin-bottom: 2rem;*/
/*             text-align: center;*/
/*         }*/
/* */
/*         .dashboard-title {*/
/*             font-size: 2rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 0.5rem;*/
/*             background: var(--gradient-primary);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/* */
/*         .dashboard-subtitle {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 1rem;*/
/*         }*/
/* */
/*         /* Stats Grid *//* */
/*         .stats-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));*/
/*             gap: 1.5rem;*/
/*             margin-bottom: 3rem;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .stat-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/* */
/*         .stat-card:hover {*/
/*             transform: translateY(-2px);*/
/*             box-shadow: var(--shadow-module);*/
/*         }*/
/* */
/*         .stat-card:nth-child(1) { animation-delay: 0.1s; }*/
/*         .stat-card:nth-child(2) { animation-delay: 0.2s; }*/
/*         .stat-card:nth-child(3) { animation-delay: 0.3s; }*/
/*         .stat-card:nth-child(4) { animation-delay: 0.4s; }*/
/* */
/*         .stat-header {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .stat-title {*/
/*             font-size: 0.875rem;*/
/*             color: var(--muted-foreground);*/
/*             font-weight: 500;*/
/*         }*/
/* */
/*         .stat-icon {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .stat-value {*/
/*             font-size: 2rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*             margin-bottom: 0.25rem;*/
/*         }*/
/* */
/*         .stat-description {*/
/*             font-size: 0.75rem;*/
/*             color: var(--muted-foreground);*/
/*         }*/
/* */
/*         /* Modules Grid *//* */
/*         .modules-title {*/
/*             font-size: 1.5rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 2rem;*/
/*             text-align: center;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .modules-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));*/
/*             gap: 1.5rem;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .module-card {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             transition: all 0.3s ease;*/
/*             cursor: pointer;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*         }*/
/* */
/*         .module-card:hover {*/
/*             transform: translateY(-4px);*/
/*             box-shadow: var(--shadow-module);*/
/*             border-color: var(--primary);*/
/*         }*/
/* */
/*         .module-card:nth-child(1) { animation-delay: 0.5s; }*/
/*         .module-card:nth-child(2) { animation-delay: 0.6s; }*/
/*         .module-card:nth-child(3) { animation-delay: 0.7s; }*/
/*         .module-card:nth-child(4) { animation-delay: 0.8s; }*/
/*         .module-card:nth-child(5) { animation-delay: 0.9s; }*/
/*         .module-card:nth-child(6) { animation-delay: 1.0s; }*/
/*         .module-card:nth-child(7) { animation-delay: 1.1s; }*/
/*         .module-card:nth-child(8) { animation-delay: 1.2s; }*/
/* */
/*         .module-header {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 1rem;*/
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .module-icon {*/
/*             width: 3rem;*/
/*             height: 3rem;*/
/*             background: var(--gradient-primary);*/
/*             border-radius: 0.75rem;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             color: var(--primary-foreground);*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .module-title {*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .module-description {*/
/*             color: var(--muted-foreground);*/
/*             font-size: 0.875rem;*/
/*             line-height: 1.5;*/
/*         }*/
/* */
/*         /* Animations *//* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(30px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/* */
/*         /* Mobile Styles *//* */
/*         @media (max-width: 768px) {*/
/*             .nav-menu {*/
/*                 display: none;*/
/*             }*/
/* */
/*             .mobile-menu-btn {*/
/*                 display: block;*/
/*             }*/
/* */
/*             .dashboard {*/
/*                 padding: 1rem;*/
/*             }*/
/* */
/*             .stats-grid {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/* */
/*             .modules-grid {*/
/*                 grid-template-columns: 1fr;*/
/*                 gap: 1rem;*/
/*             }*/
/* */
/*             .dashboard-title {*/
/*                 font-size: 1.5rem;*/
/*             }*/
/*         }*/
/* */
/*         /* Mobile Menu Overlay *//* */
/*         .mobile-overlay {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             left: 0;*/
/*             right: 0;*/
/*             bottom: 0;*/
/*             background: rgba(0, 0, 0, 0.5);*/
/*             z-index: 9999; /* Augmenté pour éviter les conflits *//* */
/*             opacity: 0;*/
/*             visibility: hidden;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .mobile-overlay.active {*/
/*             opacity: 1;*/
/*             visibility: visible;*/
/*         }*/
/* */
/*         .mobile-menu {*/
/*             position: fixed;*/
/*             top: 0;*/
/*             right: -100%;*/
/*             width: min(280px, 90vw);*/
/*             height: 100vh;*/
/*             background: var(--gradient-primary);*/
/*             z-index: 10000; /* Augmenté pour éviter les conflits *//* */
/*             transition: right 0.3s ease;*/
/*             padding: 1.5rem;*/
/*             overflow-x: hidden;*/
/*         }*/
/*         .mobile-menu.active {*/
/*             right: 0;*/
/*         }*/
/* */
/*         .mobile-menu-header {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             margin-bottom: 1.5rem;*/
/*         }*/
/* */
/*         .mobile-menu-title {*/
/*             color: var(--primary-foreground);*/
/*             font-size: 1.25rem;*/
/*             font-weight: bold;*/
/*         }*/
/* */
/*         .close-btn {*/
/*             background: transparent;*/
/*             border: none;*/
/*             color: var(--primary-foreground);*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*         }*/
/* */
/*         .mobile-nav-item {*/
/*             margin-bottom: 0.75rem;*/
/*         }*/
/* */
/*         .mobile-nav-link {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 0.75rem;*/
/*             padding: 0.75rem;*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             border-radius: 0.5rem;*/
/*             transition: background 0.3s ease;*/
/*             white-space: nowrap;*/
/*             font-size: 0.875rem;*/
/*         }*/
/* */
/*         .mobile-nav-link:hover {*/
/*             background: rgba(255, 255, 255, 0.1);*/
/*         }*/
/* */
/*         /* Icons *//* */
/*         .icon {*/
/*             width: 1rem;*/
/*             height: 1rem;*/
/*             stroke: currentColor;*/
/*             fill: none;*/
/*             stroke-width: 2;*/
/*         }*/
/* */
/*         .icon-lg {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*         }*/
/*         /* Footer Styles *//* */
/*         .footer {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             padding: 1rem;*/
/*             text-align: center;*/
/*             border-top: 1px solid rgba(255, 255, 255, 0.1);*/
/*             box-shadow: var(--shadow-elegant);*/
/*             width: 100%;*/
/*             position: sticky;*/
/*             bottom: 0;*/
/*             z-index: 1000;*/
/*         }*/
/* */
/*         .footer-text {*/
/*             font-size: 0.875rem;*/
/*             margin: 0;*/
/*         }*/
/* */
/*         .footer-text a {*/
/*             color: var(--primary-foreground);*/
/*             text-decoration: none;*/
/*             font-weight: bold;*/
/*         }*/
/* */
/*         .footer-text a:hover {*/
/*             text-decoration: underline;*/
/*         }*/
/* */
/*          /* Styles pour Select2 afin de correspondre à .form-select *//* */
/*         .select2-container {*/
/*             width: 100% !important; /* Assure que Select2 prend toute la largeur *//* */
/*         }*/
/* */
/*         /* Style du champ de sélection principal *//* */
/*         .select2-container--default .select2-selection--single {*/
/*             padding: 0.75rem;*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             color: var(--foreground);*/
/*             font-size: 0.875rem;*/
/*             box-shadow: var(--neumorphic-shadow);*/
/*             transition: all 0.3s ease;*/
/*             height: auto; /* Permet une hauteur flexible *//* */
/*         }*/
/* */
/*         /* Style du texte affiché *//* */
/*         .select2-container--default .select2-selection--single .select2-selection__rendered {*/
/*             color: var(--foreground);*/
/*             line-height: 1.6;*/
/*             padding: 0; /* Supprime le padding interne pour éviter un décalage *//* */
/*         }*/
/* */
/*         /* Style de la flèche *//* */
/*         .select2-container--default .select2-selection--single .select2-selection__arrow {*/
/*             height: 100%;*/
/*             right: 0.75rem; /* Alignement avec le padding *//* */
/*             top: 0;*/
/*             width: 20px;*/
/*         }*/
/* */
/*         /* Effet au focus (identique à .form-select:focus) *//* */
/*         .select2-container--default .select2-selection--single:focus {*/
/*             outline: none;*/
/*             border-color: var(--primary);*/
/*             box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);*/
/*             transform: translateY(-2px);*/
/*         }*/
/* */
/*         /* Effet au survol (identique à .form-select:hover) *//* */
/*         .select2-container--default .select2-selection--single:hover {*/
/*             box-shadow: var(--neumorphic-shadow-hover);*/
/*             transform: translateY(-1px);*/
/*         }*/
/* */
/*         /* Style du menu déroulant *//* */
/*         .select2-container--default .select2-dropdown {*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             box-shadow: var(--shadow-card);*/
/*             z-index: 1050; /* Supérieur au z-index de la navbar (1000) *//* */
/*         }*/
/* */
/*         /* Style des options dans le menu déroulant *//* */
/*         .select2-container--default .select2-results__option {*/
/*             color: var(--foreground);*/
/*             padding: 0.75rem 1rem;*/
/*             font-size: 0.875rem;*/
/*         }*/
/* */
/*         /* Style de l'option surlignée *//* */
/*         .select2-container--default .select2-results__option--highlighted {*/
/*             background: var(--accent);*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         /* Style de l'option sélectionnée *//* */
/*         .select2-container--default .select2-results__option--selected {*/
/*             background: var(--primary-light);*/
/*             color: var(--primary-foreground);*/
/*         }*/
/* */
/*         /* Placeholder *//* */
/*         .select2-container--default .select2-selection--single .select2-selection__placeholder {*/
/*             color: var(--muted-foreground);*/
/*         }*/
/* */
/*         .alerts-container {*/
/*             max-width: 100%;*/
/*             width: 100%;*/
/*             margin: 0 auto;*/
/*             padding: 2rem 1rem;*/
/*             display: flex;*/
/*             flex-direction: column;*/
/*             gap: 1rem;*/
/*         }*/
/* */
/*         .alert {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             padding: 1rem 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             opacity: 0;*/
/*             position: relative;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .alert:hover {*/
/*             transform: translateY(-2px);*/
/*             box-shadow: var(--shadow-hover);*/
/*         }*/
/* */
/*         .alert-primary {*/
/*             border-left: 4px solid var(--primary);*/
/*             background: linear-gradient(145deg, hsl(221, 83%, 97%), hsl(221, 83%, 99%));*/
/*         }*/
/* */
/*         .alert-success {*/
/*             border-left: 4px solid var(--success);*/
/*             background: linear-gradient(145deg, hsl(142, 71%, 97%), hsl(142, 71%, 99%));*/
/*         }*/
/* */
/*         .alert-warning {*/
/*             border-left: 4px solid var(--warning);*/
/*             background: linear-gradient(145deg, hsl(38, 92%, 97%), hsl(38, 92%, 99%));*/
/*         }*/
/* */
/*         .alert-danger {*/
/*             border-left: 4px solid var(--danger);*/
/*             background: linear-gradient(145deg, hsl(0, 84%, 97%), hsl(0, 84%, 99%));*/
/*         }*/
/* */
/*         .alert-content {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 1rem;*/
/*             flex: 1;*/
/*         }*/
/* */
/*         .alert-icon {*/
/*             width: 1.5rem;*/
/*             height: 1.5rem;*/
/*             flex-shrink: 0;*/
/*         }*/
/* */
/*         .alert-primary .alert-icon {*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .alert-success .alert-icon {*/
/*             color: var(--success);*/
/*         }*/
/* */
/*         .alert-warning .alert-icon {*/
/*             color: var(--warning);*/
/*         }*/
/* */
/*         .alert-danger .alert-icon {*/
/*             color: var(--danger);*/
/*         }*/
/* */
/*         .alert-message {*/
/*             font-size: 0.875rem;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .alert-primary .alert-message {*/
/*             color: var(--primary);*/
/*         }*/
/* */
/*         .alert-success .alert-message {*/
/*             color: var(--success);*/
/*         }*/
/* */
/*         .alert-warning .alert-message {*/
/*             color: var(--warning);*/
/*         }*/
/* */
/*         .alert-danger .alert-message {*/
/*             color: var(--danger);*/
/*         }*/
/* */
/*         .alert-close {*/
/*             background: transparent;*/
/*             border: none;*/
/*             cursor: pointer;*/
/*             padding: 0.5rem;*/
/*             color: var(--foreground);*/
/*             opacity: 0.6;*/
/*             transition: opacity 0.3s ease;*/
/*         }*/
/* */
/*         .alert-close:hover {*/
/*             opacity: 1;*/
/*         }*/
/* */
/*         .alert:nth-child(1) { animation-delay: 0.1s; }*/
/*         .alert:nth-child(2) { animation-delay: 0.2s; }*/
/*         .alert:nth-child(3) { animation-delay: 0.3s; }*/
/*         .alert:nth-child(4) { animation-delay: 0.4s; }*/
/* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(20px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/* */
/*         @media (max-width: 768px) {*/
/*             .alerts-container {*/
/*                 padding: 1rem;*/
/*             }*/
/* */
/*             .alert {*/
/*                 padding: 0.75rem 1rem;*/
/*             }*/
/* */
/*             .alert-message {*/
/*                 font-size: 0.8125rem;*/
/*             }*/
/*         }*/
/* */
/*         .table-container {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 1.5rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             margin-bottom: 2rem;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             width: 100%;*/
/*             max-width: 100vw;*/
/*             margin-left: 0;*/
/*             margin-right: 0;*/
/*         }*/
/* */
/*         .table-actions {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             margin-bottom: 1.5rem;*/
/*             padding: 0 1rem;*/
/*         }*/
/* */
/*         .table-search {*/
/*             position: relative;*/
/*             max-width: 300px;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .table-search-input {*/
/*             padding: 0.75rem 2.5rem 0.75rem 1rem;*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             color: var(--foreground);*/
/*             font-size: 0.875rem;*/
/*             width: 100%;*/
/*             box-shadow: var(--neumorphic-shadow);*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .table-search-input:focus {*/
/*             outline: none;*/
/*             border-color: var(--primary);*/
/*             box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);*/
/*         }*/
/* */
/*         .table-search-icon {*/
/*             position: absolute;*/
/*             right: 1rem;*/
/*             top: 50%;*/
/*             transform: translateY(-50%);*/
/*             color: var(--muted-foreground);*/
/*         }*/
/* */
/*         * Form Styles *//* */
/*         .product-form-container {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 2rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             margin-bottom: 2rem;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             width: 100%;*/
/*             max-width: 100%;*/
/*         }*/
/* */
/*         .form-group {*/
/*             display: flex;*/
/*             flex-direction: column;*/
/*             gap: 0.5rem;*/
/*         }*/
/* */
/*         .form-label {*/
/*             font-size: 0.875rem;*/
/*             font-weight: 500;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .form-input,*/
/*         .form-select,*/
/*         .form-textarea {*/
/*             padding: 0.75rem;*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             color: var(--foreground);*/
/*             font-size: 0.875rem;*/
/*             box-shadow: var(--neumorphic-shadow);*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .form-input:focus,*/
/*         .form-select:focus,*/
/*         .form-textarea:focus {*/
/*             outline: none;*/
/*             border-color: var(--primary);*/
/*             box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);*/
/*             transform: translateY(-2px);*/
/*         }*/
/* */
/*         .form-input:hover,*/
/*         .form-select:hover,*/
/*         .form-textarea:hover {*/
/*             box-shadow: var(--neumorphic-shadow-hover);*/
/*             transform: translateY(-1px);*/
/*         }*/
/* */
/*         .form-textarea {*/
/*             resize: vertical;*/
/*             min-height: 100px;*/
/*         }*/
/* */
/*         .form-actions {*/
/*             display: flex;*/
/*             gap: 1rem;*/
/*             justify-content: flex-end;*/
/*         }*/
/* */
/*         .btn {*/
/*             padding: 0.75rem 1.5rem;*/
/*             border-radius: 0.375rem;*/
/*             font-size: 0.875rem;*/
/*             font-weight: 500;*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*             border: none;*/
/*         }*/
/* */
/*         .btn-primary {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*         }*/
/* */
/*         .btn-primary:hover {*/
/*             background: var(--primary-dark);*/
/*         }*/
/* */
/*         .table-responsive {*/
/*             overflow-x: auto;*/
/*             width: 100%;*/
/*         }*/
/* */
/*         .product-table {*/
/*             width: 100%;*/
/*             border-collapse: separate;*/
/*             border-spacing: 0;*/
/*             background: var(--card);*/
/*             border-radius: 0.5rem;*/
/*             overflow: hidden;*/
/*             box-shadow: var(--shadow-card);*/
/*         }*/
/* */
/*         .product-table th,*/
/*         .product-table td {*/
/*             padding: 1rem;*/
/*             text-align: left;*/
/*             border-bottom: 1px solid var(--border);*/
/*         }*/
/* */
/*         .product-table th {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             font-weight: 500;*/
/*             font-size: 0.875rem;*/
/*         }*/
/* */
/*         .product-table tr:last-child td {*/
/*             border-bottom: none;*/
/*         }*/
/* */
/*         .product-table tr:hover {*/
/*             background: var(--accent);*/
/*         }*/
/* */
/*         .action-buttons {*/
/*             display: flex;*/
/*             gap: 0.5rem;*/
/*         }*/
/* */
/*         .action-btn {*/
/*             padding: 0.5rem;*/
/*             border-radius: 0.375rem;*/
/*             background: var(--muted);*/
/*             border: 1px solid var(--border);*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .action-btn:hover {*/
/*             background: var(--primary);*/
/*             color: var(--primary-foreground);*/
/*         }*/
/* */
/*         @keyframes slideInUp {*/
/*             from {*/
/*                 opacity: 0;*/
/*                 transform: translateY(30px);*/
/*             }*/
/*             to {*/
/*                 opacity: 1;*/
/*                 transform: translateY(0);*/
/*             }*/
/*         }*/
/* */
/*         @media (max-width: 768px) {*/
/*             .nav-menu {*/
/*                 display: none;*/
/*             }*/
/* */
/*             .mobile-menu-btn {*/
/*                 display: block;*/
/*             }*/
/* */
/*             .dashboard {*/
/*                 padding: 1rem 0;*/
/*             }*/
/* */
/*             .dashboard-title {*/
/*                 font-size: 1.5rem;*/
/*             }*/
/* */
/*             .table-container {*/
/*                 padding: 1rem;*/
/*             }*/
/* */
/*             .product-table th,*/
/*             .product-table td {*/
/*                 font-size: 0.75rem;*/
/*                 padding: 0.75rem;*/
/*             }*/
/* */
/*             .action-buttons {*/
/*                 flex-direction: column;*/
/*             }*/
/*         }*/
/* */
/*         .switch {*/
/*           position: relative;*/
/*           display: inline-block;*/
/*           width: 60px;*/
/*           height: 34px;*/
/*         }*/
/* */
/*         .switch input { */
/*           opacity: 0;*/
/*           width: 0;*/
/*           height: 0;*/
/*         }*/
/* */
/*         .slider {*/
/*           position: absolute;*/
/*           cursor: pointer;*/
/*           top: 0;*/
/*           left: 0;*/
/*           right: 0;*/
/*           bottom: 0;*/
/*           background-color: #ccc;*/
/*           -webkit-transition: .4s;*/
/*           transition: .4s;*/
/*         }*/
/* */
/*         .slider:before {*/
/*           position: absolute;*/
/*           content: "";*/
/*           height: 26px;*/
/*           width: 26px;*/
/*           left: 4px;*/
/*           bottom: 4px;*/
/*           background-color: white;*/
/*           -webkit-transition: .4s;*/
/*           transition: .4s;*/
/*         }*/
/* */
/*         input:checked + .slider {*/
/*           background-color: #2196F3;*/
/*         }*/
/* */
/*         input:focus + .slider {*/
/*           box-shadow: 0 0 1px #2196F3;*/
/*         }*/
/* */
/*         input:checked + .slider:before {*/
/*           -webkit-transform: translateX(26px);*/
/*           -ms-transform: translateX(26px);*/
/*           transform: translateX(26px);*/
/*         }*/
/* */
/*         /* Rounded sliders *//* */
/*         .slider.round {*/
/*           border-radius: 34px;*/
/*         }*/
/* */
/*         .slider.round:before {*/
/*           border-radius: 50%;*/
/*         }*/
/* */
/*         .pull-right {*/
/*           float: right !important;*/
/*         }*/
/*         .clearfix::after {*/
/*           content: "";*/
/*           display: table;*/
/*           clear: both;*/
/*         }*/
/* */
/*         .form-group {*/
/*             display: flex;*/
/*             flex-direction: column;*/
/*             gap: 0.5rem;*/
/*         }*/
/* */
/*         .form-label {*/
/*             font-size: 0.875rem;*/
/*             font-weight: 500;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .form-textarea {*/
/*             padding: 0.75rem;*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             color: var(--foreground);*/
/*             font-size: 0.875rem;*/
/*             box-shadow: var(--neumorphic-shadow);*/
/*             transition: all 0.3s ease;*/
/*             resize: vertical;*/
/*             min-height: 100px;*/
/*         }*/
/* */
/*         .form-textarea:focus {*/
/*             outline: none;*/
/*             border-color: var(--primary);*/
/*             box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);*/
/*             transform: translateY(-2px);*/
/*         }*/
/* */
/*         .form-textarea:hover {*/
/*             box-shadow: var(--neumorphic-shadow-hover);*/
/*             transform: translateY(-1px);*/
/*         }*/
/* */
/*         .important{*/
/* */
/*             border: 2px solid red;*/
/*         }*/
/* */
/*           .thumbnail {*/
/*           position: relative;*/
/*           display: inline-block;*/
/*           border: 1px solid #ccc;*/
/*           padding: 5px;*/
/*           margin: 10px;*/
/*           border-radius: 5px;*/
/*         }*/
/* */
/*         .thumbnail_details {*/
/*           position: relative;*/
/*           display: inline-block;*/
/*           border: 1px solid #ccc;*/
/*           padding: 5px;*/
/*           margin: 10px;*/
/*           border-radius: 5px;*/
/*         }*/
/* */
/*         .thumbnail img {*/
/*           width: 200px;*/
/*           height: 200px;*/
/*           object-fit: cover;*/
/*           display: block;*/
/*           border-radius: 5px;*/
/*         }*/
/*         .thumbnail_details img {*/
/*           width: 400px;*/
/*           height: 400px;*/
/*           object-fit: cover;*/
/*           display: block;*/
/*           border-radius: 5px;*/
/*         }*/
/* */
/*         .delete-icon {*/
/*           position: absolute;*/
/*           top: 5px;*/
/*           right: 5px;*/
/*           width: 20px;*/
/*           height: 20px;*/
/*           line-height: 20px;*/
/*           text-align: center;*/
/*           font-size: 16px;*/
/*           background-color: red;*/
/*           color: white;*/
/*           border-radius: 50%;*/
/*           cursor: pointer;*/
/*           */
/*         }*/
/* */
/*         .delete-icon:hover {*/
/*           opacity: 1;*/
/*         }*/
/* */
/*         /* ✅ Grille responsive *//* */
/*           .gallery{*/
/*             display:grid;*/
/*             gap: var(--gap);*/
/*             grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));*/
/*           }*/
/* */
/*           /* ✅ Carte image *//* */
/*           .card{*/
/*             position:relative;*/
/*             border-radius: var(--radius);*/
/*             overflow:hidden;*/
/*             background:#fff;*/
/*             box-shadow: var(--shadow);*/
/*           }*/
/* */
/*           /* ✅ Thumbnail carré (s’adapte à toutes tailles d’images) *//* */
/*           .card img{*/
/*             display:block;*/
/*             width:100%;*/
/*             aspect-ratio: 1 / 1;      /* garde un carré *//* */
/*             object-fit: cover;         /* recadre sans déformer *//* */
/*             transition: transform .25s ease;*/
/*           }*/
/*           .card:hover img{ transform: scale(1.03); }*/
/* */
/*           /* ✅ Bouton croix rouge (suppression) *//* */
/*           .remove-btn{*/
/*             position:absolute;*/
/*             top:8px; right:8px;*/
/*             width:32px; height:32px;*/
/*             border:none; border-radius:999px;*/
/*             background: var(--danger);*/
/*             color:#fff; font-size:18px; line-height:0;*/
/*             display:grid; place-items:center;*/
/*             cursor:pointer;*/
/*             box-shadow: 0 4px 10px rgba(0,0,0,.18);*/
/*             transition: background .2s ease, transform .1s ease;*/
/*           }*/
/*           .remove-btn:hover{ background: var(--danger-hover); }*/
/*           .remove-btn:active{ transform: scale(.96); }*/
/*           .remove-btn:focus-visible{ outline: 3px solid rgba(255,59,48,.35); }*/
/* */
/*           /* Optionnel: info bulle simple *//* */
/*           .remove-btn[title] { position: relative; }*/
/* */
/*           .tab-container {*/
/*                 display: flex;*/
/*                 gap: 0.5rem;*/
/*                 margin-bottom: 1.5rem;*/
/*                 overflow-x: auto;*/
/*                 padding: 0 1rem;*/
/*             }*/
/* */
/*             .tab {*/
/*                 padding: 0.75rem 1.5rem;*/
/*                 border-radius: 0.5rem;*/
/*                 background: var(--card);*/
/*                 color: var(--foreground);*/
/*                 font-size: 0.875rem;*/
/*                 font-weight: 500;*/
/*                 cursor: pointer;*/
/*                 transition: all 0.3s ease;*/
/*                 border: 1px solid var(--border);*/
/*                 box-shadow: var(--neumorphic-shadow);*/
/*                 white-space: nowrap;*/
/*             }*/
/* */
/*             .tab:hover {*/
/*                 background: var(--accent);*/
/*             }*/
/* */
/*             .tab.active {*/
/*                 background: var(--gradient-primary);*/
/*                 color: var(--primary-foreground);*/
/*                 box-shadow: var(--neumorphic-shadow-hover);*/
/*             }*/
/* */
/*             @media (max-width: 768px) {*/
/*                 .tab-container {*/
/*                     padding: 0 0.5rem;*/
/*                 }*/
/* */
/*                 .tab {*/
/*                     padding: 0.5rem 1rem;*/
/*                     font-size: 0.75rem;*/
/*                 }*/
/*             }*/
/* */
/*             .form-input,*/
/*             .form-select,*/
/*             .form-textarea {*/
/*                 padding: 0.75rem;*/
/*                 border: 1px solid hsl(217, 25%, 88%);*/
/*                 border-radius: 0.5rem;*/
/*                 background: hsl(0, 0%, 100%);*/
/*                 color: hsl(224, 30%, 15%);*/
/*                 font-size: 0.875rem;*/
/*                 box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Ombre externe *//* */
/*                 transition: all 0.3s ease;*/
/*             }*/
/* */
/*             .form-input:hover,*/
/*             .form-select:hover,*/
/*             .form-textarea:hover {*/
/*                 box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15); /* Ombre externe renforcée au survol *//* */
/*                 transform: translateY(-2px); /* Animation de soulèvement *//* */
/*             }*/
/* */
/*             .form-input:focus,*/
/*             .form-select:focus,*/
/*             .form-textarea:focus {*/
/*                 outline: none;*/
/*                 border-color: hsl(221, 83%, 53%);*/
/*                 box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15), 0 0 0 3px rgba(59, 130, 246, 0.3); /* Ombre externe + halo *//* */
/*                 transform: translateY(-2px); /* Même animation que hover *//* */
/*             }*/
/* */
/*             .form-row-inline {*/
/*             display: flex;*/
/*             flex-wrap: wrap;*/
/*             gap: 1rem; /* Espace entre les champs *//* */
/*             align-items: end; /* Aligne les bas des champs pour uniformité *//* */
/*             margin-bottom: 1rem;*/
/*         }*/
/* */
/*         .form-field-inline {*/
/*             flex: 1;*/
/*             min-width: 200px; /* Largeur minimale pour éviter le chevauchement sur petits écrans *//* */
/*             display: flex;*/
/*             flex-direction: column;*/
/*         }*/
/* */
/*         .form-field-inline label {*/
/*             margin-bottom: 0.25rem;*/
/*             font-size: 0.875rem;*/
/*             font-weight: 500;*/
/*             color: var(--foreground);*/
/*         }*/
/* */
/*         .form-field-inline .form-select,*/
/*         .form-field-inline .form-input {*/
/*             width: 100%;*/
/*             padding: 0.75rem;*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.5rem;*/
/*             background: var(--card);*/
/*             color: var(--foreground);*/
/*             font-size: 0.875rem;*/
/*             box-shadow: var(--neumorphic-shadow);*/
/*             transition: all 0.3s ease;*/
/*         }*/
/* */
/*         .form-field-inline .form-select:focus,*/
/*         .form-field-inline .form-input:focus {*/
/*             outline: none;*/
/*             border-color: var(--primary);*/
/*             box-shadow: var(--neumorphic-shadow-hover), 0 0 0 3px hsl(221, 83%, 53%, 0.3);*/
/*             transform: translateY(-2px);*/
/*         }*/
/* */
/*         /* Responsive: Sur mobile, passer en colonne *//* */
/*         @media (max-width: 768px) {*/
/*             .form-row-inline {*/
/*                 flex-direction: column;*/
/*                 gap: 0.5rem;*/
/*             }*/
/*             */
/*             .form-field-inline {*/
/*                 min-width: 100%;*/
/*             }*/
/*         }*/
/* */
/*         /* Améliorations pour les images et tableau des prix *//* */
/*         .images-section,*/
/*         .suppliers-section {*/
/*             background: var(--gradient-card);*/
/*             border: 1px solid var(--border);*/
/*             border-radius: 0.75rem;*/
/*             padding: 2rem;*/
/*             box-shadow: var(--shadow-card);*/
/*             margin-bottom: 2rem;*/
/*             animation: slideInUp 0.6s ease forwards;*/
/*             width: 100%;*/
/*             max-width: 100%;*/
/*         }*/
/* */
/*         .section-title {*/
/*             font-size: 1.5rem;*/
/*             font-weight: bold;*/
/*             margin-bottom: 1.5rem;*/
/*             color: var(--foreground);*/
/*             text-align: center;*/
/*         }*/
/* */
/*         /* Grille d'images responsive (améliorée pour mobile) *//* */
/*         .gallery {*/
/*             display: grid;*/
/*             gap: var(--gap);*/
/*             grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));*/
/*             margin-top: 1rem;*/
/*         }*/
/* */
/*         @media (max-width: 768px) {*/
/*             .gallery {*/
/*                 grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));*/
/*                 gap: 0.5rem;*/
/*             }*/
/*         }*/
/* */
/*         /* Tableau des prix par fournisseur *//* */
/*         .suppliers-table {*/
/*             width: 100%;*/
/*             border-collapse: separate;*/
/*             border-spacing: 0;*/
/*             background: var(--card);*/
/*             border-radius: 0.5rem;*/
/*             overflow: hidden;*/
/*             box-shadow: var(--shadow-card);*/
/*             margin-top: 1rem;*/
/*         }*/
/* */
/*         .suppliers-table th,*/
/*         .suppliers-table td {*/
/*             padding: 1rem;*/
/*             text-align: left;*/
/*             border-bottom: 1px solid var(--border);*/
/*         }*/
/* */
/*         .suppliers-table th {*/
/*             background: var(--gradient-primary);*/
/*             color: var(--primary-foreground);*/
/*             font-weight: 500;*/
/*             font-size: 0.875rem;*/
/*         }*/
/* */
/*         .suppliers-table tr:hover {*/
/*             background: var(--accent);*/
/*         }*/
/* */
/*         @media (max-width: 768px) {*/
/*             .suppliers-table th,*/
/*             .suppliers-table td {*/
/*                 font-size: 0.75rem;*/
/*                 padding: 0.75rem;*/
/*             }*/
/*         }*/
/*         .img_produit {*/
/*           width: 100px;*/
/*           height: 100px;*/
/*           object-fit: cover; /* Remplit la zone sans déformation *//* */
/*           object-position: center; /* Centre l’image *//* */
/*           border-radius: 6px; /* (facultatif) coins arrondis *//* */
/*         }*/
/*     </style>*/
/*     <style>*/
/*     th {*/
/*         cursor: pointer;*/
/*         user-select: none;*/
/*         padding-right: 20px;*/
/*         position: relative;*/
/*     }*/
/*     th .arrow {*/
/*         position: absolute;*/
/*         right: 5px;*/
/*         font-size: 12px;*/
/*     }*/
/* </style>*/
/*     <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" />*/
/* </head>*/
/* <body>*/
/*     <!-- Navigation -->*/
/*     <nav class="navbar">*/
/*         <div class="navbar-container">*/
/*             <div class="logo"><a href="{{ base_url }}admin/dashboard"><img src="{{ base_url }}uploads/logo_etaa_blanc.png" style="height:50px"/></a></div>*/
/*             */
/*             <div class="nav-menu">*/
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}admin/dashboard" class="nav-link">*/
/*                         <i class="icon" data-feather="home"></i>*/
/*                         Dashboard principal*/
/*                     </a>*/
/*                 </div>*/
/* */
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock" class="nav-link">*/
/*                         <i class="icon" data-feather="home"></i>*/
/*                         Tableau de bord Gestion Stock*/
/*                     </a>*/
/*                 </div>*/
/* */
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="bookmark"></i>*/
/*                         Stock*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         {% if role_utilisateur ==-1 or "Stock.liste_categories" in liste_autorisations %}*/
/*                         <a href="{{ base_url }}gestion_stock/categories" class="dropdown-item">Catégories</a>*/
/*                         {% endif %}*/
/*                         {% if role_utilisateur ==-1 or "Stock.list" in liste_autorisations %}*/
/*                         <a href="{{ base_url }}gestion_stock/liste_produits" class="dropdown-item">Produits</a>*/
/*                         <a href="{{ base_url }}gestion_stock/liste_services" class="dropdown-item">Services</a>*/
/*                         {% endif %}*/
/*                         <a href="{{ base_url }}gestion_stock/stock_par_entrepot" class="dropdown-item">Stock par entrepôt</a>*/
/*                         */
/*                         */
/*                     </div>*/
/*                 </div>*/
/*                 {% if role_utilisateur ==-1 or "Stock.liste_entrepots" in liste_autorisations %}*/
/*                 <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="layers"></i>*/
/*                         Entrepôts*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                         */
/*                          <a href="{{ base_url }}gestion_stock/entrepots" class="dropdown-item">Gestion des entreprôts</a>*/
/*                         <a href="{{ base_url }}gestion_stock/ajouter_casier" class="dropdown-item">Gestion des Casiers</a>*/
/*                         */
/*                     </div>*/
/*                 </div>*/
/*                 {% endif %}*/
/* */
/*                 {% if role_utilisateur ==-1 or "Stock.inventaire" in liste_autorisations %}*/
/* */
/*                 <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock/liste_inventaires" class="nav-link">*/
/*                         <i class="icon" data-feather="list"></i>*/
/*                         Inventaires*/
/*                     </a>*/
/*                 </div>*/
/*                 {% endif %}*/
/* */
/*                  <div class="nav-item">*/
/*                     <a href="{{ base_url }}gestion_stock/mouvements" class="nav-link">*/
/*                         <i class="icon" data-feather="book"></i>*/
/*                         Mouvements*/
/*                     </a>*/
/*                 </div>*/
/* */
/*                  {% if role_utilisateur ==-1 or "Stock.liste_fournisseurs" in liste_autorisations %}*/
/*                 */
/*                  <div class="nav-item">*/
/*                     <button class="nav-link">*/
/*                         <i class="icon" data-feather="truck"></i>*/
/*                         Fournisseurs*/
/*                         <i class="icon" data-feather="chevron-down"></i>*/
/*                     </button>*/
/*                     <div class="dropdown">*/
/*                        */
/*                         <a href="{{ base_url }}gestion_stock/fournisseurs" class="dropdown-item">Liste des fournisseurs</a> */
/*                         <a href="{{ base_url }}gestion_stock/liste_produits_fournisseur" class="dropdown-item">Produits par fournisseur</a>*/
/* */
/*                     </div>*/
/*                 </div>*/
/*                 {% endif %}*/
/*                 */
/*                 */
/*             </div>*/
/*             */
/*             <div class="user-menu">*/
/*                 <button class="user-avatar" onclick="toggleUserMenu()" style="color:white;border:1px solid white;">*/
/*                     <i class="icon icon-lg" data-feather="user" style="color:white"></i>*/
/*                 </button>*/
/*                 <div class="dropdown">*/
/*                     <a href="/profil" class="dropdown-item">Profil</a>*/
/*                     <a href="{{ base_url }}home/logout" class="dropdown-item" style="color: #dc2626;">Se déconnecter</a>*/
/*                 </div>*/
/*             </div>*/
/*             */
/*             <button class="mobile-menu-btn" onclick="toggleMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="menu"></i>*/
/*             </button>*/
/*         </div>*/
/*     </nav>*/
/* */
/*     <!-- Mobile Menu Overlay -->*/
/*     <div class="mobile-overlay" id="mobileOverlay" onclick="closeMobileMenu()"></div>*/
/*     <div class="mobile-menu" id="mobileMenu">*/
/*         <div class="mobile-menu-header">*/
/*             <div class="mobile-menu-title">Menu</div>*/
/*             <button class="close-btn" onclick="closeMobileMenu()">*/
/*                 <i class="icon icon-lg" data-feather="x"></i>*/
/*             </button>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}admin/dashboard" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="home"></i>*/
/*                 Tableau de bord principal*/
/*             </a>*/
/*         </div>*/
/*          <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="home"></i>*/
/*                 Tableau de bord stocks*/
/*             </a>*/
/*         </div>*/
/*         {% if role_utilisateur ==-1 or "Stock.list" in liste_autorisations %}*/
/*          <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock/liste_produits" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="bookmark"></i>*/
/*                 Produits*/
/*             </a>*/
/*         </div>*/
/*         <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock/liste_services" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="bookmark"></i>*/
/*                 Services*/
/*             </a>*/
/*         </div>*/
/*         {% endif %}*/
/*         {% if role_utilisateur ==-1 or "Stock.liste_entrepots" in liste_autorisations %}*/
/*         <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock/entrepots" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="layers"></i>*/
/*                 Entrepôts*/
/*             </a>*/
/*         </div>*/
/*         {% endif %}*/
/* */
/*         {% if role_utilisateur ==-1 or "Stock.inventaire" in liste_autorisations %}*/
/*         <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock/liste_inventaires" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="list"></i>*/
/*                 Inventaires*/
/*             </a>*/
/*         </div>*/
/*         {% endif %}*/
/*         <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock/mouvements" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="book"></i>*/
/*                 Mouvements*/
/*             </a>*/
/*         </div>*/
/*         {% if role_utilisateur ==-1 or "Stock.liste_fournisseurs" in liste_autorisations %}*/
/*         <div class="mobile-nav-item">*/
/*             <a href="{{ base_url }}gestion_stock/fournisseurs" class="mobile-nav-link">*/
/*                 <i class="icon" data-feather="truck"></i>*/
/*                 Fournisseurs*/
/*             </a>*/
/*         </div>*/
/*         {% endif %}*/
/*         */
/*     </div>*/
