<?php

/* togo/index.html.twig */
class __TwigTemplate_2e34bcea0cddfed11cab1a9985a595d0335971664d48381b59e48d15eb3ab356 extends Twig_Template
{
    public function __construct(Twig_Environment $env)
    {
        parent::__construct($env);

        $this->parent = false;

        $this->blocks = array(
        );
    }

    protected function doDisplay(array $context, array $blocks = array())
    {
        // line 1
        echo "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>TOGO 5 ÉTOILES - Actualités & Galerie</title>
    <style>
        /* Variables de couleurs basées sur le logo : Vert foncé (#006633), Or (#D4AF37), Rouge (#DC143C), Blanc pour contraste */
        :root {
            --primary-green: #006633;
            --secondary-gold: #D4AF37;
            --accent-red: #DC143C;
            --light-color: #FFFFFF;
            --dark-color: #000000;
            --text-color: #333333;
            --text-light: #FFFFFF;
            --shadow-light: rgba(0, 102, 51, 0.1);
            --shadow-medium: rgba(212, 175, 55, 0.2);
        }
        /* Reset et styles de base modernes */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--light-color);
            color: var(--text-color);
            line-height: 1.7;
            overflow-x: hidden;
        }
        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        /* Header et Navigation moderne avec dégradé subtil */
        header {
            background: linear-gradient(135deg, var(--primary-green) 0%, #004d40 100%);
            color: var(--text-light);
            padding: 1rem 0;
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px var(--shadow-light);
            transition: all 0.3s ease;
        }
        .header-container {
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
        }
        .logo {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            z-index: 2;
        }
        .logo h1 {
            font-size: 2rem;
            font-weight: 700;
            background: linear-gradient(45deg, var(--secondary-gold), #FFD700);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .logo span {
            color: var(--text-light);
            font-weight: 400;
        }
        .nav-left, .nav-right {
            display: flex;
            list-style: none;
        }
        .nav-left ul, .nav-right ul {
            display: flex;
            list-style: none;
            gap: 2rem;
        }
        .nav-left ul li a, .nav-right ul li a {
            color: var(--text-light);
            text-decoration: none;
            font-weight: 500;
            position: relative;
            transition: all 0.3s ease;
            padding: 0.5rem 0;
        }
        .nav-left ul li a::before, .nav-right ul li a::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 2px;
            background: linear-gradient(90deg, var(--secondary-gold), #FFD700);
            transition: width 0.3s ease;
        }
        .nav-left ul li a:hover::before, .nav-right ul li a:hover::before {
            width: 100%;
        }
        .nav-left ul li a:hover, .nav-right ul li a:hover {
            color: var(--secondary-gold);
            transform: translateY(-2px);
        }
        .header-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        .menu-toggle {
            display: none;
            cursor: pointer;
            font-size: 1.5rem;
            color: var(--text-light);
        }
        .mobile-menu {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            width: 100%;
            background: linear-gradient(135deg, var(--primary-green) 0%, #004d40 100%);
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
            z-index: 999;
        }
        .mobile-menu.active {
            max-height: 300px;
            display: block;
        }
        .mobile-menu ul {
            flex-direction: column;
            padding: 1rem 0;
            list-style: none;
        }
        .mobile-menu ul li {
            text-align: center;
            margin: 0;
        }
        .mobile-menu ul li a {
            display: block;
            padding: 1rem;
            color: var(--text-light);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .mobile-menu ul li a:hover {
            color: var(--secondary-gold);
            background: rgba(212, 175, 55, 0.1);
        }
        /* Hero Section avec vidéo YouTube en fond - Mode background cover */
        .hero {
            position: relative;
            height: 100vh;
            display: flex;
            align-items: center;
            text-align: center;
            color: var(--text-light);
            padding-top: 80px;
            overflow: hidden;
        }
        .hero-video {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
        .hero-video iframe {
            position: absolute;
            top: 50%;
            left: 50%;
            width: auto;
            height: auto;
            min-width: 100%;
            min-height: 100%;
            transform: translate(-50%, -50%);
            border: none;
            pointer-events: none; /* Empêche l'interaction avec la vidéo en fond */
        }
        .hero-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(rgba(0, 102, 51, 0.6), rgba(0, 77, 64, 0.6));
            z-index: 0;
        }
        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, rgba(212, 175, 55, 0.1) 0%, transparent 70%);
            animation: shimmer 6s ease-in-out infinite;
            z-index: 1;
        }
        @keyframes shimmer {
            0%, 100% { opacity: 0; }
            50% { opacity: 1; }
        }
        .hero-content {
            max-width: 800px;
            margin: 0 auto;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
            position: relative;
        }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .hero h2 {
            font-size: 4rem;
            margin-bottom: 1.5rem;
            font-weight: 700;
            background: linear-gradient(45deg, var(--text-light), var(--secondary-gold));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .hero p {
            font-size: 1.3rem;
            margin-bottom: 2rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }
        .btn {
            display: inline-block;
            background: linear-gradient(135deg, var(--secondary-gold), #FFD700);
            color: var(--primary-green);
            padding: 1rem 2.5rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            border: 2px solid var(--secondary-gold);
            box-shadow: 0 4px 15px var(--shadow-medium);
        }
        .btn:hover {
            background: transparent;
            color: var(--secondary-gold);
            transform: translateY(-3px);
            box-shadow: 0 6px 20px var(--shadow-medium);
        }
        /* Filtres de galerie modernes avec effet hover */
        .gallery-filters {
            display: flex;
            justify-content: center;
            margin: 4rem 0;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .filter-btn {
            background: transparent;
            border: 2px solid var(--primary-green);
            color: var(--primary-green);
            padding: 0.75rem 1.5rem;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 500;
            font-size: 0.95rem;
        }
        .filter-btn:hover, .filter-btn.active {
            background: var(--primary-green);
            color: var(--text-light);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px var(--shadow-light);
        }
        /* Grille d'articles avec effet carte moderne */
        .articles-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(360px, 1fr));
            gap: 2rem;
            margin-bottom: 5rem;
        }
        .article-card {
            background: var(--light-color);
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 8px 30px var(--shadow-light);
            transition: all 0.4s ease;
            position: relative;
        }
        .article-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, var(--primary-green), #004d40);
            opacity: 0;
            transition: opacity 0.4s ease;
            z-index: -1;
        }
        .article-card:hover {
            transform: translateY(-10px) scale(1.02);
            box-shadow: 0 20px 40px var(--shadow-medium);
        }
        .article-card:hover::before {
            opacity: 0.05;
        }
        .article-media {
            position: relative;
            height: 220px;
            overflow: hidden;
        }
        .article-media img, .article-media video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.6s ease;
        }
        .article-card:hover .article-media img,
        .article-card:hover .article-media video {
            transform: scale(1.1);
        }
        .article-date {
            position: absolute;
            top: 1rem;
            right: 1rem;
            background: var(--secondary-gold);
            color: var(--primary-green);
            padding: 0.5rem 0.75rem;
            border-radius: 15px;
            font-weight: 600;
            font-size: 0.85rem;
            box-shadow: 0 4px 10px rgba(212, 175, 55, 0.3);
        }
        .article-badge {
            position: absolute;
            top: 1rem;
            left: 1rem;
            background: var(--accent-red);
            color: var(--text-light);
            padding: 0.4rem 0.8rem;
            border-radius: 15px;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .article-content {
            padding: 1.5rem;
        }
        .article-content h3 {
            font-size: 1.4rem;
            margin-bottom: 0.75rem;
            color: var(--primary-green);
            font-weight: 600;
        }
        .article-content p {
            color: #666;
            margin-bottom: 1rem;
            font-size: 0.95rem;
        }
        .article-meta {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 1rem;
            padding-top: 1rem;
            border-top: 1px solid #eee;
        }
        .article-category {
            background: linear-gradient(135deg, var(--primary-green), #004d40);
            color: var(--text-light);
            padding: 0.3rem 0.8rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        .article-actions {
            display: flex;
            gap: 0.75rem;
        }
        .action-btn {
            background: none;
            border: none;
            color: #888;
            cursor: pointer;
            font-size: 1.1rem;
            transition: all 0.3s ease;
        }
        .action-btn:hover {
            color: var(--secondary-gold);
            transform: scale(1.2);
        }
        /* Section Newsletter avec dégradé */
        .newsletter {
            background: linear-gradient(135deg, var(--primary-green) 0%, #004d40 100%);
            color: var(--text-light);
            padding: 5rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .newsletter::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(212, 175, 55, 0.1) 0%, transparent 70%);
            animation: rotate 20s linear infinite;
        }
        @keyframes rotate {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        .newsletter > * {
            position: relative;
            z-index: 1;
        }
        .newsletter h2 {
            font-size: 2.5rem;
            margin-bottom: 1rem;
            background: linear-gradient(45deg, var(--text-light), var(--secondary-gold));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .newsletter p {
            max-width: 600px;
            margin: 0 auto 2rem;
            opacity: 0.9;
            font-size: 1.1rem;
        }
        .newsletter-form {
            display: flex;
            max-width: 500px;
            margin: 0 auto;
            border-radius: 50px;
            overflow: hidden;
            box-shadow: 0 8px 30px var(--shadow-light);
        }
        .newsletter-input {
            flex: 1;
            padding: 1rem 1.5rem;
            border: none;
            background: rgba(255, 255, 255, 0.9);
            font-size: 1rem;
        }
        .newsletter-btn {
            background: linear-gradient(135deg, var(--secondary-gold), #FFD700);
            color: var(--primary-green);
            border: none;
            padding: 0 2rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .newsletter-btn:hover {
            background: linear-gradient(135deg, #FFD700, var(--secondary-gold));
            transform: translateX(5px);
        }
        /* Footer élégant */
        footer {
            background: var(--dark-color);
            color: var(--text-light);
            padding: 4rem 0 2rem;
        }
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }
        .footer-column h3 {
            font-size: 1.4rem;
            margin-bottom: 1rem;
            background: linear-gradient(45deg, var(--secondary-gold), #FFD700);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .footer-column p {
            margin-bottom: 1rem;
            opacity: 0.8;
            font-size: 0.95rem;
        }
        .footer-links {
            list-style: none;
        }
        .footer-links li {
            margin-bottom: 0.75rem;
        }
        .footer-links a {
            color: var(--text-light);
            text-decoration: none;
            opacity: 0.8;
            transition: all 0.3s ease;
            display: inline-block;
        }
        .footer-links a:hover {
            opacity: 1;
            color: var(--secondary-gold);
            transform: translateX(5px);
        }
        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
        }
        .social-links a {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 45px;
            height: 45px;
            background: rgba(212, 175, 55, 0.1);
            border-radius: 50%;
            color: var(--text-light);
            text-decoration: none;
            transition: all 0.3s ease;
            border: 1px solid rgba(212, 175, 55, 0.2);
        }
        .social-links a:hover {
            background: var(--secondary-gold);
            color: var(--primary-green);
            transform: translateY(-3px) scale(1.1);
        }
        .copyright {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            opacity: 0.7;
            font-size: 0.9rem;
        }
        /* Titre de section */
        .section-title {
            text-align: center;
            margin-bottom: 3rem;
            font-size: 3rem;
            background: linear-gradient(45deg, var(--primary-green), #004d40);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: 600;
        }
        /* Responsive design amélioré */
        @media (max-width: 992px) {
            .articles-grid {
                grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            }
            .hero h2 { font-size: 3rem; }
            .nav-left ul, .nav-right ul { gap: 1rem; }
        }
        @media (max-width: 768px) {
            .nav-left, .nav-right {
                display: none;
            }
            .logo {
                position: static;
                transform: none;
            }
            .header-container {
                justify-content: center;
            }
            .menu-toggle {
                display: block;
                position: absolute;
                right: 20px;
                z-index: 3;
            }
            .mobile-menu {
                display: block;
            }
            .hero h2 { font-size: 2.5rem; }
            .hero p { font-size: 1.1rem; }
            .newsletter-form { flex-direction: column; }
            .newsletter-input { border-radius: 50px; margin-bottom: 1rem; }
            .newsletter-btn { border-radius: 50px; }
            .gallery-filters { gap: 0.5rem; }
            .filter-btn { padding: 0.6rem 1.2rem; font-size: 0.9rem; }
            .hero { padding-top: 100px; }
            .logo h1 { font-size: 1.5rem; }
        }
        @media (max-width: 576px) {
            .hero { height: 80vh; }
            .hero h2 { font-size: 2.2rem; }
            .articles-grid { grid-template-columns: 1fr; gap: 1.5rem; }
            .section-title { font-size: 2.2rem; }
        }
    </style>
    <link href=\"https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap\" rel=\"stylesheet\">
    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css\">
</head>
<body>
    <!-- Header -->
    <header>
        <div class=\"container\">
            <div class=\"header-container\">
                <nav class=\"nav-left\">
                    <ul>
                        <li><a href=\"#accueil\">Accueil</a></li>
                        <li><a href=\"#galerie\">A propos</a></li>
                    </ul>
                </nav>
                <div class=\"logo\">
                    <h1>TOGO <span>5 ÉTOILES</span></h1>
                </div>
                <div class=\"header-right\">
                    <nav class=\"nav-right\">
                        <ul>
                            <li><a href=\"#articles\">Réalisations</a></li>
                            <li><a href=\"#apropos\">Investir au Togo</a></li>
                            <li><a href=\"#contact\">Contact</a></li>
                        </ul>
                    </nav>
                    <div class=\"menu-toggle\">
                        <i class=\"fas fa-bars\"></i>
                    </div>
                </div>
            </div>
            <div class=\"mobile-menu\">
                <ul>
                    <li><a href=\"#accueil\">Accueil</a></li>
                    <li><a href=\"#galerie\">A propos</a></li>
                    <li><a href=\"#articles\">Réalisations</a></li>
                    <li><a href=\"#apropos\">Investir au Togo</a></li>
                    <li><a href=\"#contact\">Contact</a></li>
                </ul>
            </div>
        </div>
    </header>
    <!-- Hero Section avec vidéo YouTube corrigée en mode background cover -->
    <section class=\"hero\" id=\"accueil\">
        <div class=\"hero-video\" style=\"padding:0\">
            <iframe
                src=\"https://www.youtube.com/embed/X_OjoE8CWuY?autoplay=1&mute=1&loop=1&playlist=X_OjoE8CWuY&controls=0&showinfo=0&rel=0&playsinline=1&disablekb=1\" style=\"padding:0\"
                title=\"Vidéo YouTube\"
                frameborder=\"0\"
                allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\"
                allowfullscreen>
            </iframe>
        </div>
        <div class=\"hero-overlay\"></div>
        <div class=\"container hero-content\">
            <h2>TOGO 5 ÉTOILES</h2>
            <p>Suivez l’avancement des projets du Togo en toute transparence grâce à notre portail officiel.</p>
            <a href=\"#galerie\" class=\"btn\">Explorer la Galerie</a>
        </div>
    </section>
    <!-- Galerie d'articles -->
    <section id=\"galerie\">
        <div class=\"container\">
            <h2 class=\"section-title\">Galerie d'Articles</h2>
          
            <!-- Filtres -->
            <div class=\"gallery-filters\">
                <button class=\"filter-btn active\" data-filter=\"all\">Tous</button>
                <button class=\"filter-btn\" data-filter=\"photo\">Photos</button>
                <button class=\"filter-btn\" data-filter=\"video\">Vidéos</button>
                <button class=\"filter-btn\" data-filter=\"evenement\">Événements</button>
                <button class=\"filter-btn\" data-filter=\"actualite\">Actualités</button>
            </div>
          
            <!-- Grille d'articles -->
            <div class=\"articles-grid\">
                <!-- Article 1 - Photo -->
                <div class=\"article-card\" data-category=\"photo\">
                    <div class=\"article-media\">
                        <img src=\"https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80\" alt=\"Événement TOGO 5 ÉTOILES\">
                        <div class=\"article-date\">15 Oct 2023</div>
                        <div class=\"article-badge\">Photo</div>
                    </div>
                    <div class=\"article-content\">
                        <h3>Cérémonie de remise de prix</h3>
                        <p>Notre équipe a été honorée lors de la cérémonie annuelle des entreprises d'excellence.</p>
                        <div class=\"article-meta\">
                            <span class=\"article-category\">Événement</span>
                            <div class=\"article-actions\">
                                <button class=\"action-btn\"><i class=\"far fa-heart\"></i></button>
                                <button class=\"action-btn\"><i class=\"far fa-share-square\"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
              
                <!-- Article 2 - Vidéo -->
                <div class=\"article-card\" data-category=\"video\">
                    <div class=\"article-media\">
                        <video controls poster=\"https://images.unsplash.com/photo-1531403009284-440f080d1e12?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80\">
                            <source src=\"#\" type=\"video/mp4\">
                            Votre navigateur ne supporte pas la lecture de vidéos.
                        </video>
                        <div class=\"article-date\">12 Oct 2023</div>
                        <div class=\"article-badge\">Vidéo</div>
                    </div>
                    <div class=\"article-content\">
                        <h3>Interview exclusive</h3>
                        <p>Notre directeur général partage sa vision pour l'avenir de l'entreprise dans cette interview.</p>
                        <div class=\"article-meta\">
                            <span class=\"article-category\">Actualité</span>
                            <div class=\"article-actions\">
                                <button class=\"action-btn\"><i class=\"far fa-heart\"></i></button>
                                <button class=\"action-btn\"><i class=\"far fa-share-square\"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
              
                <!-- Article 3 - Photo -->
                <div class=\"article-card\" data-category=\"photo evenement\">
                    <div class=\"article-media\">
                        <img src=\"https://images.unsplash.com/photo-1542744173-8e7e53415bb0?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80\" alt=\"Réunion d'équipe\">
                        <div class=\"article-date\">10 Oct 2023</div>
                        <div class=\"article-badge\">Photo</div>
                    </div>
                    <div class=\"article-content\">
                        <h3>Semaine de formation interne</h3>
                        <p>Notre équipe a participé à une semaine intensive de formation pour perfectionner ses compétences.</p>
                        <div class=\"article-meta\">
                            <span class=\"article-category\">Formation</span>
                            <div class=\"article-actions\">
                                <button class=\"action-btn\"><i class=\"far fa-heart\"></i></button>
                                <button class=\"action-btn\"><i class=\"far fa-share-square\"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
              
                <!-- Article 4 - Vidéo -->
                <div class=\"article-card\" data-category=\"video actualite\">
                    <div class=\"article-media\">
                        <video controls poster=\"https://images.unsplash.com/photo-1551836026-d5c55ac5d4c9?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80\">
                            <source src=\"#\" type=\"video/mp4\">
                            Votre navigateur ne supporte pas la lecture de vidéos.
                        </video>
                        <div class=\"article-date\">08 Oct 2023</div>
                        <div class=\"article-badge\">Vidéo</div>
                    </div>
                    <div class=\"article-content\">
                        <h3>Lancement de nouveau service</h3>
                        <p>Découvrez en vidéo notre nouveau service premium lancé ce mois-ci.</p>
                        <div class=\"article-meta\">
                            <span class=\"article-category\">Innovation</span>
                            <div class=\"article-actions\">
                                <button class=\"action-btn\"><i class=\"far fa-heart\"></i></button>
                                <button class=\"action-btn\"><i class=\"far fa-share-square\"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
              
                <!-- Article 5 - Photo -->
                <div class=\"article-card\" data-category=\"photo evenement\">
                    <div class=\"article-media\">
                        <img src=\"https://images.unsplash.com/photo-1560472354-b33ff0c44a43?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80\" alt=\"Événement caritatif\">
                        <div class=\"article-date\">05 Oct 2023</div>
                        <div class=\"article-badge\">Photo</div>
                    </div>
                    <div class=\"article-content\">
                        <h3>Participation à l'événement caritatif</h3>
                        <p>Notre entreprise a participé activement à l'événement caritatif annuel de la ville.</p>
                        <div class=\"article-meta\">
                            <span class=\"article-category\">Caritatif</span>
                            <div class=\"article-actions\">
                                <button class=\"action-btn\"><i class=\"far fa-heart\"></i></button>
                                <button class=\"action-btn\"><i class=\"far fa-share-square\"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
              
                <!-- Article 6 - Vidéo -->
                <div class=\"article-card\" data-category=\"video\">
                    <div class=\"article-media\">
                        <video controls poster=\"https://images.unsplash.com/photo-1559136555-9303baea8ebd?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80\">
                            <source src=\"#\" type=\"video/mp4\">
                            Votre navigateur ne supporte pas la lecture de vidéos.
                        </video>
                        <div class=\"article-date\">01 Oct 2023</div>
                        <div class=\"article-badge\">Vidéo</div>
                    </div>
                    <div class=\"article-content\">
                        <h3>Visite de nos installations</h3>
                        <p>Découvrez en vidéo l'intérieur de nos locaux et nos équipements de pointe.</p>
                        <div class=\"article-meta\">
                            <span class=\"article-category\">Visite</span>
                            <div class=\"article-actions\">
                                <button class=\"action-btn\"><i class=\"far fa-heart\"></i></button>
                                <button class=\"action-btn\"><i class=\"far fa-share-square\"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Newsletter -->
    <section class=\"newsletter\">
        <div class=\"container\">
            <h2>Restez Informé</h2>
            <p>Abonnez-vous à notre newsletter pour ne manquer aucun de nos articles et actualités.</p>
            <form class=\"newsletter-form\">
                <input type=\"email\" class=\"newsletter-input\" placeholder=\"Votre adresse email\" required>
                <button type=\"submit\" class=\"newsletter-btn\">S'abonner</button>
            </form>
        </div>
    </section>
    <!-- Footer -->
    <footer>
        <div class=\"container\">
            <div class=\"footer-content\">
                <div class=\"footer-column\">
                    <h3>TOGO 5 ÉTOILES</h3>
                    <p>Votre partenaire de confiance pour des services haut de gamme et sur mesure. Excellence, prestige et satisfaction client sont au cœur de notre philosophie.</p>
                    <div class=\"social-links\">
                        <a href=\"#\"><i class=\"fab fa-facebook-f\"></i></a>
                        <a href=\"#\"><i class=\"fab fa-twitter\"></i></a>
                        <a href=\"#\"><i class=\"fab fa-instagram\"></i></a>
                        <a href=\"#\"><i class=\"fab fa-linkedin-in\"></i></a>
                    </div>
                </div>
                <div class=\"footer-column\">
                    <h3>Liens Rapides</h3>
                    <ul class=\"footer-links\">
                        <li><a href=\"#accueil\">Accueil</a></li>
                        <li><a href=\"#galerie\">Galerie</a></li>
                        <li><a href=\"#articles\">Articles</a></li>
                        <li><a href=\"#apropos\">À propos</a></li>
                        <li><a href=\"#contact\">Contact</a></li>
                    </ul>
                </div>
                <div class=\"footer-column\">
                    <h3>Catégories</h3>
                    <ul class=\"footer-links\">
                        <li><a href=\"#\">Photos</a></li>
                        <li><a href=\"#\">Vidéos</a></li>
                        <li><a href=\"#\">Événements</a></li>
                        <li><a href=\"#\">Actualités</a></li>
                        <li><a href=\"#\">Interviews</a></li>
                    </ul>
                </div>
                <div class=\"footer-column\">
                    <h3>Contact</h3>
                    <p>123 Avenue du Prestige<br>Lomé, Togo</p>
                    <p>Email: contact@togo5etoiles.com</p>
                    <p>Tél: +228 12 34 56 78</p>
                </div>
            </div>
            <div class=\"copyright\">
                <p>&copy; 2023 TOGO 5 ÉTOILES. Tous droits réservés.</p>
            </div>
        </div>
    </footer>
    <script>
        // Menu mobile toggle
        document.querySelector('.menu-toggle').addEventListener('click', function() {
            document.querySelector('.mobile-menu').classList.toggle('active');
        });
        // Filtrage des articles avec animation
        const filterButtons = document.querySelectorAll('.filter-btn');
        const articleCards = document.querySelectorAll('.article-card');
        filterButtons.forEach(button => {
            button.addEventListener('click', () => {
                filterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
              
                const filterValue = button.getAttribute('data-filter');
              
                articleCards.forEach((card, index) => {
                    if (filterValue === 'all') {
                        setTimeout(() => { card.style.display = 'block'; card.style.opacity = '1'; }, index * 100);
                    } else {
                        const categories = card.getAttribute('data-category').split(' ');
                        if (categories.includes(filterValue)) {
                            setTimeout(() => { card.style.display = 'block'; card.style.opacity = '1'; }, index * 100);
                        } else {
                            card.style.opacity = '0';
                            setTimeout(() => { card.style.display = 'none'; }, 300);
                        }
                    }
                });
            });
        });
        // Initial opacity pour filtrage
        articleCards.forEach(card => { card.style.opacity = '1'; card.style.transition = 'opacity 0.3s ease'; });
        // Smooth scrolling
        document.querySelectorAll('a[href^=\"#\"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
              
                const targetId = this.getAttribute('href');
                if(targetId === '#') return;
              
                const targetElement = document.querySelector(targetId);
                if(targetElement) {
                    window.scrollTo({
                        top: targetElement.offsetTop - 80,
                        behavior: 'smooth'
                    });
                  
                    document.querySelector('.mobile-menu').classList.remove('active');
                }
            });
        });
    </script>
</body>
</html>";
    }

    public function getTemplateName()
    {
        return "togo/index.html.twig";
    }

    public function getDebugInfo()
    {
        return array (  19 => 1,);
    }
}
/* <!DOCTYPE html>*/
/* <html lang="fr">*/
/* <head>*/
/*     <meta charset="UTF-8">*/
/*     <meta name="viewport" content="width=device-width, initial-scale=1.0">*/
/*     <title>TOGO 5 ÉTOILES - Actualités & Galerie</title>*/
/*     <style>*/
/*         /* Variables de couleurs basées sur le logo : Vert foncé (#006633), Or (#D4AF37), Rouge (#DC143C), Blanc pour contraste *//* */
/*         :root {*/
/*             --primary-green: #006633;*/
/*             --secondary-gold: #D4AF37;*/
/*             --accent-red: #DC143C;*/
/*             --light-color: #FFFFFF;*/
/*             --dark-color: #000000;*/
/*             --text-color: #333333;*/
/*             --text-light: #FFFFFF;*/
/*             --shadow-light: rgba(0, 102, 51, 0.1);*/
/*             --shadow-medium: rgba(212, 175, 55, 0.2);*/
/*         }*/
/*         /* Reset et styles de base modernes *//* */
/*         * {*/
/*             margin: 0;*/
/*             padding: 0;*/
/*             box-sizing: border-box;*/
/*         }*/
/*         body {*/
/*             font-family: 'Poppins', sans-serif;*/
/*             background-color: var(--light-color);*/
/*             color: var(--text-color);*/
/*             line-height: 1.7;*/
/*             overflow-x: hidden;*/
/*         }*/
/*         .container {*/
/*             width: 90%;*/
/*             max-width: 1200px;*/
/*             margin: 0 auto;*/
/*             padding: 0 20px;*/
/*         }*/
/*         /* Header et Navigation moderne avec dégradé subtil *//* */
/*         header {*/
/*             background: linear-gradient(135deg, var(--primary-green) 0%, #004d40 100%);*/
/*             color: var(--text-light);*/
/*             padding: 1rem 0;*/
/*             position: fixed;*/
/*             width: 100%;*/
/*             top: 0;*/
/*             z-index: 1000;*/
/*             box-shadow: 0 4px 20px var(--shadow-light);*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .header-container {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             justify-content: space-between;*/
/*             position: relative;*/
/*         }*/
/*         .logo {*/
/*             position: absolute;*/
/*             left: 50%;*/
/*             transform: translateX(-50%);*/
/*             z-index: 2;*/
/*         }*/
/*         .logo h1 {*/
/*             font-size: 2rem;*/
/*             font-weight: 700;*/
/*             background: linear-gradient(45deg, var(--secondary-gold), #FFD700);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/*         .logo span {*/
/*             color: var(--text-light);*/
/*             font-weight: 400;*/
/*         }*/
/*         .nav-left, .nav-right {*/
/*             display: flex;*/
/*             list-style: none;*/
/*         }*/
/*         .nav-left ul, .nav-right ul {*/
/*             display: flex;*/
/*             list-style: none;*/
/*             gap: 2rem;*/
/*         }*/
/*         .nav-left ul li a, .nav-right ul li a {*/
/*             color: var(--text-light);*/
/*             text-decoration: none;*/
/*             font-weight: 500;*/
/*             position: relative;*/
/*             transition: all 0.3s ease;*/
/*             padding: 0.5rem 0;*/
/*         }*/
/*         .nav-left ul li a::before, .nav-right ul li a::before {*/
/*             content: '';*/
/*             position: absolute;*/
/*             bottom: 0;*/
/*             left: 0;*/
/*             width: 0;*/
/*             height: 2px;*/
/*             background: linear-gradient(90deg, var(--secondary-gold), #FFD700);*/
/*             transition: width 0.3s ease;*/
/*         }*/
/*         .nav-left ul li a:hover::before, .nav-right ul li a:hover::before {*/
/*             width: 100%;*/
/*         }*/
/*         .nav-left ul li a:hover, .nav-right ul li a:hover {*/
/*             color: var(--secondary-gold);*/
/*             transform: translateY(-2px);*/
/*         }*/
/*         .header-right {*/
/*             display: flex;*/
/*             align-items: center;*/
/*             gap: 1rem;*/
/*         }*/
/*         .menu-toggle {*/
/*             display: none;*/
/*             cursor: pointer;*/
/*             font-size: 1.5rem;*/
/*             color: var(--text-light);*/
/*         }*/
/*         .mobile-menu {*/
/*             display: none;*/
/*             position: absolute;*/
/*             top: 100%;*/
/*             left: 0;*/
/*             width: 100%;*/
/*             background: linear-gradient(135deg, var(--primary-green) 0%, #004d40 100%);*/
/*             max-height: 0;*/
/*             overflow: hidden;*/
/*             transition: max-height 0.3s ease;*/
/*             z-index: 999;*/
/*         }*/
/*         .mobile-menu.active {*/
/*             max-height: 300px;*/
/*             display: block;*/
/*         }*/
/*         .mobile-menu ul {*/
/*             flex-direction: column;*/
/*             padding: 1rem 0;*/
/*             list-style: none;*/
/*         }*/
/*         .mobile-menu ul li {*/
/*             text-align: center;*/
/*             margin: 0;*/
/*         }*/
/*         .mobile-menu ul li a {*/
/*             display: block;*/
/*             padding: 1rem;*/
/*             color: var(--text-light);*/
/*             text-decoration: none;*/
/*             font-weight: 500;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .mobile-menu ul li a:hover {*/
/*             color: var(--secondary-gold);*/
/*             background: rgba(212, 175, 55, 0.1);*/
/*         }*/
/*         /* Hero Section avec vidéo YouTube en fond - Mode background cover *//* */
/*         .hero {*/
/*             position: relative;*/
/*             height: 100vh;*/
/*             display: flex;*/
/*             align-items: center;*/
/*             text-align: center;*/
/*             color: var(--text-light);*/
/*             padding-top: 80px;*/
/*             overflow: hidden;*/
/*         }*/
/*         .hero-video {*/
/*             position: absolute;*/
/*             top: 0;*/
/*             left: 0;*/
/*             width: 100%;*/
/*             height: 100%;*/
/*             z-index: -1;*/
/*         }*/
/*         .hero-video iframe {*/
/*             position: absolute;*/
/*             top: 50%;*/
/*             left: 50%;*/
/*             width: auto;*/
/*             height: auto;*/
/*             min-width: 100%;*/
/*             min-height: 100%;*/
/*             transform: translate(-50%, -50%);*/
/*             border: none;*/
/*             pointer-events: none; /* Empêche l'interaction avec la vidéo en fond *//* */
/*         }*/
/*         .hero-overlay {*/
/*             position: absolute;*/
/*             top: 0;*/
/*             left: 0;*/
/*             width: 100%;*/
/*             height: 100%;*/
/*             background: linear-gradient(rgba(0, 102, 51, 0.6), rgba(0, 77, 64, 0.6));*/
/*             z-index: 0;*/
/*         }*/
/*         .hero::before {*/
/*             content: '';*/
/*             position: absolute;*/
/*             top: 0;*/
/*             left: 0;*/
/*             width: 100%;*/
/*             height: 100%;*/
/*             background: radial-gradient(circle, rgba(212, 175, 55, 0.1) 0%, transparent 70%);*/
/*             animation: shimmer 6s ease-in-out infinite;*/
/*             z-index: 1;*/
/*         }*/
/*         @keyframes shimmer {*/
/*             0%, 100% { opacity: 0; }*/
/*             50% { opacity: 1; }*/
/*         }*/
/*         .hero-content {*/
/*             max-width: 800px;*/
/*             margin: 0 auto;*/
/*             z-index: 2;*/
/*             animation: fadeInUp 1s ease-out;*/
/*             position: relative;*/
/*         }*/
/*         @keyframes fadeInUp {*/
/*             from { opacity: 0; transform: translateY(30px); }*/
/*             to { opacity: 1; transform: translateY(0); }*/
/*         }*/
/*         .hero h2 {*/
/*             font-size: 4rem;*/
/*             margin-bottom: 1.5rem;*/
/*             font-weight: 700;*/
/*             background: linear-gradient(45deg, var(--text-light), var(--secondary-gold));*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/*         .hero p {*/
/*             font-size: 1.3rem;*/
/*             margin-bottom: 2rem;*/
/*             max-width: 600px;*/
/*             margin-left: auto;*/
/*             margin-right: auto;*/
/*         }*/
/*         .btn {*/
/*             display: inline-block;*/
/*             background: linear-gradient(135deg, var(--secondary-gold), #FFD700);*/
/*             color: var(--primary-green);*/
/*             padding: 1rem 2.5rem;*/
/*             border-radius: 50px;*/
/*             text-decoration: none;*/
/*             font-weight: 600;*/
/*             transition: all 0.3s ease;*/
/*             border: 2px solid var(--secondary-gold);*/
/*             box-shadow: 0 4px 15px var(--shadow-medium);*/
/*         }*/
/*         .btn:hover {*/
/*             background: transparent;*/
/*             color: var(--secondary-gold);*/
/*             transform: translateY(-3px);*/
/*             box-shadow: 0 6px 20px var(--shadow-medium);*/
/*         }*/
/*         /* Filtres de galerie modernes avec effet hover *//* */
/*         .gallery-filters {*/
/*             display: flex;*/
/*             justify-content: center;*/
/*             margin: 4rem 0;*/
/*             flex-wrap: wrap;*/
/*             gap: 1rem;*/
/*         }*/
/*         .filter-btn {*/
/*             background: transparent;*/
/*             border: 2px solid var(--primary-green);*/
/*             color: var(--primary-green);*/
/*             padding: 0.75rem 1.5rem;*/
/*             border-radius: 50px;*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*             font-weight: 500;*/
/*             font-size: 0.95rem;*/
/*         }*/
/*         .filter-btn:hover, .filter-btn.active {*/
/*             background: var(--primary-green);*/
/*             color: var(--text-light);*/
/*             transform: translateY(-2px);*/
/*             box-shadow: 0 4px 15px var(--shadow-light);*/
/*         }*/
/*         /* Grille d'articles avec effet carte moderne *//* */
/*         .articles-grid {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fill, minmax(360px, 1fr));*/
/*             gap: 2rem;*/
/*             margin-bottom: 5rem;*/
/*         }*/
/*         .article-card {*/
/*             background: var(--light-color);*/
/*             border-radius: 20px;*/
/*             overflow: hidden;*/
/*             box-shadow: 0 8px 30px var(--shadow-light);*/
/*             transition: all 0.4s ease;*/
/*             position: relative;*/
/*         }*/
/*         .article-card::before {*/
/*             content: '';*/
/*             position: absolute;*/
/*             top: 0;*/
/*             left: 0;*/
/*             width: 100%;*/
/*             height: 100%;*/
/*             background: linear-gradient(135deg, var(--primary-green), #004d40);*/
/*             opacity: 0;*/
/*             transition: opacity 0.4s ease;*/
/*             z-index: -1;*/
/*         }*/
/*         .article-card:hover {*/
/*             transform: translateY(-10px) scale(1.02);*/
/*             box-shadow: 0 20px 40px var(--shadow-medium);*/
/*         }*/
/*         .article-card:hover::before {*/
/*             opacity: 0.05;*/
/*         }*/
/*         .article-media {*/
/*             position: relative;*/
/*             height: 220px;*/
/*             overflow: hidden;*/
/*         }*/
/*         .article-media img, .article-media video {*/
/*             width: 100%;*/
/*             height: 100%;*/
/*             object-fit: cover;*/
/*             transition: transform 0.6s ease;*/
/*         }*/
/*         .article-card:hover .article-media img,*/
/*         .article-card:hover .article-media video {*/
/*             transform: scale(1.1);*/
/*         }*/
/*         .article-date {*/
/*             position: absolute;*/
/*             top: 1rem;*/
/*             right: 1rem;*/
/*             background: var(--secondary-gold);*/
/*             color: var(--primary-green);*/
/*             padding: 0.5rem 0.75rem;*/
/*             border-radius: 15px;*/
/*             font-weight: 600;*/
/*             font-size: 0.85rem;*/
/*             box-shadow: 0 4px 10px rgba(212, 175, 55, 0.3);*/
/*         }*/
/*         .article-badge {*/
/*             position: absolute;*/
/*             top: 1rem;*/
/*             left: 1rem;*/
/*             background: var(--accent-red);*/
/*             color: var(--text-light);*/
/*             padding: 0.4rem 0.8rem;*/
/*             border-radius: 15px;*/
/*             font-size: 0.75rem;*/
/*             font-weight: 500;*/
/*         }*/
/*         .article-content {*/
/*             padding: 1.5rem;*/
/*         }*/
/*         .article-content h3 {*/
/*             font-size: 1.4rem;*/
/*             margin-bottom: 0.75rem;*/
/*             color: var(--primary-green);*/
/*             font-weight: 600;*/
/*         }*/
/*         .article-content p {*/
/*             color: #666;*/
/*             margin-bottom: 1rem;*/
/*             font-size: 0.95rem;*/
/*         }*/
/*         .article-meta {*/
/*             display: flex;*/
/*             justify-content: space-between;*/
/*             align-items: center;*/
/*             margin-top: 1rem;*/
/*             padding-top: 1rem;*/
/*             border-top: 1px solid #eee;*/
/*         }*/
/*         .article-category {*/
/*             background: linear-gradient(135deg, var(--primary-green), #004d40);*/
/*             color: var(--text-light);*/
/*             padding: 0.3rem 0.8rem;*/
/*             border-radius: 20px;*/
/*             font-size: 0.8rem;*/
/*             font-weight: 500;*/
/*         }*/
/*         .article-actions {*/
/*             display: flex;*/
/*             gap: 0.75rem;*/
/*         }*/
/*         .action-btn {*/
/*             background: none;*/
/*             border: none;*/
/*             color: #888;*/
/*             cursor: pointer;*/
/*             font-size: 1.1rem;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .action-btn:hover {*/
/*             color: var(--secondary-gold);*/
/*             transform: scale(1.2);*/
/*         }*/
/*         /* Section Newsletter avec dégradé *//* */
/*         .newsletter {*/
/*             background: linear-gradient(135deg, var(--primary-green) 0%, #004d40 100%);*/
/*             color: var(--text-light);*/
/*             padding: 5rem 0;*/
/*             text-align: center;*/
/*             position: relative;*/
/*             overflow: hidden;*/
/*         }*/
/*         .newsletter::before {*/
/*             content: '';*/
/*             position: absolute;*/
/*             top: -50%;*/
/*             right: -50%;*/
/*             width: 200%;*/
/*             height: 200%;*/
/*             background: radial-gradient(circle, rgba(212, 175, 55, 0.1) 0%, transparent 70%);*/
/*             animation: rotate 20s linear infinite;*/
/*         }*/
/*         @keyframes rotate {*/
/*             from { transform: rotate(0deg); }*/
/*             to { transform: rotate(360deg); }*/
/*         }*/
/*         .newsletter > * {*/
/*             position: relative;*/
/*             z-index: 1;*/
/*         }*/
/*         .newsletter h2 {*/
/*             font-size: 2.5rem;*/
/*             margin-bottom: 1rem;*/
/*             background: linear-gradient(45deg, var(--text-light), var(--secondary-gold));*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/*         .newsletter p {*/
/*             max-width: 600px;*/
/*             margin: 0 auto 2rem;*/
/*             opacity: 0.9;*/
/*             font-size: 1.1rem;*/
/*         }*/
/*         .newsletter-form {*/
/*             display: flex;*/
/*             max-width: 500px;*/
/*             margin: 0 auto;*/
/*             border-radius: 50px;*/
/*             overflow: hidden;*/
/*             box-shadow: 0 8px 30px var(--shadow-light);*/
/*         }*/
/*         .newsletter-input {*/
/*             flex: 1;*/
/*             padding: 1rem 1.5rem;*/
/*             border: none;*/
/*             background: rgba(255, 255, 255, 0.9);*/
/*             font-size: 1rem;*/
/*         }*/
/*         .newsletter-btn {*/
/*             background: linear-gradient(135deg, var(--secondary-gold), #FFD700);*/
/*             color: var(--primary-green);*/
/*             border: none;*/
/*             padding: 0 2rem;*/
/*             font-weight: 600;*/
/*             cursor: pointer;*/
/*             transition: all 0.3s ease;*/
/*         }*/
/*         .newsletter-btn:hover {*/
/*             background: linear-gradient(135deg, #FFD700, var(--secondary-gold));*/
/*             transform: translateX(5px);*/
/*         }*/
/*         /* Footer élégant *//* */
/*         footer {*/
/*             background: var(--dark-color);*/
/*             color: var(--text-light);*/
/*             padding: 4rem 0 2rem;*/
/*         }*/
/*         .footer-content {*/
/*             display: grid;*/
/*             grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));*/
/*             gap: 2rem;*/
/*             margin-bottom: 2rem;*/
/*         }*/
/*         .footer-column h3 {*/
/*             font-size: 1.4rem;*/
/*             margin-bottom: 1rem;*/
/*             background: linear-gradient(45deg, var(--secondary-gold), #FFD700);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*         }*/
/*         .footer-column p {*/
/*             margin-bottom: 1rem;*/
/*             opacity: 0.8;*/
/*             font-size: 0.95rem;*/
/*         }*/
/*         .footer-links {*/
/*             list-style: none;*/
/*         }*/
/*         .footer-links li {*/
/*             margin-bottom: 0.75rem;*/
/*         }*/
/*         .footer-links a {*/
/*             color: var(--text-light);*/
/*             text-decoration: none;*/
/*             opacity: 0.8;*/
/*             transition: all 0.3s ease;*/
/*             display: inline-block;*/
/*         }*/
/*         .footer-links a:hover {*/
/*             opacity: 1;*/
/*             color: var(--secondary-gold);*/
/*             transform: translateX(5px);*/
/*         }*/
/*         .social-links {*/
/*             display: flex;*/
/*             gap: 1rem;*/
/*             margin-top: 1rem;*/
/*         }*/
/*         .social-links a {*/
/*             display: inline-flex;*/
/*             align-items: center;*/
/*             justify-content: center;*/
/*             width: 45px;*/
/*             height: 45px;*/
/*             background: rgba(212, 175, 55, 0.1);*/
/*             border-radius: 50%;*/
/*             color: var(--text-light);*/
/*             text-decoration: none;*/
/*             transition: all 0.3s ease;*/
/*             border: 1px solid rgba(212, 175, 55, 0.2);*/
/*         }*/
/*         .social-links a:hover {*/
/*             background: var(--secondary-gold);*/
/*             color: var(--primary-green);*/
/*             transform: translateY(-3px) scale(1.1);*/
/*         }*/
/*         .copyright {*/
/*             text-align: center;*/
/*             padding-top: 2rem;*/
/*             border-top: 1px solid rgba(255, 255, 255, 0.1);*/
/*             opacity: 0.7;*/
/*             font-size: 0.9rem;*/
/*         }*/
/*         /* Titre de section *//* */
/*         .section-title {*/
/*             text-align: center;*/
/*             margin-bottom: 3rem;*/
/*             font-size: 3rem;*/
/*             background: linear-gradient(45deg, var(--primary-green), #004d40);*/
/*             -webkit-background-clip: text;*/
/*             -webkit-text-fill-color: transparent;*/
/*             background-clip: text;*/
/*             font-weight: 600;*/
/*         }*/
/*         /* Responsive design amélioré *//* */
/*         @media (max-width: 992px) {*/
/*             .articles-grid {*/
/*                 grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));*/
/*             }*/
/*             .hero h2 { font-size: 3rem; }*/
/*             .nav-left ul, .nav-right ul { gap: 1rem; }*/
/*         }*/
/*         @media (max-width: 768px) {*/
/*             .nav-left, .nav-right {*/
/*                 display: none;*/
/*             }*/
/*             .logo {*/
/*                 position: static;*/
/*                 transform: none;*/
/*             }*/
/*             .header-container {*/
/*                 justify-content: center;*/
/*             }*/
/*             .menu-toggle {*/
/*                 display: block;*/
/*                 position: absolute;*/
/*                 right: 20px;*/
/*                 z-index: 3;*/
/*             }*/
/*             .mobile-menu {*/
/*                 display: block;*/
/*             }*/
/*             .hero h2 { font-size: 2.5rem; }*/
/*             .hero p { font-size: 1.1rem; }*/
/*             .newsletter-form { flex-direction: column; }*/
/*             .newsletter-input { border-radius: 50px; margin-bottom: 1rem; }*/
/*             .newsletter-btn { border-radius: 50px; }*/
/*             .gallery-filters { gap: 0.5rem; }*/
/*             .filter-btn { padding: 0.6rem 1.2rem; font-size: 0.9rem; }*/
/*             .hero { padding-top: 100px; }*/
/*             .logo h1 { font-size: 1.5rem; }*/
/*         }*/
/*         @media (max-width: 576px) {*/
/*             .hero { height: 80vh; }*/
/*             .hero h2 { font-size: 2.2rem; }*/
/*             .articles-grid { grid-template-columns: 1fr; gap: 1.5rem; }*/
/*             .section-title { font-size: 2.2rem; }*/
/*         }*/
/*     </style>*/
/*     <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">*/
/*     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">*/
/* </head>*/
/* <body>*/
/*     <!-- Header -->*/
/*     <header>*/
/*         <div class="container">*/
/*             <div class="header-container">*/
/*                 <nav class="nav-left">*/
/*                     <ul>*/
/*                         <li><a href="#accueil">Accueil</a></li>*/
/*                         <li><a href="#galerie">A propos</a></li>*/
/*                     </ul>*/
/*                 </nav>*/
/*                 <div class="logo">*/
/*                     <h1>TOGO <span>5 ÉTOILES</span></h1>*/
/*                 </div>*/
/*                 <div class="header-right">*/
/*                     <nav class="nav-right">*/
/*                         <ul>*/
/*                             <li><a href="#articles">Réalisations</a></li>*/
/*                             <li><a href="#apropos">Investir au Togo</a></li>*/
/*                             <li><a href="#contact">Contact</a></li>*/
/*                         </ul>*/
/*                     </nav>*/
/*                     <div class="menu-toggle">*/
/*                         <i class="fas fa-bars"></i>*/
/*                     </div>*/
/*                 </div>*/
/*             </div>*/
/*             <div class="mobile-menu">*/
/*                 <ul>*/
/*                     <li><a href="#accueil">Accueil</a></li>*/
/*                     <li><a href="#galerie">A propos</a></li>*/
/*                     <li><a href="#articles">Réalisations</a></li>*/
/*                     <li><a href="#apropos">Investir au Togo</a></li>*/
/*                     <li><a href="#contact">Contact</a></li>*/
/*                 </ul>*/
/*             </div>*/
/*         </div>*/
/*     </header>*/
/*     <!-- Hero Section avec vidéo YouTube corrigée en mode background cover -->*/
/*     <section class="hero" id="accueil">*/
/*         <div class="hero-video" style="padding:0">*/
/*             <iframe*/
/*                 src="https://www.youtube.com/embed/X_OjoE8CWuY?autoplay=1&mute=1&loop=1&playlist=X_OjoE8CWuY&controls=0&showinfo=0&rel=0&playsinline=1&disablekb=1" style="padding:0"*/
/*                 title="Vidéo YouTube"*/
/*                 frameborder="0"*/
/*                 allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"*/
/*                 allowfullscreen>*/
/*             </iframe>*/
/*         </div>*/
/*         <div class="hero-overlay"></div>*/
/*         <div class="container hero-content">*/
/*             <h2>TOGO 5 ÉTOILES</h2>*/
/*             <p>Suivez l’avancement des projets du Togo en toute transparence grâce à notre portail officiel.</p>*/
/*             <a href="#galerie" class="btn">Explorer la Galerie</a>*/
/*         </div>*/
/*     </section>*/
/*     <!-- Galerie d'articles -->*/
/*     <section id="galerie">*/
/*         <div class="container">*/
/*             <h2 class="section-title">Galerie d'Articles</h2>*/
/*           */
/*             <!-- Filtres -->*/
/*             <div class="gallery-filters">*/
/*                 <button class="filter-btn active" data-filter="all">Tous</button>*/
/*                 <button class="filter-btn" data-filter="photo">Photos</button>*/
/*                 <button class="filter-btn" data-filter="video">Vidéos</button>*/
/*                 <button class="filter-btn" data-filter="evenement">Événements</button>*/
/*                 <button class="filter-btn" data-filter="actualite">Actualités</button>*/
/*             </div>*/
/*           */
/*             <!-- Grille d'articles -->*/
/*             <div class="articles-grid">*/
/*                 <!-- Article 1 - Photo -->*/
/*                 <div class="article-card" data-category="photo">*/
/*                     <div class="article-media">*/
/*                         <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" alt="Événement TOGO 5 ÉTOILES">*/
/*                         <div class="article-date">15 Oct 2023</div>*/
/*                         <div class="article-badge">Photo</div>*/
/*                     </div>*/
/*                     <div class="article-content">*/
/*                         <h3>Cérémonie de remise de prix</h3>*/
/*                         <p>Notre équipe a été honorée lors de la cérémonie annuelle des entreprises d'excellence.</p>*/
/*                         <div class="article-meta">*/
/*                             <span class="article-category">Événement</span>*/
/*                             <div class="article-actions">*/
/*                                 <button class="action-btn"><i class="far fa-heart"></i></button>*/
/*                                 <button class="action-btn"><i class="far fa-share-square"></i></button>*/
/*                             </div>*/
/*                         </div>*/
/*                     </div>*/
/*                 </div>*/
/*               */
/*                 <!-- Article 2 - Vidéo -->*/
/*                 <div class="article-card" data-category="video">*/
/*                     <div class="article-media">*/
/*                         <video controls poster="https://images.unsplash.com/photo-1531403009284-440f080d1e12?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80">*/
/*                             <source src="#" type="video/mp4">*/
/*                             Votre navigateur ne supporte pas la lecture de vidéos.*/
/*                         </video>*/
/*                         <div class="article-date">12 Oct 2023</div>*/
/*                         <div class="article-badge">Vidéo</div>*/
/*                     </div>*/
/*                     <div class="article-content">*/
/*                         <h3>Interview exclusive</h3>*/
/*                         <p>Notre directeur général partage sa vision pour l'avenir de l'entreprise dans cette interview.</p>*/
/*                         <div class="article-meta">*/
/*                             <span class="article-category">Actualité</span>*/
/*                             <div class="article-actions">*/
/*                                 <button class="action-btn"><i class="far fa-heart"></i></button>*/
/*                                 <button class="action-btn"><i class="far fa-share-square"></i></button>*/
/*                             </div>*/
/*                         </div>*/
/*                     </div>*/
/*                 </div>*/
/*               */
/*                 <!-- Article 3 - Photo -->*/
/*                 <div class="article-card" data-category="photo evenement">*/
/*                     <div class="article-media">*/
/*                         <img src="https://images.unsplash.com/photo-1542744173-8e7e53415bb0?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" alt="Réunion d'équipe">*/
/*                         <div class="article-date">10 Oct 2023</div>*/
/*                         <div class="article-badge">Photo</div>*/
/*                     </div>*/
/*                     <div class="article-content">*/
/*                         <h3>Semaine de formation interne</h3>*/
/*                         <p>Notre équipe a participé à une semaine intensive de formation pour perfectionner ses compétences.</p>*/
/*                         <div class="article-meta">*/
/*                             <span class="article-category">Formation</span>*/
/*                             <div class="article-actions">*/
/*                                 <button class="action-btn"><i class="far fa-heart"></i></button>*/
/*                                 <button class="action-btn"><i class="far fa-share-square"></i></button>*/
/*                             </div>*/
/*                         </div>*/
/*                     </div>*/
/*                 </div>*/
/*               */
/*                 <!-- Article 4 - Vidéo -->*/
/*                 <div class="article-card" data-category="video actualite">*/
/*                     <div class="article-media">*/
/*                         <video controls poster="https://images.unsplash.com/photo-1551836026-d5c55ac5d4c9?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80">*/
/*                             <source src="#" type="video/mp4">*/
/*                             Votre navigateur ne supporte pas la lecture de vidéos.*/
/*                         </video>*/
/*                         <div class="article-date">08 Oct 2023</div>*/
/*                         <div class="article-badge">Vidéo</div>*/
/*                     </div>*/
/*                     <div class="article-content">*/
/*                         <h3>Lancement de nouveau service</h3>*/
/*                         <p>Découvrez en vidéo notre nouveau service premium lancé ce mois-ci.</p>*/
/*                         <div class="article-meta">*/
/*                             <span class="article-category">Innovation</span>*/
/*                             <div class="article-actions">*/
/*                                 <button class="action-btn"><i class="far fa-heart"></i></button>*/
/*                                 <button class="action-btn"><i class="far fa-share-square"></i></button>*/
/*                             </div>*/
/*                         </div>*/
/*                     </div>*/
/*                 </div>*/
/*               */
/*                 <!-- Article 5 - Photo -->*/
/*                 <div class="article-card" data-category="photo evenement">*/
/*                     <div class="article-media">*/
/*                         <img src="https://images.unsplash.com/photo-1560472354-b33ff0c44a43?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" alt="Événement caritatif">*/
/*                         <div class="article-date">05 Oct 2023</div>*/
/*                         <div class="article-badge">Photo</div>*/
/*                     </div>*/
/*                     <div class="article-content">*/
/*                         <h3>Participation à l'événement caritatif</h3>*/
/*                         <p>Notre entreprise a participé activement à l'événement caritatif annuel de la ville.</p>*/
/*                         <div class="article-meta">*/
/*                             <span class="article-category">Caritatif</span>*/
/*                             <div class="article-actions">*/
/*                                 <button class="action-btn"><i class="far fa-heart"></i></button>*/
/*                                 <button class="action-btn"><i class="far fa-share-square"></i></button>*/
/*                             </div>*/
/*                         </div>*/
/*                     </div>*/
/*                 </div>*/
/*               */
/*                 <!-- Article 6 - Vidéo -->*/
/*                 <div class="article-card" data-category="video">*/
/*                     <div class="article-media">*/
/*                         <video controls poster="https://images.unsplash.com/photo-1559136555-9303baea8ebd?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80">*/
/*                             <source src="#" type="video/mp4">*/
/*                             Votre navigateur ne supporte pas la lecture de vidéos.*/
/*                         </video>*/
/*                         <div class="article-date">01 Oct 2023</div>*/
/*                         <div class="article-badge">Vidéo</div>*/
/*                     </div>*/
/*                     <div class="article-content">*/
/*                         <h3>Visite de nos installations</h3>*/
/*                         <p>Découvrez en vidéo l'intérieur de nos locaux et nos équipements de pointe.</p>*/
/*                         <div class="article-meta">*/
/*                             <span class="article-category">Visite</span>*/
/*                             <div class="article-actions">*/
/*                                 <button class="action-btn"><i class="far fa-heart"></i></button>*/
/*                                 <button class="action-btn"><i class="far fa-share-square"></i></button>*/
/*                             </div>*/
/*                         </div>*/
/*                     </div>*/
/*                 </div>*/
/*             </div>*/
/*         </div>*/
/*     </section>*/
/*     <!-- Newsletter -->*/
/*     <section class="newsletter">*/
/*         <div class="container">*/
/*             <h2>Restez Informé</h2>*/
/*             <p>Abonnez-vous à notre newsletter pour ne manquer aucun de nos articles et actualités.</p>*/
/*             <form class="newsletter-form">*/
/*                 <input type="email" class="newsletter-input" placeholder="Votre adresse email" required>*/
/*                 <button type="submit" class="newsletter-btn">S'abonner</button>*/
/*             </form>*/
/*         </div>*/
/*     </section>*/
/*     <!-- Footer -->*/
/*     <footer>*/
/*         <div class="container">*/
/*             <div class="footer-content">*/
/*                 <div class="footer-column">*/
/*                     <h3>TOGO 5 ÉTOILES</h3>*/
/*                     <p>Votre partenaire de confiance pour des services haut de gamme et sur mesure. Excellence, prestige et satisfaction client sont au cœur de notre philosophie.</p>*/
/*                     <div class="social-links">*/
/*                         <a href="#"><i class="fab fa-facebook-f"></i></a>*/
/*                         <a href="#"><i class="fab fa-twitter"></i></a>*/
/*                         <a href="#"><i class="fab fa-instagram"></i></a>*/
/*                         <a href="#"><i class="fab fa-linkedin-in"></i></a>*/
/*                     </div>*/
/*                 </div>*/
/*                 <div class="footer-column">*/
/*                     <h3>Liens Rapides</h3>*/
/*                     <ul class="footer-links">*/
/*                         <li><a href="#accueil">Accueil</a></li>*/
/*                         <li><a href="#galerie">Galerie</a></li>*/
/*                         <li><a href="#articles">Articles</a></li>*/
/*                         <li><a href="#apropos">À propos</a></li>*/
/*                         <li><a href="#contact">Contact</a></li>*/
/*                     </ul>*/
/*                 </div>*/
/*                 <div class="footer-column">*/
/*                     <h3>Catégories</h3>*/
/*                     <ul class="footer-links">*/
/*                         <li><a href="#">Photos</a></li>*/
/*                         <li><a href="#">Vidéos</a></li>*/
/*                         <li><a href="#">Événements</a></li>*/
/*                         <li><a href="#">Actualités</a></li>*/
/*                         <li><a href="#">Interviews</a></li>*/
/*                     </ul>*/
/*                 </div>*/
/*                 <div class="footer-column">*/
/*                     <h3>Contact</h3>*/
/*                     <p>123 Avenue du Prestige<br>Lomé, Togo</p>*/
/*                     <p>Email: contact@togo5etoiles.com</p>*/
/*                     <p>Tél: +228 12 34 56 78</p>*/
/*                 </div>*/
/*             </div>*/
/*             <div class="copyright">*/
/*                 <p>&copy; 2023 TOGO 5 ÉTOILES. Tous droits réservés.</p>*/
/*             </div>*/
/*         </div>*/
/*     </footer>*/
/*     <script>*/
/*         // Menu mobile toggle*/
/*         document.querySelector('.menu-toggle').addEventListener('click', function() {*/
/*             document.querySelector('.mobile-menu').classList.toggle('active');*/
/*         });*/
/*         // Filtrage des articles avec animation*/
/*         const filterButtons = document.querySelectorAll('.filter-btn');*/
/*         const articleCards = document.querySelectorAll('.article-card');*/
/*         filterButtons.forEach(button => {*/
/*             button.addEventListener('click', () => {*/
/*                 filterButtons.forEach(btn => btn.classList.remove('active'));*/
/*                 button.classList.add('active');*/
/*               */
/*                 const filterValue = button.getAttribute('data-filter');*/
/*               */
/*                 articleCards.forEach((card, index) => {*/
/*                     if (filterValue === 'all') {*/
/*                         setTimeout(() => { card.style.display = 'block'; card.style.opacity = '1'; }, index * 100);*/
/*                     } else {*/
/*                         const categories = card.getAttribute('data-category').split(' ');*/
/*                         if (categories.includes(filterValue)) {*/
/*                             setTimeout(() => { card.style.display = 'block'; card.style.opacity = '1'; }, index * 100);*/
/*                         } else {*/
/*                             card.style.opacity = '0';*/
/*                             setTimeout(() => { card.style.display = 'none'; }, 300);*/
/*                         }*/
/*                     }*/
/*                 });*/
/*             });*/
/*         });*/
/*         // Initial opacity pour filtrage*/
/*         articleCards.forEach(card => { card.style.opacity = '1'; card.style.transition = 'opacity 0.3s ease'; });*/
/*         // Smooth scrolling*/
/*         document.querySelectorAll('a[href^="#"]').forEach(anchor => {*/
/*             anchor.addEventListener('click', function (e) {*/
/*                 e.preventDefault();*/
/*               */
/*                 const targetId = this.getAttribute('href');*/
/*                 if(targetId === '#') return;*/
/*               */
/*                 const targetElement = document.querySelector(targetId);*/
/*                 if(targetElement) {*/
/*                     window.scrollTo({*/
/*                         top: targetElement.offsetTop - 80,*/
/*                         behavior: 'smooth'*/
/*                     });*/
/*                   */
/*                     document.querySelector('.mobile-menu').classList.remove('active');*/
/*                 }*/
/*             });*/
/*         });*/
/*     </script>*/
/* </body>*/
/* </html>*/
