require("dotenv").config();
const TelegramBot = require("node-telegram-bot-api");
const axios = require("axios");

// Configuration des tokens et API
const token = process.env.TELEGRAM_BOT_TOKEN || "7562759533:AAFkRt6QjH3f1SxzCMZ2hOU_guNinh_GioM"; // Use .env
const openRouterApiKey = process.env.OPENROUTER_API_KEY || "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"; // Use .env

const jobApiUrl = "https://job-finder-bot.com/home/new_jobs";
const jobHierApiUrl = "https://job-finder-bot.com/home/last_jobs";
const messagesApiUrl = "https://job-finder-bot.com/home/new_messages";
const NewCandidatApiUrl = "https://job-finder-bot.com/home/nouveaux_candidats";
const ExpirationCandidatApiUrl = "https://job-finder-bot.com/home/expiration_10";

// File d'attente pour limiter les requêtes simultanées (initialisée après import dynamique)
let queue;

// Import dynamique de p-queue
(async () => {
  const { default: PQueue } = await import("p-queue");
  queue = new PQueue({ concurrency: 2, interval: 1000, intervalCap: 5 });
})();

// Initialisation du bot
const bot = new TelegramBot(token, { polling: { params: { timeout: 10, interval: 1000 } } });

// Suppress node-telegram-bot-api deprecation warning
process.env.NTBA_FIX_350 = 1;

// Commandes du bot
bot.setMyCommands([
  { command: "compte", description: "1️⃣ Consulter mon compte" },
  { command: "analyse_marche", description: "2️⃣ Analyse du marché" },
  { command: "abonnement", description: "3️⃣ Charger mon compte" },
  { command: "groupe", description: "4️⃣ Intégrer notre groupe VIP" },
  { command: "affiliation", description: "5️⃣ Affiliation" },
  { command: "contact", description: "6️⃣ Nous contacter" },
]);

// Message de bienvenue
const welcomeMessage = `🚀 *Automatisez* votre *recherche d'emploi* grâce à l’IA !\n\n` +
  `💡 Découvrez *JobFinderBot*, votre assistant IA spécialisé dans la recherche d’emploi !\n\n` +
  `✅ Il Scanne plus de *20 sources* d’offres dans votre pays \n` +
  `✅ Il classe les annonces par *spécialité* et *pertinence*\n` +
  `✅ Il vous envoie quotidiennement les *opportunités adaptées*\n` +
  `✅ Pour chaque offre il vous fournit une *lettre de motivation* adaptée\n` +
  `✅ Il vous donne les *instructions à inscrire sur votre CV* pour chaque offre!\n` +
  `*Cliquez sur le bouton suivant pour accéder à votre espace candidat*\n`;

// Prompt de JobFinderBot
const jobFinderPrompt = `
Vous êtes JobFinderBot, une intelligence artificielle développée pour aider les Africains à trouver rapidement un emploi. Votre mission est d’assister les utilisateurs en recherchant quotidiennement des offres d’emploi adaptées à leur profil (spécialité, compétences, localisation) à partir de plus de 10 sources par pays (Côte d'Ivoire, Gabon, Bénin, Sénégal). Vous classez les offres par pertinence et envoyez une liste personnalisée aux abonnés avec un modèle de lettre de motivation adapté.

**Fonctionnalités :**
- Recherche d’offres d’emploi à partir de multiples sources.
- Analyse du profil utilisateur pour proposer des offres pertinentes.
- Envoi quotidien des offres avec lettre de motivation.
- Conseils sur CV, entretiens, et tendances du marché.

**Conditions :**
- Inscription avec *5 jours* gratuits.
- Tarifs : *6000 FCFA* pour *5 mois*, *12 000 FCFA/an*.
- Contact : hello@job-finder-bot.com.

**Instructions :**
- Répondez uniquement avec les informations ci-dessus pour les questions liées au service.
- Pour les questions hors sujet : "Désolé, je ne peux pas répondre à cela. Contactez hello@jobfinderbot.com."
- Proposez l’inscription via "/inscription".
- Formatage : **gras** pour les mots clés, emojis pertinents, ton amical et professionnel.
`;

// Fonction pour envoyer un message avec gestion des erreurs
const sendMessageSafely = async (chatId, message, options = {}) => {
  try {
    await bot.sendMessage(chatId, message, { parse_mode: "Markdown", ...options });
  } catch (error) {
    console.error(`Erreur lors de l'envoi à ${chatId}:`, error.message);
  }
};

// Fonction pour envoyer une photo avec gestion des erreurs
const sendPhotoSafely = async (chatId, photo, options = {}) => {
  try {
    await bot.sendPhoto(chatId, photo, { parse_mode: "Markdown", ...options });
  } catch (error) {
    console.error(`Erreur lors de l'envoi de la photo à ${chatId}:`, error.message);
  }
};

// Formate le message de l'offre
const formatJobMessage = (job) => {
  return {
    text: `📢 **Nouvelle offre d’emploi** !\n\n` +
      `💼 Poste : *${job.Titre}*\n` +
      `🌐 Source : *${job.Source}*\n` +
      `📍 Type : *${job.Type}*\n` +
      `📩 Cliquez sur les boutons ci-dessous pour accéder à la lettre de motivation ou aux instructions CV !`,
    options: {
      parse_mode: "Markdown",
      reply_markup: {
        inline_keyboard: [
          [{ text: "📝 Lien pour postuler", url: `${job.Lien_postulation}` }],
          [{ text: "📝 Lettre de motivation", url: `https://job-finder-bot.com/lettre_motivation/${job.Id}` }],
          [{ text: "📄 Instructions CV", url: `https://job-finder-bot.com/instructions_cv/${job.Id}` }],
        ],
      },
    },
  };
};

// Formate les messages pour abonnés/non-abonnés

const formatConseilsNonAbonne = (msg, user) => {
  return {
    text: `📢 *Infos* !\n\n` +
      `Bonjour *${user.Nom} ${user.Prenom}*\n\n${msg.Contenu}\n\n\n` +
      `📩 *Renouvelez votre abonnement dès maintenant en cliquant sur l'un des boutons*!`,
    options: {
      parse_mode: "Markdown",
      reply_markup: {
        inline_keyboard: [
          [{ text: "🎯 200 crédits - 2500 FCFA", url: `https://oxnlkqwp.mychariow.store/prd_iqlq9w/checkout` }],
          [{ text: "🎯 500 crédits - 5000 FCFA", url: `https://oxnlkqwp.mychariow.store/prd_jmc1rq/checkout` }],
          [{ text: "🎯 Crédits illimités - 10000 FCFA", url: `https://oxnlkqwp.mychariow.store/prd_waghrz/checkout` }],
        ],
      },
    },
  };
};

const formatConseilsNonAbonneHtml = (msg, user) => {
  return {
    text: `📢 <b>Infos</b> !\n\n` +
          `Bonjour <b>${user.Nom} ${user.Prenom}</b>\n\n${msg.Contenu}\n\n\n` +
          `📩 <b>Chargez votre compte dès maintenant en cliquant sur l'un des boutons</b>!`,
    options: {
      parse_mode: "HTML",
      reply_markup: {
        inline_keyboard: [
          [
            { 
              text: "🎯 200 crédits - 2500 FCFA", 
              url: `https://oxnlkqwp.mychariow.store/prd_iqlq9w/checkout` 
            }
          ],
          [
            { 
              text: "🎯 500 crédits - 5000 FCFA", 
              url: `https://oxnlkqwp.mychariow.store/prd_jmc1rq/checkout` 
            }
          ],
          [
            { 
              text: "🎯 Crédits illimités - 10000 FCFA", 
              url: `https://oxnlkqwp.mychariow.store/prd_waghrz/checkout` 
            }
          ],

          
        ],
      },
    },
  };
};


const formatConseilsAbonne = (msg, user) => {
  return {
    text: `📢 *Conseils Pratiques* !\n\n` +
      `${msg.Contenu}\n\n` +
      `\n📩 Vous avez des questions?\nContactez-nous à hello@job-finder-bot.com`,
    options: { parse_mode: "Markdown" },
  };
};

const formatConseilsAbonneHtml = (msg, user) => {
  return {
    text: `📢 <b>Conseils Pratiques</b> !\n\n` +
          `Bonjour <b>${user.Nom}</b> <b>${user.Prenom}</b>\n\n${msg.Contenu}\n\n` +
          `📩 Vous avez des questions ?\n` +
          `Contactez-nous à <a href="mailto:hello@job-finder-bot.com">hello@job-finder-bot.com</a>`,
    options: { parse_mode: "HTML" },
  };
};


const escapeMarkdownV2 = (text) => {
  return text.replace(/([_*\[\]()~`>#+\-=|{}.!])/g, '\\$1');
};

const formatBienvenue = (candidat) => {

  return {
    text: `Bienvenue sur *JobFinderBot* votre assistant *Telegram* qui vous aide à trouver du *booulot* grâce à l' *Intelligence Artificielle*\n\nVous avez actuellement une période de *5 jours gratuits* pour tester notre assistant.A la fin des *5 jours* il vous faut souscrire à une de nos *abonnements premium* pour recevoir des *offres en illimité* et décrocher votre prochain boulot\.\n\nSi vous désirez avoir plus d'informations écrivez nous sur whatsapp sur notre numéro: *+212781671051*` ,
    options: { parse_mode: "Markdown" },
  };
};


// Sleep utility avec randomisation
const sleep = (ms) => new Promise((resolve) => setTimeout(resolve, ms * (1 + Math.random() * 0.2)));

// Retry utility avec backoff exponentiel
const retry = async (fn, retries = 3, baseDelay = 2000) => {
  for (let i = 0; i < retries; i++) {
    try {
      // Attendre que la queue soit initialisée
      if (!queue) {
        await new Promise((resolve) => setTimeout(resolve, 100));
      }
      return await queue.add(fn);
    } catch (error) {
      if (i === retries - 1) throw error;
      const delay = baseDelay * Math.pow(2, i); // Backoff exponentiel
      console.warn(`Tentative ${i + 1} échouée, nouvelle tentative dans ${delay}ms...`, error.message);
      await sleep(delay);
    }
  }
};

// Vérifier et envoyer les nouvelles offres
const checkAndSendNewJobs = async () => {
  try {
    console.log("Vérification des nouvelles offres...");
    const response = await retry(() => axios.get(jobApiUrl));
    const newJobs = response.data.jobs || [];

    if (newJobs.length === 0) {
      console.log("Aucune nouvelle offre trouvée.");
      return;
    }

    console.log(`${newJobs.length} nouvelle(s) offre(s) trouvée(s).`);

    for (const job of newJobs) {
      for (const user of job.Candidats || []) {
        const jobMessage = formatJobMessage(job);

        const test_credit = await retry(() => checkCredit(user.Id_chat));
        

        if(test_credit>0){

          await sendMessageSafely(user.Id_chat, jobMessage.text, jobMessage.options);
          const decompte = await retry(() => decompteCredit(user.Id_chat,job.Id));

        }
        
        await sleep(3000);
      }
      await retry(() => validateJob(job.Id));
    }

    console.log("Envoi des offres terminé.");
  } catch (error) {
    console.error(`Erreur lors de la vérification des offres [${jobApiUrl}]:`, error.message);
  }
};

// Vérifier et envoyer les offres aux nouveaux abonnés
const checkAndSendFirstJobs = async () => {
  try {
    console.log("Vérification des nouveaux abonnés...");
    const response = await retry(() => axios.get(jobHierApiUrl));
    const lastJobs = response.data.jobs || [];

    if (lastJobs.length === 0) {
      console.log("Aucune nouvelle offre trouvée.");
      return;
    }

    console.log(`${lastJobs.length} ancienne(s) offre(s) trouvée(s).`);

    for (const job of lastJobs) {
      for (const utilisateur of job.Candidats || []) {
        const jobMessage = formatJobMessage(job);
        await sendMessageSafely(utilisateur.Id_chat, jobMessage.text, jobMessage.options);
        await sleep(5000);
        await retry(() => validerCandidat(utilisateur.Id_chat));
      }
    }

    console.log("Envoi des anciennes offres terminé.");
  } catch (error) {
    console.error(`Erreur lors de la vérification des offres [${jobHierApiUrl}]:`, error.message);
  }
};

// Vérifier et envoyer les messages de bienvenue
const checkAndSendBienvenue = async () => {
  try {
    console.log("Vérification des nouveaux abonnés...");
    const response = await retry(() => axios.get(NewCandidatApiUrl));
    const lastCandidats = response.data.candidats || [];

    if (lastCandidats.length === 0) {
      console.log("Aucun nouveau candidat trouvé.");
      return;
    }

    console.log(`${lastCandidats.length} nouveaux candidats trouvés.`);

    for (const candidat of lastCandidats) {
      const bienvenueMessage = formatBienvenue(candidat);
      await sendMessageSafely(candidat.Id_chat, bienvenueMessage.text, bienvenueMessage.options);
      await sleep(5000);
      await retry(() => validerBienvenue(candidat.Id_chat));
    }

    console.log("Envoi des messages de bienvenue terminé.");
  } catch (error) {
    console.error(`Erreur lors de la vérification des nouveaux candidats [${NewCandidatApiUrl}]:`, error.message);
  }
};

// Vérifier et envoyer les messages d'expiration d'abonnement
const checkAndSendAbonnement = async () => {
  try {
    console.log("Vérification des expirations dpour crédits inférieur à 10...");
    const response = await retry(() => axios.get(ExpirationCandidatApiUrl));
    const lastCandidats = response.data.candidats || [];

    if (lastCandidats.length === 0) {
      console.log("Aucun nouveau candidat trouvé pour expiration abonnement.");
      return;
    }

    console.log(`${lastCandidats.length} nouveaux candidats trouvés pour expiration abonnement.`);

    for (const candidat of lastCandidats) {
      await sendMessageSafely(
        candidat.Id_chat,
        `Bonjour *${candidat.Nom} ${candidat.Prenom}* \n\n` +
        `Nous venons par ce message vous informer que votre solde de crédits va bientôt expirer .\n\n` +
        `Pensez à recharger votre compte . Cliquez sur la commande /abonnement pour accéder aux différents plans `
      );
      await sleep(5000);
      await retry(() => validerExpiration(candidat.Id_chat));
    }

    console.log("Envoi des messages d'expiration terminé.");
  } catch (error) {
    console.error(`Erreur lors de la vérification des expirations [${ExpirationCandidatApiUrl}]:`, error.message);
  }
};

// Vérifier et envoyer les messages
const checkAndSendMessages = async () => {
  try {
    console.log("Vérification des nouveaux messages...");
    const response = await retry(() => axios.get(messagesApiUrl));
    const lastMessages = response.data.messages || [];

    if (lastMessages.length === 0) {
      console.log("Aucun nouveau message.");
      return;
    }

    console.log(`${lastMessages.length} message(s) trouvée(s).`);

    for (const msg of lastMessages) {
      for (const utilisateur of msg.Candidats || []) {
        const jobMessageAbonne = formatConseilsAbonneHtml(msg, utilisateur);
        const jobMessageNonAbonne = formatConseilsNonAbonneHtml(msg, utilisateur);
        
        if (msg.Public === 2) {
          if (utilisateur.Is_abonned === 1) {
            await sendMessageSafely(utilisateur.Id_chat, jobMessageAbonne.text, jobMessageAbonne.options);
          } else {
            await sendMessageSafely(utilisateur.Id_chat, jobMessageNonAbonne.text, jobMessageNonAbonne.options);
          }
        } 

         if (msg.Public == 0 && utilisateur.Is_abonned == 0) {
          console.log("Envoie message renouvellement:"+utilisateur.Id_chat);//5336190258
          await sendMessageSafely(utilisateur.Id_chat, jobMessageNonAbonne.text, jobMessageNonAbonne.options);
        }

         if (msg.Public == 1 && utilisateur.Is_abonned == 1) {
          console.log("Envoie message conseils:"+utilisateur.Id_chat);
          await sendMessageSafely(utilisateur.Id_chat, jobMessageAbonne.text, jobMessageAbonne.options);
          //await sendMessageSafely("5336190258", jobMessageAbonne.text, jobMessageAbonne.options);
   
        }

        await sleep(1000);
        await retry(() => messageValidation(msg.Id));
        
      }
    }
    

    console.log("Envoi des messages terminé.");
  } catch (error) {
    console.error(`Erreur lors de la vérification des messages [${messagesApiUrl}]:`, error.message);
  }
};

// Planificateur générique avec intervalle configurable
const startScheduler = (name, fn, intervalMs) => {
  console.log(`🚀 Démarrage de ${name} (intervalle: ${intervalMs / 1000}s)`);

  const runCheck = async () => {
    try {
      console.log(`🕒 Exécution de ${name}...`);
      await fn();
    } catch (err) {
      console.error(`Erreur dans ${name}:`, err.message);
    } finally {
      setTimeout(runCheck, intervalMs);
    }
  };

  runCheck().catch(err => {
    console.error(`Erreur initiale dans ${name}:`, err.message);
  });
};

// Commande /start
/*
bot.onText(/\/start/, (msg) => {
  const chatId = msg.chat.id;
  console.log(`Nouveau démarrage pour chatId: ${chatId}`);
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Valider mon compte", url: `https://job-finder-bot.com/valider_compte/${chatId}` }]],
    },
    parse_mode: "Markdown",
  };

  sendPhotoSafely(chatId, "bienvenue.png", {
    caption: welcomeMessage,
    parse_mode: "Markdown",
    reply_markup: options.reply_markup,
    contentType: "image/png",
  });
});
*/

bot.onText(/\/start(?:\s+(.+))?/, async (msg, match) => {
  const chatId = msg.chat.id;
  const parameter = match[1] || null; // Récupère le paramètre ou null s'il n'y en a pas
  console.log(`Nouveau démarrage pour chatId: ${chatId}, Paramètre: ${parameter}`);

  // Vérifie si le paramètre n'est pas égal à "0"
  if (parameter && parameter !== "0") {
    try {
      await goCandidat(chatId, parameter); // Lance la fonction goCandidat si paramètre != 0
    } catch (error) {
      console.error(`Erreur dans goCandidat pour chatId ${chatId}:`, error);
    }
  }

  //console.log(`Nouveau démarrage pour chatId: ${chatId}`);
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Mon espace candidat", url: `https://job-finder-bot.com/home/compte/${chatId}` }]],
    },
    parse_mode: "Markdown",
  };

  sendPhotoSafely(chatId, "bienvenue.png", {
    caption: welcomeMessage,
    parse_mode: "Markdown",
    reply_markup: options.reply_markup,
    contentType: "image/png",
  });
  
});

// Commande /inscription
bot.onText(/\/inscription/, (msg) => {
  const chatId = msg.chat.id;
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Inscription", url: `https://job-finder-bot.com/inscription/${chatId}` }]],
    },
    parse_mode: "Markdown",
  };

  sendPhotoSafely(chatId, "accueil.png", {
    caption: "📝 Veuillez cliquer sur le bouton ci-dessous pour vous inscrire et profitez de **5 jours gratuits** !",
    parse_mode: "Markdown",
    reply_markup: options.reply_markup,
    contentType: "image/png",
  });
});

// Commande /contact
bot.onText(/\/contact/, (msg) => {
  const chatId = msg.chat.id;
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Ecrivez-nous ici", url: `https://t.me/JobfinderAI` }]],
    },
    parse_mode: "Markdown",
  };

  sendPhotoSafely(chatId, "contact.png", {
    caption: "📝 Vous avez des questions? Ecrivez-nous en cliquant sur le bouton suivant !",
    parse_mode: "Markdown",
    reply_markup: options.reply_markup,
    contentType: "image/png",
  });
});

// Commande /gagner_abonnement
bot.onText(/\/gagner_abonnement/, (msg) => {
  const chatId = msg.chat.id;
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Votre lien d'affiliation", url: `https://job-finder-bot.com/go/${chatId}` }]],
    },
    parse_mode: "Markdown",
  };

  sendPhotoSafely(chatId, "contact.png", {
    caption: `🎁 Partagez votre lien d'affiliation suivant avec vos amis et gagnez *2 jours d'abonnement* pour chaque ami qui crée et valide son compte ! \n*Lien d'affiliation:* https://job-finder-bot.com/go/${chatId}`,
    parse_mode: "Markdown",
    reply_markup: options.reply_markup,
    contentType: "image/png",
  });
});

// Commande /analyse_marche
bot.onText(/\/analyse_marche/, async (msg) => {
  const chatId = msg.chat.id;
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Consulter les besoins du marché", url: `https://job-finder-bot.com/statistiques_marche/${chatId}` }]],
    },
    parse_mode: "Markdown",
  };

  try {
    const test_validation = await retry(() => checkValidation(chatId));
    if (test_validation === 0) {
      sendMessageSafely(chatId, "📝 Vous devez d'abord valider votre compte !\nMerci");
    } else {
      sendPhotoSafely(chatId, "contact.png", {
        caption: "Soyez à jour des besoins du marché grâce à nos statistiques journaliers.\n\nPour connaître la liste des spécialités les plus recherchées actuellement dans votre *pays*, veuillez cliquer sur le bouton suivant.",
        parse_mode: "Markdown",
        reply_markup: options.reply_markup,
        contentType: "image/png",
      });
    }
  } catch (error) {
    console.error(`Erreur lors de la vérification de validation pour /analyse_marche [${chatId}]:`, error.message);
  }
});

// Commande /validation
bot.onText(/\/validation/, async (msg) => {
  const chatId = msg.chat.id;
  const options = {
    reply_markup: {
      inline_keyboard: [[{ text: "📝 Valider mon compte", url: `https://job-finder-bot.com/valider_compte/${chatId}` }]],
    },
    parse_mode: "Markdown",
  };

  try {
    const test_validation = await retry(() => checkValidation(chatId));
    if (test_validation === 0) {
      sendPhotoSafely(chatId, "validation.png", {
        caption: "📝 Pour valider votre compte et commencer à recevoir les offres, veuillez cliquer sur le bouton suivant !",
        parse_mode: "Markdown",
        reply_markup: options.reply_markup,
        contentType: "image/png",
      });
    } else {
      sendMessageSafely(chatId, "📝 Votre compte a déjà été validé !\nMerci");
    }
  } catch (error) {
    sendMessageSafely(chatId, "⚠️ *Erreur* : Impossible de vérifier la validation. Réessayez plus tard.");
  }
});

// Commande /compte
bot.onText(/\/compte/, async (msg) => {
  const chatId = msg.chat.id;

  try {
    const test_validation = await retry(() => checkValidation(chatId));
    const infos = await retry(() => infosCompte(chatId));
    let date_expiration = convertDateFormat(infos.Expiration_abonnement);

      sendMessageSafely(
        chatId,
        `📝 *Mon profil*\n\n` +
        `*Nom:* ${infos.Nom} ${infos.Prenom}\n` +
        `*Email:* ${infos.Email}\n` +
        `*Téléphone:* ${infos.Telephone}\n` +
        `*Spécialité:* ${infos.Specialite}\n` +
        `*Crédits restants:* ${infos.Credits} crédits\n`,

        {
          parse_mode: "Markdown",
          reply_markup: {
            inline_keyboard: [[{ text: "🪪 Accédez à votre espace candidat", url: `https://job-finder-bot.com/home/mon_profil/${chatId}` }]],
          },
        }
      );
    
  } catch (error) {
    sendMessageSafely(chatId, "⚠️ *Erreur* : Impossible d'afficher les informations du compte. Réessayez plus tard.");
  }
});

bot.onText(/\/affiliation/, async (msg) => {
  const chatId = msg.chat.id;

  try {
    const test_validation = await retry(() => checkValidation(chatId));
    const infos = await retry(() => infosCompte(chatId));
    let date_expiration = convertDateFormat(infos.Expiration_abonnement);

      sendMessageSafely(
        chatId,
        `📝 Partagez votre code d'affiliation avec vos amis et gagnez des commissions lorsque que votre fieul charge au minimum *5000FCFA* de crédit\n\nVotre code d'affiliation est: *${chatId}*`,

        {
          parse_mode: "Markdown",
          reply_markup: {
            inline_keyboard: [[{ text: "🪪 Accédez à votre espace candidat", url: `https://job-finder-bot.com/home/mon_profil/${chatId}` }]],
          },
        }
      );
    
  } catch (error) {
    sendMessageSafely(chatId, "⚠️ *Erreur* : Impossible d'afficher les informations du compte. Réessayez plus tard.");
  }
});

bot.onText(/\/groupe/, async (msg) => {
  const chatId = msg.chat.id;

  try {
    const test_validation = await retry(() => checkValidation(chatId));
    const infos = await retry(() => infosCompte(chatId));
    let date_expiration = convertDateFormat(infos.Expiration_abonnement);

      sendMessageSafely(
        chatId,
        `📝 Rejoignez notre *groupe VIP* pour être au courant des *nouveautés* et recevoir des *conseils en recrutement* en cliquant sur le lien:\nhttps://whatsapp.com/channel/0029Vb6mEyv29757bXLDBF0o.`,

        {
          parse_mode: "Markdown",
          reply_markup: {
            inline_keyboard: [[{ text: "🪪 Accédez à votre espace candidat", url: `https://job-finder-bot.com/home/mon_profil/${chatId}` }]],
          },
        }
      );
    
  } catch (error) {
    sendMessageSafely(chatId, "⚠️ *Erreur* : Impossible d'afficher les informations du compte. Réessayez plus tard.");
  }
});

// Conversion de la date
function convertDateFormat(dateString) {
  const date = new Date(dateString);
  const day = String(date.getDate()).padStart(2, "0");
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const year = date.getFullYear();
  return `${day}/${month}/${year}`;
}

// Commande /abonnement
bot.onText(/\/abonnement/, (msg) => {
  const chatId = msg.chat.id;
  const options = {
    reply_markup: {
      inline_keyboard: [
        [{ text: "🎯 200 crédits à 2500 FCFA", url: `https://oxnlkqwp.mychariow.store/prd_iqlq9w/checkout` }],
        [{ text: "🎯 300 crédits à 3500 FCFA", url: `https://oxnlkqwp.mychariow.store/prd_jmc1rq/checkout` }],
        [{ text: "🎯 500 crédits à 5000 FCFA", url: `https://oxnlkqwp.mychariow.store/prd_waghrz/checkout` }],
      ],
    },
    parse_mode: "Markdown",
  };

  sendPhotoSafely(chatId, "abonnement.png", {
    caption:
      `📝 Pour charger votre compte, veuillez choisir un de nos plans\n\n` +
      `✅ 200 crédits : *2500 FCFA*\n` +
      `✅ 300 crédits : *3500 FCFA*\n` +
      `✅ 500 crédits : *5000 FCFA*\n\nVeuillez faire un choix.`,
    parse_mode: "Markdown",
    reply_markup: options.reply_markup,
    contentType: "image/png",
  });
});

// Gestion des boutons inline
bot.on("callback_query", async (callbackQuery) => {
  const chatId = callbackQuery.message.chat.id;
  const data = callbackQuery.data;

  if (data === "inscription") {
    bot.sendMessage(chatId, "/inscription");
    bot.answerCallbackQuery(callbackQuery.id);
  } else if (data === "gagner_abonnement") {
    const options = {
      reply_markup: {
        inline_keyboard: [[{ text: "📝 Votre lien d'affiliation", url: `https://job-finder-bot.com/go/${chatId}` }]],
      },
      parse_mode: "Markdown",
    };

    sendPhotoSafely(chatId, "contact.png", {
      caption: `🎁 Partagez votre lien d'affiliation suivant avec vos amis et gagnez *2 jours d'abonnement* pour chaque ami qui crée et valide son compte !`,
      parse_mode: "Markdown",
      reply_markup: options.reply_markup,
      contentType: "image/png",
    });
    bot.answerCallbackQuery(callbackQuery.id);
  }
});

// Réponse aux messages avec OpenRouter
bot.on("message", async (msg) => {
  const chatId = msg.chat.id;
  const userMessage = msg.text;

  if (userMessage.startsWith("/")) return; // Ignore les commandes

  try {
    const response = await retry(() =>
      axios.post(
        "https://openrouter.ai/api/v1/chat/completions",
        {
          model: "mistral/ministral-8b",
          messages: [
            { role: "system", content: jobFinderPrompt },
            { role: "user", content: userMessage },
          ],
          max_tokens: 500,
        },
        {
          headers: {
            Authorization: `Bearer ${openRouterApiKey}`,
            "Content-Type": "application/json",
          },
        }
      )
    );

    const botResponse = response.data.choices[0].message.content.trim();
    await sendMessageSafely(chatId, botResponse);
  } catch (error) {
    console.error("Erreur avec OpenRouter:", error.response ? error.response.data : error.message);
    await sendMessageSafely(
      chatId,
      "⚠️ *Erreur* : Une erreur s’est produite. Veuillez réessayer ou contacter **hello@jobfinderbot.com**."
    );
  }
});

// Vérification de la validation
async function checkValidation(chatId) {
  try {
    const response = await axios.get(`https://job-finder-bot.com/home/chat_check/${chatId}`);
    return response.data.chatExist;
  } catch (error) {
    console.error(`Erreur lors de la requête GET [checkValidation, ${chatId}]:`, error.message);
    throw error;
  }
}

//Vérification du nombre de crédit
async function checkCredit(chatId) {
  try {
    const response = await axios.get(`https://job-finder-bot.com/home/credit_check/${chatId}`);
    return response.data.credits;
  } catch (error) {
    console.error(`Erreur lors de la requête GET [checkValidation, ${chatId}]:`, error.message);
    throw error;
  }
}

async function decompteCredit(chatId,idOffre) {
  try {
    const response = await axios.get(`https://job-finder-bot.com/home/decompte_credit/${chatId}/${idOffre}`);
    return response.data.credits;
  } catch (error) {
    console.error(`Erreur lors de la requête GET [checkValidation, ${chatId}]:`, error.message);
    throw error;
  }
}

// Informations du compte
async function infosCompte(chatId) {
  try {
    const response = await axios.get(`https://job-finder-bot.com/home/infos_compte/${chatId}`);
    return response.data.Infos;
  } catch (error) {
    console.error(`Erreur lors de la requête GET [infosCompte, ${chatId}]:`, error.message);
    throw error;
  }
}

// Validation de message
async function messageValidation(msgId) {
  try {
    const response = await axios.get(`https://job-finder-bot.com/home/valide_message/${msgId}`);
    return response.data.messageValide;
  } catch (error) {
    console.error(`Erreur lors de la requête GET [messageValidation, ${msgId}]:`, error.message);
    throw error;
  }
}

// Validation de candidat
async function validerCandidat(id_chat) {
  const url = "https://job-finder-bot.com/home/valider_candidat";
  const data = { id_chat };

  try {
    const response = await axios.post(url, data);
    console.log(`Candidat validé: ${response.data.validation}`);
    return response.data.validation;
  } catch (error) {
    console.error(`Erreur lors de la requête POST [validerCandidat, ${id_chat}]:`, error.message);
    throw error;
  }
}

// Go Candidat
async function goCandidat(id_chat,code) {
  const url = "https://job-finder-bot.com/home/go_candidat";
  const data = { id_chat ,code };

  try {
    const response = await axios.post(url, data);
    console.log(`Candidat validé: ${response.data.validation}`);
    return response.data.validation;
  } catch (error) {
    console.error(`Erreur lors de la requête POST [validerCandidat, ${id_chat}]:`, error.message);
    throw error;
  }
}

// Validation message de bienvenue
async function validerBienvenue(id_chat) {
  const url = "https://job-finder-bot.com/home/message_bienvenue";
  const data = { id_chat };

  try {
    const response = await axios.post(url, data);
    console.log(`Candidat Bienvenue: ${response.data.validation}`);
    return response.data.validation;
  } catch (error) {
    console.error(`Erreur lors de la requête POST [validerBienvenue, ${id_chat}]:`, error.message);
    throw error;
  }
}

// Validation expiration abonnement
async function validerExpiration(id_chat) {
  const url = "https://job-finder-bot.com/home/rappel_2jour";
  const data = { id_chat };

  try {
    const response = await axios.post(url, data);
    console.log(`Candidat Expiration Abonnement: ${response.data.validation}`);
    return response.data.validation;
  } catch (error) {
    console.error(`Erreur lors de la requête POST [validerExpiration, ${id_chat}]:`, error.message);
    throw error;
  }
}

// Validation du job
async function validateJob(id_offre) {
  const url = "https://job-finder-bot.com/home/valider_envoie";
  const data = { id_offre };

  try {
    const response = await axios.post(url, data);
    console.log(`Offre validée: ${response.data.id_offre}`);
    return response.data.id_offre;
  } catch (error) {
    console.error(`Erreur lors de la requête POST [validateJob, ${id_offre}]:`, error.message);
    throw error;
  }
}

// Handle polling errors
bot.on("polling_error", (error) => {
  console.error("Polling error:", error.message);
  setTimeout(() => bot.startPolling(), 10000);
});

// Main function
async function main() {
  try {
    console.log("🤖 JobFinderBot est en ligne !");

    // Attendre que la queue soit initialisée
    while (!queue) {
      await new Promise((resolve) => setTimeout(resolve, 100));
    }

    // Planificateurs avec intervalles ajustés
    startScheduler("JobCheckScheduler", checkAndSendNewJobs, 5 * 60 * 1000); // 5 minutes
    startScheduler("FirstJobScheduler", checkAndSendFirstJobs, 10 * 60 * 1000); // 10 minutes
    startScheduler("MessageScheduler", checkAndSendMessages, 4 * 60 * 1000); // 15 minutes
    startScheduler("BienvenueScheduler", checkAndSendBienvenue, 1 * 60 * 1000); // 1 minutes
    startScheduler("AbonnementScheduler", checkAndSendAbonnement, 30 * 60 * 1000); // 30 minutes

  } catch (error) {
    console.error("Erreur au démarrage:", error.message);
    process.exit(1);
  }
}

// Start the bot
main();