<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends MY_Controller {


	       public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->data['base_url'] = base_url();
		     $this->data['assets_front'] =base_url()."assets/front";
		     $this->data['assets_admin'] =base_url()."assets/admin";
		     $this->data['assets_mail']  = base_url()."assets/mail";
		     $this->data['current_year']  =date("Y");
		     $this->data['mois_en_cours']  =date("m/Y");
		     $this->data['date_du_jour']  =date("d/m/Y");
		     $this->data['role_utilisateur']  = $this->session->userdata('role');

		     $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];

		    
		    } 

		    public function dashboard(){
             
		      
               $this->data['dashboard'] =1;
               $chiffre_affaire_mois =$this->vente->get_total_ttc_mois(date("Y-m"));
               $this->data['chiffre_affaire_mois']  =$chiffre_affaire_mois;
               $total_produits_vendus =$this->vente->get_total_produits_vendus_mois(date("Y-m"));
               $this->data['total_produits_vendus']  =$total_produits_vendus;
               $total_produits_vendus_jour =$this->vente->get_total_ttc_jour(date("Y-m-d"));
               $this->data['total_produits_vendus_jour'] =$total_produits_vendus_jour;
               $total_clients =$this->contact->total_clients();
               $this->data['total_clients'] =$total_clients;

               $total_contact_mois =$this->contact->total_contacts_periode(date("m/Y"));
               $this->data['total_contacts_acquis_mois'] =$total_contact_mois;
               $this->data['mois_en_cours']=date("m/Y"); 
		       $this->twig->display('dashboard/dashboard.html.twig',$this->data);
		    }

		    public function configuration_societe(){

		       if(isset($_POST["raison_sociale"]) and $_POST["raison_sociale"]!=""){

		       	  
		       	  if($_POST["id"]!=""){


		       	  	 $file="";
					 if(!empty($_FILES)) {


					  	   if(is_uploaded_file($_FILES['cachet']['tmp_name'])) {

					  	   	       $reference=time();
			                       $sourcePath = $_FILES['cachet']['tmp_name'];
			                       $image=$_FILES['cachet']['name'];
			                       $tabimg=explode('.',$image);
			                       $extension = strtolower(end($tabimg));
			                       $file=$reference.".".$extension;
			                       $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
			                       if(in_array($extension,$liste_extensions)){
			                       	$targetPath = "uploads/".$reference.".".$extension;
			                        move_uploaded_file($sourcePath,$targetPath);

			                        $donnes_societe = array("Cachet"=>$file);
			                        $this->societe->update($_POST["id"], $donnes_societe);


			                       }

					  	   }

					  }

		       	  	 $donnes_societe = array("Raison_sociale"=>$_POST["raison_sociale"],
		       	                           "Logo"=>$_POST["nom_logo"],
		       	                           "Nom_gerant"=>$_POST["nom_gerant"],
		       	                           "Pays"=>$_POST["pays"],
		       	                           "Devise"=>$_POST["devise"],
		       	                           "Telephone"=>$_POST["telephone"],
		       	                           "Whatsapp"=>$_POST["whatsapp"],
		       	                           "Email"=>$_POST["email"],
		       	                           "Adresse"=>$_POST["adresse"],
		       	                           "Site_web"=>$_POST["site_web"],
		       	                           "Facebook"=>$_POST["facebook"],
		       	                           "Linkedin"=>$_POST["linkedin"],
		       	                           "Couleur_documents"=>$_POST["couleur"],
		       	                           "Mentions_legales"=>$_POST["mentions_legales"],
		       	                           "Banque"=>$_POST["banque"],
		       	                           "Code_swift"=>$_POST["swift"],
		       	                           "IBAN"=>$_POST["iban"],
		       	                           "Solde"=>$_POST["solde"]
		       	                       );

		       	  	 $this->societe->update($_POST["id"], $donnes_societe);


		       	  }else{

		       	  	  $file="";
					  if(!empty($_FILES)) {


					  	   if(is_uploaded_file($_FILES['cachet']['tmp_name'])) {

					  	   	       $reference=time();
			                       $sourcePath = $_FILES['cachet']['tmp_name'];
			                       $image=$_FILES['cachet']['name'];
			                       $tabimg=explode('.',$image);
			                       $extension = strtolower(end($tabimg));
			                       $file=$reference.".".$extension;
			                       $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
			                       if(in_array($extension,$liste_extensions)){
			                       	$targetPath = "uploads/".$reference.".".$extension;
			                        move_uploaded_file($sourcePath,$targetPath);

			                        $donnes_logo = array("Logo"=>$file);
			                        $this->tiers->updateRecord($_POST["id"], $donnes_logo);


			                       }

					  	   }

					  }

		       	  	 $donnes_societe = array("Raison_sociale"=>$_POST["raison_sociale"],
		       	                           "Logo"=>$_POST["nom_logo"],
		       	                           "Nom_gerant"=>$_POST["nom_gerant"],
		       	                           "Pays"=>$_POST["pays"],
		       	                           "Devise"=>$_POST["devise"],
		       	                           "Solde"=>$_POST["solde"],
		       	                           "Telephone"=>$_POST["telephone"],
		       	                           "Whatsapp"=>$_POST["whatsapp"],
		       	                           "Email"=>$_POST["email"],
		       	                           "Adresse"=>$_POST["adresse"],
		       	                           "Site_web"=>$_POST["site_web"],
		       	                           "Facebook"=>$_POST["facebook"],
		       	                           "Linkedin"=>$_POST["linkedin"],
		       	                           "Couleur_documents"=>$_POST["couleur"],
		       	                           "Cachet"=>$file,
		       	                           "Mentions_legales"=>$_POST["mentions_legales"],
		       	                           "Banque"=>$_POST["banque"],
		       	                           "Code_swift"=>$_POST["swift"],
		       	                           "IBAN"=>$_POST["iban"],
		       	                           "Solde"=>$_POST["solde"]
		       	                       );
		       	      $this->societe->insert($donnes_societe);

		       	      $donnes_numerotation=array(

		       	      	"Prefixe_devis"=>"",
		       	      	"Compteur_bon_commande_client"=>0,
		       	      	"Prefixe_bon_commande_client"=>"",
		       	      	"Compteur_devis"=>0,
		       	      	"Prefixe_bon_livraison_client"=>"",
		       	      	"Compteur_bon_livraison"=>0,
		       	      	"Prefixe_facture_client"=>"",
		       	      	"Compteur_facture_client"=>0,
		       	      	"Prefixe_bon_commande_fournisseur"=>"",
		       	      	"Compteur_bon_commande_fournisseur"=>0,
		       	      	"Prefixe_bon_reception_fournisseur"=>"",
		       	      	"Compteur_bon_reception_fournisseur"=>0,
		       	      	"Format_date"=>"",
		       	      	"Separateur"=>"",
		       	      	"Taille_reference"=>5,
		       	      	"Ordre_reference"=>""

		       	      );

		       	      $this->numerotation->insert($donnes_numerotation);

		       	      $donnes_comptes_comptables = array(

		       	      	"Ventes_marchandides"=>701,
		       	      	"Ventes_produits_finis"=>707,
		       	      	"Prestations_services"=>706,
		       	      	"Clients_montant_ttc"=>411,
		       	      	"Clients_avances_acomptes"=>419,
		       	      	"Tva_collectee"=> 4457,
		       	      	"Tva_a_regulariser"=> 4458,
		       	      	"Banque"=> 512,
		       	      	"Caisse"=> 53,
		       	      	"Achats_stockes_matieres_premieres"=> 601,
		       	      	"Achats_marchandises"=> 607,
		       	      	"Achats_non_stockes"=> 606,
		       	      	"Fournisseur_montant_ttc"=> 401,
		       	      	"Fournisseurs_avances_acomptes"=> 409,
		       	      	"TVA_deductible_biens_services"=> 4456,
		       	      	"TVA_deductible_immobilisations"=> 44562


		       	      );

		       	      $this->comptes_comptables->insert($donnes_comptes_comptables);

		       	  }


		       	   
		       	  redirect("admin/gestion_configuration/1");
		       }

		       $liste_pays =$this->utilisateur->liste_pays();
		       $this->data['liste_pays'] =$liste_pays;
		       $liste_devises =$this->utilisateur->liste_devises();
		       $this->data['liste_devises'] =$liste_devises;
		      
               $this->data['ajout'] =1;
               $infos_societe =$this->societe->get_all();
               if(count( $infos_societe)==0){
               	$this->data['config'] =0;
               }else{
               	$this->data['config'] =1;
               }
               
		       $this->twig->display('configuration/config_societe.html.twig',$this->data);
		    }

		    public function configuration_email(){

		    	if(isset($_POST["serveur_smtp"]) and $_POST["serveur_smtp"]!="" ){


		    		$donnes_mail_societe = array(

		    			"Serveur_smtp"=>$_POST["serveur_smtp"],
		    			"Port_smtp"=>$_POST["port"],
		    			"Securite_mail"=>$_POST["methode_securite"],
		    			"Expediteur_mail"=>$_POST["nom_expediteur"],
		    			"Utilisateur_smtp"=>$_POST["nom_utilisateur"],
		    			"Password_smtp"=>$_POST["password_smtp"]
		    		);

		    		$this->societe->update($_POST["id"], $donnes_mail_societe);
		    		 redirect("admin/gestion_configuration/1");

		    	}
		    	
                $infos_societe =$this->societe->get_all();
                $this->data['infos_societe'] =$infos_societe[0];
                $this->data['config'] =1;
                $this->twig->display('configuration/config_email.html.twig',$this->data);

		    }

		    public function configuration_numerotations(){

		    	if(isset($_POST["id"]) and $_POST["id"]!=""){

		    		  $donnes_numerotation=array(

		       	      	"Prefixe_devis"=>$_POST["prefixe_devis"],
		       	      	"Compteur_devis"=>$_POST["compteur_devis"],
		       	      	"Prefixe_bon_commande_client"=>$_POST["prefixe_bon_commande_client"],
		       	      	"Compteur_bon_commande_client"=>$_POST["compteur_bon_commande_client"],
		       	      	"Prefixe_bon_livraison_client"=>$_POST["prefixe_bon_livraison"],
		       	      	"Compteur_bon_livraison"=>$_POST["compteur_bon_livraison"],
		       	      	"Prefixe_facture_client"=>$_POST["prefixe_facture_client"],
		       	      	"Compteur_facture_client"=>$_POST["compteur_facture_client"],
		       	      	"Prefixe_bon_commande_fournisseur"=>$_POST["prefixe_bon_commande_fournisseur"],
		       	      	"Compteur_bon_commande_fournisseur"=>$_POST["compteur_bon_commande_client"],
		       	      	"Prefixe_bon_reception_fournisseur"=>$_POST["prefixe_bon_reception_fournisseur"],
		       	      	"Compteur_bon_reception_fournisseur"=>$_POST["compteur_reception_fournisseur"],
		       	      	"Format_date"=>$_POST["format_date"],
		       	      	"Separateur"=>$_POST["separateur"],
		       	      	"Taille_reference"=>$_POST["taille_reference"],
		       	      	"Ordre_reference"=>$_POST["ordre_reference"]
		       	      );

		       	      $this->numerotation->update($_POST["id"], $donnes_numerotation);
		       	      redirect("admin/gestion_configuration/1");

		    	}
                $infos_numerotation=$this->numerotation->get_all();
                $this->data['infos_numerotation'] =$infos_numerotation[0];
                $this->data['config'] =1;
		    	$this->twig->display('configuration/config_numerotations.html.twig',$this->data);
		    }

		     public function configuration_comptes_comptable(){

		    	if(isset($_POST["vente_marchandises"]) and $_POST["vente_marchandises"]!="" ){


		    		$donnes_comptes_comptables = array(

		       	      	"Ventes_marchandides"=>$_POST["vente_marchandises"],
		       	      	"Ventes_produits_finis"=>$_POST["vente_produits_finis"],
		       	      	"Prestations_services"=>$_POST["prestation_services"],
		       	      	"Clients_montant_ttc"=>$_POST["client_montant_ttc"],
		       	      	"Clients_avances_acomptes"=>$_POST["client_acomptes_avances"],
		       	      	"Tva_collectee"=> $_POST["tva_collectee"],
		       	      	"Tva_a_regulariser"=> $_POST["tva_collectee"],
		       	      	"Banque"=> $_POST["banque"],
		       	      	"Caisse"=> $_POST["caisse"],
		       	      	"Achats_stockes_matieres_premieres"=> $_POST["achats_stockes_matieres_premieres"],
		       	      	"Achats_marchandises"=> $_POST["achat_marchandise"],
		       	      	"Achats_non_stockes"=> $_POST["achat_non_stocke"],
		       	      	"Fournisseur_montant_ttc"=> $_POST["fournisseur_montant_ttc"],
		       	      	"Fournisseurs_avances_acomptes"=> $_POST["fournisseur_avance"],
		       	      	"TVA_deductible_biens_services"=> $_POST["tva_deductible_autres_bien"],
		       	      	"TVA_deductible_immobilisations"=> $_POST["tva_deductible_immobilisation"]
		       	      );

		    		$this->comptes_comptable->update($_POST["id"], $donnes_comptes_comptables);
		    		 redirect("admin/gestion_configuration/1");

		    	}
		    	
                $infos_comptes_comptable =$this->comptes_comptable->get_all();
                $this->data['infos_comptes_comptable'] =$infos_comptes_comptable[0];
                $this->data['config'] =1;
                $this->twig->display('configuration/config_comptes_comptable.html.twig',$this->data);

		    }

		    public function gestion_configuration($msg=0){

               $infos_societe =$this->societe->get_all();
               $this->data['id_societe'] =$infos_societe[0]->Id;
               $this->data['msg'] =$msg;
               $this->data['config'] =1;
               $this->twig->display('configuration/gestion_configuration.html.twig',$this->data);

		    }

		    public function liste_ventes_mois(){


		    	$liste_des_ventes = $this->vente->liste_factures_client_mois(date("Y-m"));
		    	$this->data['liste_des_ventes'] =$liste_des_ventes;

		    	$chiffre_affaire_mois =$this->vente->get_total_ttc_mois(date("Y-m"));
                $this->data['chiffre_affaire_mois']  =$chiffre_affaire_mois;

                $mois_en_cours =date("m/Y");
                $this->data['mois_en_cours']  =$mois_en_cours;
                $total_produits_vendus =$this->vente->get_total_produits_vendus_mois(date("Y-m"));
                $this->data['total_produits_vendus']  =$total_produits_vendus;
                $this->data['config'] =1;

		    	$this->twig->display('gestion_commerciale/liste_ventes_mois.html.twig',$this->data);
		    }

		    public function liste_ventes_du_jour(){

		    	$liste_des_ventes = $this->vente->liste_factures_client_mois(date("Y-m-d"));
		    	$this->data['liste_des_ventes'] =$liste_des_ventes;

		    	$chiffre_affaire_mois =$this->vente->get_total_ttc_mois(date("Y-m-d"));
                $this->data['chiffre_affaire_mois']  =$chiffre_affaire_mois;
                $total_produits_vendus =$this->vente->get_total_produits_vendus_mois(date("Y-m-d"));
                $this->data['total_produits_vendus']  =$total_produits_vendus;

                $this->data['jour_en_cours']  =date("d/m/Y");

                $this->twig->display('gestion_commerciale/liste_ventes_du_jour.html.twig',$this->data);

		    }

		    public function liste_devis_validees_mois(){

		    	$liste_devis =$this->vente->liste_transactions_client_mois("Devis",date("Y-m"),"Validé");
                $mois_en_cours = date("m/Y");
		    	$this->data['liste_devis']  = $liste_devis;
		    	$this->data['mois_en_cours']  =$mois_en_cours;

		    	$this->twig->display('gestion_commerciale/liste_devis_du_mois.html.twig',$this->data);

		    }


		    public function liste_commandes_validees_mois(){

                $liste_commandes =$this->vente->liste_transactions_client_mois("Bon_commande",date("Y-m"),"Validé");
                $this->data['liste_commandes']  =$liste_commandes; 
                $this->twig->display('gestion_commerciale/liste_commandes_validees_mois.html.twig',$this->data);
		    }

		    public function liste_commandes_fournisseur_mois(){

                $liste_commandes_fournisseur =$this->achat->liste_commandes_fournisseur_mois(date("Y-m"));
                $mois_en_cours = date("m/Y");
		    	$this->data['liste_commandes_fournisseur']  = $liste_commandes_fournisseur;
		    	$this->data['mois_en_cours']  =$mois_en_cours;

		    	$this->twig->display('gestion_commerciale/liste_commandes_fournisseur_mois.html.twig',$this->data);
		    }

		    public function infos_societe(){

		    	$liste_pays =$this->utilisateur->liste_pays();
		        $this->data['liste_pays'] =$liste_pays;
		        $liste_devises =$this->utilisateur->liste_devises();
		        $this->data['liste_devises'] =$liste_devises;

                $infos_societe =$this->societe->get_all();
                $this->data['infos_societe'] =$infos_societe[0];
                $this->data['ajout'] =0;
                $this->data['config'] =1;

                $this->twig->display('configuration/config_societe.html.twig',$this->data);
		    }

		    function generateInvoiceReference($prefixe,$separateur,$format_date,$pattern, $compteur,$taille_compteur) {

		      $pattern_devis  =  str_replace("[date]",$format_date,$pattern);
              $pattern_devis  =  str_replace("[préfixe]",$prefixe,$pattern_devis);
              $pattern_devis  =  str_replace("[separateur]",$separateur,$pattern_devis);

			  $pattern_devis  =  str_replace("{yyyy}",date("Y"),$pattern_devis);
		      $pattern_devis  =  str_replace("{mm}",date("m"),$pattern_devis );
		      $pattern_devis  =  str_replace("{dd}",date("d"),$pattern_devis );
		      $pattern_devis  =  str_replace("{yy}",substr(date("Y"), -2),$pattern_devis );
		      $chiffre = str_pad($compteur,$taille_compteur, "0", STR_PAD_LEFT);
		      $pattern_devis  =  str_replace("[compteur]",$chiffre,$pattern_devis);
			    
			    return $pattern_devis;
			}

			public function configuration_roles($msg=0){
               $liste_roles = $this->role->get_all();

               if(isset($_POST["libelle_role"]) and $_POST["libelle_role"]!=""){

               	$liste_roles =$this->role->get_by_libelle($_POST["libelle_role"]);
               }
               $this->data['liste_roles'] =$liste_roles;
               $this->data['msg'] =$msg;
               $this->data['config'] =1;
               $this->twig->display('configuration/config_roles.html.twig',$this->data);

		    }

		    public function configuration_utilisateurs($msg=0,$page=1){

            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->utilisateur->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->utilisateur->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->utilisateur->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->utilisateur->recherche($_POST["mot_cle"]);

	         }

           //$liste_utilisateurs = $this->utilisateur->get_all();
           $this->data['liste_utilisateurs'] =$liste;
           $liste_roles = $this->role->get_all();
           $this->data['msg'] =$msg;
           $this->data['liste_roles'] =$liste_roles;
           $this->data['total_suivant'] =$total_suivant;
           $this->data['config'] =1;
           $this->twig->display('configuration/config_utilisateurs.html.twig',$this->data);

		    }

		     public function ajout_utilisateur($id=-1){

		     	$bcrypt = new Bcrypt();
		        $bcrypt_version = '2a';

		     	if(isset($_POST["nom"]) and  $_POST["nom"]!=""){


		     		if(isset($_POST["id"]) and $_POST["id"]!=""){


		     			    $donnes_utilisateur = array(

				     			"Nom"=>$_POST["nom"],
				     			"Prenom"=>$_POST["prenom"],
				     			"Telephone"=>$_POST["telephone"],
				     			"Email"=>$_POST["email"],
				     			"Etat"=>$_POST["etat"],
			     			    "Id_compte_associe"=>$_POST["compte_associe"],
				     			"Role"=>$_POST["role"],
				     			"Id_annexe"=>$_POST["annexe"]
				     		);

				     		$this->utilisateur->update($_POST["id"], $donnes_utilisateur);

				     		if($_POST["password"]!=""){


				     			$donnes_password = array("Password"=>$bcrypt->crypt($_POST["password"]));
				     			$this->utilisateur->update($_POST["id"],$donnes_password);
				     		}


		     		}else{

		     			    

				     		$donnes_utilisateur = array(

				     			"Date_creation"=>date("d/m/Y"),
				     			"Nom"=>$_POST["nom"],
				     			"Prenom"=>$_POST["prenom"],
				     			"Telephone"=>$_POST["telephone"],
				     			"Email"=>$_POST["email"],
				     			"Id_compte_associe"=>$_POST["compte_associe"],
				     			"Password"=>$bcrypt->crypt($_POST["password"]),
				     			"Etat"=>$_POST["etat"],
				     			"Role"=>$_POST["role"],
				     			"Id_annexe"=>$_POST["annexe"]
				     		);

				     		$this->utilisateur->insert($donnes_utilisateur);


		     		}

		     		redirect("admin/configuration_utilisateurs/1");

		     		
		     	}
               
               $this->data['id'] =$id;
               if($id!=-1){

               	$infos_utilisateur = $this->utilisateur->get_by_id($id);
               	$this->data['infos_utilisateur'] =$infos_utilisateur;

               }
               
               $liste_roles = $this->role->get_all();
               $this->data['liste_roles'] =$liste_roles;
               $this->data['config'] =1;
               $liste_comptes_bancaires =$this->compte_bancaire->get_all();
               $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;
               $liste_annexes = $this->annexe->get_all();
               $this->data['liste_annexes'] =$liste_annexes;
               
               $this->twig->display('configuration/ajout_utilisateur.html.twig',$this->data);

		    }

		    public function supprimer_utilisateur($id){

		    	$this->utilisateur->delete($id);
		    	redirect("admin/configuration_utilisateurs/1");

		    }

		    public function ajouter_role($id=-1){

		    	if(isset($_POST["libelle_role"]) and $_POST["libelle_role"]!=""){


		    		if(isset($_POST["id"]) and $_POST["id"]!=""){


		    			  $donnes_role =array("Libelle"=>$_POST["libelle_role"]);
		    			  $this->role->update($_POST["id"], $donnes_role);

		    			  $this->role->supprimer_actions_role($_POST["id"]);

		    			  $liste_actions =$_POST["liste_actions"];
				    		foreach($liste_actions as $action ){

				    			$donnes_action =array("Id_role"=>$_POST["id"],"Id_action"=>$action);
				    			$this->role->ajout_action_role($donnes_action);
				    		}



		    		}else{

		    			 	$donnes_role = array("Reference"=>"R".time(),
				    			"Libelle"=>$_POST["libelle_role"]);
				    		$id_role=$this->role->insert($donnes_role);

				    		$liste_actions =$_POST["liste_actions"];
				    		foreach($liste_actions as $action ){

				    			$donnes_action =array("Id_role"=>$id_role,"Id_action"=>$action);
				    			$this->role->ajout_action_role($donnes_action);
				    		}


		    		}

		    	

		    		redirect("admin/gestion_configuration/1");
		    	}

		    	if($id!=-1){

		    		$infos_role=$this->role->get_by_id($id);
		    		$this->data['infos_role'] =$infos_role;
		    		$liste_actions = $this->role->liste_actions_role($id);
		    		$this->data['liste_actions'] = $liste_actions;

		    	}else{

		    		$this->data['liste_actions'] =array();

		    	}

		    	$this->data['id'] =$id;

		    	$liste_des_modules = $this->modules->liste_modules();
		    	$this->data['liste_des_modules'] =$liste_des_modules;
		    	$this->data['config'] =1;

                $this->twig->display('configuration/ajout_role.html.twig',$this->data);

		    }

		    public function supprimer_role($id_role){

		    	$this->role->supprimer_actions_role($id_role);
		    	$this->role->delete($id_role);

		    	redirect("admin/configuration_roles");

		    }

		    public function  profil(){

		    	$infos_utilisateur = $this->utilisateur->get_by_id($this->session->userdata('id_utilisateur'));
		    	$this->data['infos_utilisateur'] =$infos_utilisateur;

		    	if($infos_utilisateur->Role==-1){
		    		$this->data['role'] ="Administrateur";
		    	}else{
		    		$infos_role =$this->role->get_by_id($infos_utilisateur->Role);
		    		$this->data['role'] =$infos_role->Libelle;

		    	}

		    	$this->twig->display('configuration/profil.html.twig',$this->data);
		    	
		    }


		     function convertDateFormat($date) {
			    $timestamp = strtotime($date);
			    return date("d/m/Y", $timestamp);
			}
}