<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends CI_Controller {


			public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->load->helper('url');

		    } 

		   public function upload_logo(){

		   	  header('Content-Type: application/json');

			// Check if a file was uploaded and there are no errors
			if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
			    // Validate file type
			    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
			    if (!in_array($_FILES['logo']['type'], $allowedTypes)) {
			        echo json_encode(['success' => false, 'error' => 'Type de fichier non supporté. Seuls JPEG, PNG et GIF sont autorisés.']);
			        exit;
			    }

			    // Validate file size (5MB max)
			    $maxSize = 5 * 1024 * 1024; // 5MB in bytes
			    if ($_FILES['logo']['size'] > $maxSize) {
			        echo json_encode(['success' => false, 'error' => 'Fichier trop volumineux. La taille maximale est de 5 Mo.']);
			        exit;
			    }

			    // Define upload directory and ensure it exists
			    $uploadDir = 'uploads/logos/';
			    if (!is_dir($uploadDir)) {
			        mkdir($uploadDir, 0777, true);
			    }

			    // Generate a unique filename to avoid conflicts
			    $fileName = time() . '_' . basename($_FILES['logo']['name']);
			    $targetPath = $uploadDir . $fileName;

			    // Move the uploaded file to the target directory
			    if (move_uploaded_file($_FILES['logo']['tmp_name'], $targetPath)) {
			        // Return the URL of the uploaded image (adjust base URL as needed)
			        $baseUrl = ""; // Modify this based on your server configuration
			        $url = $baseUrl . $targetPath;
			        echo json_encode(['success' => true, 'url' => $url]);
			    } else {
			        echo json_encode(['success' => false, 'error' => 'Échec du déplacement du fichier.']);
			    }
			} else {
			    echo json_encode(['success' => false, 'error' => 'Aucun fichier reçu ou erreur lors de l\'upload.']);
			}


		   }

		   public function upload_fichiers_logement($reference_produit){

		   	 $this->data['base_url'] = base_url();
		     if(!empty($_FILES)) {

			  $files = $_FILES["photos"];



			  for ($i = 0; $i < count($files["name"]); $i++) {
                $file="";
			  	$reference=$i.time();
			  	$sourcePath = $files["tmp_name"][$i];
			  	$image=$files["name"][$i];
			  	$tabimg=explode('.',$image);
			  	$extension = strtolower(end($tabimg));
                $file=$reference.".".$extension;
                $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
                if(in_array($extension,$liste_extensions)){
	               	$targetPath = "uploads/".$reference.".".$extension;
	                move_uploaded_file($sourcePath,$targetPath);

	                $donnes_photos = array("Image"=>$file,"Reference_produit"=>$reference_produit);
	                $test = $this->images_produits->testReference($reference_produit,$file);

	                if($test==0){
	                	$this->images_produits->insert($donnes_photos);
	                }
	                

	               }

			   }

			  }


			  $liste_images_produit = $this->images_produits->getRecordByProduit($reference_produit);
			  $this->data['liste_images_produit'] = $liste_images_produit;

			  $resultat = $this->twig->render('stock/images_produit.html.twig', $this->data);
			  echo $resultat;



		   }

		   public function supprimer_image_produit($id){

		   	    $this->data['base_url'] = base_url();
		        $infos_produit_image = $this->images_produits->findById($id);
				$this->images_produits->delete($id);
				$liste_images_produit = $this->images_produits->getRecordByProduit($infos_produit_image->Reference_produit);
			    $this->data['liste_images_produit'] = $liste_images_produit;

			    $resultat = $this->twig->render('stock/images_produit.html.twig', $this->data);
			    echo $resultat;

		   }

		   public function set_opportunite($id_opportunite,$id_statut,$id_utilisateur){

		   	$donnes_opportunite = array("Id_statut"=>$id_statut);
		   	$this->opportunite->update($id_opportunite, $donnes_opportunite);
		   	$test_historique =$this->opportunite->test_historique($id_opportunite,$id_statut);
		    if($test_historique==0){

		    	$donnees_historique = array("Date"=>date("d/m/Y"),"Id_opportunite"=>$id_opportunite,"Id_responsable"=>$id_utilisateur,"Id_statut"=>$id_statut);

		    	$this->opportunite->ajouter_historique($donnees_historique);
		    }

		   	echo json_encode(['success' => true]);
		   }

		   public function get_article($id,$id_fournisseur){
             
		   	 $infos_article = $this->article->get_by_id($id);
		   	 $infos_produit_fournisseur =$this->produits_par_fournisseur->get_by_article_fournisseur($id,$id_fournisseur);

		   	 if(count($infos_produit_fournisseur)==0){

                 echo json_encode(['success' => true, 'prix_ht' => 0, 'tva'=>0]);

		   	 }else{

		   	 	 echo json_encode(['success' => true, 'prix_ht' => $infos_produit_fournisseur[0]->Prix_achat_ht, 'tva'=>$infos_produit_fournisseur[0]->TVA]);
		   	 }
		   	

		   }

		   public function get_article_vente($id){

		   	$infos_article = $this->article->get_by_id($id);
		   	 echo json_encode(['success' => true, 'prix_ht' => $infos_article->Prix_vente_ht, 'tva'=>$infos_article->TVA]);
		   }
		   public function get_element_achat($id){

		   	$infos_element_achat =$this->achat->get_element_achat_by_id($id);
		   	echo json_encode(['success' => true, 'prix_ht' => $infos_element_achat->Prix_unitaire,'prix_ht_devise'=>$infos_element_achat->Prix_unitaire_devise, 'tva'=>$infos_element_achat->Tva,'id_details'=>$infos_element_achat->Id,'quantite'=>$infos_element_achat->Quantite,'id_article'=>$infos_element_achat->Id_article]);

		   }

		   public function get_element_vente($id){

		   	$infos_element_vente =$this->vente->get_element_vente_by_id($id);
		   	echo json_encode(['success' => true, 'prix_ht' => $infos_element_vente->Prix_unitaire,'prix_ht_devise' => $infos_element_vente->Prix_unitaire_devise, 'tva'=>$infos_element_vente->Tva,'id_details'=>$infos_element_vente->Id,'quantite'=>$infos_element_vente->Quantite,'id_article'=>$infos_element_vente->Id_article,'reduction'=>$infos_element_vente->Reduction]);

		   }
		   

		   public function ajouter_article_da(){

		   	if($_POST["id_details"]==""){


		   		    $test  = $this->achat->test_article_achat($_POST["id_achat"],$_POST["article_id"]);

           
				   	if(count($test)>0){

		              $quantite_totale =$test[0]->Quantite+$_POST["quantite"];

		              $total_ht = floatval($quantite_totale) * floatval($_POST["prix_unitaire_ht"]);
		              $total_ht_devise =floatval($quantite_totale) * floatval($_POST["prix_unitaire_ht_devise"]);

				   	  $tva=floatval($_POST["tva"]);
				   	  $total_ttc = $total_ht * (1 + ($tva / 100));
				   	  $total_ttc_devise =$total_ht_devise * (1 + ($tva / 100));

		              $donnes_article = array(

					   		"Quantite"=>$quantite_totale,
					   		"Prix_unitaire"=>$_POST["prix_unitaire_ht"],
					   		"Prix_unitaire_devise"=>$_POST["prix_unitaire_ht_devise"],
					   		"Tva"=>$_POST["tva"],
					   		"Total_ht"=>$total_ht,
					   		"Total_ht_devise"=>$total_ht_devise,
					   		"Total_ttc"=>$total_ttc,
					   		"Total_ttc_devise"=>$total_ttc_devise
					   		
					   	);

		              $this->achat->update_details($test[0]->Id, $donnes_article);

				   	}else{

				   		$total_ht = floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht"]);
				   		$total_ht_devise =floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht_devise"]);

					   	$tva=floatval($_POST["tva"]);
					   	$total_ttc = $total_ht * (1 + ($tva / 100));
					   	$total_ttc_devise = $total_ht_devise * (1 + ($tva / 100));


				   		$donnes_article = array(

					   		"Id_achat"=>$_POST["id_achat"],
					   		"Id_article"=>$_POST["article_id"],
					   		"Quantite"=>$_POST["quantite"],
					   		"Prix_unitaire"=>$_POST["prix_unitaire_ht"],
					   		"Prix_unitaire_devise"=>$_POST["prix_unitaire_ht_devise"],
					   		"Tva"=>$_POST["tva"],
					   		"Total_ht"=>$total_ht,
					   		"Total_ht_devise"=>$total_ht_devise,
					   		"Total_ttc"=>$total_ttc,
					   		"Total_ttc_devise"=>$total_ttc_devise
					   	);

					  
				   		$id=$this->achat->ajout_details_achat($donnes_article);
				   	    

				   	}


		   	}else{

		   		    $total_ht = floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht"]);
		   		    $total_ht_devise =floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht_devise"]);
				   	$tva=floatval($_POST["tva"]);
				   	$total_ttc = $total_ht * (1 + ($tva / 100));
				   	$total_ttc_devise =$total_ht_devise * (1 + ($tva / 100));

				
		   		$donnes_article = array(

			   		"Id_article"=>$_POST["article_id"],
			   		"Quantite"=>$_POST["quantite"],
			   		"Prix_unitaire"=>$_POST["prix_unitaire_ht"],
			   		"Prix_unitaire_devise"=>$_POST["prix_unitaire_ht_devise"],
			   		"Tva"=>$_POST["tva"],
			   		"Total_ht"=>$total_ht,
			   		"Total_ht_devise"=>$total_ht_devise,
			   		"Total_ttc"=>$total_ttc,
			   		"Total_ttc_devise"=>$total_ttc_devise

				);

				$this->achat->update_details($_POST["id_details"], $donnes_article);


		   	}

		   	$liste = $this->achat->liste_details_achat($_POST["id_achat"]);
		   	$total_ht =$this->achat->get_total_ht($_POST["id_achat"]);
		   	$total_ht_devise =$this->achat->get_total_ht_devise($_POST["id_achat"]);
		   	$total_ttc =$this->achat->get_total_ttc($_POST["id_achat"]);
		   	$total_ttc_devise =$this->achat->get_total_ttc_devise($_POST["id_achat"]);
		   	$infos_demande_achat = $this->achat->get_by_id($_POST["id_achat"]);
		   	$this->data['infos_demande_achat'] =$infos_demande_achat;

		   	
		   	$this->data['liste'] =$liste;
		   	$this->data['total_ht'] =$total_ht;
		   	$this->data['total_ht_devise'] =$total_ht_devise;
		   	$this->data['total_ttc'] =$total_ttc;
		   	$this->data['total_ttc_devise'] =$total_ttc_devise;
		   	$infos_societe =$this->societe->get_all();
		    $this->data['societe']  =$infos_societe[0];
		   	$resultat = $this->twig->render('gestion_commerciale/tableau_articles.html.twig', $this->data);

		   	echo $resultat;
		   	

		   }

		    public function ajouter_article_vente(){


		   	if($_POST["id_details"]==""){

                    
		   		    $test  = $this->vente->test_article_vente($_POST["id_vente"],$_POST["article_id"]);


				   	if(count($test)>0){

		              $quantite_totale =$test[0]->Quantite+$_POST["quantite"];

		              $total_ht = floatval($quantite_totale) * floatval($_POST["prix_unitaire_ht"]);
		              $reste_pourcentage = 100-floatval($_POST["reduction"]);
		              $total_ht_reduction =($total_ht*$reste_pourcentage)/100;
		              $total_ht_reduction = round($total_ht_reduction,2);
                      
                      //Montant en devise 
		              $total_ht_devise = floatval($quantite_totale) * floatval($_POST["prix_unitaire_ht_devise"]);
		              $reste_pourcentage = 100-floatval($_POST["reduction"]);
		              $total_ht_devise_reduction =($total_ht_devise*$reste_pourcentage)/100;
		               $total_ht_devise_reduction = round($total_ht_devise_reduction,2);


				   	  $tva=floatval($_POST["tva"]);

				   	  $total_ttc = $total_ht * (1 + ($tva / 100));
				   	  $total_ttc_reduction =($total_ttc*$reste_pourcentage)/100;
				   	  $total_ttc_reduction = round($total_ttc_reduction,2);

				   	  $total_ttc_devise = $total_ht_devise * (1 + ($tva / 100));
				   	  $total_ttc_devise_reduction =($total_ttc_devise*$reste_pourcentage)/100;
				   	  $total_ttc_devise_reduction = round($total_ttc_devise_reduction,2);


		              $donnes_article = array(

					   		"Quantite"=>$quantite_totale,
					   		"Prix_unitaire"=>$_POST["prix_unitaire_ht"],
					   		"Prix_unitaire_devise"=>$_POST["prix_unitaire_ht_devise"],
					   		"Tva"=>$_POST["tva"],
					   		"Reduction"=>$_POST["reduction"],
					   		"Total_ht"=>$total_ht_reduction,
					   		"Total_ttc"=>$total_ttc_reduction,
					   		"Total_ht_devise"=>$total_ht_devise_reduction,
					   		"Total_ttc_devise"=>$total_ttc_devise_reduction
					   	);

		              $this->vente->update_details($test[0]->Id, $donnes_article);

				   	}else{

				   		$total_ht = floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht"]);
					   	$tva=floatval($_POST["tva"]);
					   	
					   	$reste_pourcentage = 100-floatval($_POST["reduction"]);
		                $total_ht_reduction =($total_ht*$reste_pourcentage)/100;
		                $total_ht_reduction = round($total_ht_reduction,2);

		                $total_ht_devise = floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht_devise"]);
					   	$tva=floatval($_POST["tva"]);
					   	$reste_pourcentage = 100-floatval($_POST["reduction"]);
		                $total_ht_devise_reduction =($total_ht_devise*$reste_pourcentage)/100;
		                $total_ht_devise_reduction = round($total_ht_devise_reduction,2);


					   	
					   	$total_ttc = $total_ht * (1 + ($tva / 100));
					   	$total_ttc_reduction =($total_ttc*$reste_pourcentage)/100;
				   	    $total_ttc_reduction = round($total_ttc_reduction,2);

				   	    $total_ttc_devise = $total_ht_devise * (1 + ($tva / 100));
					   	$total_ttc_devise_reduction =($total_ttc_devise*$reste_pourcentage)/100;
				   	    $total_ttc_devise_reduction = round($total_ttc_devise_reduction,2);


				   		$donnes_article = array(

					   		"Id_vente"=>$_POST["id_vente"],
					   		"Id_article"=>$_POST["article_id"],
					   		"Quantite"=>$_POST["quantite"],
					   		"Prix_unitaire"=>$_POST["prix_unitaire_ht"],
					   		"Prix_unitaire_devise"=>$_POST["prix_unitaire_ht_devise"],
					   		"Tva"=>$_POST["tva"],
					   		"Reduction"=>$_POST["reduction"],
					   		"Total_ht"=>$total_ht_reduction,
					   		"Total_ttc"=>$total_ttc_reduction,
					   		"Total_ht_devise"=>$total_ht_devise_reduction,
					   		"Total_ttc_devise"=>$total_ttc_devise_reduction,

					   	);
                        if(intval($_POST["quantite"])>0){
                        	$this->vente->ajout_details_vente($donnes_article);
                        }
				   		

				   	}


		   	}else{

		   		    $total_ht = floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht"]);
		   		    $total_ht_devise = floatval($_POST["quantite"]) * floatval($_POST["prix_unitaire_ht_devise"]);
				   	$tva=floatval($_POST["tva"]);
				   	
				   	$reste_pourcentage = 100-floatval($_POST["reduction"]);
		            $total_ht_reduction =($total_ht*$reste_pourcentage)/100;
		            $total_ht_reduction = round($total_ht_reduction,2);

		            $reste_pourcentage = 100-floatval($_POST["reduction"]);
		            $total_ht_devise_reduction =($total_ht_devise*$reste_pourcentage)/100;
		            $total_ht_devise_reduction = round($total_ht_devise_reduction,2);

					   	
				   	$total_ttc = $total_ht * (1 + ($tva / 100));
				   	$total_ttc_reduction =($total_ttc*$reste_pourcentage)/100;
				   	$total_ttc_reduction = round($total_ttc_reduction,2);

				   	$total_ttc_devise = $total_ht_devise * (1 + ($tva / 100));
				   	$total_ttc_devise_reduction =($total_ttc_devise*$reste_pourcentage)/100;
				   	$total_ttc_devise_reduction = round($total_ttc_devise_reduction,2);

				
		   		    $donnes_article = array(

			   		"Id_article"=>$_POST["article_id"],
			   		"Quantite"=>$_POST["quantite"],
			   		"Prix_unitaire"=>$_POST["prix_unitaire_ht"],
			   		"Prix_unitaire_devise"=>$_POST["prix_unitaire_ht_devise"],
			   		"Tva"=>$_POST["tva"],
			   		"Reduction"=>$_POST["reduction"],
			   		"Total_ht"=>$total_ht_reduction,
			   		"Total_ttc"=>$total_ttc_reduction,
			   		"Total_ht_devise"=>$total_ht_devise_reduction,
					"Total_ttc_devise"=>$total_ttc_devise_reduction,
				);

				$this->vente->update_details($_POST["id_details"], $donnes_article);


		   	}

		   	$liste = $this->vente->liste_details_vente($_POST["id_vente"]);
		   	$total_ht =$this->vente->get_total_ht($_POST["id_vente"]);
		   	$total_ht_devise =$this->vente->get_total_ht_devise($_POST["id_vente"]);
		   	$total_ttc =$this->vente->get_total_ttc($_POST["id_vente"]);
		   	$total_ttc_devise =$this->vente->get_total_ttc_devise($_POST["id_vente"]);
		   	$total_tva =$this->vente->get_total_tva($_POST["id_vente"]);
		   	$total_tva_devise =$this->vente->get_total_tva_devise($_POST["id_vente"]);

		   	$this->data['liste'] =$liste;
		   	$this->data['total_ht'] =$total_ht;
		   	$this->data['total_ht_devise'] =$total_ht_devise;
		   	$this->data['total_ttc'] =$total_ttc;
		   	$this->data['total_ttc_devise'] =$total_ttc_devise;
		   	$this->data['total_tva'] =$total_tva;
		   	$this->data['total_tva_devise'] =$total_tva_devise;

		   	$infos_societe =$this->societe->get_all();
		    $this->data['societe']  =$infos_societe[0];

		    $infos_vente = $this->vente->get_by_id($_POST["id_vente"]);
		    $this->data['infos_vente']=$infos_vente;  
		   	$resultat = $this->twig->render('gestion_commerciale/tableau_articles_vente.html.twig', $this->data);

		   	echo $resultat;
		   	

		   }

		   public function supprimer_element_achat($id){
            
            $infos_element_achat =$this->achat->get_element_achat_by_id($id);

		   	$this->achat->delete_element_achat($id);
		   	$liste = $this->achat->liste_details_achat($infos_element_achat->Id_achat);
		   	$total_ht =$this->achat->get_total_ht($infos_element_achat->Id_achat);
		   	$total_ht_devise =$this->achat->get_total_ht_devise($infos_element_achat->Id_achat);
		   	$total_ttc =$this->achat->get_total_ttc($infos_element_achat->Id_achat);
		   	$total_ttc_devise =$this->achat->get_total_ttc_devise($infos_element_achat->Id_achat);
		   	$this->data['liste'] =$liste;
		   	$this->data['total_ht'] =$total_ht;
		   	$this->data['total_ht_devise'] =$total_ht_devise;
		   	$this->data['total_ttc'] =$total_ttc;
		   	$this->data['total_ttc_devise'] =$total_ttc_devise;
		   	$infos_societe =$this->societe->get_all();
		    $this->data['societe']  =$infos_societe[0];
		    $infos_demande_achat =$this->achat->get_by_id($infos_element_achat->Id_achat);
		    $this->data['infos_demande_achat']  =$infos_demande_achat;
		   	$resultat = $this->twig->render('gestion_commerciale/tableau_articles.html.twig', $this->data);

		   	echo $resultat;
		   }

		   public function supprimer_element_vente($id){

		   	$infos_element_vente = $this->vente->get_element_vente_by_id($id);
		   	$this->vente->delete_element_vente($id);
		   	$liste = $this->vente->liste_details_vente($infos_element_vente->Id_vente);
		   	$total_ht = $this->vente->get_total_ht($infos_element_vente->Id_vente);
		   	$total_ht_devise =$this->vente->get_total_ht_devise($infos_element_vente->Id_vente);
		   	$total_ttc =$this->vente->get_total_ttc($infos_element_vente->Id_vente);
		   	$total_ttc_devise=$this->vente->get_total_ttc_devise($infos_element_vente->Id_vente);
		   	$total_tva =$this->vente->get_total_tva($infos_element_vente->Id_vente);
		   	$total_tva_devise =$this->vente->get_total_tva_devise($infos_element_vente->Id_vente);


		   	$this->data['liste'] =$liste;
		   	$this->data['total_ht'] =$total_ht;
		   	$this->data['total_ht_devise'] =$total_ht_devise;
		   	$this->data['total_ttc'] =$total_ttc;
		   	$this->data['total_ttc_devise'] =$total_ttc_devise;
		   	$this->data['total_tva'] =$total_tva;
		   	$this->data['total_tva_devise'] =$total_tva_devise;


		   	$infos_societe =$this->societe->get_all();
		    $this->data['societe']  =$infos_societe[0];
		    $infos_vente =$this->vente->get_by_id($infos_element_vente->Id_vente);
		    $this->data['infos_vente']=$infos_vente;

		   	$resultat = $this->twig->render('gestion_commerciale/tableau_articles_vente.html.twig', $this->data);
		   	echo $resultat;
		   }

		   public function stocker_commande_caisse(){

            $infos_societe =$this->societe->get_all();
		   	$input = file_get_contents('php://input');
            $saleData = json_decode($input, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
            $this->output->set_status_header(400); // Bad Request
            echo json_encode(['error' => 'Données JSON invalides']);
            return;
            }

            $telephone = isset($saleData['customerPhone']) ? $saleData['customerPhone'] : null;
            $test_phone = $this->contact->get_by_phone($telephone);
            $mode_paiement =$saleData['paymentMethod'];

            if($telephone!=""){

            	 if(count($test_phone)>0){

            	     $id_client =$test_phone[0]->Id;

                  }else{

                  	   $infos_societe =$this->societe->get_all();
		            
                  	   $donnees_contact = array(

			  	   	  	 "Date"=>date("d/m/Y"),
			  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
			  	   	  	 "Civilite"=>"--",
			  	   	  	 "Nom"=>"--",
			  	   	  	 "Prenom"=>"--",
			  	   	  	 "Telephone"=>$telephone,
			  	   	  	 "Whatsapp"=>"--",
			  	   	  	 "Email"=>"--",
			  	   	  	 "Profession"=>"--",
			  	   	  	 "Adresse"=>"--",
			  	   	  	 "Pays"=>$infos_societe[0]->Pays,
			  	   	  	 "Type"=>"Client",
			  	   	  	 "Entreprise"=>"--",
			  	   	  	 "Notes"=>"--"
			  	   	     );
                  	  $id_client = $this->contact->insert($donnees_contact);
                  }


            }else{

            	$test_client_anonyme = $this->contact->get_by_nom_prenom("Client","Anonyme");
            	if(count($test_client_anonyme)>0){
                     
                     $id_client =$test_client_anonyme[0]->Id;

            	}else{
                    $infos_societe =$this->societe->get_all();
            		$donnees_contact = array(

			  	   	  	 "Date"=>date("d/m/Y"),
			  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
			  	   	  	 "Civilite"=>"--",
			  	   	  	 "Nom"=>"Client",
			  	   	  	 "Prenom"=>"Anonyme",
			  	   	  	 "Telephone"=>"0000000000",
			  	   	  	 "Whatsapp"=>"--",
			  	   	  	 "Email"=>"--",
			  	   	  	 "Profession"=>"--",
			  	   	  	 "Adresse"=>"--",
			  	   	  	 "Pays"=>$infos_societe[0]->Pays,
			  	   	  	 "Type"=>"Client",
			  	   	  	 "Entreprise"=>"CLIENT SUR PLACE",
			  	   	  	 "Notes"=>"--"
			  	   	     );
                  	  $id_client = $this->contact->insert($donnees_contact);


            	}



            }

            $infos_numerotation =$this->numerotation->get_all();

		    $code_facture =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_facture_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_facture_client+1,$infos_numerotation[0]->Taille_reference);

		        $donnees_numerotation = array("Compteur_facture_client"=>$infos_numerotation[0]->Compteur_facture_client+1);
		        $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);


		     	$donnees_devis =array("Type"=>"Facture",
		                              "Numero_demande"=>$code_facture,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$id_client,
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>-1,
		                              "Conditions_reglement"=>"A la réception",
		                              "Mode_reglement"=>$mode_paiement,
		                              "Date_livraison"=>date("Y-m-d"),
		                              "Devise"=>$infos_societe[0]->Devise,
		                              "Notes"=>"",
		                              "Statut"=>"Validé"
		                           );
		    $id_vente =$this->vente->insert($donnees_devis);
            
            $liste_achat =  $saleData['items'];
            $methode_paiement = isset($saleData['paymentMethod']) ? $saleData['paymentMethod'] : 'cash';


            foreach($liste_achat as $achat){

                        $infos_article =$this->article->get_by_id(intval($achat["id"]));
                        $prix_vente_ht=
            	        $total_ht = floatval($achat["quantity"]) * floatval($infos_article->Prix_vente_ht);
					   	$tva=floatval($infos_article->TVA);
					   	$reduction=0;
					   	$reste_pourcentage = 100-floatval($reduction);
		                $total_ht_reduction =($total_ht*$reste_pourcentage)/100;
		                $total_ht_reduction = round($total_ht_reduction,2);
					   	
					   	$total_ttc = $total_ht * (1 + ($tva / 100));
					   	$total_ttc_reduction =($total_ttc*$reste_pourcentage)/100;
				   	    $total_ttc_reduction = round($total_ttc_reduction,2);


				   		$donnes_article = array(

					   		"Id_vente"=>$id_vente,
					   		"Id_article"=>intval($achat["id"]),
					   		"Quantite"=>intval($achat["quantity"]),
					   		"Prix_unitaire"=>$infos_article->Prix_vente_ht,
					   		"Tva"=>$infos_article->TVA,
					   		"Reduction"=>$reduction,
					   		"Total_ht"=>$total_ht_reduction,
					   		"Total_ttc"=>$total_ttc_reduction
					   	);

                        if(intval($achat["quantity"])>0){
                        	$this->vente->ajout_details_vente($donnes_article);
                        	
                        }
				   		

               }

               header('Content-Type: application/json; charset=utf-8');
               echo json_encode(['success' => true, 'id' => $id_vente]);


		   }

		   public function search_products(){

            $mot_cle=$_POST["query"];
            $liste_produits = $this->article->recherche_produit_caisse($mot_cle);

            header('Content-Type: application/json; charset=utf-8');
			echo json_encode([
			    'success' => true, 
			    'products' => $liste_produits  // Directement le tableau PHP → sera encodé en array JSON
			]);

		   }


		   function generateInvoiceReference($prefixe,$separateur,$format_date,$pattern, $compteur,$taille_compteur) {

		      $pattern_devis  =  str_replace("[date]",$format_date,$pattern);
              $pattern_devis  =  str_replace("[préfixe]",$prefixe,$pattern_devis);
              $pattern_devis  =  str_replace("[separateur]",$separateur,$pattern_devis);

			  $pattern_devis  =  str_replace("{yyyy}",date("Y"),$pattern_devis);
		      $pattern_devis  =  str_replace("{mm}",date("m"),$pattern_devis );
		      $pattern_devis  =  str_replace("{dd}",date("d"),$pattern_devis );
		      $pattern_devis  =  str_replace("{yy}",substr(date("Y"), -2),$pattern_devis );
		      $chiffre = str_pad($compteur,$taille_compteur, "0", STR_PAD_LEFT);
		      $pattern_devis  =  str_replace("[compteur]",$chiffre,$pattern_devis);
			    
			    return $pattern_devis;
			}


			public function  importer_categories(){


				 $file="";
				 if(!empty($_FILES)) {


				  	   if(is_uploaded_file($_FILES['file']['tmp_name'])) {

				  	   	       $reference=time();
		                       $sourcePath = $_FILES['file']['tmp_name'];
		                       $csv=$_FILES['file']['name'];
		                       $tabcsv=explode('.',$csv);
		                       $extension = strtolower(end($tabcsv));
		                       $file=$reference.".".$extension;
		                       $liste_extensions =array("csv");
		                       if(in_array($extension,$liste_extensions)){
		                       	$targetPath = "uploads/".$reference.".".$extension;
		                        move_uploaded_file($sourcePath,$targetPath);

		                       $filepath = FCPATH .$targetPath;
		                       try {
						            $csvData = $this->readCSVFromFile($filepath);

                                    $i=0;
						            foreach($csvData as $data){
                                        $i=$i+1;
                                        $donnee =array_values($data);
						            	$reference = $donnee[0];
						            	$libelle =$donnee[1];

						            	if($reference==""){

						            		$reference=time().$i;
						            	}

						            	$test =$this->categorie->test_doublon($libelle);
						            	if($test==0){

						            		$donnees_categorie = array("Libelle"=>$libelle,"Reference"=>$reference);
						            		$this->categorie->insert($donnees_categorie);
						            	}
						            }

						        } catch (Exception $e) {
						            show_error($e->getMessage());
						        }


		                        

		                       }

				  	   }

				  }



			}

			public function importer_fournisseurs(){

				$file="";
				if(!empty($_FILES)) {

					if(is_uploaded_file($_FILES['file']['tmp_name'])) {

						       $reference=time();
		                       $sourcePath = $_FILES['file']['tmp_name'];
		                       $csv=$_FILES['file']['name'];
		                       $tabcsv=explode('.',$csv);
		                       $extension = strtolower(end($tabcsv));
		                       $file=$reference.".".$extension;
		                       $liste_extensions =array("csv");
		                       if(in_array($extension,$liste_extensions)){

		                       	$targetPath = "uploads/".$reference.".".$extension;
		                        move_uploaded_file($sourcePath,$targetPath);

		                        $filepath = FCPATH .$targetPath;
		                        try {
						            $csvData = $this->readCSVFromFile($filepath);

                                    $i=0;
						            foreach($csvData as $data){
                                        $i=$i+1;
                                        $donnee =array_values($data);
						            	$raison_sociale = $donnee[0];
						            	$telephone =$donnee[1];
						            	$email =$donnee[2];
						            	$pays =$donnee[3];
						            	$adresse =$donnee[4];
						            	$numero_identite_fiscale=$donnee[5];
						            	$registre_commerce=$donnee[6];
						            	$banque=$donnee[7];
						            	$code_swift=$donnee[8];
						            	$rib=$donnee[9];
						            	$tva=$donnee[10];

						            	

						            	$test =$this->fournisseur->test_doublon($raison_sociale);
						            	if($test==0){

						            		$donnees_fournisseur = array(

						            			"Raison_sociale"=>$raison_sociale,
						            			"Pays"=>$pays,
						            			"Email"=>$email,
						            			"Telephone"=>$telephone,
						            			"Numero_identite_fiscale"=>$numero_identite_fiscale,
						            			"TVA"=>$tva,
						            			"Registre_commerce"=>$registre_commerce,
						            			"Banque"=>$banque,
						            			"Code_swift"=>$code_swift,
						            			"RIB"=>$rib,
						            			"Adresse"=>$adresse

						            		);

						            		$this->fournisseur->insert($donnees_fournisseur);
						            		
						            	}
						            }

						        } catch (Exception $e) {
						            show_error($e->getMessage());
						        }

		                       }


					}


				}



			}

			public function importer_produits(){

               $categorie =$_POST["categorie"];
               $fournisseur=$_POST["fournisseur"];
               $type_article=$_POST["type_article"];

               if(!empty($_FILES)) {


               	   if(is_uploaded_file($_FILES['file']['tmp_name'])) {

				  	   	       $reference=time();
		                       $sourcePath = $_FILES['file']['tmp_name'];
		                       $csv=$_FILES['file']['name'];
		                       $tabcsv=explode('.',$csv);
		                       $extension = strtolower(end($tabcsv));
		                       $file=$reference.".".$extension;
		                       $liste_extensions =array("csv");
		                       if(in_array($extension,$liste_extensions)){
		                       	$targetPath = "uploads/".$reference.".".$extension;
		                        move_uploaded_file($sourcePath,$targetPath);

		                        $filepath = FCPATH .$targetPath;

		                       try {
						            $csvData = $this->readCSVFromFile($filepath);

                                    $i=0;
						            foreach($csvData as $data){
                                        $i=$i+1;
                                        $donnee =array_values($data);
						            	$reference = $donnee[0];
						            	$designation =$donnee[1];

						            	if($reference==""){

						            		$reference=time().$i;
						            	}

						            	$unite=$donnee[2];
						            	$prix_vente_ttc =$this->toNumberOrZero($donnee[3]);
						            	$prix_achat_ttc=$this->toNumberOrZero($donnee[4]);
						            	$tva =$this->toNumberOrZero($donnee[5]);
						            	
						            	$prix_vente_ht = $prix_vente_ttc / (1 + ($tva / 100));
						            	$quantite=$this->toNumberOrZero($donnee[6]);
						            	$seuil_minimum=$this->toNumberOrZero($donnee[7]);
						            	$marque=$donnee[8];
						            	$code_barre=$donnee[9];

						            	$description="";
						            	if(isset($donnee[10])){

						            		$description=$donnee[10];
						            	}
						            	
						            
						            	$test =$this->article->test_doublon($designation);

						            	if($test==0){

						            		 $article = array(

									 			"Type"=>$type_article,
									 			"Libelle"=>$designation,
									 			"Reference"=>$reference,
									 			"Id_categorie"=>$categorie,
									 			"Unite"=>$unite,
									 			"Prix_vente_ht"=>round($prix_vente_ht,2),
									 			"Prix_vente_ttc"=>$prix_vente_ttc,
									 			"Prix_achat_ttc"=>$prix_achat_ttc,
									 			"Quantite_stock"=>$quantite,
									 			"Seuil_minimum"=>$seuil_minimum,
									 			"TVA"=>$tva,
									 			"En_vente"=>1,
									 			"Marque"=>$marque,
									 			"Code_barre"=>$code_barre,
									 			"Description"=>$description

								 		       );

							            	$id_article =$this->article->insert($article);

							            	if($fournisseur!=-1){

							            		$infos_fournisseur =$this->fournisseur->get_by_id($fournisseur);
							            		$prix_achat_ht = $prix_achat_ttc / (1 + ($infos_fournisseur->TVA / 100));

							            		$donnees_articles = array(

							            			"Id_article"=>$id_article,
							            			"Id_fournisseur"=>$fournisseur,
							            			"Prix_achat_ht"=>round($prix_achat_ht,2),
							            			"TVA"=>$infos_fournisseur->TVA

							            		);

							            		$this->produits_par_fournisseur->insert($donnees_articles);

							            	}

						            	$i=10;
						            	$cpt=0;
						            	$liste_entrepots =$this->entrepot->get_all();
						            	$total_entrepots = count($liste_entrepots);

						            	for($i=10;$i<10+$total_entrepots;$i++){
						            		$j=$i+1;

						            		
				                			if($donnee[$j]>0){


				                				  $donnees_article_entrepot = array(

					                				"Reference_reception"=>"--",
					                				"Id_article"=>$id_article,
					                				"Id_entrepot"=>$liste_entrepots[$cpt]->Id,
					                				"Quantite_recue"=>$donnee[$j]

					                			  );

					                			  $this->article->ajout_dans_entrepot($donnees_article_entrepot);

						                		  $test_entrepot=$this->stock_entrepot->get_by_article_entrepot($id_article,$liste_entrepots[$cpt]->Id);

						                		  if(count($test_entrepot)>0){

						                				$total_actuel =$test_entrepot[0]->Total_stock;
						                				$total_actuel =$total_actuel+$donnee[$j];

						                				$donnees_article_entrepot= array("Total_stock"=>$total_actuel);
						                				$this->stock_entrepot->update($test_entrepot[0]->Id, $donnees_article_entrepot);
						                			}else{

						                				$donnees_article_entrepot= array("Id_entrepot"=>$liste_entrepots[$cpt]->Id,"Id_article"=>$id_article,"Total_stock"=>$donnee[$j]
						                			    );

						                			    $this->stock_entrepot->insert($donnees_article_entrepot);

						                			
						                			}


				                			}

				                			
				                			$cpt=$cpt+1;


						            	 }


						            	}


						            }

						        } catch (Exception $e) {
						            show_error($e->getMessage());
						        }


		                        

		                       }

				  	   }


               }

				
			}


			public function importer_contacts(){

				$campagne =$_POST["campagne"];
				$statut=$_POST["statut"];
				$type=$_POST["type"];

				if(!empty($_FILES)) {

					if(is_uploaded_file($_FILES['file']['tmp_name'])) {


						       $reference=time();
		                       $sourcePath = $_FILES['file']['tmp_name'];
		                       $csv=$_FILES['file']['name'];
		                       $tabcsv=explode('.',$csv);
		                       $extension = strtolower(end($tabcsv));
		                       $file=$reference.".".$extension;
		                       $liste_extensions =array("csv");

		                       if(in_array($extension,$liste_extensions)){

		                       	$targetPath = "uploads/".$reference.".".$extension;
		                        move_uploaded_file($sourcePath,$targetPath);

		                        $filepath = FCPATH .$targetPath;
		                        try {

		                        	$csvData = $this->readCSVFromFile($filepath);
						            foreach($csvData as $data){
                             
                                        $donnee =array_values($data);
						            	$civilite = $donnee[0];
						            	$nom =$donnee[1];
						            	$prenom =$donnee[2];
						            	$telephone =$donnee[3];
						            	$whatsapp =$donnee[4];
						            	$email =$donnee[5];
						            	$profession =$donnee[6];
						            	$pays =$donnee[7];
						            	$adresse =$donnee[8];
						            	$entreprise =$donnee[9];
						            	$notes =$donnee[9];

						            	$donnees_contact = array(

						            		"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
						            		"Id_campagne"=>$campagne,
						            		"Id_statut"=>$statut,
						            		"Date"=>date("d/m/Y"),
						            		"Civilite"=>$civilite,
						            		"Nom"=>$nom,
						            		"Prenom"=>$prenom,
						            		"Telephone"=>$telephone,
						            		"Whatsapp"=>$whatsapp,
						            		"Email"=>$email,
						            		"Profession"=>$profession,
						            		"Pays"=>$pays,
						            		"Adresse"=>$adresse,
						            		"Entreprise"=>$entreprise,
						            		"Type"=>$type,
						            		"Notes"=>$notes

						            	);

						            	$test_doublon  =$this->contact->test_doublon($nom,$prenom);
						            	$test_entreprise =$this->contact->test_entreprise($entreprise);

						            	if($test_entreprise==0 and $test_doublon==0){

						            		$id_contact=$this->contact->insert($donnees_contact);

						            		$donnees_historique = array(

						            			"Date"=>date("d/m/Y"),
						            			"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
						            			"Id_contact"=>$id_contact,
						            			"Id_statut"=>$statut,
						            			"Notes"=>$notes

						            		);

						            		$this->statut_contact->ajouter_statut_contact($donnees_historique);

						            	}

						            }



		                         }catch (Exception $e) {
						            show_error($e->getMessage());
						        }


		                       };



					}


				}





			}

			function toNumberOrZero($value)
			{
			    // Nettoyage
			    $value = trim($value);

			    // Normalisation décimale (virgule → point)
			    $value = str_replace(',', '.', $value);

			    // Validation numérique
			    if (is_numeric($value)) {
			        return (float) $value;
			    }

			    return 0;
			}


			function test(){

				$valeur =$this->toNumberOrZero("355,5");
				echo $valeur;
			}



			private function detectDelimiter($filepath)
		    {
		        $delimiters = [",", ";", "\t", "|", ":"];
		        $handle = fopen($filepath, 'r');
		        if (!$handle) throw new Exception("Impossible d'ouvrir le fichier pour détecter le séparateur");

		        $firstLine = fgets($handle);
		        fclose($handle);

		        $bestDelimiter = ",";
		        $maxFields = 0;

		        foreach ($delimiters as $d) {
		            $fields = str_getcsv($firstLine, $d);
		            if (count($fields) > $maxFields) {
		                $maxFields = count($fields);
		                $bestDelimiter = $d;
		            }
		        }

		        return $bestDelimiter;
		    }
            /*
		    private function readCSVFromFile($filepath)
		    {
		        if (!file_exists($filepath)) {
		            throw new Exception("Fichier CSV introuvable : $filepath");
		        }

		        $delimiter = $this->detectDelimiter($filepath);
		        $result = [];

		        if (($handle = fopen($filepath, "r")) !== false) {

		            // Lire la première ligne comme header
		            $header = fgetcsv($handle, 0, $delimiter);

		            while (($row = fgetcsv($handle, 0, $delimiter)) !== false) {
		                $line = [];
		                foreach ($row as $index => $value) {
		                    $colName = $header[$index] ?? "col" . ($index + 1);
		                    $line[$colName] = $value;
		                }
		                $result[] = $line;
		            }

		            fclose($handle);
		        }

		        return $result;
		    }*/

		    private function readCSVFromFile($filepath)
			{
			    if (!file_exists($filepath)) {
			        throw new Exception("Fichier CSV introuvable : $filepath");
			    }

			    $delimiter = $this->detectDelimiter($filepath);
			    $result = [];

			    if (($handle = fopen($filepath, "r")) !== false) {

			        // Détecter l'encodage du fichier entier
			        $contents = file_get_contents($filepath);
			        $encoding = mb_detect_encoding($contents, ['UTF-8', 'ISO-8859-1', 'Windows-1252'], true);

			        // Lire l'en-tête
			        $header = fgetcsv($handle, 0, $delimiter);
			        $header = array_map(function($col) use ($encoding) {
			            return mb_convert_encoding($col, 'UTF-8', $encoding);
			        }, $header);

			        // Lire les lignes
			        while (($row = fgetcsv($handle, 0, $delimiter)) !== false) {
			            $line = [];
			            foreach ($row as $index => $value) {
			                $value = mb_convert_encoding($value, 'UTF-8', $encoding);
			                $colName = $header[$index] ?? "col" . ($index + 1);
			                $line[$colName] = $value;
			            }
			            $result[] = $line;
			        }

			        fclose($handle);
			    }

			    return $result;
			}









}
