<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Crm extends MY_Controller {

	  public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->data['base_url'] = base_url();
		     $this->data['assets_front'] =base_url()."assets/front";
		     $this->data['assets_admin'] =base_url()."assets/admin";
		     $this->data['assets_mail']  = base_url()."assets/mail";
		     $this->data['current_year']  =date("Y");
		     $role_utilisateur=$this->session->userdata('role');
		     $this->data['role_utilisateur']  =$role_utilisateur;

		     $liste_autorisations =[];
		     $liste_autorisations =$this->role->liste_codes_actions_role($this->session->userdata('role'));
		     $this->data['liste_autorisations']  =$liste_autorisations;

		     $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
		    
		     $this->data['annee_en_cours']  =date("Y");
		     $infos_utilisateur =$this->utilisateur->get_by_id($this->session->userdata('id_utilisateur'));
		     $this->data['total_contacts']=$this->contact->get_all();
		     $this->data['total_contacts_commercial']=$this->contact->total_contacts_commercial($this->session->userdata('id_utilisateur'));
		     
		     $this->data['mois_en_cours']=date("m/Y");
		     $this->data['total_opportunites']=$this->opportunite->valeur_by_mois(date("m/Y"));
		     $statut_gagnee =$this->statut_opportunite->get_by_libelle("Gagnée");

		     $this->data['total_opportunites_gagnees']=$this->opportunite->valeur_by_statut_mois($statut_gagnee->Id,date("m/Y"));

		     $this->data['total_opportunites_commercial']=$this->opportunite->valeur_by_responsable_mois($this->session->userdata('id_utilisateur'),date("m/Y"));

		     $this->data['total_opportunites_commercial_gagnees']=$this->opportunite->valeur_by_statut_responsable_mois($statut_gagnee->Id,$this->session->userdata('id_utilisateur'),date("m/Y"));
		     
		    
		     $this->data['infos_utilisateur']  = $infos_utilisateur;


		} 

		public function index(){

			
		  $total_campagnes =$this->campagne->total();
		  $this->data['total_campagnes']  =$total_campagnes;
          $total_contacts = $this->contact->total();
          $this->data['total_contacts']  = $total_contacts;
          $stats_contacts = $this->contact->statistiques_contacts();
          $this->data['stats_contacts']  =json_encode($stats_contacts);
          
          $this->data['dash_opportunite']  = 1;

          $stats_opportunites = $this->opportunite->statistiques_opportunites();
          $stats_opportunites_gagnees =$this->opportunite->statistiques_opportunites_gagnees();
          
          if($this->session->userdata('role')!=-1){

          $stats_opportunites = $this->opportunite->statistiques_opportunites_commercial($this->session->userdata('id_utilisateur'));
          $stats_opportunites_gagnees =$this->opportunite->statistiques_opportunites_gagnee_commercial($this->session->userdata('id_utilisateur'));

          }

          $this->data['stats_opportunites']  =json_encode($stats_opportunites);
          $this->data['stats_opportunites_gagnees']  =json_encode($stats_opportunites_gagnees);

          $this->data['has_chart'] =1;

          $this->twig->display('gestion_relation_client/dashboard_crm.html.twig',$this->data);

		}

		public function stats_contacts(){
        $stats_contacts = $this->contact->statistiques_contacts();
        if($this->session->userdata('role')!=-1){
        $stats_contacts =$this->contact->statistiques_contacts_commercial($this->session->userdata('id_utilisateur'));
        }
        $this->data['stats_contacts']  =json_encode($stats_contacts);
        $this->data['dash_contact']  = 1;
        $this->data['has_chart'] =1;

        $liste_campagnes =$this->campagne->get_all();
        $this->data['liste_campagnes']=$liste_campagnes;
        $liste_statuts_contact =$this->statut_contact->get_all();
        $this->data['liste_statuts_contact']=$liste_statuts_contact;
        
		$this->twig->display('gestion_relation_client/stats_contacts.html.twig',$this->data);
		}


		public function stats_opportunites_commerciaux(){
			   $mois=date("m/Y");
			   if(isset($_POST["mois"]) and $_POST["mois"]!=""){

				$mois=$_POST["mois"]."/".$_POST["annee"];
			   }
            $liste_agents =$this->utilisateur->liste_noms_agents();
            $this->data['liste_agents']  =json_encode($liste_agents);
            ;

            $liste_commerciaux =$this->vente->liste_id_utilisateurs();
		    	$statistiques_commerciaux =$this->vente->statistiques_opportunites_commerciaux_periode(date("m/Y"));

		    	$this->data['liste_commerciaux']  =json_encode($liste_agents);
		    	$this->data['statistiques_commerciaux'] =json_encode($statistiques_commerciaux); 

            $this->data['mois_en_cours']  =date("m/Y");
            $this->data['dash_opportunites_commerciaux']  = 1;
            $this->data['has_chart']  = 1;
			   $this->twig->display('gestion_relation_client/stats_opportunites.html.twig',$this->data);
		}

		public function liste_campagnes($page=1,$id=-1){

		if(isset($_POST["libelle"]) and $_POST["libelle"]!=""){


         	  if(isset($_POST["id"]) and $_POST["id"]!=""){

                 $donnes_campagne = array("Libelle"=>$_POST["libelle"]);
                 $this->campagne->update($_POST["id"], $donnes_campagne);

         	  }else{

         	  	 $donnes_campagne = array("Reference"=>time(),"Libelle"=>$_POST["libelle"]);
         	  	 $test = $this->campagne->test_doublon($_POST["libelle"]);
         	  	 if($test==0){
         	  	 	$this->campagne->insert($donnes_campagne);
         	  	 	$this->data['msg'] =1;
         	  	 }else{
         	  	 	$this->data['msg'] =-1;
         	  	 }
         	  	 
         	  }
         }

		  $no_of_records_per_page = 50;
        $offset = ($page-1) * $no_of_records_per_page;
        $offset_suivant = ($page) * $no_of_records_per_page;
        $total =$this->campagne->total();
        $total_pages = ceil($total / $no_of_records_per_page);

         $this->data['total_pages'] = $total_pages;
         $this->data['page_precedente'] =$page-1;
         $this->data['page_suivante'] =$page+1;
         $this->data['page'] =$page;
         $this->data['pagination'] =1;

         $liste = $this->campagne->liste($offset,$no_of_records_per_page);
         $total_suivant =count($this->campagne->liste($offset_suivant,$no_of_records_per_page));

         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

         	$liste = $this->campagne->recherche($_POST["mot_cle"]);

         }


         $this->data['liste_campagnes'] =$liste;
         $this->data['total_suivant'] =$total_suivant;
         $this->data['id'] =$id;
         if($id!=-1){

         	$infos_campagne = $this->campagne->get_by_id($id);
         	$this->data['infos_campagne'] =$infos_campagne;
         }
           
		 $this->twig->display('gestion_relation_client/liste_campagnes.html.twig',$this->data);	
		}

		public function supprimer_campagne($id){

			$this->campagne->delete($id);
			redirect("crm/liste_campagnes/1/-1");
		}

		public function liste_contacts_campagne($id_campagne){

         $infos_campagne  =$this->campagne->get_by_id($id_campagne);
         $this->data['infos_campagne'] =$infos_campagne;
			$liste_contacts =$this->contact->liste_by_campagne($id_campagne);
			$this->data['liste_contacts'] =$liste_contacts;

			$this->twig->display('gestion_relation_client/liste_contacts_campagne.html.twig',$this->data);	


		}

		public function ajouter_contact($id=-1){
		  
		  if(isset($_POST["nom"]) and $_POST["nom"]!=""){


		  	   if(isset($_POST["id"]) and $_POST["id"]!=""){

		  	   	$donnees_contact = array(

		  	   	  	 "Date"=>date("d/m/Y"),
		  	   	  	 "Civilite"=>$_POST["civilite"],
		  	   	  	 "Nom"=>$_POST["nom"],
		  	   	  	 "Prenom"=>$_POST["prenom"],
		  	   	  	 "Telephone"=>$_POST["telephone"],
		  	   	  	 "Whatsapp"=>$_POST["whatsapp"],
		  	   	  	 "Email"=>$_POST["email"],
		  	   	  	 "Profession"=>$_POST["profession"],
		  	   	  	 "Adresse"=>$_POST["adresse"],
		  	   	  	 "Pays"=>$_POST["pays"],
		  	   	  	 "Type"=>$_POST["type"],
		  	   	  	 "Entreprise"=>$_POST["entreprise"],
		  	   	  	 "Id_campagne"=>$_POST["campagne"],
		  	   	  	 "Id_statut"=>$_POST["statut"],
		  	   	  	 "Notes"=>$_POST["notes"]

		  	   	  );


		  	   	$this->contact->update($_POST["id"], $donnees_contact) ;
		  	   	$test_statut = $this->statut_contact->test_statut_contact($_POST["id"],$_POST["statut"]);

		  	   	 if($test_statut==0){

		  	   	  		$donnees_historique = array(

		  	   	  			"Date"=>date("d/m/Y"),
		  	   	  			"Id_contact"=>$_POST["id"],
		  	   	  			"Id_statut"=>$_POST["statut"],
		  	   	  			"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		  	   	  			"Notes"=>$_POST["notes"]
		  	   	  		);

		  	   	  		$this->statut_contact->ajouter_statut_contact($donnees_historique);
		  	   	 }

		  	   	$this->data['msg']  =1;


		  	   }else{

		  	   	  $donnees_contact = array(

		  	   	  	 "Date"=>date("d/m/Y"),
		  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		  	   	  	 "Civilite"=>$_POST["civilite"],
		  	   	  	 "Nom"=>$_POST["nom"],
		  	   	  	 "Prenom"=>$_POST["prenom"],
		  	   	  	 "Telephone"=>$_POST["telephone"],
		  	   	  	 "Whatsapp"=>$_POST["whatsapp"],
		  	   	  	 "Email"=>$_POST["email"],
		  	   	  	 "Profession"=>$_POST["profession"],
		  	   	  	 "Adresse"=>$_POST["adresse"],
		  	   	  	 "Pays"=>$_POST["pays"],
		  	   	  	 "Type"=>$_POST["type"],
		  	   	  	 "Entreprise"=>$_POST["entreprise"],
		  	   	  	 "Id_campagne"=>$_POST["campagne"],
		  	   	  	 "Id_statut"=>$_POST["statut"],
		  	   	  	 "Notes"=>$_POST["notes"]
		  	   	  );

		  	   	  $test_doublon = $this->contact->test_doublon($_POST["nom"],$_POST["prenom"]);
		  	   	  $test_societe =$this->contact->test_entreprise($_POST["entreprise"]);


		  	   	  if($test_societe==0){
		  	   	  	$id_contact =$this->contact->insert($donnees_contact);
		  	   	  	$test_statut = $this->statut_contact->test_statut_contact($id_contact,$_POST["statut"]);

		  	   	  	if($test_statut==0){

		  	   	  		$donnees_historique = array(

		  	   	  			"Date"=>date("d/m/Y"),
		  	   	  			"Id_contact"=>$id_contact,
		  	   	  			"Id_statut"=>$_POST["statut"],
		  	   	  			"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		  	   	  			"Notes"=>$_POST["notes"]
		  	   	  		);

		  	   	  		$this->statut_contact->ajouter_statut_contact($donnees_historique);
		  	   	  	}

		  	   	  	$this->data['msg']  =1;
		  	   	  }else{
		  	   	  	$this->data['msg']  =-1;
		  	   	  }

		  	   	  
		  	   }

		  }

		  if($id==-1){

		  	$infos_contact =$this->contact->get_by_id($id);
		  	$this->data['infos_contact']  =$infos_contact;

		  }else{

		  	$infos_contact =$this->contact->get_by_id($id);
		  	$this->data['infos_contact']  =$infos_contact;

		  }

          $liste_pays = $this->utilisateur->liste_pays();
          $this->data['liste_pays']  =$liste_pays;
          $liste_campagnes =$this->campagne->get_all();
          $this->data['liste_campagnes']=$liste_campagnes;

          $liste_statuts =$this->statut_contact->get_all(); 
          $this->data['liste_statuts']=$liste_statuts;

          $this->data['id']  = $id;
          $this->twig->display('gestion_relation_client/ajouter_contact.html.twig',$this->data);
		}


		public function details_contact($id_contact){

          $infos_contact =$this->contact->get_by_id($id_contact);
          $this->data['infos_contact']=$infos_contact;
          $infos_statut  =$this->statut_contact->get_by_id($infos_contact->Id_statut);
          $this->data['infos_statut']=$infos_statut;
          $liste_historique =$this->statut_contact->liste_historique($id_contact);
          $this->data['liste_historique']=$liste_historique;
          $liste_ventes =$this->vente->liste_by_contact($id_contact);
          $this->data['liste_ventes']=$liste_ventes;

          $this->twig->display('gestion_relation_client/details_contact.html.twig',$this->data);

		}


		public function liste_contacts($page=1,$type=1){

			  $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;

	        if($type==-1){
	        $total =$this->contact->total_contacts();
	        $this->data['num_type'] =1;
	        }


	        if($type==1){
	        $total =$this->contact->total_prospects();
	        $this->data['num_type'] =1;
	        }

	        if($type==2){
	        $total =$this->contact->total_clients();
	        $this->data['num_type'] =2;
	        }

	         $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;


	         if($type==-1){

	         $liste = $this->contact->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->contact->liste($offset_suivant,$no_of_records_per_page));

	         }

             if($type==1){

	         $liste = $this->contact->liste_prospects($offset,$no_of_records_per_page);
	         $total_suivant =count($this->contact->liste_prospects($offset_suivant,$no_of_records_per_page));

	         }

	         if($type==2){

	         $liste = $this->contact->liste_clients($offset,$no_of_records_per_page);
	         $total_suivant =count($this->contact->liste_clients($offset_suivant,$no_of_records_per_page));

	         }

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->contact->recherche($_POST["mot_cle"]);
	         	$this->data['type_contact'] ="Contacts";

	         }

           if($type==-1){
           	$this->data['type_contact'] ="Contacts";
           }

           if($type==1){
           	$this->data['type_contact'] ="Prospects";
           }

           if($type==2){
           	$this->data['type_contact'] ="Clients";
           }
           
           $this->data['liste_contacts'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('gestion_relation_client/liste_contacts.html.twig',$this->data);
		}

		public function liste_contacts_mois(){

			$liste_contacts =$this->contact->liste_contacts_periode(date("m/Y"));
			$this->data['liste_contacts'] =$liste_contacts;
			$this->data['mois_en_cours'] =date("m/Y");
			$this->data['num_type'] =-1;
			$this->twig->display('gestion_relation_client/liste_contacts_mois.html.twig',$this->data);
		}

		public function supprimer_contact($id,$type){

			$this->contact->delete($id);
			redirect("crm/liste_contacts/1/".$type);
		}

		public function ajouter_opportunite($id=-1){


			if(isset($_POST["civilite"]) and $_POST["civilite"]!=""){

				$donnes_contact = array(

					"Date"=>date("d/m/Y"),
					"Civilite"=>$_POST["civilite"],
					"Nom"=>$_POST["nom"],
					"Prenom"=>$_POST["prenom"],
					"Telephone"=>$_POST["telephone"],
					"Email"=>$_POST["email"],
					"Pays"=>$_POST["pays"],
					"Type"=>"Client",
					"Entreprise"=>$_POST["entreprise"]
				);

				$this->contact->insert($donnes_contact);
				redirect("crm/ajouter_opportunite");

			}

			if(isset($_POST["contact"]) and $_POST["contact"]!=""){


				if(isset($_POST["id"]) and $_POST["id"]!=""){


					$donnes_opportunite = array(

					"Id_contact"=>$_POST["contact"],
					"Id_source"=>$_POST["source"],
					"Nom"=>$_POST["nom_opportunite"],
					"Id_responsable"=>$_POST["id_commercial"],
					"Valeur_estimee"=>$_POST["valeur"],
					"Date_cloture"=>$_POST["date_cloture"],
					"Id_statut"=>$_POST["statut"],
					"Notes"=>$_POST["notes"]

				     );
					$this->opportunite->update($_POST["id"], $donnes_opportunite);
					$test_historique =$this->opportunite->test_historique($_POST["id"],$_POST["statut"]);
				    if($test_historique==0){

				    	$donnees_historique = array("Date"=>date("d/m/Y"),"Id_opportunite"=>$_POST["id"],"Id_responsable"=>$_POST["id"],"Id_statut"=>$_POST["statut"]);

				    	$this->opportunite->ajouter_historique($donnees_historique);
				    }
                    $this->data['msg'] =1;

				}else{

					$date =date("d/m/Y");
					$id_opportunite=-1;

				    $donnes_opportunite = array(

					"Date"=>$date,
					"Id_contact"=>$_POST["contact"],
					"Id_source"=>$_POST["source"],
					"Nom"=>$_POST["nom_opportunite"],
					"Id_responsable"=>$_POST["id_commercial"],
					"Valeur_estimee"=>$_POST["valeur"],
					"Date_cloture"=>$_POST["date_cloture"],
					"Id_statut"=>$_POST["statut"],
					"Notes"=>$_POST["notes"]

				     );

				    $test =$this->opportunite->test_doublon($date,$_POST["nom_opportunite"],$_POST["contact"]);

				    if($test==0){

				    	$id_opportunite=$this->opportunite->insert($donnes_opportunite);
				    	$this->data['msg'] =1;

				    }else{

				    	$this->data['msg'] =-1;

				    }

				    $test_historique =$this->opportunite->test_historique($id_opportunite,$_POST["statut"]);
				    if($test_historique==0){

				    	$donnees_historique = array("Date"=>date("d/m/Y"),"Id_opportunite"=>$id_opportunite,"Id_responsable"=>$_POST["id_commercial"],"Id_statut"=>$_POST["statut"]);

				    	$this->opportunite->ajouter_historique($donnees_historique);
				    }

				}

				
			}

			if($id!=-1){

				$infos_opportunite = $this->opportunite->get_by_id($id);
				$this->data['infos_opportunite'] =$infos_opportunite;
			}
			
			$this->data['has_modal'] =1;
			$this->data['id'] =$id;
			$liste_utilisateurs =$this->utilisateur->get_all();
			$this->data['liste_utilisateurs'] =$liste_utilisateurs;
         $liste_contacts = $this->contact->les_contacts();
         $this->data['liste_contacts'] =$liste_contacts;
         $liste_campagnes =$this->campagne->get_all();
         $this->data['liste_campagnes'] =$liste_campagnes;
         $liste_pays =$this->utilisateur->liste_pays();
         $this->data['liste_pays'] =$liste_pays;
         $liste_statuts_oppotunite =$this->statut_opportunite->get_all();
         $this->data['liste_statuts'] =$liste_statuts_oppotunite;
			$this->twig->display('gestion_relation_client/ajouter_opportunite.html.twig',$this->data);
		}

		public function liste_opportunites($page=1){


		  $no_of_records_per_page = 50;
        $offset = ($page-1) * $no_of_records_per_page;
        $offset_suivant = ($page) * $no_of_records_per_page;
        $total =$this->opportunite->total();
        $total_pages = ceil($total / $no_of_records_per_page);

         $this->data['total_pages'] = $total_pages;
         $this->data['page_precedente'] =$page-1;
         $this->data['page_suivante'] =$page+1;
         $this->data['page'] =$page;
         $this->data['pagination'] =1;

         $liste = $this->opportunite->liste($offset,$no_of_records_per_page);
         $total_suivant =count($this->opportunite->liste($offset_suivant,$no_of_records_per_page));

         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

         	$liste = $this->opportunite->recherche($_POST["mot_cle"]);

         }

         if(isset($_POST["date"]) and $_POST["date"]!=""){
            
            //$date_fr =$this->convertirDateFr($_POST["date"]);
         	$liste =$this->opportunite->liste_by_date_statut($_POST["date"],$_POST["statut"]);
         }


         $this->data['liste_opportunites'] =$liste;
         $this->data['total_suivant'] =$total_suivant;
         $liste_statuts =$this->statut_opportunite->get_all();
         $this->data['liste_statuts'] =$liste_statuts;

         $this->twig->display('gestion_relation_client/liste_opportunites.html.twig',$this->data);


		}


		public function liste_opportunites_gagnees(){
        
        $mois =date("m/Y");
        if(isset($_POST["mois"]) and $_POST["mois"]!=""){
        $mois =	$_POST["mois"];
        }
		  $statut_gagnee =$this->statut_opportunite->get_by_libelle("Gagnée");

        $liste_opportunites = $this->opportunite->liste_by_statut_mois($statut_gagnee->Id,$mois);

        $this->data['liste_opportunites'] =$liste_opportunites;

        $this->twig->display('gestion_relation_client/liste_opportunites_gagnees.html.twig',$this->data);

		}

		function convertirDateFr($date)
		{
		    // Vérifie la validité de la date en entrée
		    $timestamp = strtotime($date);
		    if ($timestamp === false) {
		        return '';
		    }

		    return date('d/m/Y', $timestamp);
		}

		public function details_opportunite($id){

		$infos_opportunite =$this->opportunite->get_by_id($id);

		$this->data['infos_opportunite'] =$infos_opportunite;
		$infos_contact=$this->contact->get_by_id($infos_opportunite->Id_contact);
		$this->data['infos_contact'] =$infos_contact;
		$infos_responsable= $this->utilisateur->get_by_id($infos_opportunite->Id_responsable);

		$this->data['infos_responsable'] =$infos_responsable;
		$infos_statut =$this->statut_opportunite->get_by_id($infos_opportunite->Id_statut);
		$this->data['infos_statut'] =$infos_statut;
		$liste_historique =$this->opportunite->liste_historique($infos_opportunite->Id);
      $this->data['liste_historique'] =$liste_historique;
      $liste_actions =$this->activite->liste_activites_opportunite($id);
      $this->data['liste_actions']=$liste_actions;

      $liste_devis =$this->vente->liste_devis_opportunite($id);

      $this->data['liste_devis']=$liste_devis;

      if(count($liste_devis)>0){

      	$infos_vente =$this->vente->get_by_id($liste_devis[0]->Id);
      	$this->data['infos_vente']=$infos_vente;
      }


		$this->twig->display('gestion_relation_client/details_opportunite.html.twig',$this->data);
		}


		

		public function action_opportunite($id_opportunite,$id_action=-1){

		if(isset($_POST["date"]) and $_POST["date"]!=""){

			if(isset($_POST["id"]) and $_POST["id"]!=""){

				$donnes_action = array(
			                           "Type"=>$_POST["type"],
			                           "Id_utilisateur"=>$_POST["id_commercial"],
			                           "Date"=>$_POST["date"],
			                           "Commentaires"=>$_POST["commentaires"]);

				$this->activite->update($_POST["id"], $donnes_action);
				redirect("crm/details_opportunite/".$id_opportunite);


			}else{

				$donnes_action = array("Id_opportunite"=>$id_opportunite,
			                           "Type"=>$_POST["type"],
			                           "Id_utilisateur"=>$_POST["id_commercial"],
			                           "Date"=>$_POST["date"],
			                           "Commentaires"=>$_POST["commentaires"]);
				$this->activite->insert($donnes_action);

				redirect("crm/details_opportunite/".$id_opportunite);


			}
		}

		if($id_action==-1){

			$this->data['date_action'] =date("d/m/Y H:i:s");
		}else{

			$infos_action =$this->activite->get_by_id($id_action);
			$this->data['infos_action']=$infos_action;
			$this->data['date_action'] =$infos_action->Date;
		}
		$infos_opportunite =$this->opportunite->get_by_id($id_opportunite);
		$this->data['infos_opportunite'] =$infos_opportunite;
		$this->data['id_action'] =$id_action;
        $this->data['id_opportunite'] =$id_opportunite;
        $liste_utilisateurs =$this->utilisateur->get_all();
			$this->data['liste_utilisateurs'] =$liste_utilisateurs;
        $this->twig->display('gestion_relation_client/actions_opportunite.html.twig',$this->data);

		}

		public function supprimer_opportunite($id){

			$this->opportunite->delete($id);
			redirect("crm/liste_opportunites");
		}

		public function supprimer_action_opportunite($id_action){
            $infos_action = $this->activite->get_by_id($id_action);
			$this->activite->delete($id_action);
			redirect("crm/details_opportunite/".$infos_action->Id_opportunite);
		}

		public function pipeline_commercial(){
		$mois=date("m/Y");
		if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){
            $mois=$_POST["mot_cle"];
			
		}
		$liste_pipeline = $this->statut_opportunite->liste_pipeline($mois);

		if($this->session->userdata('role')!=-1){

		$liste_pipeline =$this->statut_opportunite->liste_pipeline_commercial($this->session->userdata('id_utilisateur'),$mois);
		}
		$this->data['liste_pipeline'] =$liste_pipeline;
        $this->data['karban'] =1;

      $this->data['id_utilisateur'] =$this->session->userdata('id_utilisateur');
		$this->twig->display('gestion_relation_client/pipeline_commercial.html.twig',$this->data);

		}

		public function action_envoie_mail($id_opportunite){

            $infos_opportunite =$this->opportunite->get_by_id($id_opportunite);
			$this->data['infos_opportunite'] =$infos_opportunite;
			$infos_contact  = $this->contact->get_by_id($infos_opportunite->Id_contact);
			$this->data['infos_contact'] = $infos_contact;
			if(isset($_POST["destinataire"]) and $_POST["destinataire"]!=""){


				//Script d'envoie de mail


				//Enregistrement de l'action

				$donnes_action = array("Id_opportunite"=>$id_opportunite,
			                           "Type"=>"Email",
			                           "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
			                           "Date"=>date("d/m/Y h:i:m"),
			                           "Commentaires"=>$_POST["commentaires"]);
				$this->activite->insert($donnes_action);

				$donnes_contact=array("Email"=>$_POST["email"]);
				$this->contact->update($infos_contact->Id, $donnes_contact);

				redirect("crm/details_opportunite/".$id_opportunite);
			}
            
            $this->data['date'] =date("d/m/Y h:i:s");
            $this->data['id_opportunite'] =$id_opportunite;
			
			$this->twig->display('gestion_relation_client/action_envoie_mail.html.twig',$this->data);
		}


		public function action_envoie_whatsapp($id_opportunite){

            $infos_opportunite =$this->opportunite->get_by_id($id_opportunite);
			$this->data['infos_opportunite'] =$infos_opportunite;
			$infos_contact  = $this->contact->get_by_id($infos_opportunite->Id_contact);
			$this->data['infos_contact'] = $infos_contact;
			if(isset($_POST["destinataire"]) and $_POST["destinataire"]!=""){


				//Script d'envoie de whatsapp


				//Enregistrement de l'action

				$donnes_action = array("Id_opportunite"=>$id_opportunite,
			                           "Type"=>"Whatsapp",
			                           "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
			                           "Date"=>date("d/m/Y h:i:m"),
			                           "Commentaires"=>$_POST["commentaires"]);
				$this->activite->insert($donnes_action);

				$donnes_contact=array("Whatsapp"=>$_POST["whatsapp"]);
				$this->contact->update($infos_contact->Id, $donnes_contact);


				redirect("crm/details_opportunite/".$id_opportunite);
			}
            
            $this->data['date'] =date("d/m/Y h:i:s");
            $this->data['id_opportunite'] =$id_opportunite;
			
			$this->twig->display('gestion_relation_client/action_envoie_whatsapp.html.twig',$this->data);
		}

		public function distribuer_contacts(){
           
	           if(isset($_POST["id_contact"])){

	           	    $total_agents =count($_POST["agents"]);
					$contacts =$_POST["id_contact"];
					$agents =$_POST["agents"];

					

					for($i=0;$i<$total_agents;$i++){
                        
						$donnees_contact=array("Id_utilisateur"=>intval($agents[$i]));
						$this->contact->update(intval($contacts[$i]), $donnees_contact);
					}

	           }
			
			$liste_contacts =$this->contact->liste_nouveaux_contacts();
			if(isset($_POST["campagne"]) and $_POST["campagne"]!=""){

				$liste_contacts =$this->contact->liste_nouveaux_contacts_campagne($_POST["campagne"]);
			}
            $this->data['liste_contacts']=$liste_contacts;
            $liste_agents =$this->utilisateur->liste_agents();
            $this->data['liste_agents']=$liste_agents;
            $liste_campagnes =$this->campagne->get_all();
            $this->data['liste_campagnes']=$liste_campagnes;
            $this->twig->display('gestion_relation_client/distribuer_fiches.html.twig',$this->data);

		}

		


}