<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Docs extends MY_Controller {

	  public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');

		     $this->data['base_url'] = base_url();
		     $this->data['assets_front'] =base_url()."assets/front";
		     $this->data['assets_admin'] =base_url()."assets/admin";
		     $this->data['assets_mail']  = base_url()."assets/mail";
		     $this->data['assets_docs']  = base_url()."assets/docs";
		     $this->data['current_year']  =date("Y");
		     $role_utilisateur=$this->session->userdata('role');
		     $this->data['role_utilisateur']  =$role_utilisateur;

		     $liste_autorisations =[];
		     $liste_autorisations =$this->role->liste_codes_actions_role($this->session->userdata('role'));
		     $this->data['liste_autorisations']  =$liste_autorisations;

		     $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
		    
		     $this->data['annee_en_cours']  =date("Y");
		     $infos_utilisateur =$this->utilisateur->get_by_id($this->session->userdata('id_utilisateur'));		     
		    
		     $this->data['infos_utilisateur']  = $infos_utilisateur;


		} 

		

		public function generer_bon_commande_fournisseur($id_achat){

       $infos_societe =$this->societe->get_all();
       $this->data['infos_societe']=$infos_societe[0];
		   $infos_achat =$this->achat->get_by_id($id_achat);
		   $this->data['infos_achat'] =$infos_achat;
		   $infos_fournisseur = $this->fournisseur->get_by_id($infos_achat->Id_fournisseur);
		   $this->data['infos_fournisseur'] =$infos_fournisseur;
		   $liste_articles =$this->achat->liste_details_achat($id_achat);

		   $this->data['liste_articles']  =$liste_articles;
		   $total_ht =$this->achat->get_total_ht($id_achat);
		   $total_ht_devise =$this->achat->get_total_ht_devise($id_achat);
		   $total_ttc =$this->achat->get_total_ttc($id_achat);
		   $total_ttc_devise =$this->achat->get_total_ttc_devise($id_achat);
		   $total_tva =$this->achat->get_total_tva($id_achat);
		   $total_tva_devise =$this->achat->get_total_tva_devise($id_achat);
		   $this->data['total_tva'] =$total_tva;
		   $this->data['total_tva_devise'] =$total_tva_devise;
		   $this->data['total_ht'] =$total_ht;
		   $this->data['total_ht_devise'] =$total_ht_devise;
	   	 $this->data['total_ttc'] =$total_ttc;
	   	 $this->data['total_ttc_devise'] =$total_ttc_devise;

	   	 $this->twig->display('docs_commande_fournisseur/'.$infos_societe[0]->Couleur_documents.'.html.twig',$this->data);

		    	
		}

		public function generer_bon_reception($id_achat){

           $infos_societe =$this->societe->get_all();
           $this->data['infos_societe']=$infos_societe[0];
		   $infos_achat =$this->achat->get_by_id($id_achat);
		   $this->data['infos_achat'] =$infos_achat;
		   $infos_fournisseur = $this->fournisseur->get_by_id($infos_achat->Id_utilisateur);
		   $this->data['infos_fournisseur'] =$infos_fournisseur;
		   $liste_articles =$this->achat->liste_articles_reception($id_achat);
		   $this->data['liste_articles']  =$liste_articles;
		   $total_ht =$this->achat->get_total_ht($id_achat);
		   $total_ht_devise =$this->achat->get_total_ht_devise($id_achat);
		   $total_ttc =$this->achat->get_total_ttc($id_achat);
		   $total_ttc_devise =$this->achat->get_total_ttc_devise($id_achat);
		   $total_tva =$this->achat->get_total_tva($id_achat);
		   $total_tva_devise =$this->achat->get_total_tva_devise($id_achat);
		   $this->data['total_tva'] =$total_tva;
		   $this->data['total_tva_devise'] =$total_tva_devise;
		   $this->data['total_ht'] =$total_ht;
		   $this->data['total_ht_devise'] =$total_ht_devise;
	   	 $this->data['total_ttc'] =$total_ttc;
	   	 $this->data['total_ttc_devise'] =$total_ttc_devise;

	   	   $this->twig->display('docs_bon_reception/'.$infos_societe[0]->Couleur_documents.'.html.twig',$this->data);

		    	
		}


		public function generer_devis($id){

          $infos_societe =$this->societe->get_all();
          $this->data['infos_societe']=$infos_societe[0];

          $infos_vente =$this->vente->get_by_id($id);
          $infos_client =$this->contact->get_by_id($infos_vente->Id_client);

          $banque =$infos_societe[0]->Banque;
          $iban=$infos_societe[0]->IBAN;
          $code_swift=$infos_societe[0]->Code_swift;

          if($infos_vente->Id_compte_bancaire!="-1"){

          	$infos_compte_bancaire =$this->compte_bancaire->get_by_id($infos_vente->Id_compte_bancaire);
          	$banque =$infos_compte_bancaire->Institution_bancaire;
            $iban=$infos_compte_bancaire->RIB;
            $code_swift=$infos_compte_bancaire->SWIFT;
          }

          $this->data['banque'] =$banque;
          $this->data['iban'] =$iban;
          $this->data['code_swift'] =$code_swift;

          $this->data['infos_client'] =$infos_client;
          $this->data['infos_vente']  =$infos_vente;
          $liste_articles = $this->vente->liste_details_vente($id);
          $this->data['liste_articles']  =$liste_articles;
          $total_ht =$this->vente->get_total_ht($id);
          $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	    $total_ttc =$this->vente->get_total_ttc($id);
	   	    $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	    $total_tva =$this->vente->get_total_tva($id);
	   	    $total_tva_devise =$this->vente->get_total_tva_devise($id);
	   	  
	   	    $this->data['total_tva'] =$total_tva;
	   	    $this->data['total_tva_devise'] =$total_tva_devise;
	   	    $this->data['total_ht'] =$total_ht;
	   	    $this->data['total_ht_devise'] =$total_ht_devise;
	   	    $this->data['total_ttc'] =$total_ttc;
	   	    $this->data['total_ttc_devise'] =$total_ttc_devise;
   	
          $this->twig->display('docs_devis/'.$infos_societe[0]->Couleur_documents.'.html.twig',$this->data);

		}

		public function generer_bon_commande($id){

          $infos_societe =$this->societe->get_all();
          $this->data['infos_societe']=$infos_societe[0];
          $infos_vente =$this->vente->get_by_id($id);
          $infos_client =$this->contact->get_by_id($infos_vente->Id_client);

          $banque =$infos_societe[0]->Banque;
          $iban=$infos_societe[0]->IBAN;
          $code_swift=$infos_societe[0]->Code_swift;

          if($infos_vente->Id_compte_bancaire!="-1"){

          	$infos_compte_bancaire =$this->compte_bancaire->get_by_id($infos_vente->Id_compte_bancaire);
          	$banque =$infos_compte_bancaire->Institution_bancaire;
            $iban=$infos_compte_bancaire->RIB;
            $code_swift=$infos_compte_bancaire->SWIFT;
          }

          $this->data['banque'] =$banque;
          $this->data['iban'] =$iban;
          $this->data['code_swift'] =$code_swift;



          $this->data['infos_client'] =$infos_client;
          $this->data['infos_vente']  =$infos_vente;
          $liste_articles = $this->vente->liste_details_vente($id);
          $this->data['liste_articles']  =$liste_articles;
          $total_ht =$this->vente->get_total_ht($id);
          $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	    $total_ttc =$this->vente->get_total_ttc($id);
	   	    $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	    $total_tva =$this->vente->get_total_tva($id);
	   	    $total_tva_devise =$this->vente->get_total_tva_devise($id);
	   	  
	   	  $this->data['total_tva'] =$total_tva;
	   	  $this->data['total_tva_devise'] =$total_tva_devise;
	   	  $this->data['total_ht'] =$total_ht;
	   	  $this->data['total_ht_devise'] =$total_ht_devise;
	   	  $this->data['total_ttc'] =$total_ttc;
	   	  $this->data['total_ttc_devise'] =$total_ttc_devise;
   	
          $this->twig->display('docs_commande_client/'.$infos_societe[0]->Couleur_documents.'.html.twig',$this->data);

		}

		public function generer_bon_livraison($id){

          $infos_societe =$this->societe->get_all();
          $this->data['infos_societe']=$infos_societe[0];
          $infos_vente =$this->vente->get_by_id($id);
          $infos_client =$this->contact->get_by_id($infos_vente->Id_client);
          $this->data['infos_client'] =$infos_client;
          $this->data['infos_vente']  =$infos_vente;

          $banque =$infos_societe[0]->Banque;
          $iban=$infos_societe[0]->IBAN;
          $code_swift=$infos_societe[0]->Code_swift;

          if($infos_vente->Id_compte_bancaire!="-1"){

          	$infos_compte_bancaire =$this->compte_bancaire->get_by_id($infos_vente->Id_compte_bancaire);
          	$banque =$infos_compte_bancaire->Institution_bancaire;
            $iban=$infos_compte_bancaire->RIB;
            $code_swift=$infos_compte_bancaire->SWIFT;
          }

          $this->data['banque'] =$banque;
          $this->data['iban'] =$iban;
          $this->data['code_swift'] =$code_swift;


          $liste_articles = $this->vente->liste_details_vente($id);
          $this->data['liste_articles']  =$liste_articles;
          $total_ht =$this->vente->get_total_ht($id);
          $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	  $total_ttc =$this->vente->get_total_ttc($id);
	   	  $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	  $total_tva =$this->vente->get_total_tva($id);
	   	  $total_tva_devise =$this->vente->get_total_tva_devise($id);
	   	  
	   	  $this->data['total_tva'] =$total_tva;
	   	  $this->data['total_tva_devise'] =$total_tva_devise;
	   	  $this->data['total_ht'] =$total_ht;
	   	  $this->data['total_ht_devise'] =$total_ht_devise;
	   	  $this->data['total_ttc'] =$total_ttc;
	   	  $this->data['total_ttc_devise'] =$total_ttc_devise;
        $this->twig->display('docs_bon_livraison/'.$infos_societe[0]->Couleur_documents.'.html.twig',$this->data);

		}


		public function generer_facture($id){

          $infos_societe =$this->societe->get_all();
          $this->data['infos_societe']=$infos_societe[0];
          $infos_vente =$this->vente->get_by_id($id);
          $infos_client =$this->contact->get_by_id($infos_vente->Id_client);
          $this->data['infos_client'] =$infos_client;
          $this->data['infos_vente']  =$infos_vente;

          $banque =$infos_societe[0]->Banque;
          $iban=$infos_societe[0]->IBAN;
          $code_swift=$infos_societe[0]->Code_swift;

          if($infos_vente->Id_compte_bancaire!="-1"){

          	$infos_compte_bancaire =$this->compte_bancaire->get_by_id($infos_vente->Id_compte_bancaire);
          	$banque =$infos_compte_bancaire->Institution_bancaire;
            $iban=$infos_compte_bancaire->RIB;
            $code_swift=$infos_compte_bancaire->SWIFT;
          }

          $this->data['banque'] =$banque;
          $this->data['iban'] =$iban;
          $this->data['code_swift'] =$code_swift;


          $liste_articles = $this->vente->liste_details_vente($id);
          $this->data['liste_articles']  =$liste_articles;
          $total_ht =$this->vente->get_total_ht($id);
          $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	  $total_ttc =$this->vente->get_total_ttc($id);
	   	  $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	  $total_tva =$this->vente->get_total_tva($id);
	   	  $total_tva_devise =$this->vente->get_total_tva_devise($id);
	   	  
	   	  $this->data['total_tva'] =$total_tva;
	   	  $this->data['total_tva_devise'] =$total_tva_devise;
	   	  $this->data['total_ht'] =$total_ht;
	   	  $this->data['total_ht_devise'] =$total_ht_devise;
	   	  $this->data['total_ttc'] =$total_ttc;
	   	  $this->data['total_ttc_devise'] =$total_ttc_devise;
		  $this->twig->display('docs_facture_client/'.$infos_societe[0]->Couleur_documents.'.html.twig',$this->data);
		}

		public function ticket_caisse($id){

		  $infos_societe =$this->societe->get_all();
          $this->data['infos_societe']=$infos_societe[0];
          $infos_vente =$this->vente->get_by_id($id);
          $infos_client =$this->contact->get_by_id($infos_vente->Id_client);
          $infos_responsable =$this->utilisateur->get_by_id($infos_vente->Id_utilisateur);
          $this->data['infos_responsable']= $infos_responsable;
          $this->data['infos_client'] =$infos_client;
          $this->data['infos_vente']  =$infos_vente;
          $liste_articles = $this->vente->liste_details_vente($id);
          $this->data['liste_articles']  =$liste_articles;
          $total_ht =$this->vente->get_total_ht($id);
          $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	  $total_ttc =$this->vente->get_total_ttc($id);
	   	  $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	  $total_tva =$this->vente->get_total_tva($id);
	   	  $total_tva_devise =$this->vente->get_total_tva_devise($id);
	   	  
	   	  $this->data['total_tva'] =$total_tva;
	   	  $this->data['total_tva_devise'] =$total_tva_devise;
	   	  $this->data['total_ht'] =$total_ht;
	   	  $this->data['total_ht_devise'] =$total_ht_devise;
	   	  $this->data['total_ttc'] =$total_ttc;
	   	  $this->data['total_ttc_devise'] =$total_ttc_devise;
		  $this->twig->display('docs_facture_client/impression_caisse.html.twig',$this->data);


		}

		public function envoyer_devis($id){

        $infos_vente = $this->vente->get_by_id($id);
        $this->data['infos_vente'] =$infos_vente;
        $infos_client =$this->contact->get_by_id($infos_vente->Id_client);
        $this->data['infos_client'] =$infos_client;

        $infos_societe =$this->societe->get_all();
		    $this->data['societe']  =$infos_societe[0];
		    $this->data['id']  =$id;

				if(isset($_POST["email_client"]) and $_POST["email_client"]!=""){

					$to=$_POST["email_client"];
					$objet=$_POST["objet"];
					$message=$_POST["message"];
					$this->envoie_mail_commercial($to,$objet,$message);
					$this->data['message'] =1;
				}

		    $this->data['has_ckeditor']  =1;
		    $this->data['id_vente'] =$id;

        $this->twig->display('gestion_commerciale/envoie_devis.html.twig',$this->data);

		}

		public function envoie_mail_commercial($to,$objet,$message){

      $infos_societe =$this->societe->get_all();

			$config = array(
          'protocol'  => 'smtp',
          'smtp_host' => $infos_societe[0]->Serveur_smtp,
          'smtp_port' => 465,
          'smtp_user' => $infos_societe[0]->Utilisateur_smtp,
          'smtp_pass' => $infos_societe[0]->Password_smtp,
          'mailtype'  => 'html',
          'charset'   => 'utf-8'
        );

        $this->email->initialize($config);
        $this->email->set_mailtype("html");
        $this->email->set_newline("\r\n");

        $this->email->to($to);
        $this->email->from($infos_societe[0]->Utilisateur_smtp,$infos_societe[0]->Raison_sociale);
        $this->email->reply_to($infos_societe[0]->Utilisateur_smtp);
        $this->email->subject($objet);
        $this->email->message($message);
        $this->email->send();

			}



}