<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Gestion_commerciale extends MY_Controller {


	       public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->data['base_url']       = base_url();
		     $this->data['assets_front']   = base_url()."assets/front";
		     $this->data['assets_admin']   = base_url()."assets/admin";
		     $this->data['assets_mail']    = base_url()."assets/mail";
		     $this->data['current_year']   = date("Y");
		     $this->data['mois_en_cours']  = date("m/Y");
		     $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
		     $this->data['infos_societe']  =$infos_societe[0];
		     $infos_utilisateur = $this->utilisateur->get_by_id($this->session->userdata('id_utilisateur'));


		     $this->data['infos_utilisateur']  =$infos_utilisateur;
		     $this->data['role_utilisateur']  = $this->session->userdata('role');
		     $compte_bancaire="";

		     if($infos_utilisateur->Id_compte_associe!=-1){

		     	$infos_compte =$this->compte_bancaire->get_by_id($infos_utilisateur->Id_compte_associe);
		     	$compte_bancaire=$infos_compte->Nom_du_compte;
		     }

		     $this->data['compte_bancaire']  =$compte_bancaire;

		     $liste_autorisations =[];
		     $liste_autorisations =$this->role->liste_codes_actions_role($this->session->userdata('role'));
		     $this->data['liste_autorisations']  =$liste_autorisations;

		    
		    } 

		    public function index(){
		      
               $this->data['dash_ventes'] =1;
               $liste_stats = $this->vente->statistiques_ventes_annuel();
               $this->data['liste_stats_ventes']=json_encode($liste_stats);
               $chiffre_affaire_mois =$this->vente->get_total_ttc_mois(date("Y-m"));
               $this->data['chiffre_affaire_mois'] =$chiffre_affaire_mois;
               $total_devis_valides =$this->vente->total_by_type_statut("Devis","Validé",date("Y-m"));
               $this->data['total_devis_valides'] =$total_devis_valides;
               $total_commandes_valides =$this->vente->total_by_type_statut("Bon_commande","Validé",date("Y-m"));
               $this->data['total_commandes_valides'] =$total_commandes_valides;
               $total_factures =$this->vente->total_by_type_statut("Facture","Validé",date("Y-m"));
               $this->data['total_factures'] =$total_factures;
               $total_bons_commande_fournisseur = $this->achat->total_by_type_statut("BCF","Validé",date("Y-m"));
               $this->data['total_bons_commande_fournisseur'] =$total_bons_commande_fournisseur;
               $total_demandes_achat=$this->achat->total_demandes_achat();
               $this->data['total_demandes_achat'] =$total_demandes_achat;
               $total_devis_non_valides =$this->vente->total_devis_non_valides();
               $this->data['total_devis_non_valides'] =$total_devis_non_valides;
               $total_devis_non_valides =$this->vente->total_devis_non_valides();
               $this->data['total_devis_non_valides'] =$total_devis_non_valides;


               $this->data['has_chart'] =1;
               
		       $this->twig->display('gestion_commerciale/dashboard_commerciale.html.twig',$this->data);
		    }

		    public function stats_vente_par_commerciaux(){

		    	 $liste_commerciaux =$this->vente->liste_commerciaux_vente_periode(date("Y-m"));
		    	 $statistiques_commerciaux =$this->vente->statistiques_ventes_commerciaux_periode(date("Y-m"));

		    	 $this->data['liste_commerciaux']  =json_encode($liste_commerciaux);
		    	 $this->data['statistiques_commerciaux'] =json_encode($statistiques_commerciaux); 

		    	 $chiffre_affaire_mois =$this->vente->get_total_ttc_mois(date("Y-m"));
                 $this->data['chiffre_affaire_mois'] =$chiffre_affaire_mois;

                 $chiffre_affaire_jour =$this->vente->get_total_ttc_jour(date("Y-m-d"));
                 $this->data['chiffre_affaire_jour'] =$chiffre_affaire_jour;

                 $chiffre_affaire_semaine = $this->vente->get_total_ttc_semaine_en_cours();
                 $this->data['chiffre_affaire_semaine'] =$chiffre_affaire_semaine;

                 $total_contact_mois =$this->contact->total_contacts_periode(date("d/m/Y"));
                 $this->data['total_contacts_acquis_mois'] =$total_contact_mois;

                 $infos_societe =$this->societe->get_all();
		         $this->data['societe']  =$infos_societe[0];
                 $this->data['stats_ventes_commerciaux'] =1;
                 $this->data['has_chart'] =1;
		    	 $this->twig->display('gestion_commerciale/stats_vente_par_commerciaux.html.twig',$this->data);
		    }

		    public function demandes_achat($id=-1,$page=1){

		    	$no_of_records_per_page = 50;
		        $offset = ($page-1) * $no_of_records_per_page;
		        $offset_suivant = ($page) * $no_of_records_per_page;
		        $total =$this->achat->total_demandes_achat();
		        $total_pages = ceil($total / $no_of_records_per_page);

		         $this->data['total_pages'] = $total_pages;
		         $this->data['page_precedente'] =$page-1;
		         $this->data['page_suivante'] =$page+1;
		         $this->data['page'] =$page;
		         $this->data['pagination'] =1;

		         $liste = $this->achat->liste_demandes_achat($offset,$no_of_records_per_page);
		         $total_suivant =count($this->achat->liste_demandes_achat($offset_suivant,$no_of_records_per_page));

		         if(isset($_POST["date_acchat"]) and $_POST["date_acchat"]!=""){

                   $liste =$this->achat->recherche($_POST["date_acchat"]);
		         }


		         $this->data['liste_demandes_achat'] =$liste;
                 $this->data['total_suivant'] =$total_suivant;

		    	$liste_fournisseurs = $this->fournisseur->get_all();
		    	$this->data['liste_fournisseurs'] =$liste_fournisseurs;
                if($id==-1){

                	$this->data['date_achat'] =date("Y-m-d");
                }

                $liste_devises =$this->utilisateur->liste_devises();
		        $this->data['liste_devises'] =$liste_devises;

		    	$this->twig->display('gestion_commerciale/demandes_achat.html.twig',$this->data);
		    }

		    public function commandes_fournisseur($id=-1,$page=1){

		    	$no_of_records_per_page = 50;
		        $offset = ($page-1) * $no_of_records_per_page;
		        $offset_suivant = ($page) * $no_of_records_per_page;
		        $total =$this->achat->total_commandes_fournisseurs();
		        $total_pages = ceil($total / $no_of_records_per_page);

		         $this->data['total_pages'] = $total_pages;
		         $this->data['page_precedente'] =$page-1;
		         $this->data['page_suivante'] =$page+1;
		         $this->data['page'] =$page;
		         $this->data['pagination'] =1;

		        
		         $liste = $this->achat->liste_commandes_fournisseur($offset,$no_of_records_per_page);
		         $total_suivant =count($this->achat->liste_commandes_fournisseur($offset_suivant,$no_of_records_per_page));

		         if(isset($_POST["date_acchat"]) and $_POST["date_acchat"]!=""){

                   $liste =$this->achat->recherche($_POST["date_acchat"]);
		         }

		         if(isset($_POST["fournisseur"]) and $_POST["fournisseur"]!=""){

                   $liste =$this->achat->recherche_avancee($_POST["fournisseur"],$_POST["statut"],"BCF");
		         }

		         $this->data['liste_commandes_fournisseur'] =$liste;
                 $this->data['total_suivant'] =$total_suivant;

		    	$liste_fournisseurs = $this->fournisseur->get_all();
		    	$this->data['liste_fournisseurs'] =$liste_fournisseurs;
                if($id==-1){

                	$this->data['date_achat'] =date("Y-m-d");
                }

                $liste_devises =$this->utilisateur->liste_devises();
		        $this->data['liste_devises'] =$liste_devises;

		    	$this->twig->display('gestion_commerciale/commandes_fournisseur.html.twig',$this->data);
		    }

		    public function liste_bons_recepotion($id=-1,$page=1){

		    	$no_of_records_per_page = 50;
		        $offset = ($page-1) * $no_of_records_per_page;
		        $offset_suivant = ($page) * $no_of_records_per_page;
		        $total =$this->achat->total_bons_reception();
		        $total_pages = ceil($total / $no_of_records_per_page);

		         $this->data['total_pages'] = $total_pages;
		         $this->data['page_precedente'] =$page-1;
		         $this->data['page_suivante'] =$page+1;
		         $this->data['page'] =$page;
		         $this->data['pagination'] =1;

		         $liste = $this->achat->liste_bons_reception($offset,$no_of_records_per_page);
		         $total_suivant =count($this->achat->liste_bons_reception($offset_suivant,$no_of_records_per_page));

		         if(isset($_POST["date_acchat"]) and $_POST["date_acchat"]!=""){

                   $liste =$this->achat->recherche($_POST["date_acchat"]);
		         }

		        if(isset($_POST["fournisseur"]) and $_POST["fournisseur"]!=""){

                   $liste =$this->achat->recherche_avancee($_POST["fournisseur"],$_POST["statut"],"BRF");

		         }


		         $this->data['liste_bons_reception'] =$liste;
                 $this->data['total_suivant'] =$total_suivant;

		    	$liste_fournisseurs = $this->fournisseur->get_all();
		    	$this->data['liste_fournisseurs'] =$liste_fournisseurs;
                if($id==-1){

                	$this->data['date_achat'] =date("Y-m-d");
                }

                $liste_devises =$this->utilisateur->liste_devises();
		        $this->data['liste_devises'] =$liste_devises;

		    	$this->twig->display('gestion_commerciale/liste_bons_reception.html.twig',$this->data);
		    }

		    public function liste_factures_fournisseur($id=-1,$page=1){

		    	$no_of_records_per_page = 50;
		        $offset = ($page-1) * $no_of_records_per_page;
		        $offset_suivant = ($page) * $no_of_records_per_page;
		        $total =$this->achat->total_factures_achat();
		        $total_pages = ceil($total / $no_of_records_per_page);

		         $this->data['total_pages'] = $total_pages;
		         $this->data['page_precedente'] =$page-1;
		         $this->data['page_suivante'] =$page+1;
		         $this->data['page'] =$page;
		         $this->data['pagination'] =1;

		         $liste = $this->achat->liste_factures_achat($offset,$no_of_records_per_page);
		         $total_suivant =count($this->achat->liste_factures_achat($offset_suivant,$no_of_records_per_page));

		         if(isset($_POST["date_acchat"]) and $_POST["date_acchat"]!=""){

                   $liste =$this->achat->recherche($_POST["date_acchat"]);
		         }

		         if(isset($_POST["fournisseur"]) and $_POST["fournisseur"]!=""){

                   $liste =$this->achat->recherche_avancee($_POST["fournisseur"],$_POST["statut"],"FF");
		         }

		         $this->data['liste_factures_achat'] =$liste;
                 $this->data['total_suivant'] =$total_suivant;

		    	$liste_fournisseurs = $this->fournisseur->get_all();
		    	$this->data['liste_fournisseurs'] =$liste_fournisseurs;
                if($id==-1){

                	$this->data['date_achat'] =date("Y-m-d");
                }

                $liste_devises =$this->utilisateur->liste_devises();
		        $this->data['liste_devises'] =$liste_devises;

		    	$this->twig->display('gestion_commerciale/liste_factures_achat.html.twig',$this->data);


		    }

		    public function supprimer_bon_reception($id){

		    	$this->achat->delete($id);
		    	$this->achat->delete_achat($id);
		    	redirect("gestion_commerciale/liste_bons_recepotion");
		    }

		    public function supprimer_demande_achat($id){
                $infos_achat = $this->achat->get_by_id($id);
		    	$this->achat->delete($id);
		    	$this->achat->delete_achat($id);
		    	if($infos_achat->Statut=="Brouillon"){
                    redirect("gestion_commerciale/demandes_achat");
		    	}else{
		    		redirect("gestion_commerciale/commandes_fournisseur");
		    	}
		    	

		    }

		     public function supprimer_facture_achat($id){

		    	$this->achat->delete($id);
		    	$this->achat->delete_achat($id);
		    	redirect("gestion_commerciale/liste_factures_fournisseur");
		    }

		    public function modifier_infos_achat($id_achat){



		     if(isset($_POST["fournisseur"]) and $_POST["fournisseur"]!=""){


		     	  $donnees_achat = array(
                    "Numero_demande"=>$_POST["reference"],
		     	  	"Id_fournisseur"=>$_POST["fournisseur"],
		     	  	"Date_livraison"=>$_POST["date_livraison"],
		     	  	"Lieu_livraison"=>$_POST["lieu_livraison"],
		     	  	"Mode_reglement"=>$_POST["mode_reglement"],
		     	  	"Devise"=>$_POST["devise"]

		     	  );

		     	  $this->achat->update($id_achat, $donnees_achat);
		     	  $infos_achat =$this->achat->get_by_id($id_achat);

		     	  if($infos_achat->Type=="BCF"){

		     	  	if($infos_achat->Statut=="Brouillon"){

                      redirect("gestion_commerciale/demandes_achat");

		     	  	}else{
                      
                      redirect("gestion_commerciale/commandes_fournisseur");

		     	  	}

		     	  	


		     	  }


		     }


             $infos_achat =$this->achat->get_by_id($id_achat);
             $this->data['infos_achat'] =$infos_achat;
             $liste_fournisseurs = $this->fournisseur->get_all();
             $this->data['liste_fournisseurs'] =$liste_fournisseurs;
             $liste_modes_reglement =$this->modes_paiement->get_all();
             $this->data['liste_modes_reglement'] =$liste_modes_reglement;
             $liste_devises =$this->utilisateur->liste_devises();
		     $this->data['liste_devises'] =$liste_devises;
		     $this->data['id_achat'] =$id_achat;
             $this->twig->display('gestion_commerciale/modifier_infos_achat.html.twig',$this->data);

		    }


		    public function modifier_infos_vente($id_vente){

                $infos_vente =$this->vente->get_by_id($id_vente);
		    	if(isset($_POST["duree_validite"]) and  $_POST["duree_validite"]!=""){


		    		  $donnees_vente =array(
		                              "Duree_validite"=>$_POST["duree_validite"],
		                              "Conditions_reglement"=>$_POST["conditions_reglement"],
		                              "Mode_reglement"=>$_POST["mode_reglement"],
		                              "Date_livraison"=>$_POST["date_livraison"],
		                              "Devise"=>$_POST["devise"],
		                              "Reference_commande"=>$_POST["reference_commande_client"],
		                              "Id_compte_bancaire"=>$_POST["compte_bancaire"],
		                              "Notes"=>$_POST["notes"]
		                           );
		     	      $this->vente->update($_POST["id"], $donnees_vente);

		     	      if($infos_vente->Type=="Devis"){

		     	      	redirect("gestion_commerciale/liste_devis");
		     	      }

		     	      if($infos_vente->Type=="Bon_commande"){

		     	      	redirect("gestion_commerciale/liste_bons_commande");
		     	      }

		     	      if($infos_vente->Type=="Bon_livraison"){

		     	      	redirect("gestion_commerciale/liste_bons_livraison");
		     	      }

		     	       if($infos_vente->Type=="Facture"){

		     	      	redirect("gestion_commerciale/liste_factures_client");
		     	      }


		    	}


		    	$this->data['infos_vente'] =$infos_vente;

		    	$liste_clients =$this->contact->les_contacts();
		    	$this->data['liste_contacts'] =$liste_clients;

		    	$liste_modes_reglement =$this->modes_paiement->get_all();
                $this->data['liste_modes_reglement'] =$liste_modes_reglement;
                $liste_devises =$this->utilisateur->liste_devises();
		        $this->data['liste_devises'] =$liste_devises;

                $liste_conditions_reglements =$this->conditions_reglement->get_all();
                $this->data['liste_conditions_reglements'] =$liste_conditions_reglements;

                $liste_comptes_bancaires =$this->compte_bancaire->get_all();
		        $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;

                $this->data['modification'] =1;

		        $this->twig->display('gestion_commerciale/modifier_infos_vente.html.twig',$this->data);



		    }



		    public function creer_demande_achat(){

		    	$infos_numerotation =$this->numerotation->get_all();

		        $code_demande_achat =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_commande_fournisseur,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_commande_fournisseur+1,$infos_numerotation[0]->Taille_reference);

		        $donnees_numerotation = array("Compteur_bon_commande_fournisseur"=>$infos_numerotation[0]->Compteur_bon_commande_fournisseur+1);
		        $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);


		    	$donnees_achat =array(
                    "Type"=>"BCF",
		    		"Numero_demande"=>$code_demande_achat,
		    		"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		    		"Id_fournisseur"=>$_POST["fournisseur"],
		    		"Date_achat"=>$_POST["date_achat"],
		    		"Devise"=>$_POST["devise"],
		    		"Statut"=>"Brouillon"
		    	);

		    	$id_achat=$this->achat->insert($donnees_achat);

		    	$donnees_statut = array("Id_achat"=>$id_achat,
		                                "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                                "Date"=>date("d/m/Y H:i:s"),
		                                "Statut"=>"Brouillon");
		    	$this->historique_statut_achat->insert($donnees_statut);

		    	redirect("gestion_commerciale/details_demande_achat/".$id_achat);
		    }

		    

		    public function creer_commande_fournisseur(){

		    	$infos_numerotation =$this->numerotation->get_all();

		        $code_demande_achat =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_commande_fournisseur,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_commande_fournisseur+1,$infos_numerotation[0]->Taille_reference);

		        $donnees_numerotation = array("Compteur_bon_commande_fournisseur"=>$infos_numerotation[0]->Compteur_bon_commande_fournisseur+1);
		        $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

		    	$donnees_achat =array(
                    "Type"=>"BCF",
		    		"Numero_demande"=>$code_demande_achat,
		    		"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		    		"Id_fournisseur"=>$_POST["fournisseur"],
		    		"Date_achat"=>$_POST["date_achat"],
		    		"Devise"=>$_POST["devise"],
		    		"Statut"=>"Validé"
		    	);

		    	$id_achat=$this->achat->insert($donnees_achat);

		    	$donnees_statut = array("Id_achat"=>$id_achat,
		                                "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                                "Date"=>date("d/m/Y H:i:s"),
		                                "Statut"=>"Brouillon");
		    	$this->historique_statut_achat->insert($donnees_statut);

		    	redirect("gestion_commerciale/details_demande_achat/".$id_achat);
		    }

		    public function creer_facture_achat(){

		    	$code_facture_client = "FA".time();
		    	$donnees_achat =array(
                    "Type"=>"FF",
		    		"Numero_demande"=>$code_facture_client,
		    		"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		    		"Id_fournisseur"=>$_POST["fournisseur"],
		    		"Date_achat"=>$_POST["date_achat"],
		    		"Devise"=>$_POST["devise"],
		    		"Statut"=>"Validé"
		    	);

		    	$id_achat=$this->achat->insert($donnees_achat);

		    	$donnees_statut = array("Id_achat"=>$id_achat,
		                                "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                                "Date"=>date("d/m/Y H:i:s"),
		                                "Statut"=>"Brouillon");
		    	$this->historique_statut_achat->insert($donnees_statut);

		    	redirect("gestion_commerciale/details_facture_achat/".$id_achat);


		    }

		    public function creer_facture_achat_by_commande($id_achat){

		    	$infos_achat = $this->achat->get_by_id($id_achat);
		    	$liste_articles_achat =$this->achat->liste_details_achat($id_achat);

		    	$code_facture_client = "FA".time();
		    	$donnees_achat =array(
                    "Type"=>"FF",
                    "Id_parent"=>$id_achat,
		    		"Numero_demande"=>$code_facture_client,
		    		"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		    		"Id_fournisseur"=>$infos_achat->Id_fournisseur,
		    		"Date_achat"=>$infos_achat->Date_achat,
		    		"Date_livraison"=>$infos_achat->Date_livraison,
		    		"Lieu_livraison"=>$infos_achat->Lieu_livraison,
		    		"Mode_reglement"=>$infos_achat->Mode_reglement,
		    		"Devise"=>$infos_achat->Devise,
		    		"Statut"=>"Validé"
		    	);

		    	$id_facture =$this->achat->insert($donnees_achat);

		    	foreach($liste_articles_achat as $achat){

		    		$donnees_details = array(

		    			"Id_article"=>$achat->Id_article,
		    			"Id_achat"=>$id_facture,
		    			"Quantite"=>$achat->Quantite,
		    			"Prix_unitaire"=>$achat->Prix_unitaire,
		    			"Prix_unitaire_devise"=>$achat->Prix_unitaire_devise,
		    			"Tva"=>$achat->Tva,
		    			"Total_ht"=>$achat->Total_ht,
		    			"Total_ht_devise"=>$achat->Total_ht_devise,
		    			"Total_ttc"=>$achat->Total_ttc,
		    			"Total_ttc_devise"=>$achat->Total_ttc_devise

		    		);

		    		$this->achat->ajout_details_achat($donnees_details);
		    	}

		    	redirect("gestion_commerciale/details_facture_achat/".$id_facture);


		    }

		    public function set_statut_achat($id_achat,$statut){

		    	if($statut==2){

		    		$libelle_statut="En attente de validation";
		    	}

		    	if($statut==3){

		    		$libelle_statut="Validé";
		    	}

		    	if($statut==4){

		    		$libelle_statut="Annulé";
		    	}

		    	$donnees_statut= array("Statut"=>$libelle_statut);
		    	$this->achat->update($id_achat, $donnees_statut);

		    	$donnees_historique = array("Id_achat"=>$id_achat,"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),"Statut"=>$libelle_statut);
		    	$this->historique_statut_achat->insert($donnees_historique);

		    	redirect("gestion_commerciale/details_demande_achat/".$id_achat);

		    }

		    public function set_statut_vente($id_vente,$statut){

		    	if($statut==3){

		    		$libelle_statut="Validé";
		    	}

		    	if($statut==4){

		    		$libelle_statut="Annulé";
		    	}

		    	$donnees_statut= array("Statut"=>$libelle_statut);
		    	$this->vente->update($id_vente, $donnees_statut);

		    	$donnees_historique = array("Id_vente"=>$id_vente,"Id_utilisateur"=>$this->session->userdata('id_utilisateur'),"Statut"=>$libelle_statut);
		    	$this->historique_statut_vente->insert($donnees_historique);

		    	redirect("gestion_commerciale/details_vente/".$id_vente);

		    }

		    public function creer_bon_reception($id_achat){

		     $infos_numerotation =$this->numerotation->get_all();

		     $code_demande_reception =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_reception_fournisseur,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_reception_fournisseur+1,$infos_numerotation[0]->Taille_reference);

		     $infos_demande_achat =$this->achat->get_by_id($id_achat);

		     $donnees_numerotation = array("Compteur_bon_reception_fournisseur"=>$infos_numerotation[0]->Compteur_bon_reception_fournisseur+1);
		        $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

             $donnees_bon_reception = array("Type"=>"BRF",
             	                            "Id_parent"=>$id_achat,
             	                            "Numero_demande"=>$code_demande_reception,
             	                            "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
             	                            "Id_fournisseur"=>$infos_demande_achat->Id_fournisseur,
             	                            "Date_achat"=>date("Y-m-d"),
             	                            "Devise"=>$infos_demande_achat->Devise,
             	                            "Date_livraison"=>$infos_demande_achat->Date_livraison,
             	                            "Lieu_livraison"=>$infos_demande_achat->Lieu_livraison,
             	                             "Mode_reglement"=>$infos_demande_achat->Mode_reglement,
             	                            "Statut"=>"Brouillon");

             $id_bon_reception =$this->achat->insert($donnees_bon_reception);

             $liste_articles_achat = $this->achat->liste_details_achat($id_achat);

             //Remplissage des articles reçues dans le bon de réception

             foreach($liste_articles_achat as $achat){

             	$donnees_achat=array("Id_article"=>$achat->Id_article,
                                     "Id_achat"=>$id_bon_reception,
                                     "Quantite"=>0,
                                     "Prix_unitaire"=>$achat->Prix_unitaire,
                                     "Prix_unitaire_devise"=>$achat->Prix_unitaire_devise,
                                     "Tva"=>$achat->Tva,
                                     "Total_ht"=>0,
                                     "Total_ttc"=>0,
                                     "Total_ht_devise"=>0,
                                     "Total_ttc_devise"=>0
                                     );
             	$this->achat->ajout_details_achat($donnees_achat);

             }


             redirect("gestion_commerciale/details_bon_reception/".$id_bon_reception);

		    }

		    public function details_bon_reception($id){

             $infos_bon_reception =$this->achat->get_by_id($id);
             $this->data['infos_bon_reception'] =$infos_bon_reception;
             $id_achat=$infos_bon_reception->Id_parent;
             $infos_demande_achat =$this->achat->get_by_id($infos_bon_reception->Id_parent);

		     if(isset($_POST["elements_achat"])){

		     	$liste_elements_achat = $_POST["elements_achat"];
		     	$quantites_reçues =$_POST["quantites_recue"];
		     	$liste_entrepots =$_POST["liste_entrepots"];
		     	$quantites_entrepots = $_POST["quantites_entrepots"];
		     	$achats_entrepots = $_POST["achats_entrepots"];


		     	for($i=0;$i<count($liste_elements_achat);$i++){

		     		$infos_article_achat = $this->achat->get_article_from_achat($id_achat,$liste_elements_achat[$i]);

		     		$infos_article_reception = $this->achat->get_article_from_achat($id,$liste_elements_achat[$i]);

		     		if(count($infos_article_reception)>0){

		     			$total_ht = floatval($quantites_reçues[$i]) * floatval($infos_article_achat[0]->Prix_unitaire);
		     			$total_ht_devise = floatval($quantites_reçues[$i]) * floatval($infos_article_achat[0]->Prix_unitaire_devise);
					   	$tva=floatval($infos_article_achat[0]->Tva);
					   	$total_ttc = $total_ht * (1 + ($tva / 100));
					   	;
					   	$total_ttc_devise = $total_ht_devise * (1 + ($tva / 100));
					   	$donnee_element_achat=array("Quantite"=>$quantites_reçues[$i],
					                                "Total_ht"=>$total_ht,
					                                "Total_ttc"=> $total_ttc,
					                                "Total_ht_devise"=>$total_ht_devise,
					                                "Total_ttc_devise"=> $total_ttc_devise
					                               );

                        //Modification des éléments de l'achat
					   	$this->achat->update_details($infos_article_reception[0]->Id, $donnee_element_achat);

					   	$infos_article = $this->article->get_by_id($liste_elements_achat[$i]);
					   	$quantite_totale =$infos_article->Quantite_stock+$quantites_reçues[$i];

					   	//Modification du stock
					   	$donnees_article = array("Quantite_stock"=>$quantite_totale);
					   	$this->article->update($infos_article->Id, $donnees_article);

					   	

					   	if($quantites_reçues[$i]>0){

					   		
					   	    $test_mouvement = $this->mouvements_stock->test_mouvement_reception($liste_elements_achat[$i],$infos_bon_reception->Numero_demande);

					   	    if(count($test_mouvement)==0){

					   	    	$donnees_mouvement = array("Id_article"=>$liste_elements_achat[$i],"Type"=>"Sortie","Quantite"=>$quantites_reçues[$i],"Date"=>date("d/m/Y"),"Id_inventaire"=>-1,"Reference_reception"=>$infos_bon_reception->Numero_demande,"Commentaire"=>"Reception commande ".$infos_bon_reception->Numero_demande
					   	         );
					   	    	 $this->mouvements_stock->insert($donnees_mouvement);

					   	    }else{

					   	    	$donnees_mouvement= array("Quantite"=>$quantites_reçues[$i]);
					   	    	$this->mouvements_stock->update($test_mouvement[0]->Id, $donnees_mouvement);
					   	    }

					   	   
					   	}

		     		}
		     	

		     	}


		     }
             //Enregistrement des différents stocks dans les entrepôts
		     if(isset($_POST["liste_entrepots"])){


		     	  for($i=0;$i<count($liste_entrepots);$i++){

                       if($quantites_entrepots[$i]>0){

                       	  $donnees_produit_entrepot = array("Reference_reception"=>$infos_bon_reception->Numero_demande,"Id_entrepot"=>$liste_entrepots[$i], "Id_article"=>$achats_entrepots[$i],"Quantite_recue"=>$quantites_entrepots[$i]
                          );

                          
                          $test = $this->article->get_article_entrepot($achats_entrepots[$i],$liste_entrepots[$i],$infos_bon_reception->Numero_demande);

                          if(count($test)==0){
                           
                           $this->article->ajout_dans_entrepot($donnees_produit_entrepot);

                          }else{

                          	$donnees_produit_entrepot = array("Quantite_recue"=>$achats_entrepots[$i]);

                          	$this->article->update_article_entrepot($test[0]->Id, $donnees_produit_entrepot);
                          }

                          $test_entrepot=$this->stock_entrepot->get_by_article_entrepot($achats_entrepots[$i],$liste_entrepots[$i]);


                         //Modification du stock par entrepot
	                	  if(count($test_entrepot)>0){

                				$total_actuel =$test_entrepot[0]->Total_stock+$quantites_entrepots[$i];
					           
					            $donnees_article_entrepot= array("Total_stock"=>$total_actuel);
					            $this->stock_entrepot->update($test_entrepot[0]->Id, $donnees_article_entrepot);
	                	  }else{

	                	   if($quantites_entrepots[$i]>0){

	                	  	 	$donnees_article_entrepot= array(
	                						"Id_entrepot"=>$liste_entrepots[$i],
	                						"Id_article"=>$achats_entrepots[$i],
	                						"Total_stock"=>$quantites_entrepots[$i]
						                );

						        $this->stock_entrepot->insert($donnees_article_entrepot);

	                	  	}


	                	  }
	                	  



                       }
                       
		          }



		          $donnees_reception = array("Statut"=>"Validé");
		          $this->achat->update($id, $donnees_reception);

		     }

		     

		     
             $this->data['infos_demande_achat'] =$infos_demande_achat;

		     $infos_fournisseur =$this->fournisseur->get_by_id($infos_demande_achat->Id_fournisseur);
             $this->data['infos_fournisseur'] =$infos_fournisseur;
             $liste_des_entrepots =$this->entrepot->get_all();

             $this->data['liste_des_entrepots'] =$liste_des_entrepots;

             $liste_articles_reception =$this->achat->liste_articles_reception($id);

             $this->data['liste_articles_reception'] =$liste_articles_reception;

		   	 $total_ht =$this->achat->get_total_ht($id_achat);
		   	 $total_ht_devise =$this->achat->get_total_ht_devise($id_achat);
		   	 $total_ttc =$this->achat->get_total_ttc($id_achat);
		   	 $total_ttc_devise =$this->achat->get_total_ttc($id_achat);
		   	 $this->data['total_ht'] =$total_ht;
		   	 $this->data['total_ht_devise'] =$total_ht_devise;
		   	 $this->data['total_ttc_devise'] =$total_ttc_devise;
		   	 $this->data['total_ttc'] =$total_ttc;
		   	 $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];

             $this->twig->display('gestion_commerciale/details_bon_reception.html.twig',$this->data);

		    }

		    

		    public function details_demande_achat($id){

             $infos_demande_achat =$this->achat->get_by_id($id);
             $this->data['infos_demande_achat'] =$infos_demande_achat;
             $infos_fournisseur =$this->fournisseur->get_by_id($infos_demande_achat->Id_fournisseur);
             $this->data['infos_fournisseur'] =$infos_fournisseur;
             $liste_des_articles =$this->article->liste_produits_disponibles();
             $this->data['liste_des_articles'] =$liste_des_articles;
             $liste = $this->achat->liste_details_achat($id);
		   	 $total_ht =$this->achat->get_total_ht($id);
		   	 $total_ht_devise =$this->achat->get_total_ht_devise($id);
		   	 $total_ttc =$this->achat->get_total_ttc($id);
		   	 $total_ttc_devise =$this->achat->get_total_ttc_devise($id);
		   	 $this->data['liste'] =$liste;
		   	 $this->data['total_ht'] =$total_ht;
		   	 $this->data['total_ht_devise'] =$total_ht_devise;
		   	 $this->data['total_ttc'] =$total_ttc;
		   	 $this->data['total_ttc_devise'] =$total_ttc_devise;
		   	 $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
             $this->twig->display('gestion_commerciale/details_demandes_achat.html.twig',$this->data);
		    }

		     public function details_facture_achat($id){

             $infos_facture_achat =$this->achat->get_by_id($id);
             $this->data['infos_facture_achat'] =$infos_facture_achat;
             $infos_fournisseur =$this->fournisseur->get_by_id($infos_facture_achat->Id_fournisseur);
             $this->data['infos_fournisseur'] =$infos_fournisseur;
             $liste_des_articles =$this->article->liste_produits_disponibles();
             $this->data['liste_des_articles'] =$liste_des_articles;
             $liste = $this->achat->liste_details_achat($id);
		   	 $total_ht =$this->achat->get_total_ht($id);
		   	 $total_ht_devise =$this->achat->get_total_ht_devise($id);
		   	 $total_ttc =$this->achat->get_total_ttc($id);
		   	 $total_ttc_devise =$this->achat->get_total_ttc_devise($id);
		   	 $this->data['liste'] =$liste;
		   	 $this->data['total_ht'] =$total_ht;
		   	 $this->data['total_ht_devise'] =$total_ht_devise;
		   	 $this->data['total_ttc'] =$total_ttc;
		   	 $this->data['total_ttc_devise'] =$total_ttc_devise;
		   	 $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
             $this->twig->display('gestion_commerciale/details_facture_achat.html.twig',$this->data);
		    }

		    public function liste_devis($page=1){

		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->vente->total_devis();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->vente->liste_devis($offset,$no_of_records_per_page);
	         $total_suivant =count($this->vente->liste_devis($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["date_vente"]) and $_POST["date_vente"]!=""){

                   $liste =$this->vente->recherche($_POST["date_vente"]);
		     }

		     if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

		     	  $liste =$this->vente->recherche_avancee($_POST["mot_cle"],"Devis");
		     }

		     if(isset($_POST["statut"]) and $_POST["statut"]!=""){

		     	  $liste =$this->vente->get_by_statut($_POST["statut"],"Devis");
		     }
		     

	         $this->data['liste_devis'] =$liste;
             $this->data['total_suivant'] =$total_suivant;


		     $this->twig->display('gestion_commerciale/liste_devis.html.twig',$this->data);
		    }

		    public function liste_devis_non_valides(){

		    
	         $this->data['pagination'] =0;

	         $liste = $this->vente->liste_devis_non_valides();

	         if(isset($_POST["date_vente"]) and $_POST["date_vente"]!=""){

                   $liste =$this->vente->recherche($_POST["date_vente"]);
		     }

		     if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

		     	  $liste =$this->vente->recherche_avancee($_POST["mot_cle"],"Devis");
		     }

		     if(isset($_POST["statut"]) and $_POST["statut"]!=""){

		     	  $liste =$this->vente->get_by_statut($_POST["statut"],"Devis");
		     }
		     

	         $this->data['liste_devis'] =$liste;

		     $this->twig->display('gestion_commerciale/liste_devis.html.twig',$this->data);
		    }

		     public function liste_bons_commande($page=1){

		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->vente->total_bons_commande();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->vente->liste_commandes($offset,$no_of_records_per_page);
	         $total_suivant =count($this->vente->liste_commandes($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

		     	  $liste =$this->vente->recherche_avancee($_POST["mot_cle"],"Bon_commande");
		     }

		     if(isset($_POST["statut"]) and $_POST["statut"]!=""){

		     	  $liste =$this->vente->get_by_statut($_POST["statut"],"Bon_commande");
		     }
		     


	         $this->data['liste_bons_commande'] =$liste;
             $this->data['total_suivant'] =$total_suivant;


		     $this->twig->display('gestion_commerciale/liste_bons_commande.html.twig',$this->data);
		    }

		     public function liste_bons_livraison($page=1){

		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->vente->total_bons_livraison();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->vente->liste_bons_livraison($offset,$no_of_records_per_page);
	         $total_suivant =count($this->vente->liste_bons_livraison($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["date_vente"]) and $_POST["date_vente"]!=""){

                   $liste =$this->vente->recherche($_POST["date_vente"]);
		     }

		     if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

		     	  $liste =$this->vente->recherche_avancee($_POST["mot_cle"],"Bon_livraison");
		     }

		     if(isset($_POST["statut"]) and $_POST["statut"]!=""){

		     	  $liste =$this->vente->get_by_statut($_POST["statut"],"Bon_livraison");
		     }
		     

	         $this->data['liste_bons_livraion'] =$liste;
             $this->data['total_suivant'] =$total_suivant;


		     $this->twig->display('gestion_commerciale/liste_bons_livraison.html.twig',$this->data);
		    }

		    public function liste_factures_client($page=1){

		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->vente->total_factures_client();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->vente->liste_factures_client($offset,$no_of_records_per_page);
	         $total_suivant =count($this->vente->liste_factures_client($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["date_vente"]) and $_POST["date_vente"]!=""){

                   $liste =$this->vente->recherche($_POST["date_vente"]);
		     }

		     if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

		     	  $liste =$this->vente->recherche_avancee($_POST["mot_cle"],"Facture");
		     }

		     if(isset($_POST["statut"]) and $_POST["statut"]!=""){

		     	  $liste =$this->vente->get_by_statut($_POST["statut"],"Facture");
		     }
		     

	         $this->data['liste_factures_client'] =$liste;
             $this->data['total_suivant'] =$total_suivant;


		     $this->twig->display('gestion_commerciale/liste_factures_client.html.twig',$this->data);
		    }


		    public function supprimer_vente($id){
             $infos_vente =$this->vente->get_by_id($id);
             $this->vente->delete_vente($id);
             $this->vente->delete($id);

             if($infos_vente->Type=="Devis"){
             	redirect("gestion_commerciale/liste_devis");
             }

             if($infos_vente->Type=="Bon_commande"){
             	redirect("gestion_commerciale/liste_bons_commande");
             }

             if($infos_vente->Type=="Bon_livraison"){
             	redirect("gestion_commerciale/liste_bons_livraison");
             }

             if($infos_vente->Type=="Facture"){
             	redirect("gestion_commerciale/liste_factures_client");
             }
             

		    }

		    public function creer_devis($id=-1){


		     if(isset($_POST["entreprise"])){


		     	  $donnees_client = array(

					     	  	 "Date"=>date("d/m/Y"),
					  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
					  	   	  	 "Civilite"=>"",
					  	   	  	 "Nom"=>$_POST["nom"],
					  	   	  	 "Prenom"=>$_POST["prenom"],
					  	   	  	 "Telephone"=>$_POST["telephone"],
					  	   	  	 "Whatsapp"=>"",
					  	   	  	 "Email"=>$_POST["email"],
					  	   	  	 "Profession"=>"",
					  	   	  	 "Adresse"=>$_POST["adresse"],
					  	   	  	 "Pays"=>$_POST["pays"],
					  	   	  	 "Type"=>"Client",
					  	   	  	 "Entreprise"=>$_POST["entreprise"]
					     	  );
		     	  $test = $this->contact->test_entreprise($_POST["entreprise"]);

		     	  if($test==0){
		     	  	$this->contact->insert($donnees_client);
		     	  }
		     }

		     if(isset($_POST["duree_validite"]) and $_POST["duree_validite"]!=""){


		     	$infos_numerotation =$this->numerotation->get_all();

		        $code_devis =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_devis,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_devis+1,$infos_numerotation[0]->Taille_reference);

		        $donnees_numerotation = array("Compteur_devis"=>$infos_numerotation[0]->Compteur_devis+1);
		        $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);


		     	$donnees_devis =array("Type"=>"Devis",
		                              "Numero_demande"=>$code_devis,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$_POST["contact"],
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>$_POST["duree_validite"],
		                              "Conditions_reglement"=>$_POST["conditions_reglement"],
		                              "Mode_reglement"=>$_POST["mode_reglement"],
		                              "Date_livraison"=>$_POST["date_livraison"],
		                              "Devise"=>$_POST["devise"],
		                              "Id_compte_bancaire"=>$_POST["compte_bancaire"],
		                              "Notes"=>$_POST["notes"],
		                              "Statut"=>"Brouillon"
		                           );
		     	$id_vente =$this->vente->insert($donnees_devis);

		     	redirect("gestion_commerciale/details_vente/".$id_vente);


		     }

             $liste_contacts  = $this->contact->liste_decroissante();
             $this->data['liste_contacts'] =$liste_contacts;
             
             $liste_pays = $this->utilisateur->liste_pays();
             $this->data['liste_pays'] =$liste_pays;
             $liste_conditions_reglements =$this->conditions_reglement->get_all();
             $this->data['liste_conditions_reglements'] =$liste_conditions_reglements;
             $liste_modes_reglement =$this->modes_paiement->get_all();
             $this->data['liste_modes_reglement'] =$liste_modes_reglement;
             $liste_devises =$this->utilisateur->liste_devises();
		     $this->data['liste_devises'] =$liste_devises;
		     $this->data['id_devis'] =$id;
		     $liste_comptes_bancaires =$this->compte_bancaire->get_all();
		     $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;
		     $this->data['has_modal'] =1;

		     $this->twig->display('gestion_commerciale/creer_devis.html.twig',$this->data);
		    }


		    public function creer_devis_from_opportunite($id_opportunite){

            $infos_opportunite =$this->opportunite->get_by_id($id_opportunite);
            $infos_contact=$this->contact->get_by_id($infos_opportunite->Id_contact);

            $infos_numerotation =$this->numerotation->get_all();

		    $code_devis =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_devis,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_devis+1,$infos_numerotation[0]->Taille_reference);

		    $donnees_numerotation = array("Compteur_devis"=>$infos_numerotation[0]->Compteur_devis+1);
		    $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

		    $infos_societe =$this->societe->get_all();
		    
		    $donnees_devis =array("Type"=>"Devis",
		                              "Numero_demande"=>$code_devis,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$infos_contact->Id,
		                              "Id_opportunite"=>$id_opportunite,
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>15,
		                              "Conditions_reglement"=>"A la réception",
		                              "Mode_reglement"=>"Virement bancaire",
		                              "Date_livraison"=>"",
		                              "Devise"=>$infos_societe[0]->Devise,
		                              "Notes"=>"",
		                              "Statut"=>"Brouillon"
		                           );
		     	$id_vente =$this->vente->insert($donnees_devis);

		     	redirect("gestion_commerciale/details_vente/".$id_vente);


		    }

		    public function creer_bon_commande_client($id=-1){

              
		    	 if(isset($_POST["entreprise"])){

		     	  $donnees_client = array(

					     	  	 "Date"=>date("d/m/Y"),
					  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
					  	   	  	 "Civilite"=>"",
					  	   	  	 "Nom"=>$_POST["nom"],
					  	   	  	 "Prenom"=>$_POST["prenom"],
					  	   	  	 "Telephone"=>$_POST["telephone"],
					  	   	  	 "Whatsapp"=>"",
					  	   	  	 "Email"=>$_POST["email"],
					  	   	  	 "Profession"=>"",
					  	   	  	 "Adresse"=>$_POST["adresse"],
					  	   	  	 "Pays"=>$_POST["pays"],
					  	   	  	 "Type"=>"Client",
					  	   	  	 "Entreprise"=>$_POST["entreprise"]
					     	  );
		     	  $test = $this->contact->test_entreprise($_POST["entreprise"]);

		     	  if($test==0){
		     	  	$this->contact->insert($donnees_client);
		     	  }
		     	  
		     }

		     if(isset($_POST["duree_validite"]) and $_POST["duree_validite"]!=""){

		     	  	$infos_numerotation =$this->numerotation->get_all();

		            $code_bon_commande =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_commande_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_commande_client+1,$infos_numerotation[0]->Taille_reference);

		            $donnees_numerotation = array("Compteur_bon_commande_client"=>$infos_numerotation[0]->Compteur_bon_commande_client+1);
		            $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

		            $donnees_commande =array("Type"=>"Bon_commande",
		                              "Numero_demande"=>$code_bon_commande,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$_POST["contact"],
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>$_POST["duree_validite"],
		                              "Conditions_reglement"=>$_POST["conditions_reglement"],
		                              "Mode_reglement"=>$_POST["mode_reglement"],
		                              "Date_livraison"=>$_POST["date_livraison"],
		                              "Devise"=>$_POST["devise"],
		                              "Id_compte_bancaire"=>$_POST["compte_bancaire"],
		                              "Notes"=>$_POST["notes"],
		                              "Statut"=>"Brouillon"
		                           );
		     	   $id_vente =$this->vente->insert($donnees_commande);

		     	   redirect("gestion_commerciale/details_vente/".$id_vente);


		      }

		     $liste_contacts  = $this->contact->liste_decroissante();
             $this->data['liste_contacts'] =$liste_contacts;
             $liste_devises =$this->utilisateur->liste_devises();
             $liste_pays = $this->utilisateur->liste_pays();
             $this->data['liste_pays'] =$liste_pays;
             $liste_conditions_reglements =$this->conditions_reglement->get_all();
             $this->data['liste_conditions_reglements'] =$liste_conditions_reglements;
             $liste_modes_reglement =$this->modes_paiement->get_all();
             $this->data['liste_modes_reglement'] =$liste_modes_reglement;
		     $this->data['liste_devises'] =$liste_devises;
		     $liste_comptes_bancaires =$this->compte_bancaire->get_all();
		     $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;
		     $this->data['id_bon_commande'] =$id;
		     $this->data['has_modal'] =1;



		     $this->twig->display('gestion_commerciale/creer_bon_commande_client.html.twig',$this->data);


		    }

		    public function creer_bon_commande_from_devis($id){

		    	$infos_numerotation =$this->numerotation->get_all();

	            $code_bon_commande =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_commande_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_commande_client+1,$infos_numerotation[0]->Taille_reference);

	            $donnees_numerotation = array("Compteur_bon_commande_client"=>$infos_numerotation[0]->Compteur_bon_commande_client+1);
	            $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

		    	$infos_vente = $this->vente->get_by_id($id);
		    	$donnees_bon_commande =array(
		    		                  "Type"=>"Bon_commande",
		    		                  "Id_parent"=>$id,
		                              "Numero_demande"=>$code_bon_commande,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$infos_vente->Id_client,
		                              "Date_vente"=>$infos_vente->Date_vente,
		                              "Duree_validite"=>$infos_vente->Duree_validite,
		                              "Conditions_reglement"=>$infos_vente->Conditions_reglement,
		                              "Mode_reglement"=>$infos_vente->Mode_reglement,
		                              "Date_livraison"=>$infos_vente->Date_livraison,
		                              "Devise"=>$infos_vente->Devise,
		                              "Id_compte_bancaire"=>$infos_vente->Id_compte_bancaire,
		                              "Notes"=>$infos_vente->Notes,
		                              "Statut"=>"Validé"
		                           );

		    	$id_vente =$this->vente->insert($donnees_bon_commande);

		    	$liste_articles_vente =$this->vente->liste_details_vente($id);
		    	foreach($liste_articles_vente as $article){

		    		$donnees_article=array(
		    			                   "Id_vente"=>$id_vente,
		    	                           "Id_article"=>$article->Id_article,
		    	                           "Quantite"=>$article->Quantite,
		    	                           "Prix_unitaire"=>$article->Prix_unitaire,
		    	                           "Prix_unitaire_devise"=>$article->Prix_unitaire_devise,
		    	                           "Reduction"=>$article->Reduction,
		    	                           "Tva"=>$article->Tva,
		    	                           "Total_ht"=>$article->Total_ht,
		    	                           "Total_ht_devise"=>$article->Total_ht_devise,
		    	                           "Total_ttc"=>$article->Total_ttc,
		    	                           "Total_ttc_devise"=>$article->Total_ttc_devise);
		    		$this->vente->ajout_details_vente($donnees_article);
		    	}

		    	redirect("gestion_commerciale/details_vente/".$id_vente);
		    }


		    public function creer_bon_livraison_from_devis($id){

               $infos_numerotation =$this->numerotation->get_all();

               $code_bon_livraison =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_livraison_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_livraison+1,$infos_numerotation[0]->Taille_reference);

                $donnees_numerotation = array("Compteur_bon_livraison"=>$infos_numerotation[0]->Compteur_bon_livraison+1);
	            $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

	            $infos_vente = $this->vente->get_by_id($id);

	            $donnees_bon_livraison =array(
		    		                  "Type"=>"Bon_livraison",
		    		                  "Id_parent"=>$id,
		                              "Numero_demande"=>$code_bon_livraison,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$infos_vente->Id_client,
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>$infos_vente->Duree_validite,
		                              "Conditions_reglement"=>$infos_vente->Conditions_reglement,
		                              "Mode_reglement"=>$infos_vente->Mode_reglement,
		                              "Date_livraison"=>$infos_vente->Date_livraison,
		                              "Devise"=>$infos_vente->Devise,
		                              "Id_compte_bancaire"=>$infos_vente->Id_compte_bancaire,
		                              "Notes"=>$infos_vente->Notes,
		                              "Statut"=>"Brouillon"
		                           );
	            $id_vente =$this->vente->insert($donnees_bon_livraison);

	            $liste_articles_vente =$this->vente->liste_details_vente($id);
		    	foreach($liste_articles_vente as $article){

		    		$donnees_article=array(
		    			                   "Id_vente"=>$id_vente,
		    	                           "Id_article"=>$article->Id_article,
		    	                           "Quantite"=>0,
		    	                           "Prix_unitaire"=>$article->Prix_unitaire,
		    	                           "Prix_unitaire_devise"=>$article->Prix_unitaire_devise,
		    	                           "Reduction"=>$article->Reduction,
		    	                           "Tva"=>$article->Tva,
		    	                           "Total_ht"=>0,
		    	                           "Total_ht_devise"=>0,
		    	                           "Total_ttc"=>0,
		    	                           "Total_ttc_devise"=>0);
		    		$this->vente->ajout_details_vente($donnees_article);
		    	}

		    	redirect("gestion_commerciale/details_bon_livraison/".$id_vente);


		    }

		    public function creer_facture_from_devis($id){

		    	 $infos_numerotation =$this->numerotation->get_all();

                 $code_facture =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_facture_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_facture_client+1,$infos_numerotation[0]->Taille_reference);

                 $donnees_numerotation = array("Compteur_facture_client"=>$infos_numerotation[0]->Compteur_facture_client+1);
	             $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

	             $infos_vente = $this->vente->get_by_id($id);

	             $donnees_facture =array(
		    		                  "Type"=>"Facture",
		    		                  "Id_parent"=>$id,
		                              "Numero_demande"=>$code_facture,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$infos_vente->Id_client,
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>$infos_vente->Duree_validite,
		                              "Conditions_reglement"=>$infos_vente->Conditions_reglement,
		                              "Mode_reglement"=>$infos_vente->Mode_reglement,
		                              "Date_livraison"=>$infos_vente->Date_livraison,
		                              "Devise"=>$infos_vente->Devise,
		                              "Notes"=>$infos_vente->Notes,
		                              "Id_compte_bancaire"=>$infos_vente->Id_compte_bancaire,
		                              "Statut"=>"Validé"
		                           );
	            $id_facture =$this->vente->insert($donnees_facture);

	            $liste_articles_vente =$this->vente->liste_details_vente($id);
		    	foreach($liste_articles_vente as $article){

		    		$donnees_article=array(
		    			                   "Id_vente"=>$id_facture,
		    	                           "Id_article"=>$article->Id_article,
		    	                           "Quantite"=>$article->Quantite,
		    	                           "Prix_unitaire"=>$article->Prix_unitaire,
		    	                           "Prix_unitaire_devise"=>$article->Prix_unitaire_devise,
		    	                           "Reduction"=>$article->Reduction,
		    	                           "Tva"=>$article->Tva,
		    	                           "Total_ht"=>$article->Total_ht,
		    	                           "Total_ht_devise"=>$article->Total_ht_devise,
		    	                           "Total_ttc"=>$article->Total_ttc,
		    	                           "Total_ttc_devise"=>$article->Total_ttc_devise);
		    		$this->vente->ajout_details_vente($donnees_article);



		    	}

		    	redirect("gestion_commerciale/details_vente/".$id_facture);


		    }

		    public function details_bon_livraison($id){

             $infos_bon_livraison =$this->vente->get_by_id($id);
             $this->data['infos_bon_livraison'] =$infos_bon_livraison;
             $id_vente=$infos_bon_livraison->Id_parent;
             $infos_vente =$this->vente->get_by_id($id_vente);
             $infos_devis =$this->vente->get_by_id($infos_bon_livraison->Id_parent);

             $this->data['infos_devis'] =$infos_devis;

             if(isset($_POST["elements_vente"])){

		     	$liste_elements_vente = $_POST["elements_vente"];
		     	$quantites_livrees =$_POST["quantites_livrees"];
		     	$liste_entrepots =$_POST["liste_entrepots"];
		     	$quantites_entrepots = $_POST["quantites_entrepots"];
		     	$ventes_entrepots = $_POST["ventes_entrepots"];


		     	for($i=0;$i<count($liste_elements_vente);$i++){

		     		$infos_article_vente = $this->vente->get_article_from_vente($id_vente,$liste_elements_vente[$i]);

		     		$infos_article_livraison = $this->vente->get_article_from_vente($id,$liste_elements_vente[$i]);

		     		if(count($infos_article_livraison)>0){

		     			$total_ht = floatval($quantites_livrees[$i]) * floatval($infos_article_livraison[0]->Prix_unitaire);
		     			$reste_pourcentage = 100-floatval($infos_article_vente[0]->Reduction);
		     			$total_ht_reduction =($total_ht*$reste_pourcentage)/100;
		                $total_ht_reduction = round($total_ht_reduction,2);

		     			$total_ht_devise = floatval($quantites_livrees[$i]) * floatval($infos_article_vente[0]->Prix_unitaire_devise);
					   	$tva=floatval($infos_article_vente[0]->Tva);
					   	$reste_pourcentage = 100-floatval($infos_article_vente[0]->Reduction);
					   	$total_ht_devise_reduction =($total_ht_devise*$reste_pourcentage)/100;
					   	$total_ht_devise_reduction = round($total_ht_devise_reduction,2);


					   	$total_ttc = $total_ht * (1 + ($tva / 100));
					   	$reste_pourcentage = 100-floatval($infos_article_vente[0]->Reduction);

					   	$total_ttc_reduction =($total_ttc*$reste_pourcentage)/100;
					   	$total_ttc_reduction = round($total_ttc_reduction,2);

					   	
					   	$total_ttc_devise = $total_ht_devise * (1 + ($tva / 100));
					   	$reste_pourcentage = 100-floatval($infos_article_vente[0]->Reduction);
					   	$total_ttc_devise_reduction =($total_ttc_devise*$reste_pourcentage)/100;
					   	$total_ttc_devise_reduction = round($total_ttc_devise_reduction,2);



					   	$donnee_element_vente=array("Quantite"=>$quantites_livrees[$i],
					                                "Total_ht"=>$total_ht_reduction,
					                                "Total_ttc"=> $total_ttc_reduction,
					                                "Total_ht_devise"=>$total_ht_devise_reduction,
					                                "Total_ttc_devise"=> $total_ttc_devise_reduction
					                               );

                        //Modification des éléments de la vente
					   	$this->vente->update_details($infos_article_livraison[0]->Id, $donnee_element_vente);

					   	$infos_article = $this->article->get_by_id($liste_elements_vente[$i]);
					   	$quantite_totale =$infos_article->Quantite_stock-$quantites_livrees[$i];

					   	//Modification du stock
					   	$donnees_article = array("Quantite_stock"=>$quantite_totale);
					   	$this->article->update($infos_article->Id, $donnees_article);

					   	if($quantites_livrees[$i]>0){

					   		
					   	    $test_mouvement = $this->mouvements_stock->test_mouvement_reception($liste_elements_vente[$i],$infos_bon_livraison->Numero_demande);

					   	    if(count($test_mouvement)==0){

					   	    	$donnees_mouvement = array("Id_article"=>$liste_elements_vente[$i],"Type"=>"Entrée","Quantite"=>$quantites_livrees[$i],"Date"=>date("d/m/Y"),"Id_inventaire"=>-1,"Reference_reception"=>$infos_bon_livraison->Numero_demande,"Commentaire"=>"Livraison commande ".$infos_bon_livraison->Numero_demande
					   	         );
					   	    	 $this->mouvements_stock->insert($donnees_mouvement);

					   	    }else{

					   	    	$donnees_mouvement= array("Quantite"=>$quantites_livrees[$i]);
					   	    	$this->mouvements_stock->update($test_mouvement[0]->Id, $donnees_mouvement);
					   	    }

					   	   
					   	}

		     		}
		     	

		     	}


		     }


		      if(isset($_POST["liste_entrepots"])){


		     	  for($i=0;$i<count($liste_entrepots);$i++){

                       if($quantites_entrepots[$i]>0){

                       	  $donnees_produit_entrepot = array("Reference_reception"=>$infos_bon_livraison->Numero_demande,"Id_entrepot"=>$liste_entrepots[$i], "Id_article"=>$ventes_entrepots[$i],"Quantite_recue"=>-$quantites_entrepots[$i]
                          );

                          
                          $test = $this->article->get_article_entrepot($ventes_entrepots[$i],$liste_entrepots[$i],$infos_bon_livraison->Numero_demande);

                          if(count($test)==0){
                           
                           $this->article->ajout_dans_entrepot($donnees_produit_entrepot);

                          }else{

                          	$donnees_produit_entrepot = array("Quantite_recue"=>-$quantites_entrepots[$i]);

                          	$this->article->update_article_entrepot($test[0]->Id, $donnees_produit_entrepot);
                          }

                       }
                       
		          }



		          $donnees_livraison = array("Statut"=>"Validé");
		          $this->vente->update($id, $donnees_livraison);

		          redirect("gestion_commerciale/details_vente/".$id);

		     }



		     $infos_client=$this->contact->get_by_id($infos_devis->Id_client);
             $this->data['infos_client'] =$infos_client;
             $liste_des_entrepots =$this->entrepot->get_all();

             $this->data['liste_des_entrepots'] =$liste_des_entrepots;

             $liste_articles_livraison =$this->vente->liste_articles_livraison($id);

             $this->data['liste_articles_livraison'] =$liste_articles_livraison;


             $this->twig->display('gestion_commerciale/details_bon_livraison.html.twig',$this->data);
		    }

		     public function creer_bon_livraison_client($id=-1){

              
		    	 if(isset($_POST["entreprise"])){

		     	  $donnees_client = array(

					     	  	 "Date"=>date("d/m/Y"),
					  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
					  	   	  	 "Civilite"=>"",
					  	   	  	 "Nom"=>$_POST["nom"],
					  	   	  	 "Prenom"=>$_POST["prenom"],
					  	   	  	 "Telephone"=>$_POST["telephone"],
					  	   	  	 "Whatsapp"=>"",
					  	   	  	 "Email"=>$_POST["email"],
					  	   	  	 "Profession"=>"",
					  	   	  	 "Adresse"=>$_POST["adresse"],
					  	   	  	 "Pays"=>$_POST["pays"],
					  	   	  	 "Type"=>"Client",
					  	   	  	 "Entreprise"=>$_POST["entreprise"]
					     	  );
		     	  $test = $this->contact->test_entreprise($_POST["entreprise"]);

		     	  if($test==0){
		     	  	$this->contact->insert($donnees_client);
		     	  }
		     	  
		     }

		     if(isset($_POST["duree_validite"]) and $_POST["duree_validite"]!=""){

		     	  	$infos_numerotation =$this->numerotation->get_all();

		            $code_bon_livraison =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_bon_livraison_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_bon_livraison+1,$infos_numerotation[0]->Taille_reference);

		            $donnees_numerotation = array("Compteur_bon_livraison"=>$infos_numerotation[0]->Compteur_bon_livraison+1);
		            $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);

		            $donnees_devis =array("Type"=>"Bon_livraison",
		                              "Numero_demande"=>$code_bon_livraison,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$_POST["contact"],
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>$_POST["duree_validite"],
		                              "Conditions_reglement"=>$_POST["conditions_reglement"],
		                              "Mode_reglement"=>$_POST["mode_reglement"],
		                              "Date_livraison"=>$_POST["date_livraison"],
		                              "Devise"=>$_POST["devise"],
		                              "Id_compte_bancaire"=>$_POST["compte_bancaire"],
		                              "Notes"=>$_POST["notes"],
		                              "Statut"=>"Brouillon"
		                           );
		     	   $id_vente =$this->vente->insert($donnees_devis);

		     	   redirect("gestion_commerciale/details_vente/".$id_vente);


		      }

		     $liste_contacts  = $this->contact->liste_decroissante();
             $this->data['liste_contacts'] =$liste_contacts;
             $liste_devises =$this->utilisateur->liste_devises();
             $liste_pays = $this->utilisateur->liste_pays();
             $this->data['liste_pays'] =$liste_pays;
             $liste_conditions_reglements =$this->conditions_reglement->get_all();
             $this->data['liste_conditions_reglements'] =$liste_conditions_reglements;
             $liste_modes_reglement =$this->modes_paiement->get_all();
             $this->data['liste_modes_reglement'] =$liste_modes_reglement;
		     $this->data['liste_devises'] =$liste_devises;
		     $liste_comptes_bancaires =$this->compte_bancaire->get_all();
		     $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;
		     $this->data['id_bon_commande'] =$id;
		     $this->data['has_modal'] =1;

		     $this->twig->display('gestion_commerciale/creer_bon_livraison_client.html.twig',$this->data);


		    }

		    public function creer_facture_client($id=-1){


		     if(isset($_POST["entreprise"])){


		     	  $donnees_client = array(

					     	  	 "Date"=>date("d/m/Y"),
					  	   	  	 "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
					  	   	  	 "Civilite"=>"",
					  	   	  	 "Nom"=>$_POST["nom"],
					  	   	  	 "Prenom"=>$_POST["prenom"],
					  	   	  	 "Telephone"=>$_POST["telephone"],
					  	   	  	 "Whatsapp"=>"",
					  	   	  	 "Email"=>$_POST["email"],
					  	   	  	 "Profession"=>"",
					  	   	  	 "Adresse"=>$_POST["adresse"],
					  	   	  	 "Pays"=>$_POST["pays"],
					  	   	  	 "Type"=>"Client",
					  	   	  	 "Entreprise"=>$_POST["entreprise"]
					     	  );
		     	  $test = $this->contact->test_entreprise($_POST["entreprise"]);

		     	  if($test==0){
		     	  	$this->contact->insert($donnees_client);
		     	  }
		     }

		     if(isset($_POST["duree_validite"]) and $_POST["duree_validite"]!=""){


		     	$infos_numerotation =$this->numerotation->get_all();

		        $code_facture =$this->generateInvoiceReference($infos_numerotation[0]->Prefixe_facture_client,$infos_numerotation[0]->Separateur,$infos_numerotation[0]->Format_date,$infos_numerotation[0]->Ordre_reference, $infos_numerotation[0]->Compteur_facture_client+1,$infos_numerotation[0]->Taille_reference);

		        $donnees_numerotation = array("Compteur_facture_client"=>$infos_numerotation[0]->Compteur_facture_client+1);
		        $this->numerotation->update($infos_numerotation[0]->Id, $donnees_numerotation);


		     	$donnees_devis =array("Type"=>"Facture",
		                              "Numero_demande"=>$code_facture,
		                              "Id_utilisateur"=>$this->session->userdata('id_utilisateur'),
		                              "Id_client"=>$_POST["contact"],
		                              "Date_vente"=>date("Y-m-d"),
		                              "Duree_validite"=>$_POST["duree_validite"],
		                              "Conditions_reglement"=>$_POST["conditions_reglement"],
		                              "Mode_reglement"=>$_POST["mode_reglement"],
		                              "Date_livraison"=>$_POST["date_livraison"],
		                              "Devise"=>$_POST["devise"],
		                              "Id_compte_bancaire"=>$_POST["compte_bancaire"],
		                              "Notes"=>$_POST["notes"],
		                              "Statut"=>"Validé"
		                           );
		     	$id_vente =$this->vente->insert($donnees_devis);

		     	redirect("gestion_commerciale/details_vente/".$id_vente);


		     }

             $liste_contacts  = $this->contact->liste_decroissante();
             $this->data['liste_contacts'] =$liste_contacts;
             $liste_devises =$this->utilisateur->liste_devises();
             $liste_pays = $this->utilisateur->liste_pays();
             $this->data['liste_pays'] =$liste_pays;
             $liste_conditions_reglements =$this->conditions_reglement->get_all();
             $this->data['liste_conditions_reglements'] =$liste_conditions_reglements;
             $liste_modes_reglement =$this->modes_paiement->get_all();
             $this->data['liste_modes_reglement'] =$liste_modes_reglement;
		     $this->data['liste_devises'] =$liste_devises;
		     $liste_comptes_bancaires =$this->compte_bancaire->get_all();
		     $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;
		     $this->data['id_devis'] =$id;
		     $this->data['has_modal'] =1;

		     $this->twig->display('gestion_commerciale/creer_facture_client.html.twig',$this->data);
		    }


		    public function details_vente($id){

             $infos_vente =$this->vente->get_by_id($id);
             $this->data['infos_vente'] =$infos_vente;
             $infos_client =$this->contact->get_by_id($infos_vente->Id_client);
             $this->data['infos_client'] =$infos_client;


             $titre ="Devis";
             if($infos_vente->Type=="Bon_commande"){
             $titre ="Bon de commande";	
             }

             if($infos_vente->Type=="Bon_livraison"){
             $titre ="Bon de livraison";	
             }

             if($infos_vente->Type=="Facture"){
             $titre ="Facture";	
             }

             $this->data['titre'] =$titre;

             $liste_des_articles =$this->article->liste_produits_disponibles();
             $this->data['liste_des_articles'] =$liste_des_articles;

             $liste = $this->vente->liste_details_vente($id);
		   	 $total_ht =$this->vente->get_total_ht($id);
		   	 $total_ht_devise =$this->vente->get_total_ht_devise($id);
		   	 $total_ttc =$this->vente->get_total_ttc($id);
		   	 $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
		   	 $total_tva =$this->vente->get_total_tva($id);
		   	 $total_tva_devise =$this->vente->get_total_tva_devise($id);
		   	 $this->data['liste'] =$liste;

		   	 $this->data['total_ht'] =$total_ht;
		   	 $this->data['total_ht_devise'] =$total_ht_devise;
		   	 $this->data['total_ttc'] =$total_ttc;
		   	 $this->data['total_ttc_devise'] =$total_ttc_devise;
		   	 $this->data['total_tva'] =$total_tva;
		   	 $this->data['total_tva_devise'] =$total_tva_devise;



		   	 $has_bon_commande =$this->vente->nb_fille("Bon_commande",$id);
		   	 $this->data['has_bon_commande'] =$has_bon_commande;

		   	 $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
		     $this->twig->display('gestion_commerciale/details_vente.html.twig',$this->data);	
		    }


		   

		     function generateInvoiceReference($prefixe,$separateur,$format_date,$pattern, $compteur,$taille_compteur) {

		      $pattern_devis  =  str_replace("[date]",$format_date,$pattern);
              $pattern_devis  =  str_replace("[préfixe]",$prefixe,$pattern_devis);
              $pattern_devis  =  str_replace("[separateur]",$separateur,$pattern_devis);

			  $pattern_devis  =  str_replace("{yyyy}",date("Y"),$pattern_devis);
		      $pattern_devis  =  str_replace("{mm}",date("m"),$pattern_devis );
		      $pattern_devis  =  str_replace("{dd}",date("d"),$pattern_devis );
		      $pattern_devis  =  str_replace("{yy}",substr(date("Y"), -2),$pattern_devis );
		      $chiffre = str_pad($compteur,$taille_compteur, "0", STR_PAD_LEFT);
		      $pattern_devis  =  str_replace("[compteur]",$chiffre,$pattern_devis);
			    
			    return $pattern_devis;
			}




}