<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Gestion_stock extends MY_Controller {

	  public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->data['base_url'] = base_url();
		     $this->data['assets_front'] =base_url()."assets/front";
		     $this->data['assets_admin'] =base_url()."assets/admin";
		     $this->data['assets_mail']  = base_url()."assets/mail";
		     $this->data['current_year']  =date("Y");
		     $this->data['role_utilisateur']  = $this->session->userdata('role');
		     $liste_autorisations =[];
		     $liste_autorisations =$this->role->liste_codes_actions_role($this->session->userdata('role'));
		     $this->data['liste_autorisations']  =$liste_autorisations;

		     
		     $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];

		     $nb_produits =$this->article->total_produits();
		     $this->data['nb_produits']  =$nb_produits;
		     $nb_services =$this->article->total_services();
		     $this->data['nb_services']  =$nb_services;
		     $total_fournisseur = $this->fournisseur->total();
		     $this->data['total_fournisseur']  =$total_fournisseur;
		     $total_approvisionnement =$this->article->total_articles_approvisionnement();
		     $this->data['total_approvisionnement']  =$total_approvisionnement;


		} 


		public function index(){


			$this->twig->display('stock/dashboard_stock.html.twig',$this->data);
		}

		public function categories($id=-1,$page=1){


			if(isset($_POST["libelle"]) and $_POST["libelle"]!=""){


	         	  if(isset($_POST["id"]) and $_POST["id"]!=""){

                     $donnes_categorie = array("Libelle"=>$_POST["libelle"]);
                     $this->categorie->update($_POST["id"], $donnes_categorie);

	         	  }else{

	         	  	 $donnes_categorie = array("Reference"=>time(),"Libelle"=>$_POST["libelle"]);
	         	  	 $test = $this->categorie->test_doublon($_POST["libelle"]);
	         	  	 if($test==0){
	         	  	 	$this->categorie->insert($donnes_categorie);
	         	  	 	$this->data['msg'] =1;
	         	  	 }else{
	         	  	 	$this->data['msg'] =-1;
	         	  	 }
	         	  	 
	         	  }
	         }
            
            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->categorie->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->categorie->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->categorie->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->categorie->recherche($_POST["mot_cle"]);

	         }

	         if($id!=-1){

	         	$infos_categorie = $this->categorie->get_by_id($id);
	         	$this->data['infos_categorie'] =$infos_categorie;
	         }



           $this->data['liste_categories'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('stock/stock_categorie.html.twig',$this->data);
		}

		public function supprimer_categorie($id){

			$this->categorie->delete($id);
			redirect("gestion_stock/categories/-1/1");
		}

	

		public function entrepots($id=-1,$page=1){

            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->entrepot->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->entrepot->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->entrepot->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->entrepot->recherche($_POST["mot_cle"]);

	         }


           $this->data['liste_entrepots'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('stock/stock_entrepot.html.twig',$this->data);
		}

		public function ajouter_entrepot($id=-1){


		     	if(isset($_POST["nom_entrepot"]) and  $_POST["nom_entrepot"]!=""){


		     		if(isset($_POST["id"]) and $_POST["id"]!=""){


		     			    $donnes_entrepot = array(

				     			"Nom"=>$_POST["nom_entrepot"],
				     			"Pays"=>$_POST["pays"],
				     			"Adresse"=>$_POST["adresse"],
				     			"Responsable"=>$_POST["responsable"],
				     			"Id_annexe"=>$_POST["annexe"]

				     		);

				     		$this->entrepot->update($_POST["id"], $donnes_entrepot);


		     		}else{

		     			    

                           $donnes_entrepot = array(

				     			"Nom"=>$_POST["nom_entrepot"],
				     			"Pays"=>$_POST["pays"],
				     			"Adresse"=>$_POST["adresse"],
				     			"Responsable"=>$_POST["responsable"],
				     			"Id_annexe"=>$_POST["annexe"]

				     		);
                           $test = $this->entrepot->test_doublon($_POST["nom_entrepot"]);
                           if($test==0){
                           	$this->entrepot->insert($donnes_entrepot);
                           }
				     		

		     		}

		     		redirect("gestion_stock/entrepots/-1/1");

		     		
		     	}
               
               $this->data['id'] =$id;
               if($id!=-1){

               	$infos_entrepot = $this->entrepot->get_by_id($id);
               	$this->data['infos_entrepot'] =$infos_entrepot;

               }
               
               $liste_pays = $this->utilisateur->liste_pays();
               $liste_annexes =$this->annexe->get_all();

               $this->data['liste_pays'] =$liste_pays;
               $this->data['liste_annexes'] =$liste_annexes;
               $this->twig->display('stock/ajouter_entrepot.html.twig',$this->data);

		    }

		public function supprimer_entrepot($id){

			$this->entrepot->delete($id);
			redirect("gestion_stock/entrepots/-1/1");
		}


        public function ajouter_casier($id=-1,$page=1){


        	if(isset($_POST["libelle_casier"]) and  $_POST["libelle_casier"]!=""){


		     		if(isset($_POST["id"]) and $_POST["id"]!=""){


		     			    $donnes_casier = array(

				     			"Libelle"=>$_POST["libelle_casier"],
				     			"Id_entrepot"=>$_POST["entrepot"]

				     		);

				     		$this->casier->update($_POST["id"], $donnes_casier);
				     		$this->data['msg'] =1;


		     		}else{

                           $donnes_casier = array(

				     			"Libelle"=>$_POST["libelle_casier"],
				     			"Id_entrepot"=>$_POST["entrepot"]

				     		);
                           $test = $this->casier->test_doublon($_POST["libelle_casier"],$_POST["entrepot"]);
                           if($test==0){
                           	$this->casier->insert($donnes_casier);
                           	$this->data['msg'] =1;
                           }else{
                           	$this->data['msg'] =-1;
                           }
				     		

		     		}

		     		
		     	}


			    $no_of_records_per_page = 50;
		        $offset = ($page-1) * $no_of_records_per_page;
		        $offset_suivant = ($page) * $no_of_records_per_page;
		        $total =$this->casier->total();
		        $total_pages = ceil($total / $no_of_records_per_page);

		         $this->data['total_pages'] = $total_pages;
		         $this->data['page_precedente'] =$page-1;
		         $this->data['page_suivante'] =$page+1;
		         $this->data['page'] =$page;
		         $this->data['pagination'] =1;

		         $liste = $this->casier->liste($offset,$no_of_records_per_page);
		         $total_suivant =count($this->casier->liste($offset_suivant,$no_of_records_per_page));

		        $this->data['liste_casiers'] =$liste;
	            $this->data['total_suivant'] =$total_suivant;
               
               $this->data['id'] =$id;
               if($id!=-1){

               	$infos_casier = $this->casier->get_by_id($id);
               	$this->data['infos_casier'] =$infos_casier;

               }
               
               $liste_entrepots = $this->entrepot->get_all();

               $this->data['liste_entrepots'] =$liste_entrepots;
               $this->twig->display('stock/ajouter_casier.html.twig',$this->data);


        }

        public function supprimer_casier($id){

        	$this->casier->delete($id);
        	redirect("gestion_stock/ajouter_casier/-1/1");

        }

        public function fournisseurs($id=-1,$page=1){

            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->fournisseur->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->fournisseur->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->fournisseur->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->fournisseur->recherche($_POST["mot_cle"]);

	         }


           $this->data['liste_fournisseurs'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('stock/stock_fournisseur.html.twig',$this->data);
		}

		public function liste_produits_fournisseur($id=-1,$page=1){

			if(isset($_POST["article_id"]) and $_POST["article_id"]!=""){

				  $donnees_produit = array("Id_article"=>$_POST["article_id"],
			                             "Id_fournisseur"=>$_POST["fournisseur"],
			                             "Prix_achat_ht"=>$_POST["prix_unitaire_ht"],
			                             "TVA"=>$_POST["tva"]
			                         );


				  if($_POST["id"] and $_POST["id"]!=""){

                   $this->produits_par_fournisseur->update($_POST["id"], $donnees_produit);

				  }else{

				  	$test =$this->produits_par_fournisseur->test_doublon($_POST["article_id"],$_POST["fournisseur"]);

                    if($test==0){
                    	 $this->produits_par_fournisseur->insert($donnees_produit);
                    	 $this->data['message'] =1;
                    }else{
                    	 $this->data['message'] =-1;
                    }
				   

				  }

			}

			$no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->produits_par_fournisseur->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->produits_par_fournisseur->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->fournisseur->liste($offset_suivant,$no_of_records_per_page));

	         $this->data['liste_produits_fournisseur'] =$liste;
             $this->data['total_suivant'] =$total_suivant;

             $liste_des_articles =$this->article->liste_produits_disponibles();
             $this->data['liste_des_articles'] =$liste_des_articles;

             $liste_fournisseurs= $this->fournisseur->get_all();
             $this->data['liste_fournisseurs'] =$liste_fournisseurs;

             if($id!=-1){

             	$infos_produit =$this->produits_par_fournisseur->get_by_id($id);;
             	$this->data['infos_produit'] =$infos_produit;
             }

             $this->twig->display('stock/liste_produits_fournisseur.html.twig',$this->data);

		}

		public function supprimer_produit_fournisseur($id){

			$this->produits_par_fournisseur->delete($id);
			redirect("gestion_stock/liste_produits_fournisseur");
		}

		public function ajouter_fournisseur($id=-1){


		     	if(isset($_POST["raison_sociale"]) and  $_POST["raison_sociale"]!=""){


		     		if(isset($_POST["id"]) and $_POST["id"]!=""){


		     			    $donnes_fournisseur = array(

				     			"Raison_sociale"=>$_POST["raison_sociale"],
				     			"Pays"=>$_POST["pays"],
				     			"Email"=>$_POST["email"],
				     			"Telephone"=>$_POST["telephone"],
				     			"Adresse"=>$_POST["adresse"],
				     			"Numero_identite_fiscale"=>$_POST["numero_identite_fiscale"],
				     			"TVA"=>$_POST["tva"],
				     			"Registre_commerce"=>$_POST["registre_commerce"],
				     			"Banque"=>$_POST["banque"],
				     			"Code_swift"=>$_POST["code_swift"],
				     			"RIB"=>$_POST["rib"]

				     		);

				     		$this->fournisseur->update($_POST["id"], $donnes_fournisseur);


		     		}else{

		     			    
                           $donnes_fournisseur = array(

				     			"Raison_sociale"=>$_POST["raison_sociale"],
				     			"Pays"=>$_POST["pays"],
				     			"Email"=>$_POST["email"],
				     			"Telephone"=>$_POST["telephone"],
				     			"Adresse"=>$_POST["adresse"],
				     			"Numero_identite_fiscale"=>$_POST["numero_identite_fiscale"],
				     			"TVA"=>$_POST["tva"],
				     			"Registre_commerce"=>$_POST["registre_commerce"],
				     			"Banque"=>$_POST["banque"],
				     			"Code_swift"=>$_POST["code_swift"],
				     			"RIB"=>$_POST["rib"]

				     		);
                           $test = $this->fournisseur->test_doublon($_POST["raison_sociale"]);
                           if($test==0){
                           	$this->fournisseur->insert($donnes_fournisseur);
                           }
				     		

		     		}

		     		redirect("gestion_stock/fournisseurs/-1/1");

		     		
		     	}
               
               $this->data['id'] =$id;
               if($id!=-1){

               	$infos_fournisseur = $this->fournisseur->get_by_id($id);
               	$this->data['infos_fournisseur'] =$infos_fournisseur;

               }
               
               $liste_pays = $this->utilisateur->liste_pays();

               $this->data['liste_pays'] =$liste_pays;
               $this->twig->display('stock/ajouter_fournisseur.html.twig',$this->data);

		    }

		    public function supprimer_fournisseur($id){


		    	$this->fournisseur->delete($id);
		    	redirect("gestion_stock/fournisseurs/-1/1");
		    }
		

		 public function articles($page=1){

		 	$no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->article->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->article->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->article->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->article->recherche($_POST["mot_cle"]);

	         }

        
           $this->data['liste_articles'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('stock/stock_produits_services.html.twig',$this->data);

		 }

		 public function supprimer_article($id=-1){

		 	$this->article->delete($id);
		 	redirect("gestion_stock/articles/1");


		 }

		 public function supprimer_produit($id=-1){

		 	$this->article->delete($id);
		 	redirect("gestion_stock/liste_produits");


		 }

		 public function ajouter_produit($id=-1){

		 	if(isset($_POST["reference"]) and $_POST["reference"]!=""){


		 		if(isset($_POST["id"]) and $_POST["id"]!=""){

                     $article = array(

			 			"Type"=>$_POST["type"],
			 			"Libelle"=>$_POST["libelle"],
			 			"Reference"=>$_POST["reference"],
			 			"Id_categorie"=>$_POST["categorie"],
			 			"Unite"=>$_POST["unite_mesure"],
			 			"Prix_vente_ht"=>$_POST["prix_vente_ht"],
			 			"Prix_vente_ttc"=>$_POST["prix_vente_ttc"],
			 			"Prix_achat_ttc"=>$_POST["prix_achat_ttc"],
			 			"Quantite_stock"=>$_POST["quantite_stock"],
			 			"Seuil_minimum"=>$_POST["seuil_minimum"],
			 			"TVA"=>$_POST["tva"],
			 			"En_vente"=>$_POST["en_vente"],
			 			"Marque"=>$_POST["marque"],
			 			"Code_barre"=>$_POST["code_barre"],
			 			"Description"=>$_POST["description"]

			 		  );

                     $this->article->update($_POST["id"], $article);
                     redirect("gestion_stock/articles/1");

		 		}else{

			 		  $article = array(

			 			"Type"=>$_POST["type"],
			 			"Libelle"=>$_POST["libelle"],
			 			"Reference"=>$_POST["reference"],
			 			"Id_categorie"=>$_POST["categorie"],
			 			"Unite"=>$_POST["unite_mesure"],
			 			"Prix_vente_ht"=>$_POST["prix_vente_ht"],
			 			"Prix_vente_ttc"=>$_POST["prix_vente_ttc"],
			 			"Prix_achat_ttc"=>$_POST["prix_achat_ttc"],
			 			"Quantite_stock"=>$_POST["quantite_stock"],
			 			"Seuil_minimum"=>$_POST["seuil_minimum"],
			 			"TVA"=>$_POST["tva"],
			 			"En_vente"=>$_POST["en_vente"],
			 			"Marque"=>$_POST["marque"],
			 			"Code_barre"=>$_POST["code_barre"],
			 			"Description"=>$_POST["description"]

			 		  );
	                $test =$this->article->test_doublon($_POST["libelle"]);

	                if($test==0){

	                	$id_article= $this->article->insert($article);
	                	if(isset($_POST["les_entrepot"]) and count($_POST["les_entrepot"])>0){

	                		$les_entrepots=$_POST["les_entrepot"];
	                		$quantite_entrepot =$_POST["quantite_entrepot"];

	                		for($i=0;$i<count($les_entrepots);$i++){

	                			$donnees_article_entrepot = array(

	                				"Reference_reception"=>"--",
	                				"Id_article"=>$id_article,
	                				"Id_entrepot"=>$les_entrepots[$i],
	                				"Quantite_recue"=>$quantite_entrepot[$i]

	                			);

	                			$this->article->ajout_dans_entrepot($donnees_article_entrepot);

	                			$test_entrepot=$this->stock_entrepot->get_by_article_entrepot($id_article,$les_entrepots[$i]);
	                			if(count($test_entrepot)>0){

	                				$total_actuel =$test_entrepot[0]->Total_stock;
						            $total_actuel =$total_actuel+$quantite_entrepot[$i];
						            $donnees_article_entrepot= array("Total_stock"=>$total_actuel);
						            $this->stock_entrepot->update($test_entrepot[0]->Id, $donnees_article_entrepot);


	                			}else{

	                				if($quantite_entrepot[$i]>0){

	                					$donnees_article_entrepot= array(
	                						"Id_entrepot"=>$les_entrepots[$i],
	                						"Id_article"=>$id_article,
	                						"Total_stock"=>$quantite_entrepot[$i]
						                );

						                $this->stock_entrepot->insert($donnees_article_entrepot);
	                				}


	                			}

	                		}
	                	}
	                	
			 		    $this->data['msg'] =1;

	                }else{

	                	$this->data['msg'] =-1;
	                }


		 		}

	

		 	}

            $reference_produit ="";
		 	if($id==-1){

                $reference_produit =time();
		 		$this->data['reference'] =$reference_produit;

		 	}else{
                
                $infos_produit = $this->article->get_by_id($id);
                $reference_produit=$infos_produit->Reference;
                $this->data['reference'] =$reference_produit;
                $this->data['infos_produit'] =$infos_produit;
                $liste_images = $this->images_produits->getRecordByProduit($reference_produit);
                $this->data['liste_images'] =$liste_images;

		 	}

		 	$liste_unites_mesure = $this->unite_valeur->get_all();
            $this->data['liste_unites_mesure'] =$liste_unites_mesure;
            $liste_categories = $this->categorie->get_all();
            $this->data['liste_categories'] =$liste_categories;
            $liste_fournisseurs = $this->fournisseur->get_all();
            $this->data['liste_fournisseurs'] =$liste_fournisseurs;
            $liste_entrepots=$this->entrepot->get_all();
            $this->data['liste_entrepots'] =$liste_entrepots;
            $liste_casiers = $this->casier->get_all();
            $this->data['liste_casiers'] =$liste_casiers;
            
            $this->data['id'] =$id;
            $this->twig->display('stock/ajouter_produit.html.twig',$this->data);

		 }

	 public function liste_produits($page=1){

            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->article->total_produits();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->article->liste_produits($offset,$no_of_records_per_page);
	         $total_suivant =count($this->article->liste_produits($offset_suivant,$no_of_records_per_page));


	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->article->recherche_produit($_POST["mot_cle"]);

	         }


           $this->data['liste_articles'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $liste_categories =$this->categorie->get_all();
           $this->data['liste_categories'] =$liste_categories;
           $liste_fournisseurs = $this->fournisseur->get_all();
           $this->data['liste_fournisseurs'] =$liste_fournisseurs;
           $this->twig->display('stock/liste_produits.html.twig',$this->data);


	}

	public function details_article($id){

        $infos_produit = $this->article->get_by_id($id);
        $this->data['infos_article'] = $infos_produit ;
        $infos_categorie =$this->categorie->get_by_id($infos_produit->Id_categorie);
        $this->data['categorie'] =$infos_categorie->Libelle;
        $liste_images= $this->images_produits->getRecordByProduit($infos_produit->Reference);
        $this->data['liste_images'] =$liste_images;
        $liste_prix =$this->produits_par_fournisseur->get_by_article($id);
        $this->data['liste_prix'] =$liste_prix;
        $liste_stock_entrepot =$this->article->liste_by_entrepot($id);
        $this->data['liste_stock_entrepot'] =$liste_stock_entrepot;
		$this->twig->display('stock/details_article.html.twig',$this->data);
	}


	 public function liste_services($page=1){

            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->article->total_services();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->article->liste_services($offset,$no_of_records_per_page);
	         $total_suivant =count($this->article->liste_produits($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	$liste = $this->article->recherche_service($_POST["mot_cle"]);

	         }


           $this->data['liste_articles'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('stock/liste_services.html.twig',$this->data);


	}

	 public function ajouter_service($id=-1){

		 	if(isset($_POST["reference"]) and $_POST["reference"]!=""){


		 		if(isset($_POST["id"]) and $_POST["id"]!=""){

                     $article = array(

			 			"Libelle"=>$_POST["libelle"],
			 			"Reference"=>$_POST["reference"],
			 			"Id_categorie"=>$_POST["categorie"],
			 			"Unite"=>"",
			 			"Prix_vente_ht"=>$_POST["prix_vente_ht"],
			 			"Prix_vente_ttc"=>$_POST["prix_vente_ttc"],
			 			"Prix_achat_ttc"=>$_POST["prix_achat_ttc"],
			 			"Quantite_stock"=>1,
			 			"Seuil_minimum"=>1,
			 			"TVA"=>$_POST["tva"],
			 			"En_vente"=>$_POST["en_vente"],
			 			"Description"=>$_POST["description"]

			 		  );

                     $this->article->update($_POST["id"], $article);
                     redirect("gestion_stock/articles/1");

		 		}else{

			 		  $article = array(

			 			"Libelle"=>$_POST["libelle"],
			 			"Reference"=>$_POST["reference"],
			 			"Id_categorie"=>$_POST["categorie"],
			 			"Unite"=>"",
			 			"Prix_vente_ht"=>$_POST["prix_vente_ht"],
			 			"Prix_vente_ttc"=>$_POST["prix_vente_ttc"],
			 			"Prix_achat_ttc"=>$_POST["prix_achat_ttc"],
			 			"Quantite_stock"=>1,
			 			"Seuil_minimum"=>1,
			 			"Type"=>"Service",
			 			"TVA"=>$_POST["tva"],
			 			"En_vente"=>$_POST["en_vente"],
			 			"Description"=>$_POST["description"]

			 		  );
	                $test =$this->article->test_doublon($_POST["libelle"]);

	                if($test==0){

	                	$this->article->insert($article);
			 		    $this->data['msg'] =1;

	                }else{

	                	$this->data['msg'] =-1;
	                }


		 		}

	

		 	}

            $reference_produit ="";
		 	if($id==-1){

                $reference_produit =time();
		 		$this->data['reference'] =$reference_produit;

		 	}else{
                
                $infos_service = $this->article->get_by_id($id);
                $reference_service=$infos_service->Reference;
                $this->data['reference'] =$reference_service;
                $this->data['infos_service'] =$infos_service;
                $liste_images = $this->images_produits->getRecordByProduit($reference_service);

                $this->data['liste_images'] =$liste_images;

		 	}

		 	
            $liste_categories = $this->categorie->get_all();
            $this->data['liste_categories'] =$liste_categories;
            $liste_fournisseurs = $this->fournisseur->get_all();
            $this->data['liste_fournisseurs'] =$liste_fournisseurs;
            $liste_entrepots=$this->entrepot->get_all();
           
            
            $this->data['id'] =$id;
            $this->twig->display('stock/ajouter_service.html.twig',$this->data);

		 }


	 public function liste_produits_approvisionnement($page=1){

            $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
	        $total =$this->article->total_articles_approvisionnement();

	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->article->liste_produits_approvisionnement($offset,$no_of_records_per_page);

	         $total_suivant =count($this->article->liste_produits_approvisionnement($offset_suivant,$no_of_records_per_page));

           $this->data['liste_articles'] =$liste;
           $this->data['total_suivant'] =$total_suivant;
           $this->twig->display('stock/liste_produits_approvisionnement.html.twig',$this->data);


	}

	public function liste_inventaires($page=1,$id=-1){


		if(isset($_POST["reference"]) and $_POST["reference"]!=""){


			  if(isset($_POST["id"]) and $_POST["id"]!=""){

                $donnees_inventaire = array("Reference"=>$_POST["reference"],
				                        "Date"=>date("d/m/Y"),
				                        "Id_categorie"=>-1,
				                        "Id_entrepot"=>-1
				                       
				                    );

                $this->inventaire->update($_POST["id"], $donnees_inventaire);


			  }else{


			  	 $donnees_inventaire = array("Reference"=>$_POST["reference"],
				                        "Date"=>date("d/m/Y"),
				                        "Id_categorie"=>-1,
				                        "Id_entrepot"=>-1
				                    );
			      $id_inventaire = $this->inventaire->insert($donnees_inventaire);
			    redirect("gestion_stock/produits_inventaire/".$id_inventaire);


			  }


			
		}

        $no_of_records_per_page = 50;
        $offset = ($page-1) * $no_of_records_per_page;
        $offset_suivant = ($page) * $no_of_records_per_page;
        $total =$this->inventaire->total();

        $total_pages = ceil($total / $no_of_records_per_page);

         $this->data['total_pages'] = $total_pages;
         $this->data['page_precedente'] =$page-1;
         $this->data['page_suivante'] =$page+1;
         $this->data['page'] =$page;
         $this->data['pagination'] =1;

       $liste = $this->inventaire->liste($offset,$no_of_records_per_page);

       $total_suivant =count($this->article->liste($offset_suivant,$no_of_records_per_page));
      
       $reference ="RINV".time();
       $this->data['reference'] =$reference;
       $this->data['liste_inventaires'] =$liste;
       $liste_entrepots =$this->entrepot->get_all();
       $this->data['liste_entrepots'] =$liste_entrepots;
       $this->data['total_suivant'] =$total_suivant;
       $this->data['id'] =$id;

       if($id!=-1){
       	$infos_inventaire  =$this->inventaire->get_by_id($id);
       	$this->data['infos_inventaire'] =$infos_inventaire;
       	$this->data['reference'] =$infos_inventaire->Reference;
       }

	   $this->twig->display('stock/liste_inventaires.html.twig',$this->data);


	}


	public function produits_inventaire($id){


		if(isset($_POST["id_produit"])){

          $liste_produits =$_POST["id_produit"];

          $liste_quantite_theorique = $_POST["quantite_theorique"];
          $liste_quantite_reelle =$_POST["quantite_reelle"];
          $liste_entrepots =$this->entrepot->get_all();
          $stock_entrepot=$_POST["stock_entrepot"];

          $total_entrepots =$this->entrepot->total();

	   	  $total = count($_POST["id_produit"]);
	   	  for($i=0;$i<$total;$i++){
             $ecart =$liste_quantite_reelle[$i]-$liste_quantite_theorique[$i];
             $donnees_produit_inventaire = array(

             	"Id_inventaire"=>$id,
             	"Id_produit"=>$liste_produits[$i],
             	"Quantite_theorique"=>$liste_quantite_theorique[$i],
             	"Quantite_relle"=>$liste_quantite_reelle[$i],
             	"Ecart"=>$ecart

             );

             $test = $this->inventaire->test_produit_inventaire($liste_produits[$i],$id);

             if($test==0){

             	 $this->inventaire->ajout_produits_inventaire($donnees_produit_inventaire);

	             	  $infos_article =$this->article->get_by_id($liste_produits[$i]);
	             	  $reste=$infos_article->Quantite_stock+$ecart;

	             	  if($ecart>0){

			             	$donnees_mouvement =array(

			             		"Id_article"=>$liste_produits[$i],
			             		"Type"=>"Entrée",
			             		"Quantite"=>abs($ecart),
			             		"Date"=>date("d/m/Y"),
			             		"Id_inventaire"=>$id,
			             		"Commentaire"=>"Ajustement inventaire : surplus constaté"

			             	);
			             	$this->mouvements_stock->insert($donnees_mouvement);

			           }

			           if($ecart<0){

			             	$donnees_mouvement =array(

			             		"Id_article"=>$liste_produits[$i],
			             		"Type"=>"Sortie",
			             		"Quantite"=>abs($ecart),
			             		"Date"=>date("d/m/Y"),
			             		"Id_inventaire"=>$id,
			             		"Commentaire"=>"Ajustement inventaire : manque constaté"

			             	);
			             	$this->mouvements_stock->insert($donnees_mouvement);
			           }

			           $donnes_article=array("Quantite_stock"=>$reste);
			           $this->article->update($liste_produits[$i], $donnes_article);


             }

             //Modification des stocks entrepot



             $j=0;
             for($j=0;$j<$total_entrepots;$j++){

    			$test_entrepot=$this->stock_entrepot->get_by_article_entrepot($liste_produits[$i],$liste_entrepots[$j]->Id);

    			$total_actuel=0;

    			if(count($test_entrepot)>0){

    				$total_actuel =$stock_entrepot[$i][$j];
		            $donnees_article_entrepot= array("Total_stock"=>$total_actuel);
		            $this->stock_entrepot->update($test_entrepot[0]->Id, $donnees_article_entrepot);


    			}else{

    				if($stock_entrepot[$i]>0){

    					$donnees_article_entrepot= array(
    						"Id_entrepot"=>$liste_entrepots[$j]->Id,
    						"Id_article"=>$liste_produits[$i],
    						"Total_stock"=>$stock_entrepot[$i][$j]
		                );

		                $this->stock_entrepot->insert($donnees_article_entrepot);
    				}


    			}

	   	  }
	   	  //Fin modification entrepot




	   	  }



	   	  $donnes_inventaire = array("Etat"=>1);
	   	  $this->inventaire->update($id, $donnes_inventaire);

	   	  redirect("gestion_stock/liste_inventaires");
	   }

       $infos_inventaire = $this->inventaire->get_by_id($id);
       $this->data['infos_inventaire'] =$infos_inventaire;
       
       $liste_entrepots =$this->entrepot->get_all();
       $this->data['liste_entrepots'] =$liste_entrepots;
       $liste_produits_par_stock =$this->article->historique_stock_by_entrepot();

     
       $this->data['liste_produits_par_stock'] =$liste_produits_par_stock;

       $this->data['id']=$id;
       $this->twig->display('stock/produits_inventaire.html.twig',$this->data);

	}

    public function details_inventaire($id){
       $infos_inventaire = $this->inventaire->get_by_id($id);
       $liste_produits = $this->inventaire->get_liste_produits_inventaire($id);
       $this->data['infos_inventaire']=$infos_inventaire; 
       $this->data['liste_produits'] =$liste_produits;
       $this->data['id']=$id;
       $this->twig->display('stock/details_inventaires.html.twig',$this->data);
    }

    public function mouvements($page=1){

    	$no_of_records_per_page = 50;
        $offset = ($page-1) * $no_of_records_per_page;
        $offset_suivant = ($page) * $no_of_records_per_page;
        $total =$this->mouvements_stock->total();

        $total_pages = ceil($total / $no_of_records_per_page);

         $this->data['total_pages'] = $total_pages;
         $this->data['page_precedente'] =$page-1;
         $this->data['page_suivante'] =$page+1;
         $this->data['page'] =$page;
         $this->data['pagination'] =1;

       $liste = $this->mouvements_stock->liste($offset,$no_of_records_per_page);

       $total_suivant =count($this->mouvements_stock->liste($offset_suivant,$no_of_records_per_page));
       $liste_categories = $this->categorie->get_all();
       ;
       $this->data['liste_mouvements'] =$liste;
       $this->data['total_suivant'] =$total_suivant;

       $this->twig->display('stock/liste_mouvements.html.twig',$this->data);

    }

	public function supprimer_inventaire($id){
        $this->inventaire->delete_produits_inventaire($id);
		$this->inventaire->delete($id);
		redirect("gestion_stock/liste_inventaires");
	}


	public function importer_produit(){
     
        $liste_categories =$this->categorie->get_all();
        $this->data['liste_categories'] =$liste_categories;
        $liste_fournisseurs = $this->fournisseur->get_all();
        $this->data['liste_fournisseurs'] =$liste_fournisseurs;
        $this->twig->display('stock/importer_produit.html.twig',$this->data);

	}

	public function supprimer_lot_produits(){

		$liste_id =$_POST["produits"];
		foreach($liste_id as $id){

			$this->article->delete($id);

		}

		redirect("gestion_stock/liste_produits");

	}

	public function supprimer_lot_produits_services(){

		$liste_id =$_POST["produits"];
		foreach($liste_id as $id){

			$this->article->delete($id);

		}

		redirect("gestion_stock/articles");


	}

	public function stock_par_entrepot(){
        $liste_entrepots =$this->entrepot->get_all();
        $this->data['liste_entrepots'] =$liste_entrepots;
        $liste_produits_par_stock =$this->article->historique_stock_by_entrepot();

        if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!="" ){

        $liste_produits_par_stock=$this->article->recherche_stock_by_entrepot($_POST["mot_cle"]);
	    }
        $this->data['liste_produits_par_stock'] =$liste_produits_par_stock;
		$this->twig->display('stock/stock_par_entrepot.html.twig',$this->data);
	}





		


}