<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

			public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->data['base_url'] = base_url();
		     $this->data['assets_front'] =base_url()."assets/front";
		     $this->data['assets_admin'] =base_url()."assets/admin";
		     $this->data['assets_mail']  = base_url()."assets/mail";
		     $this->data['current_year']  =date("Y");

		    } 


		    public function ajout_utilisateur(){


		    	$bcrypt = new Bcrypt();
          $bcrypt_version = '2a';

                
                $donne_utilisateur = array(
                "Date_creation"=>date("d/m/Y"),
	 	    		 	  "Nom"=>"SALLAH",
	 	    		 	  "Prenom"=>"Messan",
	 	    		 	  "Telephone"=>"0676234567",
	 	    		 	  "Email"=>"smessan@gmail.com",
	 	    		 	  "Password"=>$bcrypt->crypt("123456"),
	 	    		 	  "Derniere_connexion"=>"",
	 	    		 	  "Etat"=>1

	 	    	);

	 	    	$this->utilisateur->insert($donne_utilisateur);
		    }

		    

			public function index(){
         
				$this->twig->display('login/login.html.twig',$this->data);

			}

			public function fichier_modele_produits(){
        /*
				header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="modele_produit.csv"');
        readfile('uploads/modele_produit.csv');
        */

        $filename = 'modele_produit.csv';

        // Définition des en-têtes HTTP
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$filename");
        header("Content-Type: application/csv; ");

        // Ouvrir la sortie "php://output"
        $file = fopen('php://output', 'w');

        // 🔸 Écrire l’en-tête CSV
        $header = array("Reference", "Designation", "Unite", "Prix_vente_ttc", "Prix_achat_ttc","TVA","Quantite","Seuil_minimum","Marque","Code_barre","Description");
        $pr=array("P3223","Ordinateur portable","Pièce (PC)","420","280","20","45","5","HP","1122222","Core I7");
        $liste_entrepots =$this->entrepot->get_all();
        foreach($liste_entrepots as $entrepot){

        	$nom_entrepot ="Quantite_".$this->transformer_chaine($entrepot->Nom);
        	$header[]=$nom_entrepot;
        	$pr[]=0;
        }
        fputcsv($file, $header);
        

        $produits[] =$pr ;

          // 🔸 Écrire chaque ligne
        foreach ($produits as $row) {
            fputcsv($file, $row);
        }

        fclose($file);
        exit;

			}



			public function fichier_modele_categorie(){
         
				header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="modele_produit.csv"');
        readfile('uploads/modele_categorie.csv');

			}

			public function fichier_modele_fournisseur(){
      
       header('Content-Type: application/octet-stream');
       header('Content-Disposition: attachment; filename="modele_fournisseur.csv"');
       readfile('uploads/modele_fournisseur.csv');

			}

				public function fichier_modele_contact(){
      
       header('Content-Type: application/octet-stream');
       header('Content-Disposition: attachment; filename="modele_contact.csv"');
       readfile('uploads/modele_contact.csv');

			}

			

			function transformer_chaine($str)
				{
				    // 1. Remplacer les espaces par _
				    $str = str_replace(' ', '_', $str);

				    // 2. Supprimer les accents
				    $str = iconv('UTF-8', 'ASCII//TRANSLIT', $str);

				    // 3. Supprimer tout caractère non désiré (optionnel)
				    $str = preg_replace('/[^A-Za-z0-9_]/', '', $str);

				    // 4. Retourner la chaîne
				    return $str;
				}


			public function consulter_devis($id_vente){
       
				$infos_devis =$this->vente->get_by_id($id_vente);
				$infos_societe =$this->societe->get_all();
        $this->data['infos_societe']=$infos_societe[0];
        $infos_vente =$this->vente->get_by_id($id);
        $infos_client =$this->contact->get_by_id($infos_vente->Id_client);
        $this->data['infos_client'] =$infos_client;
        $this->data['infos_vente']  =$infos_vente;
        $liste_articles = $this->vente->liste_details_vente($id);
        $this->data['liste_articles']  =$liste_articles;
        $total_ht =$this->vente->get_total_ht($id);
        $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	  $total_ttc =$this->vente->get_total_ttc($id);
	   	  $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	  $total_tva =$this->vente->get_total_tva($id);
	   	  $total_tva_devise =$this->vente->get_total_tva_devise($id);

	   	  $donnees_vente = array("Statut"=>"Vu par le client");
	   	  $this->vente->update($id_vente, $donnees_vente);
	   	  
	   	  $this->data['total_tva'] =$total_tva;
	   	  $this->data['total_tva_devise'] =$total_tva_devise;
	   	  $this->data['total_ht'] =$total_ht;
	   	  $this->data['total_ht_devise'] =$total_ht_devise;
	   	  $this->data['total_ttc'] =$total_ttc;
	   	  $this->data['total_ttc_devise'] =$total_ttc_devise;



			}

			

			public function login(){

				 $bcrypt = new Bcrypt();
                 $bcrypt_version = '2a';

				 if(isset($_POST["email"]) and  $_POST["email"]!=""){
                    
                 $infos_utilisateur= $this->utilisateur->get_by_email($_POST["email"]);

                 if(count($infos_utilisateur)==0){

			                $this->data['message'] = -1;


			            }else{

			            	 if($infos_utilisateur[0]->Etat==0){

			                     $this->data['message'] = -2;

			                }else{

			                	   if($bcrypt->compare($_POST["password"],$infos_utilisateur[0]->Password) ){

				                        $this->session->set_userdata('logged_in', true);
				                        $this->session->set_userdata('nom_utilisateur',$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom );
				                        $this->session->set_userdata('id_utilisateur', $infos_utilisateur[0]->Id_utilisateur);
				                        $this->session->set_userdata('role', $infos_utilisateur[0]->Role);
				                        $donnes_utilisateur = array("Derniere_connexion"=>date("d/m/Y H:i:m"));
				                        $this->utilisateur->update($infos_utilisateur[0]->Id_utilisateur, $donnes_utilisateur);
				                        $infos_societe =$this->societe->get_all();

				                        if(count($infos_societe)>0){

				                        	redirect("admin/dashboard");

				                        }else{

				                        	redirect("admin/configuration_societe");

				                        }

				                        

				                    }else{

				                    	$this->data['message'] = -1;


				                    }



			                }


			            }

				 }
         
				$this->twig->display('login/login.html.twig',$this->data);

			}

			
			public function logout(){
        $this->session->set_userdata('logged_in', false);
				$this->twig->display('login/login.html.twig',$this->data);

			}

			public function mon_devis($id){

				  $infos_societe =$this->societe->get_all();
          $this->data['infos_societe']=$infos_societe[0];

          $infos_vente =$this->vente->get_by_id($id);
          $infos_client =$this->contact->get_by_id($infos_vente->Id_client);

          $banque =$infos_societe[0]->Banque;
          $iban=$infos_societe[0]->IBAN;
          $code_swift=$infos_societe[0]->Code_swift;

          if($infos_vente->Id_compte_bancaire!="-1"){

          	$infos_compte_bancaire =$this->compte_bancaire->get_by_id($infos_vente->Id_compte_bancaire);
          	$banque =$infos_compte_bancaire->Institution_bancaire;
            $iban=$infos_compte_bancaire->RIB;
            $code_swift=$infos_compte_bancaire->SWIFT;
          }

          $this->data['banque'] =$banque;
          $this->data['iban'] =$iban;
          $this->data['code_swift'] =$code_swift;

          $this->data['infos_client'] =$infos_client;
          $this->data['infos_vente']  =$infos_vente;
          $liste_articles = $this->vente->liste_details_vente($id);
          $this->data['liste_articles']  =$liste_articles;
          $total_ht =$this->vente->get_total_ht($id);
          $total_ht_devise =$this->vente->get_total_ht_devise($id);
	   	    $total_ttc =$this->vente->get_total_ttc($id);
	   	    $total_ttc_devise =$this->vente->get_total_ttc_devise($id);
	   	    $total_tva =$this->vente->get_total_tva($id);
	   	    $total_tva_devise =$this->vente->get_total_tva_devise($id);
	   	  
	   	    $this->data['total_tva'] =$total_tva;
	   	    $this->data['total_tva_devise'] =$total_tva_devise;
	   	    $this->data['total_ht'] =$total_ht;
	   	    $this->data['total_ht_devise'] =$total_ht_devise;
	   	    $this->data['total_ttc'] =$total_ttc;
	   	    $this->data['total_ttc_devise'] =$total_ttc_devise;
	   	    $this->data['id_vente'] =$id;
	   	    $this->twig->display('docs_devis/mon_devis.html.twig',$this->data);

			}

			public function valider_devis($id_vente){

				$infos_devis = array("Statut"=>"Validé");
				$this->vente->update($id_vente, $infos_devis);
				redirect("home/mon_devis");


			}

			public function erreur(){

				$this->twig->display('template/404.html.twig',$this->data);

			}




}
