<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tresorerie extends MY_Controller {


	       public function __construct() {
		     
		     parent::__construct();
		     $this->load->library("Bcrypt");
		     $this->load->library('email');
		     $this->data['base_url']       = base_url();
		     $this->data['assets_front']   = base_url()."assets/front";
		     $this->data['assets_admin']   = base_url()."assets/admin";
		     $this->data['assets_mail']    = base_url()."assets/mail";
		     $this->data['current_year']   = date("Y");
		     $this->data['mois_en_cours']  = date("m/Y");
		     $infos_societe =$this->societe->get_all();
		     $this->data['societe']  =$infos_societe[0];
		     $this->data['infos_societe']  =$infos_societe[0];
		     $this->data['role_utilisateur']  = $this->session->userdata('role');

		     $liste_autorisations =[];
		     $liste_autorisations =$this->role->liste_codes_actions_role($this->session->userdata('role'));
		     $this->data['liste_autorisations']  =$liste_autorisations;

		    
		    } 


		    public function index(){
                
                $this->data['mois_en_cours']  = date("m/Y");
                $this->data['annee_en_cours'] = date("Y");

                
                $total_encaissements =$this->encaissement->get_total_encaissements_par_mois(date("Y-m"));
                $this->data['total_encaissements']  =$total_encaissements;
                $total_decaissements =$this->decaissement->get_total_decaissements_par_mois(date("Y-m"));
                $this->data['total_decaissements']  =$total_decaissements;
                $solde_disponible =$total_encaissements-$total_decaissements;
                $solde_positif =1;
                if($solde_disponible<0){
                $solde_positif =0;
                }
                $this->data['solde_disponible']  =$solde_disponible;
                $this->data['solde_positif']  =$solde_positif;
                $this->data['entrees_prevues']  =$this->vente-> total_des_ventes_a_encaisser();

                $statistiques_encaissement =$this->encaissement->statistiques_encaissements();

                $this->data['statistiques_encaissement']  =json_encode($statistiques_encaissement);

                $statistiques_decaissement=$this->decaissement->statistiques_decaissements();
                $this->data['statistiques_decaissement']  =json_encode($statistiques_decaissement);
                $this->data['dash_tresorerie']  =1;
                $this->data['has_chart'] =1;
                

		    	$this->twig->display('tresorerie/dashboard_tresorerie.html.twig',$this->data);
		    }

		    public function ajouter_un_encaissement($id=-1){

		    	if(isset($_POST["date_encaissement"]) and $_POST["date_encaissement"]!=""){

		    		  if(isset($_POST["id"]) and $_POST["id"]!=""){

		    		  	     $file="";
							 if(!empty($_FILES)) {


							  	   if(is_uploaded_file($_FILES['piece_jointe']['tmp_name'])) {

							  	   	       $reference=time();
					                       $sourcePath = $_FILES['piece_jointe']['tmp_name'];
					                       $image=$_FILES['piece_jointe']['name'];
					                       $tabimg=explode('.',$image);
					                       $extension = strtolower(end($tabimg));
					                       $file=$reference.".".$extension;
					                       $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
					                       if(in_array($extension,$liste_extensions)){
					                       	$targetPath = "uploads/".$reference.".".$extension;
					                        move_uploaded_file($sourcePath,$targetPath);

					                        $donnes_encaissement = array("Piece_jointe"=>$file);
					                        $this->encaissement->update($_POST["id"], $donnes_encaissement);


					                       }

							  	   }

							  }

							  $donnees_encaissement =array(
                                    "Date"=>$_POST["date_encaissement"],
				    		  		"Reference_facture"=>$_POST["numero_facture"],
				    		  		"Montant"=>$_POST["montant"],
				    		  		"Libelle"=>$_POST["libelle"],
				    		  		"Mode_paiement"=>$_POST["mode_paiement"],
				    		  		"Type_encaissement"=>$_POST["type_encaissement"],
				    		  		"Id_compte_bancaire"=>$_POST["id_compte"],
				    		  		"Statut"=>$_POST["statut"],
				    		  		"Id_caisse"=>$_POST["id_caisse"],
				    		  		"Notes"=>$_POST["notes"]

				    		  	);
				    		  	$this->encaissement->update($_POST["id"], $donnees_encaissement);



		    		  }else{


		    		  		 $file="";
							 if(!empty($_FILES)) {


							  	   if(is_uploaded_file($_FILES['piece_jointe']['tmp_name'])) {

							  	   	       $reference=time();
					                       $sourcePath = $_FILES['piece_jointe']['tmp_name'];
					                       $image=$_FILES['piece_jointe']['name'];
					                       $tabimg=explode('.',$image);
					                       $extension = strtolower(end($tabimg));
					                       $file=$reference.".".$extension;
					                       $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
					                       if(in_array($extension,$liste_extensions)){
					                       	$targetPath = "uploads/".$reference.".".$extension;
					                        move_uploaded_file($sourcePath,$targetPath);

					                       }

							  	   }

							  }

                        $reference_encaissement = "ENC".time();
		    		  	$donnees_encaissement =array(
                            "Reference"=>$reference_encaissement,
		    		  		"Date"=>$_POST["date_encaissement"],
		    		  		"Id_responsable"=>$this->session->userdata('id_utilisateur'),
		    		  		"Reference_facture"=>$_POST["numero_facture"],
		    		  		"Montant"=>$_POST["montant"],
		    		  		"Libelle"=>$_POST["libelle"],
		    		  		"Mode_paiement"=>$_POST["mode_paiement"],
		    		  		"Type_encaissement"=>$_POST["type_encaissement"],
		    		  		"Id_compte_bancaire"=>$_POST["id_compte"],
		    		  		"Statut"=>$_POST["statut"],
		    		  		"Id_caisse"=>$_POST["id_caisse"],
		    		  		"Piece_jointe"=>$file,
		    		  		"Notes"=>$_POST["notes"]

		    		  	);
		    		  	$this->encaissement->insert($donnees_encaissement);
		    		  	

		             

		    		  	

		    		  }

		    		  $this->data['msg'] =1;

		    		  if($_POST["statut"]=="Validé"){
                            
                            $infos_societe =$this->societe->get_all();
		    		  	    $solde_finale =$infos_societe[0]->Solde +floatval($_POST["montant"]);
		                	$donnees_journal=array(

		    		  		"Reference_piece"=>$_POST["numero_facture"],
		    		  		"Type_operation"=>"Encaissement",
		    		  		"Montant"=>$_POST["montant"],
		    		  		"Mode_paiement"=>$_POST["mode_paiement"],
		    		  		"Date_operation"=>$_POST["date_encaissement"],
		    		  		"Libelle"=>$_POST["libelle"],
		    		  		"Id_responsable"=>$this->session->userdata('id_utilisateur'),
		    		  		"Solde_apres_operation"=>$solde_finale

			    		  	);

			    		  	$this->journal_tresorerie->insert($donnees_journal);

			    		  	$donnees_societe=array(

			    		  		"Solde"=>$solde_finale

			    		  	);
			    		  	$this->societe->update($infos_societe[0]->Id, $donnees_societe);

		                }

		    		  $infos_vente =$this->vente->get_by_reference_vente($_POST["numero_facture"]);

		    		  if(count($infos_vente)>0){

		    		  	$total_ttc_vente =$this->vente->get_total_ttc($infos_vente[0]->Id);
		    		  	$total_encaissement = floatval($_POST["montant"]);

		    		  	if($total_encaissement<$total_ttc_vente){
                            

                            if($_POST["statut"]=="Validé"){

                            	$donnees_vente = array("Statut"=>"Partiellement payé");
                            }
		    		  		
		    		  	}else{

		    		  		if($_POST["statut"]=="Validé"){

		    		  		$donnees_vente = array("Statut"=>"Payé");

		    		  		}
		    		  	}

		    		  	if($_POST["statut"]=="Annulé"){

		    		  		$donnees_vente = array("Statut"=>"Validé");

		    		  	}

		    		  	$this->vente->update($infos_vente[0]->Id, $donnees_vente);

		    		  }


		    	}

		    	if($id!=-1){

		    		$infos_encaissement =$this->encaissement->get_by_id($id);
		    		$this->data['infos_encaissement'] =$infos_encaissement;
		    		$this->data['ajout'] =2;
		    	}else{
		    		$this->data['ajout'] =1;
		    	}

		    	$this->data['id'] =$id;

		    	$liste_modes_reglement =$this->modes_paiement->get_all();
                $this->data['liste_modes_reglement'] =$liste_modes_reglement;

                $liste_types_encaissement =$this->type_encaissement->get_all();
                $this->data['liste_types_encaissement'] =$liste_types_encaissement;

                $liste_statuts_encaissement =$this->statut_encaissement->get_all();
                $this->data['liste_statuts_encaissement'] =$liste_statuts_encaissement;

                $liste_comptes_bancaires =$this->compte_bancaire->get_all();
                $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;

                $liste_caisses =$this->caisse->get_all();
                $this->data['liste_caisses'] =$liste_caisses;


		    	$this->twig->display('tresorerie/ajouter_encaissement.html.twig',$this->data);


		    }

		    public function liste_encaissements($page=1){


		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
            $total = $this->encaissement->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->encaissement->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->encaissement->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["date"]) and $_POST["date"]!=""){
                
	         	$liste =$this->encaissement->recherche($_POST["date"]);
	         }

	         $this->data['liste_encaissements'] =$liste;
             $this->data['total_suivant'] =$total_suivant;

             $this->twig->display('tresorerie/liste_encaissements.html.twig',$this->data);

		    }

		    function convertirDateYmdVersDmy($date) {
			    $timestamp = strtotime($date);
			    if ($timestamp === false) {
			        return null; // ou retourner la date originale selon ton besoin
			    }
			    return date('d/m/Y', $timestamp);
			}


		    public function supprimer_encaissement($id){

		    	$this->encaissement->delete($id);
		    	redirect("tresorerie/liste_encaissements");
		    }


		    public function creer_compte_bancaire($id=-1){


		    	if(isset($_POST["nom_du_compte"]) and $_POST["nom_du_compte"]!=""){


                  
                    if(isset($_POST["id"]) and $_POST["id"]!=-1){

                    	$donnes_compte_bancaire = array(
		            
		            		"Nom_du_compte"=>$_POST["nom_du_compte"],
		            		"Institution_bancaire"=>$_POST["institution_bancaire"],
		            		"Numero_compte"=>$_POST["numero_compte"],
		            		"RIB"=>$_POST["rib"],
		            		"SWIFT"=>$_POST["swift"],
		            		"Id_annexe"=>$_POST["annexe"]
	            	    );

                        $this->compte_bancaire->update($_POST["id"],$donnes_compte_bancaire);

                    }else{

                    	 $donnes_compte_bancaire = array(
		                    "Date_creation"=>date("d/m/Y"),
		            		"Nom_du_compte"=>$_POST["nom_du_compte"],
		            		"Institution_bancaire"=>$_POST["institution_bancaire"],
		            		"Id_responsable"=>$this->session->userdata('id_utilisateur'),
		            		"Numero_compte"=>$_POST["numero_compte"],
		            		"RIB"=>$_POST["rib"],
		            		"SWIFT"=>$_POST["swift"],
		            		"Id_annexe"=>$_POST["annexe"]
	            	    );

                    	 $this->compte_bancaire->insert($donnes_compte_bancaire);
                    	 

                    }


                    $this->data['msg']  =1;

		    	}

		    	if($id!=-1){

		    		$infos_compte_bancaire =$this->compte_bancaire->get_by_id($id);
		    		$this->data['infos_compte']=$infos_compte_bancaire;
		    	}

		    	$liste_annexes =$this->annexe->get_all();
		    	$this->data['liste_annexes']=$liste_annexes;

		    	$this->data['id']  =$id;

		    	$this->twig->display('tresorerie/creer_compte_bancaire.html.twig',$this->data);
		    }

		    public function supprimer_compte($id){

		    	$this->compte_bancaire->delete($id);
		    	redirect("tresorerie/comptes_bancaires");
		    }

		    public function comptes_bancaires($page=1){

		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
            $total = $this->compte_bancaire->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->compte_bancaire->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->compte_bancaire->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	  $liste =$this->compte_bancaire->recherche($_POST["mot_cle"]);
	         }

	         $this->data['liste_coomptes_bancaires'] =$liste;
             $this->data['total_suivant'] =$total_suivant;

             $this->twig->display('tresorerie/comptes_bancaires.html.twig',$this->data);

		    }

		    public function caisses($page=1){

		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
            $total = $this->caisse->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->caisse->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->caisse->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["mot_cle"]) and $_POST["mot_cle"]!=""){

	         	  $liste =$this->caisse->recherche($_POST["mot_cle"]);
	         }

	         $this->data['liste_caisses'] =$liste;
             $this->data['total_suivant'] =$total_suivant;

             $this->twig->display('tresorerie/caisses.html.twig',$this->data);

		    }

		    public function creer_caisse($id=-1){

		    if(isset($_POST["nom_caisse"]) and $_POST["nom_caisse"]!=""){


                  
                    if(isset($_POST["id"]) and $_POST["id"]!=-1){

                    	$donnes_caisse = array(
		            
		            		"Nom_caisse"=>$_POST["nom_caisse"],
		            		"Code_caisse"=>$_POST["code_caisse"],
		            		"Type"=>$_POST["type_caisse"]
		            		
	            	    );

                        $this->caisse->update($_POST["id"],$donnes_caisse);

                    }else{

                    	 $donnes_caisse = array(
		                    "Date_creation"=>date("d/m/Y"),
		                    "Id_responsable"=>$this->session->userdata('id_utilisateur'),
		            		"Nom_caisse"=>$_POST["nom_caisse"],
		            		"Code_caisse"=>$_POST["code_caisse"],
		            		"Type"=>$_POST["type_caisse"]
	            	    );

                    	 $this->caisse->insert($donnes_caisse);
                    	 

                    }


                    $this->data['msg']  =1;

		    	}

		    	if($id!=-1){

		    		$infos_caisse =$this->caisse->get_by_id($id);
		    		$this->data['infos_caisse']=$infos_caisse;
		    	}

		    	$this->data['id']  =$id;

            $this->data['id'] =$id;
            $liste_type_caisse =$this->type_caisse->get_all();
            $this->data['liste_type_caisse'] =$liste_type_caisse;
            $this->twig->display('tresorerie/creer_caisse.html.twig',$this->data);

		    }

		    public function ajouter_un_decaissement($id=-1){


		    	if(isset($_POST["date_decaissement"]) and $_POST["date_decaissement"]!=""){


		    		   if(isset($_POST["id"]) and $_POST["id"]!=""){



		    		   	     $file="";
							 if(!empty($_FILES)) {


							  	   if(is_uploaded_file($_FILES['piece_jointe']['tmp_name'])) {

							  	   	       $reference=time();
					                       $sourcePath = $_FILES['piece_jointe']['tmp_name'];
					                       $image=$_FILES['piece_jointe']['name'];
					                       $tabimg=explode('.',$image);
					                       $extension = strtolower(end($tabimg));
					                       $file=$reference.".".$extension;
					                       $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
					                       if(in_array($extension,$liste_extensions)){
					                       	$targetPath = "uploads/".$reference.".".$extension;
					                        move_uploaded_file($sourcePath,$targetPath);

					                        $donnes_decaissement = array("Piece_jointe"=>$file);
					                        $this->decaissement->update($_POST["id"], $donnes_decaissement);


					                       }

							  	   }

							  }
                              $reference_decaissement ="DEC".time();
							  $donnees_decaissement = array(
                                "Reference"=>$reference_decaissement,
							  	"Montant"=>$_POST["montant"],
							  	"Libelle"=>$_POST["libelle"],
							  	"Reference_facture"=>$_POST["reference_facture"],
							  	"Beneficiaire"=>$_POST["beneficiaire"],
							  	"Type"=>$_POST["type_decaissement"],
							  	"Statut"=>$_POST["statut"],
							  	"Piece_jointe"=>$file,
							  	"Mode_reglement"=>$_POST["mode_reglement"],
							  	"Id_compte_bancaire"=>$_POST["id_compte"],
							  	"Id_caisse"=>$_POST["id_compte"],
							  	"Notes"=>$_POST["notes"],

							  );

							  $this->decaissement->update($_POST["id"], $donnees_decaissement);


		    		   }else{


		    		   	     $file="";
							 if(!empty($_FILES)) {


							  	   if(is_uploaded_file($_FILES['piece_jointe']['tmp_name'])) {

							  	   	       $reference=time();
					                       $sourcePath = $_FILES['piece_jointe']['tmp_name'];
					                       $image=$_FILES['piece_jointe']['name'];
					                       $tabimg=explode('.',$image);
					                       $extension = strtolower(end($tabimg));
					                       $file=$reference.".".$extension;
					                       $liste_extensions =array("jpeg","jpg","png","gif","bmp","jfif");
					                       if(in_array($extension,$liste_extensions)){
					                       	$targetPath = "uploads/".$reference.".".$extension;
					                        move_uploaded_file($sourcePath,$targetPath);

					                       }

							  	   }

							  }

							  $donnees_decaissement = array(

							  	"Id_responsable"=>$this->session->userdata('id_utilisateur'),
							  	"Date"=>$_POST["date_decaissement"],
							  	"Montant"=>$_POST["montant"],
							  	"Libelle"=>$_POST["libelle"],
							  	"Reference_facture"=>$_POST["reference_facture"],
							  	"Beneficiaire"=>$_POST["beneficiaire"],
							  	"Type"=>$_POST["type_decaissement"],
							  	"Statut"=>$_POST["statut"],
							  	"Piece_jointe"=>$file,
							  	"Mode_reglement"=>$_POST["mode_reglement"],
							  	"Id_compte_bancaire"=>$_POST["id_compte"],
							  	"Id_caisse"=>$_POST["id_compte"],
							  	"Notes"=>$_POST["notes"],

							  );

							  $this->decaissement->insert($donnees_decaissement);




		    		   }

		        if(isset($_POST["reference_facture"]) and $_POST["reference_facture"]!=""){

		        	$infos_achat =$this->achat->get_by_reference_achat($_POST["reference_facture"]);

		        	if(count($infos_achat)>0){


		        		$total_ttc =$this->achat->get_total_ttc($infos_achat[0]->Id);
		        		$total_encaisse =floatval($_POST["montant"]);

		        		if($total_encaisse<$total_ttc){

		        			if($_POST["statut"]=="Validé"){

		        				$donnees_achat =array("Statut"=>"Partiellement payé");
		        				$this->achat->update($infos_achat[0]->Id, $donnees_achat);
		        			}

		        			
		        		}else{

		        			if($_POST["statut"]=="Validé"){

		        				$donnees_achat =array("Statut"=>"Payé");
		        				$this->achat->update($infos_achat[0]->Id, $donnees_achat);
		        			}


		        		}


		        		if($_POST["statut"]=="Annulé"){

		        				$donnees_achat =array("Statut"=>"Validé");
		        				$this->achat->update($infos_achat[0]->Id, $donnees_achat);
		        		}



		        	}


		        }

		                 $this->data['msg'] =1;

		                 if($_POST["statut"]=="Validé"){
                            
                            $infos_societe =$this->societe->get_all();
		    		  	    $solde_finale =$infos_societe[0]->Solde -floatval($_POST["montant"]);
		                	$donnees_journal=array(

		    		  		"Reference_piece"=>$_POST["reference_facture"],
		    		  		"Type_operation"=>"Décaissement",
		    		  		"Montant"=>$_POST["montant"],
		    		  		"Mode_paiement"=>$_POST["mode_reglement"],
		    		  		"Date_operation"=>$_POST["date_decaissement"],
		    		  		"Libelle"=>$_POST["libelle"],
		    		  		"Id_responsable"=>$this->session->userdata('id_utilisateur'),
		    		  		"Solde_apres_operation"=>$solde_finale

			    		  	);
			    		  	$this->journal_tresorerie->insert($donnees_journal);

			    		  	$donnees_societe=array(

			    		  		"Solde"=>$solde_finale

			    		  	);
			    		  	$this->societe->update($infos_societe[0]->Id, $donnees_societe);

		                }

		    	}

		    	$this->data['id'] =$id;

		    	if($id!=-1){

		    		$infos_decaissement =$this->decaissement->get_by_id($id);
		    		$this->data['infos_decaissement']=$infos_decaissement;
		    	}

		    	$liste_comptes_bancaires =$this->compte_bancaire->get_all();
                $this->data['liste_comptes_bancaires'] =$liste_comptes_bancaires;

		    	$liste_modes_reglement =$this->modes_paiement->get_all();
                $this->data['liste_modes_reglement'] =$liste_modes_reglement;

		    	$liste_types_decaissement =$this->type_decaissement->get_all();
                $this->data['liste_types_decaissement'] =$liste_types_decaissement;

                $liste_statuts_decaissement =$this->statut_decaissement->get_all();
                $this->data['liste_statuts_decaissement'] =$liste_statuts_decaissement;

                $this->data['ajout'] =1;
		    	$this->twig->display('tresorerie/ajouter_decaissement.html.twig',$this->data);

		    }

		    public function liste_decaissements($page=1){


		    $no_of_records_per_page = 50;
	        $offset = ($page-1) * $no_of_records_per_page;
	        $offset_suivant = ($page) * $no_of_records_per_page;
            $total = $this->decaissement->total();
	        $total_pages = ceil($total / $no_of_records_per_page);

	         $this->data['total_pages'] = $total_pages;
	         $this->data['page_precedente'] =$page-1;
	         $this->data['page_suivante'] =$page+1;
	         $this->data['page'] =$page;
	         $this->data['pagination'] =1;

	         $liste = $this->decaissement->liste($offset,$no_of_records_per_page);
	         $total_suivant =count($this->decaissement->liste($offset_suivant,$no_of_records_per_page));

	         if(isset($_POST["date"]) and $_POST["date"]!=""){
                
	         	$liste =$this->decaissement->recherche($_POST["date"]);
	         }

	         $this->data['liste_decaissements'] =$liste;
             $this->data['total_suivant'] =$total_suivant;

             $this->twig->display('tresorerie/liste_decaissements.html.twig',$this->data);

		    }


		    public function supprimer_decaissement($id){

		    	$this->decaissement->delete($id);
		    	redirect("tresorerie/liste_decaissements");
		    }

		    public function liste_entrees_prevues(){

                $liste_prochains_recouvrements =$this->vente->liste_des_ventes_a_encaisser();
                $this->data['liste_prochains_recouvrements']=$liste_prochains_recouvrements;
		    	$this->twig->display('tresorerie/liste_entrees_prevues.html.twig',$this->data);

		    }

		    public function journal_tresorerie(){
                $periode=date("Y-m");

                if(isset($_POST["mois"]) and $_POST["mois"]!=""){

                	$periode=date($_POST["annee"]."-".$_POST["mois"]);
                }
                $liste_journal =$this->journal_tresorerie->recherche($periode);
                $this->data['liste_journal'] =$liste_journal;
		    	$this->twig->display('tresorerie/journal_tresorerie.html.twig',$this->data);
		    }






}