<?php 
class Achat extends CI_Model {
	
 protected $table = 'Achats';
 protected $table_details_achat = 'Achats_details';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

    public function ajout_details_achat($data){

        $this->db->insert($this->table_details_achat, $data);
         return $this->db->insert_id();
    }

    public function recherche($date){
        
        $liste_des_achats = array();
        $resultats= $this->db->get_where($this->table, array('Date_achat' => $date))->result();
        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

        return $liste_des_achats;

    }

    public function recherche_avancee($fournisseur,$statut,$type){

        $liste_des_achats = array();
        $resultats= $this->db->get_where($this->table, array('Id_fournisseur' => $fournisseur,'Statut'=>$statut,"Type"=>$type))->result();

        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

        return $liste_des_achats;


    }

    public function liste_details_achat($id){
        
        $liste_details =[];
        $resultats= $this->db->get_where($this->table_details_achat, array('Id_achat' => $id))->result();
        foreach($resultats as $res){

            $donnee =$res;
            $infos_article = $this->article->get_by_id($res->Id_article);
            $donnee->Article =$infos_article->Libelle;
            $donnee->Reference =$infos_article->Reference;
            $donnee->Unite =$infos_article->Unite;
            $liste_details[] =$donnee;
        }

        return $liste_details;
    }

    public function liste_articles_reception($id){

        $liste_reception = array();
        $infos_reception =$this->get_by_id($id);
        $liste_articles = $this->liste_details_achat($id);
        $liste_des_entrepots  = $this->entrepot->get_all();

        foreach($liste_articles as $article){

           $donnee =$article;

           $test_article =$this->get_article_from_achat($id,$article->Id_article);
           $infos_achat =$this->get_article_from_achat($infos_reception->Id_parent,$article->Id_article);
           $infos_article =$this->article->get_by_id($article->Id_article);
           $donnee->Reference =$infos_article->Reference;
           $donnee->Unite =$infos_article->Unite;
           $donnee->Article =$infos_article->Libelle;
           $donnee->Quantite =$infos_achat[0]->Quantite;
           if(count($test_article)==0){
            $donnee->Quantite_recue =0;
           }else{
            $donnee->Quantite_recue=$test_article[0]->Quantite;
           }
           $liste_data_entrepot = array();
           foreach($liste_des_entrepots as $entrepot){
              $data_entrepot = new stdClass();
              $data_entrepot->Id_entrepot=$entrepot->Id;
              $test_reception_entrepot = $this->article->get_article_entrepot($article->Id_article,$entrepot->Id,$infos_reception->Numero_demande);
              if(count($test_reception_entrepot)==0){
                $data_entrepot->Quantite_recue_entrepot=0;
               }else{
                $data_entrepot->Quantite_recue_entrepot=$test_reception_entrepot[0]->Quantite_recue;
               }
               $data_entrepot->Id_entrepot =$entrepot->Id;

               $liste_data_entrepot[]=$data_entrepot;
           }

           $donnee->Liste_data_entrepot=$liste_data_entrepot;
           $liste_reception[]=$donnee;
           
        }

      return $liste_reception;
    }

  

    public function get_article_from_achat($id_achat,$id_article){

        $resultats= $this->db->get_where($this->table_details_achat, array('Id_achat' => $id_achat,'Id_article'=>$id_article))->result();

        return $resultats;
    }

    public function test_article_achat($id_achat,$id_article){

        $resultats= $this->db->get_where($this->table_details_achat, array('Id_achat' => $id_achat,'Id_article'=>$id_article))->result();

        return $resultats;

    }


    public function get_total_ht($id_achat)
    {
        $this->db->select_sum('Total_ht');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return (float) $query->row()->Total_ht;
        } else {
            return 0;
        }
    }

     public function get_total_ht_devise($id_achat)
    {
        $this->db->select_sum('Total_ht_devise');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return (float) $query->row()->Total_ht_devise;
        } else {
            return 0;
        }
    }

    public function get_total_ttc($id_achat)
    {
        $this->db->select_sum('Total_ttc');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return (float) $query->row()->Total_ttc;
        } else {
            return 0;
        }
    }


    public function get_total_ttc_devise($id_achat)
    {
        $this->db->select_sum('Total_ttc_devise');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return (float) $query->row()->Total_ttc_devise;
        } else {
            return 0;
        }
    }

    public function get_total_tva($id_achat)
    {
        // Calcule la somme totale de la TVA (sans réduction)
        $this->db->select_sum('((Total_ttc * (Tva / (100 + Tva))))', 'Total_tva');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            // Retourne le total de TVA arrondi à 2 décimales
            return number_format((float) $query->row()->Total_tva, 2);
        } else {
            return 0;
        }
    }

    public function get_total_tva_devise($id_achat)
    {
        // Calcule la somme totale de la TVA (sans réduction)
        $this->db->select_sum('((Total_ttc_devise * (Tva / (100 + Tva))))', 'Total_tva');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            // Retourne le total de TVA arrondi à 2 décimales
            return number_format((float) $query->row()->Total_tva, 2);
        } else {
            return 0;
        }
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

    public function total_by_statut($statut){

        $resultats= $this->db->get_where($this->table, array('Statut' => $statut))->result();

        return $resultats;

    }


    public function get_total_quantite($id_achat)
    {
        $this->db->select_sum('Quantite', 'total_quantite');
        $this->db->from('Achats_details');
        $this->db->where('Id_achat', $id_achat);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return (int)$row->total_quantite;
        }

        return 0;
    }


    public function liste_commandes_fournisseur($offset,$nb_per_page) {
          
          $liste_des_achats = array();
          $query=$this->db->query('SELECT * FROM Achats WHERE Type="BCF" AND Statut="Validé" ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

           return $liste_des_achats;

    }

    public function total_commandes_fournisseurs(){

        $query=$this->db->query('SELECT * FROM Achats WHERE Type="BCF" AND Statut="Validé" ' );
          $resultats = $query->num_rows();
    }

     public function liste_commandes_fournisseur_mois($mois) {
          
          $liste_des_achats = array();
          $query=$this->db->query('SELECT * FROM Achats WHERE Type="BCF" AND Statut="Validé" AND Date_achat LIKE "%'.$mois.'%"' );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

           return $liste_des_achats;

    }

    public function total_by_type_statut($type,$statut,$mois){

        
        $liste_des_ventes = array();
        $query=$this->db->query("SELECT * FROM Achats WHERE Type='".$type."' AND Statut='".$statut."' AND Date_achat LIKE '%".$mois."%'" );
          $resultats = $query->num_rows();

          return $resultats;
    }

     public function liste_demandes_achat($offset,$nb_per_page) {
          
          $liste_des_achats = array();
          $query=$this->db->query('SELECT * FROM Achats WHERE Type="BCF" AND  (Statut="Brouillon" OR Statut="En attente de validation") ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

           return $liste_des_achats;

    }

    public function total_demandes_achat(){

          $query=$this->db->query('SELECT * FROM Achats WHERE Type="BCF" AND Statut="Brouillon" OR Statut="En attente de validation" ' );
          $resultats = $query->num_rows();

          return $resultats;
    }

   
    public function liste_bons_reception($offset,$nb_per_page) {
          
          $liste_des_achats = array();
          $query=$this->db->query('SELECT * FROM Achats WHERE Type="BRF" ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

           return $liste_des_achats;

    }

    public function total_bons_reception(){

        $query=$this->db->query('SELECT * FROM Achats WHERE Type="BRF" ' );
          $resultats = $query->num_rows();
    }

    public function liste_factures_achat($offset,$nb_per_page) {
          
          $liste_des_achats = array();
          $query=$this->db->query('SELECT * FROM Achats WHERE Type="FF"  ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_fournisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_achats[]=$donnee;
         
          }

           return $liste_des_achats;

    }

    public function total_factures_achat(){

        $query=$this->db->query('SELECT * FROM Achats WHERE Type="FF"  ' );
          $resultats = $query->num_rows();
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function get_by_reference_achat($reference_achat) {
        return $this->db->get_where($this->table, array('Type' => "FF",'Numero_demande'=>$reference_achat))->result();
    }

     public function get_element_achat_by_id($id) {
        return $this->db->get_where($this->table_details_achat, array('Id' => $id))
                        ->row();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function delete_element_achat($id)
    {
    $this->db->where('Id', $id);
    return $this->db->delete($this->table_details_achat);
    }

     public function delete_achat($id)
    {
    $this->db->where('Id_achat', $id);
    return $this->db->delete($this->table_details_achat);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }

    public function update_details($id, $data) {
        return $this->db->update($this->table_details_achat, $data, ['Id' => $id]);
    }


}