<?php 
class Annexe extends CI_Model {
	
 protected $table = 'Annexes';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
     public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function infos_annexe($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->result();
    }

    public function test_by_designation($designation){

        return $this->db->get_where($this->table, array('Designation' => $designation))
                        ->num_rows();
    }

    public function test_doublon($nom,$id_entrepot) {
        return $this->db->get_where($this->table, array('Libelle' => $nom,'Id_entrepot'=>$id_entrepot))->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}