<?php 
class Article extends CI_Model {
	
 protected $table = 'Articles';
 protected $table_par_entrepot = 'Articles_par_entrepot';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

    public function ajout_dans_entrepot($data){

    $this->db->insert($this->table_par_entrepot, $data);
         return $this->db->insert_id();

    }

    public function get_article_entrepot($id_article,$id_entrepot,$ref_reception){

        return $this->db->get_where($this->table_par_entrepot, array('Id_article' => $id_article,'Id_entrepot'=>$id_entrepot,'Reference_reception'=>$ref_reception))->result();
    }

    public function get_all() {
    return $this->db->order_by('id', 'DESC')
                    ->get($this->table)
                    ->result();
    }

    public function liste_by_entrepot($id_article){
     
      $liste_stock_entrepot=array();
      $resultats =$this->stock_entrepot->get_by_article($id_article);
      foreach($resultats as $res){
         
         $donnee=$res;
         $infos_entrepot=$this->entrepot->get_by_id($res->Id_entrepot);
         $donnee->Entrepot=$infos_entrepot->Nom." ".$infos_entrepot->Pays;
         $liste_stock_entrepot[]=$donnee;

      }

      return $liste_stock_entrepot;

    }

    public function recherche_stock_by_entrepot($mot_cle){


        $liste_historique=array();
       
        $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" AND  Libelle LIKE "%'.$mot_cle.'%" ORDER BY Id DESC ' );
        $liste_articles =$query->result();
        $liste_entrepots =$this->entrepot->get_all();
        
        
        foreach($liste_articles  as $article){

            $donnee=$article;
            $stocks_par_entrepot=array();
            foreach($liste_entrepots as $entrepot){

                  $infos_by_entrepot =$this->stock_entrepot->get_by_article_entrepot($article->Id,$entrepot->Id);
                  $dentrepot = new stdClass();
                  $dentrepot->Id_entrepot=$entrepot->Id;

                if(count($infos_by_entrepot)>0){
                    $dentrepot->Total_stock=$infos_by_entrepot[0]->Total_stock;

                }else{
                    $dentrepot->Total_stock=0;

                }

                $stocks_par_entrepot[]=$dentrepot;

            }

            $donnee->Stock_entrepots=$stocks_par_entrepot;
            $liste_historique[]=$donnee;

        }


        return $liste_historique;
    }


    public function historique_stock_by_entrepot(){


        $liste_historique=array();
        $liste_articles =$this->liste_produits_disponibles();
        $liste_entrepots =$this->entrepot->get_all();
        
        foreach($liste_articles  as $article){

            $donnee=$article;
            $stocks_par_entrepot=array();
            foreach($liste_entrepots as $entrepot){

                  $infos_by_entrepot =$this->stock_entrepot->get_by_article_entrepot($article->Id,$entrepot->Id);
                  $dentrepot = new stdClass();
                  $dentrepot->Id_entrepot=$entrepot->Id;

                if(count($infos_by_entrepot)>0){
                    $dentrepot->Total_stock=$infos_by_entrepot[0]->Total_stock;

                }else{
                    $dentrepot->Total_stock=0;

                }

                $stocks_par_entrepot[]=$dentrepot;

            }

            $donnee->Stock_entrepots=$stocks_par_entrepot;
            $liste_historique[]=$donnee;

        }


        return $liste_historique;
    }

    public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

    public function liste_produits_categorie($id_categorie){

        if($id_categorie==-1){

          $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" ORDER BY Id DESC ' );
         
        }else{
           
           $query=$this->db->query('SELECT * FROM Articles WHERE Id_categorie='.$id_categorie.' AND Type!="Service" ORDER BY Id DESC ' );

        }
         $resultats = $query->result();

         return  $resultats;

    }

    public function liste_derniers_produits(){

        $base_url = base_url();
        $liste_produits = array();
        $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" ORDER BY Id DESC  ' );
        $resultats = $query->result();

        foreach($resultats as $res){

          $donnee = new stdClass();
          $donnee->id=$res->Id;
          $donnee->name=$res->Libelle;
          $donnee->price=floatval($res->Prix_vente_ttc);
          $liste_images  =$this->images_produits->getRecordByProduit($res->Reference);

          if(count($liste_images)==0){
            $donnee->image=$base_url."uploads/default_product.png";
          }else{
            $donnee->image=$base_url."uploads/".$liste_images[0]->Image;
          }

          $liste_produits[]=$donnee;

        }

        return $liste_produits;


    }


    public function recherche_produit_caisse($mot_cle){

        $base_url = base_url();
        $liste_produits = array();

        if($mot_cle==""){

            $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service"  ORDER BY Id DESC ' );

        }else{

            $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" AND (Libelle LIKE "%'.$mot_cle.'%" OR Code_barre LIKE "%'.$mot_cle.'%" ) ORDER BY Id DESC ' );

        }
        
        $resultats = $query->result();

        foreach($resultats as $res){

          $donnee = new stdClass();
          $donnee->id=$res->Id;
          $donnee->name=$res->Libelle;
          $donnee->price=floatval($res->Prix_vente_ttc);
          $liste_images  =$this->images_produits->getRecordByProduit($res->Reference);

          if(count($liste_images)==0){
            $donnee->image=$base_url."uploads/default_product.png";
          }else{
            $donnee->image=$base_url."uploads/".$liste_images[0]->Image;
          }

          $liste_produits[]=$donnee;

        }

        return $liste_produits;


    }

     public function liste_produits_disponibles(){

        $query=$this->db->query('SELECT * FROM Articles WHERE En_vente=1 AND Type!="Service" ORDER BY Id DESC ' );
     
         $resultats = $query->result();

         return  $resultats;

    }



     public function liste_produits_categorie_entrepot($id_categorie,$id_entrepot){

        if($id_categorie==-1){

          $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" AND Id_entrepot='.$id_entrepot.' ORDER BY Id DESC ' );
         
        }else{
           
           $query=$this->db->query('SELECT * FROM Articles WHERE Id_categorie='.$id_categorie.' AND Type!="Service" AND Id_entrepot='.$id_entrepot.' ORDER BY Id DESC ' );

        }
         $resultats = $query->result();

         return  $resultats;

    }

    public function liste($offset,$nb_per_page) {
          
          $liste_articles = array();
          $query=$this->db->query('SELECT * FROM Articles ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $donnee->Categorie =$infos_categorie->Libelle;

            $liste_images =$this->images_produits->getRecordByProduit($res->Reference);
            $base_url =base_url();
            if(count($liste_images)==0){
            $donnee->Image=$base_url."uploads/default_product.png";
            }else{
            $donnee->Image=$base_url."uploads/".$liste_images[0]->Image;
            }
            
            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;

    }

   public function liste_produits($offset,$nb_per_page) {
          
          $liste_articles = array();
          $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $liste_images =$this->images_produits->getRecordByProduit($res->Reference);
            $base_url =base_url();
            if(count($liste_images)==0){
            $donnee->Image=$base_url."uploads/default_product.png";
            }else{
            $donnee->Image=$base_url."uploads/".$liste_images[0]->Image;
            }
            $donnee->Categorie =$infos_categorie->Libelle;
            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;

    }

     public function liste_produits_approvisionnement($offset,$nb_per_page) {
          
          $liste_articles = array();
          $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" AND Quantite_stock<=Seuil_minimum  ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $donnee->Categorie =$infos_categorie->Libelle;
            $infos_founisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);
            $infos_entrepot =$this->entrepot->get_by_id($res->Id_entrepot);
            $donnee->Entrepot=$infos_entrepot->Nom;
             $liste_images =$this->images_produits->getRecordByProduit($res->Reference);
            $base_url =base_url();
            if(count($liste_images)==0){
            $donnee->Image=$base_url."uploads/default_product.png";
            }else{
            $donnee->Image=$base_url."uploads/".$liste_images[0]->Image;
            }

            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;

    }

    public function liste_services($offset,$nb_per_page) {
          
          $liste_articles = array();
          $query=$this->db->query('SELECT * FROM Articles WHERE Type="Service" ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $donnee->Categorie =$infos_categorie->Libelle;
            
            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;

    }

    public function recherche($mot_cle){
        
        $liste_articles = array();
        $query=$this->db->query('SELECT * FROM Articles WHERE (Libelle LIKE "%'.$mot_cle.'%" OR Reference  LIKE "%'.$mot_cle.'%" ) ORDER BY Id DESC  ' );
        $resultats = $query->result();

       foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $donnee->Categorie =$infos_categorie->Libelle;

            $liste_images =$this->images_produits->getRecordByProduit($res->Reference);
            $base_url =base_url();
            if(count($liste_images)==0){
            $donnee->Image=$base_url."uploads/default_product.png";
            }else{
            $donnee->Image=$base_url."uploads/".$liste_images[0]->Image;
            }

            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;
    
    }

     public function recherche_produit($mot_cle){
        
        $liste_articles = array();
        $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service"  AND (Libelle LIKE "%'.$mot_cle.'%" OR Reference  LIKE "%'.$mot_cle.'%" ) ORDER BY Id DESC  ' );
        $resultats = $query->result();

       foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $donnee->Categorie =$infos_categorie->Libelle;

            $liste_images =$this->images_produits->getRecordByProduit($res->Reference);
            $base_url =base_url();
            if(count($liste_images)==0){
            $donnee->Image=$base_url."uploads/default_product.png";
            }else{
            $donnee->Image=$base_url."uploads/".$liste_images[0]->Image;
            }
            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;
    
    }

     public function recherche_service($mot_cle){
        
        $liste_articles = array();
        $query=$this->db->query('SELECT * FROM Articles WHERE Type="Service"  AND (Libelle LIKE "%'.$mot_cle.'%" OR Reference  LIKE "%'.$mot_cle.'%" ) ORDER BY Id DESC  ' );
        $resultats = $query->result();

       foreach($resultats as $res){
            
            $donnee =$res;
            $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
            $donnee->Categorie =$infos_categorie->Libelle;
            $infos_founisseur = $this->fournisseur->get_by_id($res->Id_fournisseur);

            if($res->Id_fournisseur==-1){
            $donnee->Fournisseur="";
            }else{
            $donnee->Fournisseur=$infos_founisseur->Raison_sociale;
            }
            $liste_articles[] =$donnee;
            
          }

           return $liste_articles;
    
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_doublon($libelle) {
        return $this->db->get_where($this->table, array('Libelle' => $libelle))
                        ->num_rows();
    }

    public function total_produits() {
        $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" ' );
        $resultats = $query->num_rows();
        return $resultats;
    }

    public function total_services() {
        $query=$this->db->query('SELECT * FROM Articles WHERE Type="Service" ' );
        $resultats = $query->num_rows();
        return $resultats;
    }

    public function total_articles_approvisionnement() {
        $query=$this->db->query('SELECT * FROM Articles WHERE Type!="Service" AND Quantite_stock<=Seuil_minimum ' );
        $resultats = $query->num_rows();
        return $resultats;
    }


    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }

    public function update_article_entrepot($id, $data) {
        return $this->db->update($this->table_par_entrepot, $data, ['Id' => $id]);
    }


}