<?php 
class Caisse extends CI_Model {
	
 protected $table = 'Caisses';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
    public function liste($offset,$nb_per_page) {
          
          $liste_caisses =array();
          $query=$this->db->query('SELECT * FROM Caisses ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
          foreach($resultats as $res){

            $donnee=$res;
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $donnee->Responsable =$infos_responsable->Nom." ".$infos_responsable->Prenom;
            $liste_caisses[] = $donnee;

          }
        
           return $liste_caisses;

    }

    public function recherche($mot_cle){

        $liste_caisses =array();
        $query=$this->db->query('SELECT * FROM Caisses WHERE (Nom_caisse LIKE "%'.$mot_cle.'%" OR Type LIKE "%'.$mot_cle.'%" )  ORDER BY Id DESC  ' );
        $resultats = $query->result();

        foreach($resultats as $res){

            $donnee=$res;
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $donnee->Responsable =$infos_responsable->Nom." ".$infos_responsable->Prenom;
            $liste_comptes_bancaires[] = $donnee;

          }
        
        return $liste_comptes_bancaires;
    
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_nom($nom_caisse){

        return $this->db->get_where($this->table, array('Nom_caisse' => $nom_caisse))
                        ->num_rows();
    }


    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}