<?php 
class Campagne extends CI_Model {
	
 protected $table = 'Campagnes';
 protected $table_contact = 'Contacts';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }


     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
    public function liste($offset,$nb_per_page) {
          $liste_campagnes =array();
          $query=$this->db->query('SELECT * FROM Campagnes ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){

            $donnee=$res;
            $total_contacts =$this->total_contact_campagne($res->Id);
            $donnee->Total_contacts=$total_contacts;
            $liste_campagnes []=$donnee;

          }
        
           return $liste_campagnes;

    }

    public function recherche($mot_cle){
        $liste_campagnes =array();
        $query=$this->db->query('SELECT * FROM Campagnes WHERE (Libelle LIKE "%'.$mot_cle.'%"  )  ORDER BY Id DESC  ' );
        $resultats = $query->result();

         foreach($resultats as $res){

            $donnee=$res;
            $total_contacts =$this->total_contact_campagne($res->Id);
            $donnee->Total_contacts=$total_contacts;
            $liste_campagnes []=$donnee;

          }
        
           return $liste_campagnes;
    
    }

     public function total_contact_campagne($id_campagne) {
        return $this->db->get_where($this->table_contact, array('Id_campagne' => $id_campagne))->num_rows();
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function infos_campagne($id){

         return $this->db->get_where($this->table, array('Id' => $id))
                        ->result();
    }

    public function test_doublon($libelle) {
        return $this->db->get_where($this->table, array('Libelle' => $libelle))->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}