<?php 
class Casier extends CI_Model {
	
 protected $table = 'Casiers';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
    public function liste($offset,$nb_per_page) {
          $liste_casiers = array();
          $query=$this->db->query('SELECT * FROM Casiers ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
           foreach($resultats as $res){

              $infos_entrepot = $this->entrepot->get_by_id($res->Id_entrepot);
              $donnee=$res;
              $donnee->Entrepot=$infos_entrepot->Nom;
              $liste_casiers[]=$donnee;

           }

           return $liste_casiers;

    }

    public function recherche($mot_cle){
         $liste_casiers = array();
        $query=$this->db->query('SELECT * FROM Casiers WHERE (LIbelle LIKE "%'.$mot_cle.'%"  )  ORDER BY Id DESC  ' );
        $resultats = $query->result();
 
           foreach($resultats as $res){

              $infos_entrepot = $this->entrepot->get_by_id($res->Id_entrepot);
              $donnee=$res;
              $donnee->Entrepot=$infos_entrepot->Nom;
              $liste_casiers[]=$donnee;

           }

           return $liste_casiers;
    
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_doublon($nom,$id_entrepot) {
        return $this->db->get_where($this->table, array('Libelle' => $nom,'Id_entrepot'=>$id_entrepot))->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}