<?php 
class Compte_bancaire extends CI_Model {
	
 protected $table = 'Comptes_bancaire';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
    public function liste($offset,$nb_per_page) {
          
          $liste_comptes_bancaires =array();
          $query=$this->db->query('SELECT * FROM Comptes_bancaire ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
          foreach($resultats as $res){

            $donnee=$res;
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $donnee->Responsable =$infos_responsable->Nom." ".$infos_responsable->Prenom;
            $liste_comptes_bancaires[] = $donnee;

          }
        
           return $liste_comptes_bancaires;

    }

    public function recherche($mot_cle){

        $liste_comptes_bancaires =array();
        $query=$this->db->query('SELECT * FROM Comptes_bancaire WHERE (Nom_du_compte LIKE "%'.$mot_cle.'%" OR Institution_bancaire LIKE "%'.$mot_cle.'%"  OR  Numero_compte LIKE "%'.$mot_cle.'%" OR RIB LIKE "%'.$mot_cle.'%")  ORDER BY Id DESC  ' );
        $resultats = $query->result();

        foreach($resultats as $res){

            $donnee=$res;
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $donnee->Responsable =$infos_responsable->Nom." ".$infos_responsable->Prenom;
            $liste_comptes_bancaires[] = $donnee;

          }
        
        return $liste_comptes_bancaires;
    
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_numero_compte($numero_compte){

        return $this->db->get_where($this->table, array('Numero_compte' => $numero_compte))
                        ->num_rows();
    }


    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}