<?php 
class Contact extends CI_Model {
	
 protected $table = 'Contacts';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function liste_decroissante() {
    return $this->db->order_by('id', 'DESC')
                    ->get($this->table)
                    ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

    public function liste_by_campagne($id_campagne){
          
          $liste_contacts =array();
          $resultats= $this->db->get_where($this->table, array('Id_campagne' => $id_campagne)) ->result();
          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }

            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;

    }

    public function total_prospects() {
          
          $query=$this->db->query('SELECT * FROM Contacts WHERE Type="Prospect" ' );
          $resultats = $query->num_rows();
           return $resultats;

    }

    public function les_contacts() {
          
          $query=$this->db->query('SELECT * FROM Contacts  ORDER BY Id DESC' );
          $resultats = $query->result();
           return $resultats;

    }

     public function total_contacts() {
          
          $query=$this->db->query('SELECT * FROM Contacts ' );
          $resultats = $query->num_rows();
           return $resultats;

    }

    public function liste_nouveaux_contacts(){

        $liste_contacts =array();
        $statut_nouveau =$this->statut_contact->get_by_libelle("Nouveau");
        $query=$this->db->query('SELECT * FROM Contacts WHERE Id_statut='.$statut_nouveau->Id.' AND Id_utilisateur=-1 ORDER BY Id DESC ' );
        $resultats = $query->result();
        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }


            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;

    }

    public function liste_nouveaux_contacts_campagne($id_campagne){
        
        $liste_contacts =array();
        $statut_nouveau =$this->statut_contact->get_by_libelle("Nouveau");
        $query=$this->db->query('SELECT * FROM Contacts WHERE Id_statut='.$statut_nouveau->Id.' AND Id_campagne='.$id_campagne.' ORDER BY Id DESC ' );
        $resultats = $query->result();
        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }


            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;

    }

     public function total_contacts_periode($periode) {
          
          $query=$this->db->query('SELECT * FROM Contacts  WHERE  Date LIKE "%'.$periode.'%"' );
          $resultats = $query->num_rows();
           return $resultats;

    }

    public function liste_contacts_periode($periode) {
          $liste_contacts=array();
          $query=$this->db->query('SELECT * FROM Contacts  WHERE  Date LIKE "%'.$periode.'%"' );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }


            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;
           

    }

      public function total_contacts_commercial($id_commercial) {
          
          $query=$this->db->query('SELECT * FROM Contacts WHERE Id_utilisateur='.$id_commercial );
          $resultats = $query->num_rows();
           return $resultats;

    }

    public function total_clients() {
          
          $query=$this->db->query('SELECT * FROM Contacts WHERE Type="Client" ' );
          $resultats = $query->num_rows();
           return $resultats;

    }


  
    public function liste($offset,$nb_per_page) {

          $liste_contacts = array();
          $query=$this->db->query('SELECT * FROM Contacts ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }

            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;

    }

    public function liste_prospects($offset,$nb_per_page) {
          
          $liste_contacts =array();
          $query=$this->db->query('SELECT * FROM Contacts WHERE Type="Prospect" ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
           
           foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }

            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;

    }

     public function liste_clients($offset,$nb_per_page) {

          $liste_contacts=array();
          $query=$this->db->query('SELECT * FROM Contacts WHERE Type="Client" ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
           
         foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }

            $liste_contacts[] =$donnee;

          }
           return $liste_contacts;

    }

    public function total_contacts_date($date){

        $query=$this->db->query('SELECT * FROM Contacts WHERE Date LIKE "%'.$date.'%" ' );
        $resultats = $query->num_rows();
         return $resultats;

    }

    public function total_contacts_commercial_date($id_commercial,$date){

        $query=$this->db->query('SELECT * FROM Contacts WHERE Id_utilisateur='.$id_commercial.' AND Date LIKE "%'.$date.'%" ' );
        $resultats = $query->num_rows();
         return $resultats;

    }

    public function statistiques_contacts(){
        
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->total_contacts_date($mois."/".date("Y"));
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }

     public function statistiques_contacts_commercial($id_commercial){
        
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->total_contacts_commercial_date($id_commercial,$mois."/".date("Y"));
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }



    public function recherche($mot_cle){
        
        $liste_contacts =array();
        $query=$this->db->query('SELECT * FROM Contacts WHERE (Nom LIKE "%'.$mot_cle.'%" OR Prenom LIKE  "%'.$mot_cle.'%" OR Telephone LIKE "%'.$mot_cle.'%" OR Whatsapp LIKE "%'.$mot_cle.'%" OR Pays LIKE "%'.$mot_cle.'%" OR Adresse LIKE "%'.$mot_cle.'%" OR Email LIKE "%'.$mot_cle.'%" OR Entreprise LIKE "%'.$mot_cle.'%" )  ORDER BY Id DESC  ' );
        $resultats = $query->result();

        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_statut =$this->statut_contact->infos_statut($res->Id_statut);
            $infos_campagne  =$this->campagne->infos_campagne($res->Id_campagne);
            $infos_utilisateur =$this->utilisateur->infos_utilisateur($res->Id_utilisateur);

            if(count($infos_statut)==0){

            $donnee->Statut ="--";
            $donnee->Couleur ="--";

            }else{

            $donnee->Statut =$infos_statut[0]->Libelle;
            $donnee->Couleur =$infos_statut[0]->Couleur;

            }
            

            if(count($infos_campagne)==0){

            $donnee->Campagne="--";

            }else{

            $donnee->Campagne=$infos_campagne[0]->Libelle;

            }

            if(count($infos_utilisateur)==0){
           
             $donnee->Responsable="--";

            }else{

              $donnee->Responsable=$infos_utilisateur[0]->Nom." ".$infos_utilisateur[0]->Prenom;
            }

            $liste_contacts[] =$donnee;

          }

        return $liste_contacts;
    
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function get_by_nom_prenom($nom,$prenom) {
        return $this->db->get_where($this->table, array('Nom' => $nom,'Prenom'=>$prenom))
                        ->result();
    }

     public function get_by_phone($telephone) {
        return $this->db->get_where($this->table, array('Telephone' => $telephone))
                        ->result();
    }

    public function test_doublon($nom,$prenom) {
        return $this->db->get_where($this->table, array('Nom' => $nom,'Prenom'=>$prenom))->num_rows();
    }

    public function test_entreprise($entreprise){
        
        return $this->db->get_where($this->table, array('Entreprise' => $entreprise))->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}