<?php 
class Decaissement extends CI_Model {
	
 protected $table = 'Decaissements';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

     public function liste($offset,$nb_per_page) {

          $liste_decaissements = array();
          $query=$this->db->query('SELECT * FROM Decaissements ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats  as $res){

            $donnee=$res;
            if($res->Id_compte_bancaire==-1){

                $infos_caisse =$this->caisse->get_by_id($res->Id_caisse);
                $donnee->Compte_caisse=$infos_caisse->Nom_caisse;
            }else{

                $infos_compte_bancaire=$this->compte_bancaire->get_by_id($res->Id_compte_bancaire);
                $donnee->Compte_caisse=$infos_compte_bancaire->Nom_du_compte;
            }

            $infos_responsable = $this->utilisateur->get_by_id($res->Id_responsable);
            $donnee->Responsable =$infos_responsable->Nom." ".$infos_responsable->Prenom;
            $liste_decaissements[]=$donnee;

          }
           return $liste_decaissements;

    }

    public function recherche($mot_cle){
        $liste_decaissements = array();
        $query=$this->db->query('SELECT * FROM Decaissements WHERE (Reference_facture LIKE "%'.$mot_cle.'%" OR Date  LIKE "%'.$mot_cle.'%") ORDER BY Id DESC  ' );
        $resultats = $query->result();

        foreach($resultats  as $res){

            $donnee=$res;
            if($res->Id_compte_bancaire==-1){

                $infos_caisse =$this->caisse->get_by_id($res->Id_caisse);
                $donnee->Compte_caisse=$infos_caisse->Nom_caisse;
            }else{

                $infos_compte_bancaire=$this->compte_bancaire->get_by_id($res->Id_compte_bancaire);
                $donnee->Compte_caisse=$infos_compte_bancaire->Nom_du_compte;
            }

            $infos_responsable = $this->utilisateur->get_by_id($res->Id_responsable);
            $donnee->Responsable =$infos_responsable->Nom." ".$infos_responsable->Prenom;
            $liste_en_caissements[]=$donnee;

          }
           return $liste_en_caissements;
    
    }


   public function statistiques_decaissements(){
        
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->get_total_decaissements_par_mois(date("Y")."-".$mois);
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

     public function get_total_decaissements_par_mois($mois)
    {
        $this->db->select("SUM(Montant) AS total");
        $this->db->from('Decaissements');
        $this->db->where("DATE_FORMAT(STR_TO_DATE(Date, '%Y-%m-%d'), '%Y-%m') =", $mois);

        $row = $this->db->get()->row();
        return $row->total ?? 0;
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}