<?php 
class Entrepot extends CI_Model {
	
 protected $table = 'Entrepots';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
    public function liste($offset,$nb_per_page) {
          $liste_entrepots=array();
          $query=$this->db->query('SELECT * FROM Entrepots ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){

            $donnee=$res;
            $annexe =$this->annexe->infos_annexe($res->Id_annexe);
            if(count($annexe)==0){
               $donnee->Annexe=""; 
            }else{
               $donnee->Annexe=$annexe[0]->Designation;
            }
            $liste_entrepots[]=$donnee;
          }
           return $liste_entrepots;

    }

    public function recherche($mot_cle){
       
        $query=$this->db->query('SELECT * FROM Entrepots WHERE (Nom LIKE "%'.$mot_cle.'%" OR Pays  LIKE "%'.$mot_cle.'%" OR Adresse LIKE "%'.$mot_cle.'%" OR Responsable LIKE "%'.$mot_cle.'%" )  ORDER BY Id DESC  ' );
        $resultats = $query->result();

        return $resultats;
    
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_doublon($nom) {
        return $this->db->get_where($this->table, array('Nom' => $nom))
                        ->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}