<?php 
class Fournisseur extends CI_Model {
	
 protected $table = 'Fournisseurs';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_doublon($raison_sociale) {
        return $this->db->get_where($this->table, array('Raison_sociale' => $raison_sociale))
                        ->num_rows();
    }

    public function liste($offset,$nb_per_page) {

          $query=$this->db->query('SELECT * FROM Fournisseurs ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
           return $resultats;

    }

     public function recherche($mot_cle){
       
        $query=$this->db->query('SELECT * FROM Fournisseurs WHERE (Raison_sociale LIKE "%'.$mot_cle.'%" OR Pays  LIKE "%'.$mot_cle.'%" OR Email LIKE "%'.$mot_cle.'%" OR Telephone LIKE "%'.$mot_cle.'%" OR Adresse LIKE "%'.$mot_cle.'%" )  ORDER BY Id DESC  ' );
        $resultats = $query->result();

        return $resultats;
    
    }


    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}