<?php 
class Inventaire extends CI_Model {
	
 protected $table = 'Inventaires';
 protected $table_produits_inventaire = 'Produits_inventaire';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

   public function ajout_produits_inventaire($data){

       $this->db->insert($this->table_produits_inventaire, $data);
         return $this->db->insert_id();
   }

   public function test_produit_inventaire($id_produit,$id_inventaire){
     
     return $this->db->get_where($this->table_produits_inventaire, array('Id_produit' => $id_produit,'Id_inventaire'=>$id_inventaire))->num_rows();
      
   }

    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

   public function nb_produits_inventaires($id_inventaire){
    
    return $this->db->get_where($this->table_produits_inventaire, array('Id_inventaire'=>$id_inventaire))->num_rows();

   }
    public function get_liste_produits_inventaire($id_inventaire){

        $liste_produits = array();
        $resultats = $this->db->get_where($this->table_produits_inventaire, array('Id_inventaire' => $id_inventaire))->result();
        foreach($resultats as $res){

            $donnee =$res;
            $infos_article=$this->article->get_by_id($res->Id_produit);
            $donnee->Libelle_produit =$infos_article->Libelle;
            $liste_produits[]=$donnee;
        }

        return $liste_produits;

    }
  
    public function liste($offset,$nb_per_page) {
          $liste_inventaires = array();
          $query=$this->db->query('SELECT * FROM Inventaires ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
           foreach($resultats as $res){
             
             $donnee =$res;
             if($res->Id_categorie==-1){

                $donnee->Categorie ="Tout";

             }else{
                $infos_categorie = $this->categorie->get_by_id($res->Id_categorie);
                $donnee->Categorie =$infos_categorie->Libelle;

             }
             $nb_produits = $this->nb_produits_inventaires($res->Id);
             $donnee->Nb_produits = $nb_produits;
             $liste_inventaires[]=$donnee;

           }

           return $liste_inventaires;

    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }


    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function delete_produits_inventaire($id_inventaire)
    {
    $this->db->where('Id_inventaire', $id_inventaire);
    return $this->db->delete($this->table_produits_inventaire);
    }

    public function update_produit_inventaire($id, $data) {
        return $this->db->update($this->table_produits_inventaire, $data, ['Id' => $id]);
    }

     public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}