<?php 
class Modules extends CI_Model {
	
 protected $table = 'Modules';
 protected $table_actions = 'Actions';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

    public function liste_modules(){

        $liste_modules = array();
        $modules = $this->get_all();
        foreach($modules as $module){

             $donnee=$module;
             $liste_actions=$this->liste_actions_module($module->Id);
             $donnee->Actions=$liste_actions;
             $liste_modules[]=$donnee;

        }

        return $liste_modules;
    }


    public function liste_actions_module($id_module){

     return $this->db
    ->order_by('Ordre', 'ASC')   // ou 'DESC'
    ->get_where($this->table_actions, array('Id_module' => $id_module))
    ->result();

    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}