<?php 
class Mouvements_stock extends CI_Model {
	
 protected $table = 'Mouvements_stock';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

     public function liste($offset,$nb_per_page) {
          
          $liste_mouvements =array();
          $query=$this->db->query('SELECT * FROM Mouvements_stock ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
          foreach($resultats as $res){

            $infos_article =$this->article->get_by_id($res->Id_article);
            $donnee=$res;
            $donnee->Libelle_article=$infos_article->Libelle;
            $liste_mouvements[]=$donnee;

          }
           return $liste_mouvements;

    }

    public function recherche($mot_cle){
       
        $query=$this->db->query('SELECT * FROM Mouvements_stock WHERE (Date LIKE "%'.$mot_cle.'%" ) ORDER BY Id DESC  ' );
        $resultats = $query->result();

        return $resultats;
    
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_doublon($id_article,$id_inventaire) {
        return $this->db->get_where($this->table, array('Id_article' => $id_article,'Id_inventaire'=>$id_inventaire))
                        ->num_rows();
    }

    public function test_mouvement_reception($id_article,$reference_reception){
        
        return $this->db->get_where($this->table, array('Id_article' => $id_article,'Reference_reception'=>$reference_reception))
                        ->result();

    }


    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function delete_by_inventaire($id)
    {
    $this->db->where('Id_inventaire', $id);
    return $this->db->delete($this->table);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}