<?php 
class Opportunite extends CI_Model {
	
 protected $table = 'Opportunites';
 protected $table_historique = 'Historique_opportunite';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

   public function ajouter_historique($data){

       $this->db->insert($this->table_historique, $data);
         return $this->db->insert_id();
   }

   public function stats_total_par_agent($mois){
     $liste_stats =[];
     $liste_agents =$this->utilisateur->liste_agents();
     foreach($liste_agents as $agent){
        $total_opportunite =$this->valeur_by_responsable_mois($agent->Id_utilisateur,$mois);
        $liste_stats[]=$total_opportunite;
     }

     return $liste_stats;

   }

   public function stats_total_gagnees_par_agent($mois){
     $liste_stats =[];
     $statut_gagnee =$this->statut_opportunite->get_by_libelle("Gagnée");
     $liste_agents =$this->utilisateur->liste_agents();
     foreach($liste_agents as $agent){
        $total_opportunite =$this->valeur_by_statut_responsable_mois($statut_gagnee->Id,$agent->Id_utilisateur,$mois);
        $liste_stats[]=$total_opportunite;
     }

     return $liste_stats;

   }

   


   public function test_historique($id_opportunite,$id_statut){
    
     return $this->db->get_where($this->table_historique, array("Id_opportunite"=>$id_opportunite,'Id_statut' => $id_statut))->num_rows();

   }

   public function liste_by_date_statut($date,$id_statut){

     $liste_opportunites = array();
     $resultats = $this->db
    ->like('Date', $date)                // équivalent de "WHERE Date LIKE '%$date%'"
    ->where('Id_statut', $id_statut)     // autre condition
    ->get($this->table)                  // table concernée
    ->result();
     
     foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }

            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }

     return $liste_opportunites;

   }

   public function liste_by_statut($id_statut){
    $liste_opportunites = array();
    $resultats= $this->db->get_where($this->table, array('Id_statut' => $id_statut))
                        ->result();
    foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }
            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }
     return $liste_opportunites;
   }

    public function liste_by_mois($mois){
    $liste_opportunites = array();
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Date LIKE "%'.$mois.'%"' );
    $resultats = $query->result();
    foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }
            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }
     return $liste_opportunites;
   }

   public function valeur_by_mois($mois){

    $total = 0;
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Date LIKE "%'.$mois.'%"' );
    $resultats = $query->result();
    foreach($resultats as $res){

        $total =$total+$res->Valeur_estimee;
    }

    return $total;

   }

   public function valeur_by_statut_mois($statut,$mois){

    $total = 0;
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Id_statut='.$statut.' AND  Date LIKE "%'.$mois.'%"' );
    $resultats = $query->result();
    foreach($resultats as $res){

        $total =$total+$res->Valeur_estimee;
    }

    return $total;

   }

    public function valeur_by_responsable_mois($id_responsable,$mois){

    $total = 0;
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Date LIKE "%'.$mois.'%" AND Id_responsable='.$id_responsable );
    $resultats = $query->result();
    foreach($resultats as $res){

        $total =$total+$res->Valeur_estimee;
    }

    return $total;

   }

   public function valeur_by_statut_responsable_mois($statut,$id_responsable,$mois){

    $total = 0;
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Id_statut='.$statut.' AND Date LIKE "%'.$mois.'%" AND Id_responsable='.$id_responsable );
    $resultats = $query->result();
    foreach($resultats as $res){

        $total =$total+$res->Valeur_estimee;
    }

    return $total;

   }

   public function statistiques_opportunites(){
        
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->valeur_by_mois($mois."/".date("Y"));
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }

     public function statistiques_opportunites_gagnees(){
        $statut_gagnee =$this->statut_opportunite->get_by_libelle("Gagnée");
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->valeur_by_statut_mois($statut_gagnee->Id,$mois."/".date("Y"));
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }

    public function statistiques_opportunites_commercial($id_commercial){
        
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->valeur_by_responsable_mois($id_commercial,$mois."/".date("Y"));
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }

    public function statistiques_opportunites_gagnee_commercial($id_commercial){
        $statut_gagnee =$this->statut_opportunite->get_by_libelle("Gagnée");
        $liste_stats= array();
        $liste_mois = array("01","02","03","04","05","06","07","08","09","10","11","12");
        foreach($liste_mois as $mois){

            $total = $this->valeur_by_statut_responsable_mois($statut_gagnee->Id,$id_commercial,$mois."/".date("Y"));
            $liste_stats[]=$total;
        }

        return $liste_stats;

    }

   public function liste_by_statut_mois($statut,$mois){
    $liste_opportunites = array();
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Id_statut='.$statut.' AND Date LIKE "%'.$mois.'%"' );
    $resultats = $query->result();
    foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }
            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }
     return $liste_opportunites;
   }

  

   public function liste_by_statut_mois_commercial($statut,$mois,$id_commercial){
    $liste_opportunites = array();
    $query=$this->db->query('SELECT * FROM Opportunites WHERE Id_statut='.$statut.' AND Date LIKE "%'.$mois.'%" AND Id_responsable='.$id_commercial );
    $resultats = $query->result();
    foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }
            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }
     return $liste_opportunites;
   }

   public function liste_by_responsable_statut_mois($id_responsable,$statut,$mois){
    $liste_opportunites = array();
    $query=$this->db->query('SELECT * FROM Opportunites WHERE  Id_responsable='.$id_responsable.' AND Id_statut='.$statut.' AND Date LIKE "%'.$mois.'%"' );
    $resultats = $query->result();
    foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }
            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }
     return $liste_opportunites;
   }

   public function liste_historique($id_opportunite){
    $liste_historique=array();
    $resultats= $this->db->get_where($this->table_historique, array("Id_opportunite"=>$id_opportunite))->result();
    foreach($resultats as $res){

        $donnee=$res;
        $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);


        $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
        $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
        $donnee->Statut=$infos_statut->Libelle;
        $donnee->Couleur=$infos_statut->Couleur;
        $liste_historique[]=$donnee;
    }
    return $liste_historique;

   }

    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }
  
    public function liste($offset,$nb_per_page) {

          $liste_opportunites= array();
          $query=$this->db->query('SELECT * FROM Opportunites ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }

            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $donnee->Couleur =$infos_statut->Couleur;
            $liste_opportunites[]=$donnee;

          }
        
           return $liste_opportunites;

    }

    public function recherche($mot_cle){
        $liste_opportunites= array();
        $query=$this->db->query('SELECT * FROM Opportunites WHERE (Nom LIKE "%'.$mot_cle.'%" OR Date LIKE  "%'.$mot_cle.'%" )  ORDER BY Id DESC  ' );
        $resultats = $query->result();


        foreach($resultats as $res){

            $infos_contact =$this->contact->get_by_id($res->Id_contact);
            $infos_responsable =$this->utilisateur->get_by_id($res->Id_responsable);
            $infos_statut =$this->statut_opportunite->get_by_id($res->Id_statut);
            $donnee=$res;
            $donnee->Contact =$infos_contact->Nom." ".$infos_contact->Prenom;
            $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
            if($res->Id_source==-1){

                $donnee->Source="--";

            }else{
                $infos_source = $this->campagne->get_by_id($res->Id_source);
                $donnee->Source= $infos_source->Libelle;

            }
            $donnee->Total_ttc=$this->vente->get_ttc_by_proposition($res->Id);
            $donnee->Total_ttc_devise=$this->vente->get_ttc_devise_by_proposition($res->Id);
            $donnee->Statut =$infos_statut->Libelle;
            $liste_opportunites[]=$donnee;

          }
        
           return $liste_opportunites;
    
    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function get_stats_by_statut($id_statut) {
        return $this->db->get_where($this->table, array('Id_statut' => $id_statut))
                        ->num_rows();
    }

    public function test_doublon($date,$libelle,$id_contact) {
        return $this->db->get_where($this->table, array("Date"=>$date,'Nom' => $libelle,"Id_contact"=>$id_contact))->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}