<?php 
class Produits_par_fournisseur extends CI_Model {
	
 protected $table = 'Produits_par_fournisseur';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function test_doublon($id_article,$id_fournisseur) {
        return $this->db->get_where($this->table, array('Id_article' => $id_article,'Id_fournisseur'=>$id_fournisseur))
                        ->num_rows();
    }

    public function get_by_article_fournisseur($id_article,$id_fournisseur) {
        return $this->db->get_where($this->table, array('Id_article' => $id_article,'Id_fournisseur'=>$id_fournisseur))
                        ->result();
    }

     public function get_by_article($id_article) {
        $liste_prix=array();
        $resultats=  $this->db->get_where($this->table, array('Id_article'=>$id_article))->result();
        foreach($resultats as $res){
            $donnee=$res;
            $infos_fournisseur =$this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur =$infos_fournisseur->Raison_sociale;
            $liste_prix[]=$donnee;

        }
        return $liste_prix;
    }

    public function liste($offset,$nb_per_page) {

          $liste_produits_fournisseur=array();
          $query=$this->db->query('SELECT * FROM Produits_par_fournisseur ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();
          foreach($resultats as $res){
            
            $donnee=$res;
            $infos_fournisseur =$this->fournisseur->get_by_id($res->Id_fournisseur);
            $donnee->Fournisseur=$infos_fournisseur->Raison_sociale;
            $infos_article = $this->article->get_by_id($res->Id_article);
            $donnee->Article =$infos_article->Libelle;
            $liste_produits_fournisseur[]= $donnee;

          }
        
        return $liste_produits_fournisseur;

    }



    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}