<?php 
class Role extends CI_Model {
	
 protected $table = 'Roles';
 protected $table_role_actions = 'Role_actions';
 protected $table_actions = 'Actions';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

    public function ajout_action_role($data){

         $this->db->insert($this->table_role_actions, $data);
         return $this->db->insert_id();
    }

    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function liste_actions_role($id_role){
       $liste_actions=[];
       $resultats =$this->db->get_where($this->table_role_actions, array('Id_role' => $id_role))->result();
       foreach($resultats as $res){
        $liste_actions[]=$res->Id_action;
       }

       return  $liste_actions;

    }

    public function liste_codes_actions_role($id_role){
       $liste_actions=[];
       $resultats =$this->db->get_where($this->table_role_actions, array('Id_role' => $id_role))->result();
       foreach($resultats as $res){
        $infos_action =$this->get_action($res->Id_action);
        $liste_actions[]=$infos_action->Code;
       }

       return  $liste_actions;

    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

     public function get_action($id) {
        return $this->db->get_where($this->table_actions, array('Id' => $id))
                        ->row();
    }

   public function get_by_libelle($libelle) {
    $this->db->like('Libelle', $libelle);
    return $this->db->get($this->table)->result();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function supprimer_actions_role($id_role){

     $this->db->where('Id_role', $id_role);
    return $this->db->delete($this->table_role_actions);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}