<?php 
class Statut_contact extends CI_Model {
	
 protected $table = 'Statuts_contact';
 protected $table_historique='Historique_statut_contact';



	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function test_statut_contact($id_contact,$id_statut){
     
     return $this->db->get_where($this->table_historique, array('Id_contact' => $id_contact,'Id_statut'=>$id_statut))->num_rows();

    }

    public function liste_historique($id_contact){
    $liste_historique=array();
    $resultats= $this->db->get_where($this->table_historique, array("Id_contact"=>$id_contact))->result();
    foreach($resultats as $res){

        $donnee=$res;
        $infos_responsable =$this->utilisateur->get_by_id($res->Id_utilisateur);


        $donnee->Responsable=$infos_responsable->Nom." ".$infos_responsable->Prenom;
        $infos_statut =$this->statut_contact->get_by_id($res->Id_statut);
        $donnee->Statut=$infos_statut->Libelle;
        $donnee->Couleur=$infos_statut->Couleur;
        $liste_historique[]=$donnee;
    }
    return $liste_historique;

   }

    public function ajouter_statut_contact($data){

        $this->db->insert($this->table_historique, $data);
         return $this->db->insert_id();

    }

    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function infos_statut($id){

        return $this->db->get_where($this->table, array('Id' => $id))
                        ->result();
    }


     public function get_by_libelle($libelle) {
        return $this->db->get_where($this->table, array('Libelle' => $libelle))
                        ->row();
    }

    public function test_by_libelle($libelle) {
        return $this->db->get_where($this->table, array('Libelle' => $libelle))
                        ->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}