<?php 
class Statut_opportunite extends CI_Model {
	
 protected $table = 'Statuts_opportunite';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function liste_pipeline($mois){
        
        $liste_pipeline = array();
        $liste_status =$this->get_all();
        foreach($liste_status as $res){

            $donnee =$res;
            $donnee->opportunites=$this->opportunite->liste_by_statut_mois($res->Id,$mois);
            $liste_pipeline[]=$donnee;

        }

        return $liste_pipeline;
    }

    public function liste_pipeline_commercial($id_commercial,$mois){
        
        $liste_pipeline = array();
        $liste_status =$this->get_all();
        foreach($liste_status as $res){

            $donnee =$res;
            $donnee->opportunites=$this->opportunite->liste_by_statut_mois_commercial($res->Id,$mois,$id_commercial);
            $liste_pipeline[]=$donnee;

        }

        return $liste_pipeline;
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }


     public function get_by_libelle($libelle) {
        return $this->db->get_where($this->table, array('Libelle' => $libelle))
                        ->row();
    }

    public function test_by_libelle($libelle) {
        return $this->db->get_where($this->table, array('Libelle' => $libelle))
                        ->num_rows();
    }

    public function delete($id)
	{
	$this->db->where('Id', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }


}