<?php 
class Utilisateur extends CI_Model {
	
 protected $table = 'Utilisateurs';
 protected $table_pays = 'Pays';
 protected $table_devise = 'Devises';


	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

    public function liste_pays(){

     return $this->db->order_by('Nom_fr_fr', 'ASC')
                    ->get($this->table_pays)
                    ->result();
    }

    public function liste_devises(){

     return $this->db->get($this->table_devise)
                        ->result();
    }

    public function email_check($email){

         return $this->db->get_where($this->table, array('Email' => $email))
                        ->num_rows();
    }

     public function pseudo_check($pseudo){

         return $this->db->get_where($this->table, array('Pseudo' => $pseudo))
                        ->num_rows();
    }

    public function liste_utilisateurs_par_annexe($id_annexe){

        if($id_annexe==-1){

            $resultats=$this->db->get($this->table)
                        ->result();

        }else{

            $resultats=$this->db->get_where($this->table, array('Id_annexe' => $id_annexe))
                        ->result();

        }

        return $resultats;



    }


    public function get_all() {
        return $this->db->get($this->table)
                        ->result();
    }

    public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

    public function liste_agents(){

        $query=$this->db->query('SELECT * FROM Utilisateurs WHERE Role!=-1 ' );
        $resultats = $query->result();
        return $resultats;
    }

     public function liste_noms_agents(){
        $liste_noms=[];
        $query=$this->db->query('SELECT * FROM Utilisateurs WHERE Role!=-1 ' );
        $resultats = $query->result();
        foreach($resultats as $res){
          
          $liste_noms[] =$res->Nom." ".$res->Prenom;

        }
        return $liste_noms;
    }

    public function liste($offset,$nb_per_page) {

          $liste_utilisateurs = array();
          $query=$this->db->query('SELECT * FROM Utilisateurs ORDER BY Id_utilisateur DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){

             $donne=$res;
             $infos_role = $this->role->get_by_id($res->Role);
             if($res->Role=="-1"){
               
               $donne->Le_role="Administrateur";

             }else{

                $donne->Le_role=$infos_role->Libelle;
             }

             $annexe =$this->annexe->infos_annexe($res->Id_annexe);
             if(count($annexe)==0){

                $donne->Annexe="";

             }else{
                
                $donne->Annexe=$annexe[0]->Designation;

             }
             
             $liste_utilisateurs[]=$donne;

          }

           return $liste_utilisateurs;

    }

    public function recherche($mot_cle){
        $liste_utilisateurs = array();
        $query=$this->db->query('SELECT * FROM Utilisateurs WHERE (Nom LIKE "%'.$mot_cle.'%" OR Prenom  LIKE "%'.$mot_cle.'%") ORDER BY Id_utilisateur DESC  ' );
          $resultats = $query->result();

          foreach($resultats as $res){

             $donne=$res;
             $infos_role = $this->role->get_by_id($res->Role);
             if($res->Role=="-1"){
               
               $donne->Le_role="Administrateur";

             }else{

                $donne->Le_role=$infos_role->Libelle;
             }
             
             $liste_utilisateurs[]=$donne;

          }

           return $liste_utilisateurs;
    
    }


    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id_utilisateur' => $id))
                        ->row();
    }

    public function infos_utilisateur($id){

        return $this->db->get_where($this->table, array('Id_utilisateur' => $id))
                        ->result();


    }

     public function get_by_pseudo($pseudo) {
        return $this->db->get_where($this->table, array('Pseudo' => $pseudo))
                        ->result();
    }


    public function infos_by_pseudo($pseudo) {
        return $this->db->get_where($this->table, array('Pseudo' => $pseudo))
                        ->row();
    }

     public function get_by_email($email) {
        return $this->db->get_where($this->table, array('Email' => $email))
                        ->result();
    }


    public function delete($id)
	{
	$this->db->where('Id_utilisateur', $id);
	return $this->db->delete($this->table);
	}

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id_utilisateur' => $id]);
    }


}