<?php 
class Vente extends CI_Model {
	
 protected $table = 'Ventes';
 protected $table_details_vente = 'Ventes_details';

	 function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->database(); 
    }
   

   public function insert($data) {
        $this->db->insert($this->table, $data);
         return $this->db->insert_id();
    }

    public function ajout_details_vente($data){

        $this->db->insert($this->table_details_vente, $data);
         return $this->db->insert_id();
    }

    public function recherche_avancee($mot_cle,$type){


        $liste_des_ventes = array();
        $query = $this->db->query('
            SELECT 
                Ventes.Id_utilisateur AS Id_responsable, 
                Ventes.Id AS Id_vente,
                Ventes.*, 
                Utilisateurs.*, 
                Contacts.*
            FROM Ventes
            JOIN Utilisateurs ON Ventes.Id_utilisateur = Utilisateurs.Id_utilisateur
            JOIN Contacts ON Ventes.Id_client = Contacts.Id
            WHERE Ventes.Type = "'.$type.'"
            AND (
                Ventes.Numero_demande = "'.$mot_cle.'"
                OR Ventes.Statut = "'.$mot_cle.'"
                OR Utilisateurs.Nom LIKE "%'.$mot_cle.'%"
                OR Utilisateurs.Prenom LIKE "%'.$mot_cle.'%"
                OR Contacts.Nom LIKE "%'.$mot_cle.'%"
                OR Contacts.Prenom LIKE "%'.$mot_cle.'%"
                OR Contacts.Entreprise LIKE "%'.$mot_cle.'%"
            )
        ');
         $resultats = $query->result();

        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_responsable);

            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id_vente);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id_vente);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id_vente);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;


    }


    public function get_by_statut($statut,$type){

        
        $liste_des_ventes = array();
        $resultats= $this->db->get_where($this->table, array('Statut' => $statut,'Type'=>$type))->result();

        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;


    }


    public function liste_commerciaux_vente_periode($periode){

        $liste_commerciaux=array();
        $query=$this->db->query('SELECT DISTINCT Id_utilisateur FROM Ventes WHERE Type="Facture" AND Date_vente LIKE "%'.$periode.'%" ' );
        $resultats = $query->result();
        foreach($resultats as $res){

           $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
           $liste_commerciaux[]=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
        }

        return $liste_commerciaux;

    }

    public function liste_id_commerciaux_vente_periode($periode){

        $liste_commerciaux=array();
        $query=$this->db->query('SELECT DISTINCT Id_utilisateur FROM Ventes WHERE Type="Facture" AND Date_vente LIKE "%'.$periode.'%" ' );
        $resultats = $query->result();
        
        foreach($resultats as $res){

           $infos_utilisateur =$this->utilisateur->get_by_id(intval($res->Id_utilisateur));
           $liste_commerciaux[]=$infos_utilisateur->Id_utilisateur;
        }

        return $liste_commerciaux;

    }

       public function liste_id_utilisateurs(){

        $liste_commerciaux=array();
        $query=$this->db->query('SELECT  Id_utilisateur FROM Utilisateurs  ' );
        $resultats = $query->result();
        
        return $resultats;

    }

    public function total_vente_commercial_periode($id_commercial,$periode){
        $total=0;
        $query=$this->db->query('SELECT *  FROM Ventes WHERE Type="Facture" AND Date_vente LIKE "%'.$periode.'%"  AND Id_utilisateur='.$id_commercial );
        $resultats = $query->result();

        foreach($resultats as $res){

            $total=$total+floatval($this->get_total_ttc($res->Id));
        }

        return round($total,2);
    }

    public function total_opportunite_commercial_periode($id_commercial,$periode){
        $total=0;
        $query=$this->db->query('SELECT *  FROM Opportunites WHERE Date LIKE "%'.$periode.'%" AND Id_responsable='.$id_commercial );
        $resultats = $query->result();

        foreach($resultats as $res){

            $total=$total+floatval($this->get_ttc_by_proposition($res->Id));
        }

        return round($total,2);
    }

    public function statistiques_ventes_commerciaux_periode($periode){
        
        $liste_stats = array();
        $liste_commerciaux =$this->liste_id_commerciaux_vente_periode($periode);

        foreach($liste_commerciaux as $id){
         
         $liste_stats[]=$this->total_vente_commercial_periode($id,$periode);
        }

        return $liste_stats;

    }

    public function statistiques_opportunites_commerciaux_periode($periode){
        
        $liste_stats = array();
        $liste_commerciaux =$this->liste_id_utilisateurs();

        foreach($liste_commerciaux as $id){
       
         $liste_stats[]=$this->total_opportunite_commercial_periode($id->Id_utilisateur,$periode);
        }

        return $liste_stats;

    }

    public function total_marge_vente($id_vente){
        
        $total_marge=0;
        $query=$this->db->query("SELECT * FROM Ventes_details WHERE Id_vente=".$id_vente );
        $produits_ventes = $query->result();
        foreach($produits_ventes as $produit){

            $infos_produit = $this->article->get_by_id($produit->Id_article);
            $marge =$produit->Quantite*$infos_produit->Prix_vente_ttc -$produit->Quantite*$infos_produit->Prix_achat_ttc;
            $total_marge=$total_marge+$marge;
        }

        return $total_marge;

    }



    public function statistiques_ventes_annuel(){
        
        $liste_stats =array();
        $liste_mois = [];
        for ($i = 1; $i <= 12; $i++) {
            $liste_mois[] = date("Y") . '-' . str_pad($i, 2, '0', STR_PAD_LEFT);
        }

        foreach($liste_mois as $mois){

            $chiffre_affaire_mensuel = $this->get_total_ttc_mois($mois);
            $liste_stats[]=$chiffre_affaire_mensuel;
        }

        return $liste_stats;
    }

    public function total_by_type_statut($type,$statut,$mois){

        
        $liste_des_ventes = array();
        $query=$this->db->query("SELECT * FROM Ventes WHERE Type='".$type."' AND Statut='".$statut."' AND Date_vente LIKE '%".$mois."%'" );
          $resultats = $query->num_rows();

          return $resultats;
    }

    public function get_total_ttc_mois($mois)
    {
        $this->db->select_sum('(Ventes_details.Total_ttc * (1 - (Ventes_details.Reduction / 100)))', 'total_ttc_reduit');
        $this->db->from('Ventes_details');
        $this->db->join('Ventes', 'Ventes.Id = Ventes_details.Id_vente');
        $this->db->where('Ventes.Type', 'Facture');
        $this->db->where('Ventes.Statut', 'Validé');
        $this->db->where('Ventes.Date_vente LIKE', $mois . '%'); // ✅ correction ici

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return round((float) $query->row()->total_ttc_reduit, 2);
        } else {
            return 0;
        }
    }

    public function get_total_ttc_jour($jour)
    {
        $this->db->select_sum('(Ventes_details.Total_ttc * (1 - (Ventes_details.Reduction / 100)))', 'total_ttc_reduit');
        $this->db->from('Ventes_details');
        $this->db->join('Ventes', 'Ventes.Id = Ventes_details.Id_vente');
        $this->db->where('Ventes.Type', 'Facture');
        $this->db->where('Ventes.Statut', 'Validé');
        $this->db->where('Ventes.Date_vente', $jour); 

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return round((float) $query->row()->total_ttc_reduit, 2);
        } else {
            return 0;
        }
    }

    public function get_total_ttc_semaine_en_cours()
{
    // Déterminer le premier et le dernier jour de la semaine en cours
    $debut_semaine = date('Y-m-d', strtotime('monday this week'));
    $fin_semaine   = date('Y-m-d', strtotime('sunday this week'));

    // Construire la requête
    $this->db->select_sum('(Ventes_details.Total_ttc * (1 - (Ventes_details.Reduction / 100)))', 'total_ttc_reduit');
    $this->db->from('Ventes_details');
    $this->db->join('Ventes', 'Ventes.Id = Ventes_details.Id_vente');
    $this->db->where('Ventes.Type', 'Facture');
    $this->db->where('Ventes.Statut', 'Validé');
    $this->db->where('Ventes.Date_vente >=', $debut_semaine);
    $this->db->where('Ventes.Date_vente <=', $fin_semaine);

    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        return round((float) $query->row()->total_ttc_reduit, 2);
    } else {
        return 0;
    }
}




    public function recherche($date){

        $liste_des_ventes = array();
        $resultats= $this->db->get_where($this->table, array('Date_vente' => $date))->result();

        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;
    }

    public function liste_by_contact($id_contact){

        $liste_des_ventes = array();
        $resultats= $this->db->get_where($this->table, array('Id_client' => $id_contact))->result();

        foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;
    }

    public function liste_devis_opportunite($id_opportunite) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Devis" AND Id_opportunite='.$id_opportunite );
          
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }


    public function liste_devis_non_valides() {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Devis" AND Statut="Brouillon"  ORDER BY Id DESC  ' );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }

    public function total_devis_non_valides() {
          
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Devis" AND Statut="Brouillon" ' );
          $resultats = $query->num_rows();
          return $resultats;

    }

  
    public function liste_devis($offset,$nb_per_page) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Devis"  ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $total_marge=$this->total_marge_vente($res->Id);
            $donnee->Total_marge_ttc=$total_marge;
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }



    public function total_devis() {
        return $this->db->get_where($this->table, array('Type' => "Devis"))
                        ->num_rows();
    }

     public function liste_commandes($offset,$nb_per_page) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Bon_commande"  ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $total_marge=$this->total_marge_vente($res->Id);
            $donnee->Total_marge_ttc=$total_marge;
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }

    public function total_bons_commande() {
        return $this->db->get_where($this->table, array('Type' => "Bon_commande"))
                        ->num_rows();
    }

    public function liste_bons_livraison($offset,$nb_per_page) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Bon_livraison"  ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $total_marge=$this->total_marge_vente($res->Id);
            $donnee->Total_marge_ttc=$total_marge;
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }


    public function total_bons_livraison() {
        return $this->db->get_where($this->table, array('Type' => "Bon_livraison"))
                        ->num_rows();
    }

    public function liste_factures_client($offset,$nb_per_page) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Facture"  ORDER BY Id DESC LIMIT '.$offset.','.$nb_per_page );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $total_marge=$this->total_marge_vente($res->Id);
            $donnee->Total_marge_ttc=$total_marge;
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }


    public function total_factures_client() {
        return $this->db->get_where($this->table, array('Type' => "Facture"))
                        ->num_rows();
    }

    public function total_vente_agent_jour($id_responsable){
      
      $total =0;
      $liste_des_ventes = array();
      $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Facture" AND Date_vente LIKE "%'.date("Y-m-d").'%" AND Id_utilisateur='.$id_responsable );
      $resultats = $query->result();

      foreach($resultats as $res){

          $donnee =$res;
          $total=$total+$this->get_total_ttc($res->Id);
      }

      return $total;

    }

    public function liste_factures_client_mois($mois) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="Facture" AND Date_vente LIKE "%'.$mois.'%"' );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }

    public function liste_transactions_client_mois($type,$mois,$statut) {
          
          $liste_des_ventes = array();
          $query=$this->db->query('SELECT * FROM Ventes WHERE Type="'.$type.'" AND Statut="'.$statut.'" AND Date_vente LIKE "%'.$mois.'%"' );
          $resultats = $query->result();

          foreach($resultats as $res){
            
            $donnee =$res;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $infos_utilisateur =$this->utilisateur->get_by_id($res->Id_utilisateur);
            $donnee->Responsable=$infos_utilisateur->Nom." ".$infos_utilisateur->Prenom;
            $total_produits = $this->get_total_quantite($res->Id);
            $donnee->Total_articles=$total_produits;
            $donnee->Total_ttc=$this->get_total_ttc($res->Id);
            $donnee->Total_ttc_devise=$this->get_total_ttc_devise($res->Id);
            $liste_des_ventes[]=$donnee;
         
          }

           return $liste_des_ventes;

    }



    public function get_by_id($id) {
        return $this->db->get_where($this->table, array('Id' => $id))
                        ->row();
    }

    public function get_by_reference_vente($reference_vente) {
        return $this->db->get_where($this->table, array('Type' => "Facture",'Numero_demande'=>$reference_vente))
                        ->result();
    }

     public function get_total_quantite($id_vente)
    {
        $this->db->select_sum('Quantite', 'total_quantite');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return (int)$row->total_quantite;
        }

        return 0;
    }

    public function get_total_produits_vendus_mois($mois)
    {
        $this->db->select_sum('Ventes_details.Quantite', 'total_produits_vendus');
        $this->db->from('Ventes_details');
        $this->db->join('Ventes', 'Ventes.Id = Ventes_details.Id_vente');
        $this->db->where('Ventes.Type', 'Facture');
        $this->db->where('Ventes.Statut', 'Validé');
        $this->db->where('Ventes.Date_vente LIKE', $mois . '%'); // exemple: '2025-10%'

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return (int) $query->row()->total_produits_vendus;
        } else {
            return 0;
        }
    }


      public function get_total_ht($id_vente)
    {
        $this->db->select_sum('Total_ht');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return round((float) $query->row()->Total_ht);
        } else {
            return 0;
        }
    }

       public function get_total_ht_devise($id_vente)
    {
        $this->db->select_sum('Total_ht_devise');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return round((float) $query->row()->Total_ht_devise);
        } else {
            return 0;
        }
    }

    public function get_total_ttc($id_vente)
    {
        $this->db->select_sum('Total_ttc');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return number_format((float) $query->row()->Total_ttc, 2, '.', '');
        } else {
            return 0;
        }
    }

      public function get_total_ttc_devise($id_vente)
    {
        $this->db->select_sum('Total_ttc_devise');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
           
            return number_format((float) $query->row()->Total_ttc_devise, 2, '.', '');
        } else {
            return 0;
        }
    }

    public function get_total_tva($id_vente)
    {
        // Calcule la somme totale de la TVA (sans réduction)
        $this->db->select_sum('((Total_ttc * (Tva / (100 + Tva))))', 'Total_tva');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            // Retourne le total de TVA arrondi à 2 décimales
            return number_format((float) $query->row()->Total_tva, 2, '.', '');
        } else {
            return 0;
        }
    }


     public function get_total_tva_devise($id_vente)
    {
        // Calcule la somme totale de la TVA (sans réduction)
        $this->db->select_sum('((Total_ttc_devise * (Tva / (100 + Tva))))', 'Total_tva_devise');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            // Retourne le total de TVA arrondi à 2 décimales
            return number_format((float) $query->row()->Total_tva_devise, 2);
        } else {
            return 0;
        }
    }


    public function get_ttc_by_proposition($id_proposition){

          $total_vente = 0;
          $query=$this->db->query('SELECT * FROM Ventes WHERE Id_opportunite="'.$id_proposition.'" ' );
          $resultats = $query->result();

          foreach($resultats as $res){
        
            $total_vente = $total_vente+$this->get_total_ttc($res->Id);

          }

          return $total_vente;

    }

    public function get_ttc_devise_by_proposition($id_proposition){

          $total_vente = 0;
          $query=$this->db->query('SELECT * FROM Ventes WHERE Id_opportunite="'.$id_proposition.'" ' );
          $resultats = $query->result();

          foreach($resultats as $res){

            $total_vente = $total_vente+$this->get_total_ttc_devise($res->Id);

          }

          return $total_vente;

    }

    public function get_total_ttc_reduction($id_vente)
    {
        // On calcule la somme du Total_ttc après application de la réduction
        $this->db->select_sum('(Total_ttc * (1 - (Reduction / 100)))', 'Total_ttc_reduit');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            // On retourne le total TTC arrondi
            return number_format((float) $query->row()->Total_ttc_reduit, 2);
        } else {
            return 0;
        }
    }

    public function get_total_tva_reduction($id_vente)
{
    // On calcule la somme de la TVA après application de la réduction
    $this->db->select_sum('((Total_ttc / (1 + (Tva / 100))) * (Tva / 100) * (1 - (Reduction / 100)))', 'Total_tva_reduite');
    $this->db->from('Ventes_details');
    $this->db->where('Id_vente', $id_vente);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        // On retourne le total de TVA arrondi à 2 décimales
        return round((float) $query->row()->Total_tva_reduite, 2);
    } else {
        return 0;
    }
}

    public function get_total_reduction_ht($id_vente)
    {
   
        $this->db->select('SUM(Total_ht * (Reduction / 100)) AS total_reduction_ht');
        $this->db->from('Ventes_details');
        $this->db->where('Id_vente', $id_vente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return round((float) $query->row()->total_reduction_ht, 2);
        } else {
            return 0;
        }
    }


    public function nb_fille($type,$id_parent){

        return $this->db->get_where($this->table, array('Type' => $type,"Id_parent"=>$id_parent))->num_rows();


    }

    public function liste_articles_livraison($id){

        $liste_livraison = array();
        $infos_livraison =$this->get_by_id($id);
        $liste_articles = $this->liste_details_vente($id);
        $liste_des_entrepots  = $this->entrepot->get_all();

        foreach($liste_articles as $article){

           $donnee =$article;

           $test_article =$this->get_article_from_vente($id,$article->Id_article);
           $infos_vente =$this->get_article_from_vente($infos_livraison->Id_parent,$article->Id_article);
           $infos_article =$this->article->get_by_id($article->Id_article);
           $donnee->Reference =$infos_article->Reference;
           $donnee->Unite =$infos_article->Unite;
           $donnee->Article =$infos_article->Libelle;
           $donnee->Quantite =$infos_vente[0]->Quantite;
           if(count($test_article)==0){
            $donnee->Quantite_livree =0;
           }else{
            $donnee->Quantite_livree=$test_article[0]->Quantite;
           }

           $liste_data_entrepot = array();
           foreach($liste_des_entrepots as $entrepot){
              $data_entrepot = new stdClass();
              $data_entrepot->Id_entrepot=$entrepot->Id;
              $test_livraison_entrepot = $this->article->get_article_entrepot($article->Id_article,$entrepot->Id,$infos_livraison->Numero_demande);
              if(count($test_livraison_entrepot)==0){
                $data_entrepot->Quantite_livree_entrepot=0;
               }else{
                $data_entrepot->Quantite_livree_entrepot=-$test_livraison_entrepot[0]->Quantite_recue;
               }
               $data_entrepot->Id_entrepot =$entrepot->Id;

               $liste_data_entrepot[]=$data_entrepot;
           }

           $donnee->Liste_data_entrepot=$liste_data_entrepot;
           $liste_livraison[]=$donnee;
           
        }

      return $liste_livraison;
    }



     public function total() {
        return $this->db->get($this->table)
                        ->num_rows();
    }

    public function liste_details_vente($id){
        
        $liste_details =[];
        $resultats= $this->db->get_where($this->table_details_vente, array('Id_vente' => $id))->result();
        foreach($resultats as $res){

            $donnee =$res;
            $infos_article = $this->article->get_by_id($res->Id_article);
            $donnee->Article =$infos_article->Libelle;
            $liste_details[] =$donnee;
        }

        return $liste_details;
    }

    public function get_element_vente_by_id($id) {
        return $this->db->get_where($this->table_details_vente, array('Id' => $id))
                        ->row();
    }

     public function get_article_from_vente($id_vente,$id_article){

        $resultats= $this->db->get_where($this->table_details_vente, array('Id_vente' => $id_vente,'Id_article'=>$id_article))->result();

        return $resultats;
    }



    public function test_article_vente($id_vente,$id_article){

        $resultats= $this->db->get_where($this->table_details_vente, array('Id_vente' => $id_vente,'Id_article'=>$id_article))->result();

        return $resultats;

    }

    public function total_des_ventes_a_encaisser(){
        $total=0;
        $query=$this->db->query('SELECT *  FROM Ventes WHERE Type="Facture" AND Statut!="Payé"' );
        $resultats = $query->result();

        foreach($resultats as $res){
            $total_vente =$this->get_total_ttc($res->Id);
            $total_encaisse =$this->encaissement->get_total_encaissements_par_facture($res->Numero_demande);
            $reste =$total_vente-$total_encaisse;
            $total=$total+$reste;

        }

        return round($total);
    }


    public function liste_des_ventes_a_encaisser(){
        
        $liste_recouvrement = array();
        $query=$this->db->query('SELECT *  FROM Ventes WHERE Type="Facture" AND Statut!="Payé"' );
        $resultats = $query->result();
        foreach($resultats as $res){

            $donnee=$res;
            $total_vente =$this->get_total_ttc($res->Id);
            $total_encaisse=0;
            $total_encaisse =$this->encaissement->get_total_encaissements_par_facture($res->Numero_demande);
            $reste =$total_vente-$total_encaisse;
            $donnee->Total=$total_vente;
            if($total_encaisse==""){
                $donnee->Total_encaisse=0;
            }else{
                $donnee->Total_encaisse=$total_encaisse;
            }
            
            $donnee->Reste=$reste;
            $infos_client = $this->contact->get_by_id($res->Id_client);
            $donnee->Client =$infos_client->Entreprise;
            $liste_recouvrement[]=$donnee;

        }

        return $liste_recouvrement;

    }

    public function liste_vente_par_annexe($id_annexe){


    }

    public function delete($id)
    {
    $this->db->where('Id', $id);
    return $this->db->delete($this->table);
    }

    public function delete_element_vente($id)
    {
    $this->db->where('Id', $id);
    return $this->db->delete($this->table_details_vente);
    }

     public function delete_vente($id)
    {
    $this->db->where('Id_vente', $id);
    return $this->db->delete($this->table_details_vente);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, ['Id' => $id]);
    }

    public function update_details($id, $data) {
        return $this->db->update($this->table_details_vente, $data, ['Id' => $id]);
    }


}